/*
 * Decompiled with CFR 0.152.
 */
package jalis.relatorio.editor;

import jalis.util.TamanhoPersonalizado;
import java.util.ArrayList;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;

public class FormatoPagina
extends MediaSizeName {
    private MediaSizeName[] formatos = this.getFormatos();
    private float[] tamanho = new float[]{210.0f, 297.0f};

    public FormatoPagina() {
        super(0);
    }

    public float[] getTamanho() {
        return new float[]{this.tamanho[0] / 10.0f, this.tamanho[1] / 10.0f};
    }

    public void setTamanho(float[] tamanho) {
        this.tamanho = new float[]{tamanho[0] * 10.0f, tamanho[1] * 10.0f};
        this.validarFormato();
    }

    public MediaSizeName getFormato() {
        return MediaSize.findMedia(this.tamanho[0], this.tamanho[1], 1000);
    }

    public void setFormato(MediaSizeName formato) {
        MediaSize size = MediaSize.getMediaSizeForName(formato);
        if (size != null) {
            this.tamanho = size.getSize(1000);
        }
    }

    public MediaSizeName[] getFormatos() {
        ArrayList<MediaSizeName> a = new ArrayList<MediaSizeName>();
        MediaSizeName[] msn = (MediaSizeName[])this.getEnumValueTable();
        for (int i = 0; i < msn.length; ++i) {
            if (MediaSize.getMediaSizeForName(msn[i]) == null) continue;
            a.add(msn[i]);
        }
        a.add(TamanhoPersonalizado.PERSONALIZADO);
        return a.toArray(new MediaSizeName[a.size()]);
    }

    private void validarFormato() {
        boolean padrao = false;
        for (int i = 0; i < this.formatos.length; ++i) {
            float[] fArray;
            MediaSize media = MediaSize.getMediaSizeForName(this.formatos[i]);
            if (media != null) {
                fArray = media.getSize(1000);
            } else {
                float[] fArray2 = new float[2];
                fArray2[0] = 0.0f;
                fArray = fArray2;
                fArray2[1] = 0.0f;
            }
            float[] size = fArray;
            if (size[0] != this.tamanho[0] || size[1] != this.tamanho[1]) continue;
            padrao = true;
            break;
        }
        if (!padrao) {
            if (this.tamanho[0] < this.tamanho[1]) {
                new MediaSize(this.tamanho[0], this.tamanho[1], 1000, TamanhoPersonalizado.PERSONALIZADO);
            } else {
                new MediaSize(this.tamanho[1], this.tamanho[0], 1000, TamanhoPersonalizado.PERSONALIZADO);
            }
        }
    }
}

