/*
 * Decompiled with CFR 0.152.
 */
package jalis.relatorio.editor;

import jalis.relatorio.editor.LinhaGuia;
import jalis.relatorio.editor.ModeloPagina;
import jalis.relatorio.editor.Pagina;
import jalis.relatorio.editor.item.AbstractItemModelo;
import jalis.relatorio.editor.item.Banda;
import jalis.relatorio.editor.item.CampoBanco;
import jalis.relatorio.editor.item.CodigoBarras;
import jalis.relatorio.editor.item.CodigoQRCode;
import jalis.relatorio.editor.item.Expressao;
import jalis.relatorio.editor.item.Forma;
import jalis.relatorio.editor.item.Imagem;
import jalis.relatorio.editor.item.ItemModelo;
import jalis.relatorio.editor.item.ItemSelecionavel;
import jalis.relatorio.editor.item.Rotulo;
import jalis.relatorio.editor.item.Texto;
import jalis.relatorio.gerador.Bordas;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.Point;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;

public class EditorXMLFactory {
    public static String getAtributosItemSelecionavel(ItemSelecionavel item) {
        StringBuilder bui = new StringBuilder();
        if (item instanceof ItemModelo && item instanceof AbstractItemModelo) {
            AbstractItemModelo a = (AbstractItemModelo)item;
            bui.append(StringUtil.getTag("tipoItem", a.getTipoItem()));
            bui.append(StringUtil.getTag("nome", a.getNome()));
            StringBuilder tmp = new StringBuilder();
            tmp.append(StringUtil.getTag("x", String.valueOf(a.getEsquerda())));
            tmp.append(StringUtil.getTag("y", String.valueOf(a.getTopo())));
            tmp.append(StringUtil.getTag("largura", String.valueOf(a.getLargura())));
            tmp.append(StringUtil.getTag("altura", String.valueOf(a.getAltura())));
            bui.append(StringUtil.getTag("retangulo", tmp.toString()));
            bui.append(StringUtil.getTag("fonte", StringUtil.getFonteAtributos(a.getFonte())));
            bui.append(StringUtil.getTag("bordas", a.getBordas().getAtributos()));
            bui.append(StringUtil.getTag("corDaFonte", String.valueOf(a.getCorDaFonte().getRGB())));
            bui.append(StringUtil.getTag("alinhamentoHorizontal", String.valueOf(a.getAlinhamentoHorizontal())));
            if (item instanceof CampoBanco) {
                CampoBanco campo = (CampoBanco)item;
                bui.append(StringUtil.getTag("nomeCampo", campo.getCampoDoBanco()));
                bui.append(StringUtil.getTag("mascara", campo.getMascara()));
            }
            if (item instanceof Rotulo) {
                Rotulo rotulo = (Rotulo)item;
                bui.append(StringUtil.getTag("texto", rotulo.getTexto()));
            }
            if (item instanceof Texto) {
                Texto texto = (Texto)item;
                bui.append(StringUtil.getTag("quebrarPalavras", String.valueOf(texto.getQuebrarPalavras())));
                bui.append(StringUtil.getTag("nomeCampo", texto.getCampoDoBanco()));
            }
            if (item instanceof Expressao) {
                Expressao exp = (Expressao)item;
                bui.append(StringUtil.getTag("quebrarLinhas", String.valueOf(exp.getQuebrarLinhas())));
                bui.append(StringUtil.getTag("quebrarPalavras", String.valueOf(exp.getQuebrarPalavras())));
                bui.append(StringUtil.getTag("expressao", exp.getExpressao()));
                bui.append(StringUtil.getTag("mascara", exp.getMascara()));
            }
            if (item instanceof Imagem) {
                Imagem img = (Imagem)item;
                bui.append(StringUtil.getTag("estender", String.valueOf(img.getEstender())));
                bui.append(StringUtil.getTag("imagem", img.getImagem()));
                bui.append(StringUtil.getTag("nomeCampo", img.getCampoDoBanco()));
                bui.append(StringUtil.getTag("expressao", img.getExpressao()));
                bui.append(StringUtil.getTag("condicao", img.getCondicao()));
                bui.append(StringUtil.getTag("alinhamentoVertical", String.valueOf(img.getAlinhamentoVertical())));
            }
            if (item instanceof CodigoBarras) {
                CodigoBarras cod = (CodigoBarras)item;
                bui.append(StringUtil.getTag("formato", String.valueOf(cod.getFormato())));
                bui.append(StringUtil.getTag("nomeCampo", cod.getCampoDoBanco()));
                bui.append(StringUtil.getTag("preencherZero", String.valueOf(cod.getPreencherZero())));
            }
            if (item instanceof Forma) {
                Forma forma = (Forma)item;
                bui.append(StringUtil.getTag("tipo", String.valueOf(forma.getTipo())));
                bui.append(StringUtil.getTag("corLinha", String.valueOf(forma.getCorDaLinha().getRGB())));
                bui.append(StringUtil.getTag("corPreenchimento", String.valueOf(forma.getCorDePreenchimento().getRGB())));
                bui.append(StringUtil.getTag("alinhamentoVertical", String.valueOf(forma.getAlinhamentoVertical())));
                bui.append(StringUtil.getTag("espessura", String.valueOf(forma.getEspessura())));
            }
            if (item instanceof CodigoQRCode) {
                CodigoQRCode codigoQRCode = (CodigoQRCode)item;
                bui.append(StringUtil.getTag("expressao", codigoQRCode.getExpressao()));
            }
        }
        return bui.toString();
    }

    public static String getAtributosItensBanda(ItemSelecionavel[] itens) {
        StringBuilder bui = new StringBuilder();
        for (int i = 0; i < itens.length; ++i) {
            bui.append(StringUtil.getTag("itemBanda", EditorXMLFactory.getAtributosItemSelecionavel(itens[i])));
        }
        return bui.toString();
    }

    public static String getAtributosBanda(ItemSelecionavel banda, ItemSelecionavel[] itens) {
        StringBuilder bui = new StringBuilder();
        if (banda instanceof Banda) {
            Banda b = (Banda)banda;
            bui.append(StringUtil.getTag("tipoBanda", String.valueOf(b.getTipo())));
            bui.append(StringUtil.getTag("nome", b.getNome()));
            bui.append(StringUtil.getTag("altura", String.valueOf(b.getAltura())));
            if (b.getTipo() == 2) {
                bui.append(StringUtil.getTag("colunas", String.valueOf(b.getColunas())));
                bui.append(StringUtil.getTag("entreColunas", String.valueOf(b.getEntreColunas())));
            }
            bui.append(StringUtil.getTag("campoChave", b.getCampoChave()));
            bui.append(StringUtil.getTag("nomeBandaFilha", b.getFilha()));
            bui.append(StringUtil.getTag("nomeBandaRodapeGrupo", b.getRodape()));
            bui.append(StringUtil.getTag("quebrarPagina", String.valueOf(b.getQuebrarPagina())));
            bui.append(StringUtil.getTag("itens", EditorXMLFactory.getAtributosItensBanda(itens)));
        }
        return bui.toString();
    }

    public static String getAtributosModelo(ModeloPagina modelo) {
        StringBuilder bui = new StringBuilder();
        ItemSelecionavel[] bandas = modelo.getBandas();
        for (int i = 0; i < bandas.length; ++i) {
            ItemSelecionavel[] itens = modelo.getItensBanda(bandas[i]);
            bui.append(StringUtil.getTag("banda", EditorXMLFactory.getAtributosBanda(bandas[i], itens)));
        }
        return StringUtil.getTag("bandas", bui.toString());
    }

    public static String getAtributosPagina(Pagina pagina) {
        StringBuilder atr = new StringBuilder();
        StringBuilder aux1 = new StringBuilder();
        StringBuilder aux2 = new StringBuilder();
        atr.append(StringUtil.getTag("alturaPagina", String.valueOf(pagina.getAltura())));
        atr.append(StringUtil.getTag("larguraPagina", String.valueOf(pagina.getLargura())));
        aux1.append(StringUtil.getTag("esquerda", String.valueOf(pagina.getMargemEsquerda())));
        aux1.append(StringUtil.getTag("direita", String.valueOf(pagina.getMargemDireita())));
        aux1.append(StringUtil.getTag("superior", String.valueOf(pagina.getMargemSuperior())));
        aux1.append(StringUtil.getTag("inferior", String.valueOf(pagina.getMargemInferior())));
        atr.append(StringUtil.getTag("margens", aux1.toString()));
        atr.append(StringUtil.getTag("forcarRetrato", pagina.getForcarRetrato() ? "Sim" : "Nao"));
        LinhaGuia[] lns = pagina.getLinhasGuias();
        aux1.delete(0, aux1.length());
        for (int i = 0; i < lns.length; ++i) {
            aux2.delete(0, aux2.length());
            aux2.append(StringUtil.getTag("orientacao", String.valueOf(lns[i].getOrientacao())));
            aux2.append(StringUtil.getTag("posicao", String.valueOf(lns[i].getPosicao())));
            aux1.append(StringUtil.getTag("linhaGuia", aux2.toString()));
        }
        atr.append(StringUtil.getTag("linhasGuias", aux1.toString()));
        atr.append(EditorXMLFactory.getAtributosModelo(pagina.getModeloArvore()));
        return atr.toString();
    }

    public static ItemSelecionavel instanciarItem(ModeloPagina modelo, String xml) {
        ItemSelecionavel item = null;
        try {
            AbstractItemModelo tmp;
            item = EditorXMLFactory.getItemSelecionavel(modelo, StringUtil.getValor(xml, "tipoItem"));
            if (item instanceof Rotulo) {
                tmp = (Rotulo)item;
                ((Rotulo)tmp).setTexto(StringUtil.getValor(xml, "texto"));
            }
            if (item instanceof AbstractItemModelo) {
                tmp = (AbstractItemModelo)item;
                tmp.setNome(StringUtil.getValor(xml, "nome"));
                tmp.setFonte(StringUtil.getFonte(StringUtil.getValor(xml, "fonte")));
                tmp.setRetangulo2D(StringUtil.getRetangulo2DFloat(StringUtil.getValor(xml, "retangulo")));
                tmp.setBordas(new Bordas().setAtributos(xml));
                tmp.setCorDaFonte(StringUtil.getColor(xml, "corDaFonte"));
                tmp.setAlinhamentoHorizontal(StringUtil.getInt(xml, "alinhamentoHorizontal"));
            }
            if (item instanceof CampoBanco) {
                tmp = (CampoBanco)item;
                ((CampoBanco)tmp).setCampoDoBanco(StringUtil.getValor(xml, "nomeCampo"));
                ((CampoBanco)tmp).setMascara(StringUtil.getValor(xml, "mascara"));
            }
            if (item instanceof Texto) {
                tmp = (Texto)item;
                ((Texto)tmp).setQuebrarPalavras(StringUtil.getBoolean(xml, "quebrarPalavras"));
                ((Texto)tmp).setCampoDoBanco(StringUtil.getValor(xml, "nomeCampo"));
            }
            if (item instanceof Expressao) {
                tmp = (Expressao)item;
                ((Expressao)tmp).setQuebrarLinhas(StringUtil.getBoolean(xml, "quebrarLinhas"));
                ((Expressao)tmp).setQuebrarPalavras(StringUtil.getBoolean(xml, "quebrarPalavras"));
                ((Expressao)tmp).setExpressao(StringUtil.getValor(xml, "expressao"));
                ((Expressao)tmp).setMascara(StringUtil.getValor(xml, "mascara"));
            }
            if (item instanceof Imagem) {
                tmp = (Imagem)item;
                ((Imagem)tmp).setEstender(StringUtil.getBoolean(StringUtil.getValor(xml, "estender")));
                ((Imagem)tmp).setImagem(StringUtil.getValor(xml, "imagem"));
                ((Imagem)tmp).setCampoDoBanco(StringUtil.getValor(xml, "nomeCampo"));
                ((Imagem)tmp).setExpressao(StringUtil.getValor(xml, "expressao"));
                ((Imagem)tmp).setCondicao(StringUtil.getValor(xml, "condicao"));
                ((Imagem)tmp).setAlinhamentoVertical(StringUtil.getInt(xml, "alinhamentoVertical"));
            }
            if (item instanceof CodigoBarras) {
                tmp = (CodigoBarras)item;
                ((CodigoBarras)tmp).setFormato(StringUtil.getInt(xml, "formato"));
                ((CodigoBarras)tmp).setCampoDoBanco(StringUtil.getValor(xml, "nomeCampo"));
                ((CodigoBarras)tmp).setPreencherZero(StringUtil.getInt(xml, "preencherZero"));
            }
            if (item instanceof Forma) {
                tmp = (Forma)item;
                ((Forma)tmp).setTipo(StringUtil.getInt(xml, "tipo"));
                ((Forma)tmp).setCorDaLinha(StringUtil.getColor(xml, "corLinha"));
                ((Forma)tmp).setCorDePreenchimento(StringUtil.getColor(xml, "corPreenchimento"));
                ((Forma)tmp).setAlinhamentoVertical(StringUtil.getInt(xml, "alinhamentoVertical"));
                ((Forma)tmp).setEspessura(StringUtil.getInt(xml, "espessura"));
            }
            if (item instanceof CodigoQRCode) {
                CodigoQRCode codigoQRCode = (CodigoQRCode)item;
                codigoQRCode.setExpressao(StringUtil.getValor(xml, "expressao"));
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "EditorXMLFactory: 258");
        }
        return item;
    }

    public static ItemSelecionavel[] instanciarItens(ModeloPagina modelo, String xml) {
        ArrayList<ItemSelecionavel> itens = new ArrayList<ItemSelecionavel>();
        String[] str = StringUtil.getValores(xml, "itemBanda");
        for (int i = 0; i < str.length; ++i) {
            ItemSelecionavel item = EditorXMLFactory.instanciarItem(modelo, str[i]);
            if (item == null) continue;
            itens.add(item);
        }
        return itens.toArray(new ItemSelecionavel[itens.size()]);
    }

    public static void carregarBandas(ModeloPagina modelo, MutableTreeNode raiz, String[] bandas) {
        if (modelo instanceof DefaultTreeModel) {
            DefaultTreeModel treeModel = (DefaultTreeModel)((Object)modelo);
            for (int i = 0; i < bandas.length; ++i) {
                Banda banda = new Banda(modelo);
                MutableTreeNode noBanda = (MutableTreeNode)banda.getTreeNode();
                treeModel.insertNodeInto(noBanda, raiz, raiz.getChildCount());
                banda.setTipo(StringUtil.getInt(bandas[i], "tipoBanda"));
                banda.setNomeBanda(StringUtil.getValor(bandas[i], "nome"));
                banda.setAltura(StringUtil.getFloat(bandas[i], "altura"));
                if (banda.getTipo() == 2) {
                    banda.setColunas(StringUtil.getInt(bandas[i], "colunas"));
                    banda.setEntreColunas(StringUtil.getInt(bandas[i], "entreColunas"));
                }
                banda.setCampoChave(StringUtil.getValor(bandas[i], "campoChave"));
                banda.setFilha(StringUtil.getValor(bandas[i], "nomeBandaFilha"));
                banda.setRodape(StringUtil.getValor(bandas[i], "nomeBandaRodapeGrupo"));
                banda.setQuebrarPagina(StringUtil.getBoolean(bandas[i], "quebrarPagina"));
                ItemSelecionavel[] itens = EditorXMLFactory.instanciarItens(modelo, StringUtil.getValor(bandas[i], "itens"));
                Point pt = banda.getRetangulo().getLocation();
                for (int j = 0; j < itens.length; ++j) {
                    ItemModelo tmp = (ItemModelo)itens[j];
                    Rectangle2D.Float rec = tmp.getRetangulo2D();
                    tmp.setRetangulo2D(new Rectangle2D.Float(rec.x + (float)pt.x, rec.y + (float)pt.y, rec.width, rec.height));
                    treeModel.insertNodeInto((MutableTreeNode)tmp.getTreeNode(), noBanda, noBanda.getChildCount());
                    tmp.setBanda(banda);
                }
            }
        }
    }

    private static ItemSelecionavel getItemSelecionavel(ModeloPagina modelo, String tipo) {
        if (tipo != null) {
            if (tipo.equalsIgnoreCase("jalis.relatorio.gerador.item.CampoBanco")) {
                return new CampoBanco(modelo);
            }
            if (tipo.equals("jalis.relatorio.gerador.item.Texto")) {
                return new Texto(modelo);
            }
            if (tipo.equals("jalis.relatorio.gerador.item.Expressao")) {
                return new Expressao(modelo);
            }
            if (tipo.equals("jalis.relatorio.gerador.item.Imagem")) {
                return new Imagem(modelo);
            }
            if (tipo.equals("jalis.relatorio.gerador.item.CodigoBarras")) {
                return new CodigoBarras(modelo);
            }
            if (tipo.equals("jalis.relatorio.gerador.item.Rotulo")) {
                return new Rotulo(modelo);
            }
            if (tipo.equals("jalis.relatorio.gerador.item.Forma")) {
                return new Forma(modelo);
            }
            if (tipo.equals("jalis.relatorio.gerador.item.CodigoQRCode")) {
                return new CodigoQRCode(modelo);
            }
        }
        return null;
    }
}

