/*
 * Decompiled with CFR 0.152.
 */
package jalis.relatorio.editor;

import jalis.relatorio.editor.Pagina;
import jalis.relatorio.editor.item.Banda;
import jalis.relatorio.editor.item.CampoBanco;
import jalis.relatorio.editor.item.CodigoBarras;
import jalis.relatorio.editor.item.CodigoQRCode;
import jalis.relatorio.editor.item.Expressao;
import jalis.relatorio.editor.item.Imagem;
import jalis.relatorio.editor.item.ItemInvalido;
import jalis.relatorio.editor.item.Rotulo;
import jalis.util.ImagemUtils;
import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;

public class ArvoreRenderer
extends JLabel
implements TreeCellRenderer {
    private Icon pagina;
    private Icon banda;
    private Icon rotulo;
    private Icon campoBanco;
    private Icon expressao;
    private Icon codigoBarras;
    private Icon imagem;
    private Icon invalido;
    private Icon codigoQRCode;
    protected Color corTextoSelecionado;
    protected Color corTextoNaoSelecionado;
    protected Color corFundoSelecionado;
    protected Color corFundoNaoSelecionado;
    protected Color corBordaSelecionado;

    public ArvoreRenderer() {
        this.setOpaque(true);
        this.setHorizontalAlignment(2);
        this.pagina = ImagemUtils.carregaImagemJalis("editor/pagina_16x16.jpg");
        this.banda = ImagemUtils.carregaImagemJalis("editor/banda_16x16.jpg");
        this.rotulo = ImagemUtils.carregaImagemJalis("editor/rotulo_16x16.jpg");
        this.campoBanco = ImagemUtils.carregaImagemJalis("editor/campo_banco_16x16.jpg");
        this.expressao = ImagemUtils.carregaImagemJalis("editor/expressao_16x16.jpg");
        this.codigoBarras = ImagemUtils.carregaImagemJalis("editor/cod_bar_16x16.jpg");
        this.imagem = ImagemUtils.carregaImagemJalis("editor/imagem_16x16.jpg");
        this.codigoQRCode = ImagemUtils.carregaImagemJalis("editor/qrcode_16x16.jpg");
        this.invalido = ImagemUtils.carregaImagemJalis("editor/iconeInvalido.jpg");
        this.corTextoSelecionado = UIManager.getColor("Tree.selectionForeground");
        this.corTextoNaoSelecionado = UIManager.getColor("Tree.textForeground");
        this.corFundoSelecionado = UIManager.getColor("Tree.selectionBackground");
        this.corFundoNaoSelecionado = UIManager.getColor("Tree.textBackground");
        this.corBordaSelecionado = UIManager.getColor("Tree.selectionBorderColor");
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (value instanceof DefaultMutableTreeNode) {
            this.setText(value.toString());
            Icon icone = this.getIconeValor(((DefaultMutableTreeNode)value).getUserObject());
            if (icone != null) {
                this.setIcon(icone);
            }
            this.setForeground(selected ? this.corTextoSelecionado : this.corTextoNaoSelecionado);
            this.setBackground(selected ? this.corFundoSelecionado : this.corFundoNaoSelecionado);
            this.setComponentOrientation(tree.getComponentOrientation());
            this.setFont(tree.getFont());
        }
        return this;
    }

    private Icon getIconeValor(Object valor) {
        if (valor instanceof Pagina) {
            return this.pagina;
        }
        if (valor instanceof Banda) {
            return this.banda;
        }
        if (valor instanceof Rotulo) {
            return this.rotulo;
        }
        if (valor instanceof CampoBanco) {
            return this.campoBanco;
        }
        if (valor instanceof Expressao) {
            return this.expressao;
        }
        if (valor instanceof CodigoBarras) {
            return this.codigoBarras;
        }
        if (valor instanceof Imagem) {
            return this.imagem;
        }
        if (valor instanceof CodigoQRCode) {
            return this.codigoQRCode;
        }
        if (valor instanceof ItemInvalido) {
            return this.invalido;
        }
        return null;
    }
}

