/*
 * Decompiled with CFR 0.152.
 */
package jalis.relatorio;

import jalis.laboratorio.Laboratorio;
import jalis.relatorio.gerador.Imprimivel;
import jalis.relatorio.gerador.PreVisualizacao;
import jalis.relatorio.gerador.Relatorio;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.math.RoundingMode;
import java.util.Date;
import java.util.Map;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.table.TableModel;

public class Gerador
implements Imprimivel {
    private PrintService service;
    private boolean visualizar;
    private Relatorio relatorio;
    private Container pai;
    private float zoom = 1.0f;
    private int copias = 1;
    private Runnable acaoFechar;
    private String tituloImpressao = "";
    private int casas = 2;
    private RoundingMode round = RoundingMode.HALF_UP;

    public Relatorio getRelatorio() {
        return this.relatorio;
    }

    public static boolean vazio(String xml) {
        if (xml != null) {
            xml = StringUtil.getValor(xml, "relatorio");
            xml = StringUtil.getValor(xml, "bandas");
            return StringUtil.getListValores(xml, "banda").isEmpty();
        }
        return true;
    }

    public Gerador(int casas, RoundingMode round) {
        this.service = PrintServiceLookup.lookupDefaultPrintService();
        this.visualizar = false;
        this.casas = casas;
        this.round = round;
    }

    public Gerador(String nomeImpressora) {
        this.setImpressora(nomeImpressora);
        this.visualizar = false;
    }

    @Override
    public void setImpressora(String nomeImpressora) {
        for (PrintService ps : PrintServiceLookup.lookupPrintServices(DocFlavor.SERVICE_FORMATTED.PRINTABLE, null)) {
            if (!ps.getName().equalsIgnoreCase(nomeImpressora)) continue;
            this.service = ps;
            break;
        }
    }

    public void setPai(Container pai) {
        this.pai = pai;
    }

    public void setAcaoFechar(Runnable acaoFechar) {
        this.acaoFechar = acaoFechar;
    }

    public void setZoomPreVisualizar(float zoom) {
        this.zoom = zoom;
    }

    public void setPreVisualizar(boolean preview) {
        this.visualizar = preview;
    }

    public void setCopias(int copias) {
        this.copias = copias;
    }

    public void executar(String xml, TableModel dados) {
        this.executar(xml, dados, null, false);
    }

    public void executar(String xml, TableModel dados, boolean exibirModal) {
        this.executar(xml, dados, null, exibirModal);
    }

    public void executar(String xml, TableModel dados, Map<String, Object> variaveis) {
        this.executar(xml, dados, variaveis, false);
    }

    public void executar(String xml, TableModel dados, Map<String, Object> variaveis, boolean exibirModal) {
        this.executar(xml, dados, variaveis, exibirModal, false);
    }

    public void executar(String xml, TableModel dados, Map<String, Object> variaveis, boolean exibirModal, boolean gerarRelatorio) {
        if (xml == null || xml.trim().length() == 0 || dados == null) {
            return;
        }
        Relatorio rel = new Relatorio(dados, variaveis, this.casas, this.round);
        rel.setConfiguracao(xml);
        rel.setCopias(this.copias);
        if (gerarRelatorio) {
            rel.gerarRelatorio();
        }
        this.executar(rel, exibirModal, true, false);
    }

    public void executar(String xml, TableModel dados, Map<String, Object> variaveis, boolean exibirModal, boolean gerarRelatorio, boolean isColetaWeb) {
        if (xml == null || xml.trim().length() == 0 || dados == null) {
            return;
        }
        Relatorio rel = new Relatorio(dados, variaveis, this.casas, this.round);
        rel.setConfiguracao(xml);
        rel.setCopias(this.copias);
        if (gerarRelatorio) {
            rel.gerarRelatorio();
        }
        this.executar(rel, exibirModal, true, isColetaWeb);
    }

    public void executar(Relatorio relatorio) {
        this.executar(relatorio, false, true, false);
    }

    public void executar(Relatorio relatorio, boolean isGerarPDF) {
        this.executar(relatorio, false, true, isGerarPDF);
    }

    public void executar(Relatorio relatorio, boolean exibirModal, boolean imprimirComThread, boolean isColetaWeb) {
        if (relatorio == null) {
            return;
        }
        this.relatorio = relatorio;
        if (this.visualizar) {
            PreVisualizacao preview = new PreVisualizacao(this, relatorio);
            preview.setZoom(this.zoom);
            if (this.pai != null) {
                this.pai.setLayout(new BorderLayout());
                this.pai.add((Component)preview, "Center");
                preview.setAcaoFechar(this.acaoFechar);
            } else {
                Window frame;
                if (exibirModal) {
                    frame = new JDialog(Laboratorio.getInstancia());
                    ((JDialog)frame).setModal(true);
                    ((JDialog)frame).getContentPane().setLayout(new BorderLayout());
                    ((JDialog)frame).getContentPane().add((Component)preview, "Center");
                    ((JDialog)frame).setDefaultCloseOperation(2);
                } else {
                    frame = new JFrame();
                    ((JFrame)frame).setLayout(new BorderLayout());
                    ((JFrame)frame).add((Component)preview, "Center");
                    ((JFrame)frame).setDefaultCloseOperation(2);
                }
                preview.setAcaoFechar(new Runnable(){

                    @Override
                    public void run() {
                        frame.dispose();
                    }
                });
                frame.setSize(new Dimension(750, 600));
                frame.setVisible(true);
            }
        } else if (!isColetaWeb) {
            this.imprimir(imprimirComThread);
        }
    }

    @Override
    public void imprimir(boolean usarThread) {
        if (this.service != null && this.relatorio != null) {
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    if (Gerador.this.relatorio.getFormatoPagina().getOrientation() == 0) {
                        DocFlavor.SERVICE_FORMATTED flavor = DocFlavor.SERVICE_FORMATTED.PRINTABLE;
                        try {
                            Gerador.this.service.createPrintJob().print(new SimpleDoc(Gerador.this.relatorio, flavor, Gerador.this.relatorio.getAtributosDocumento()), Gerador.this.relatorio.getAtributosImpressora());
                        }
                        catch (Exception e) {
                            ErrorLogger.mostraMensagem(null, "O documento e atributos n\u00e3o s\u00e3o v\u00e1lidos para o trabalho de impress\u00e3o.", e.getStackTrace());
                        }
                    } else {
                        PrinterJob job = null;
                        try {
                            job = PrinterJob.getPrinterJob();
                            if (job != null) {
                                if (Gerador.this.tituloImpressao != null && Gerador.this.tituloImpressao.trim().length() > 0) {
                                    job.setJobName(Gerador.this.tituloImpressao);
                                } else {
                                    job.setJobName("Impressao de relatorio - Jalis - " + Funcoes.formataData("dd_mm_yyyy_HH_mm_ss_SSS", new Date()));
                                }
                                job.setPrintService(Gerador.this.service);
                            }
                        }
                        catch (PrinterException e) {
                            ErrorLogger.mostraMensagem(null, "N\u00e3o foi possivel criar servi\u00e7o de impress\u00e3o.", e.getStackTrace());
                        }
                        if (job != null) {
                            try {
                                job.setPrintable(Gerador.this.relatorio, Gerador.this.relatorio.getFormatoPagina());
                                job.setCopies(Gerador.this.relatorio.getCopias());
                                job.print();
                            }
                            catch (PrinterException e) {
                                ErrorLogger.mostraMensagem(null, "O trabalho de impress\u00e3o falhou ao iniciar.", e.getStackTrace());
                            }
                        }
                    }
                }
            };
            if (usarThread) {
                new Thread(run).start();
            } else {
                run.run();
            }
        }
    }

    public void setTituloImpressao(String titulo) {
        this.tituloImpressao = titulo;
    }

    public Container getPai() {
        return this.pai;
    }
}

