/*
 * Decompiled with CFR 0.152.
 */
package jalis.relatorio;

import jalis.laboratorio.DisposeListener;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.configurador.componente.Componente;
import jalis.relatorio.editor.ArvoreRenderer;
import jalis.relatorio.editor.EditorXMLFactory;
import jalis.relatorio.editor.LinhaGuia;
import jalis.relatorio.editor.ModeloArvore;
import jalis.relatorio.editor.Pagina;
import jalis.relatorio.editor.item.AbstractItemModelo;
import jalis.relatorio.editor.item.Banda;
import jalis.relatorio.editor.item.CampoBanco;
import jalis.relatorio.editor.item.CodigoBarras;
import jalis.relatorio.editor.item.CodigoQRCode;
import jalis.relatorio.editor.item.Expressao;
import jalis.relatorio.editor.item.Forma;
import jalis.relatorio.editor.item.Imagem;
import jalis.relatorio.editor.item.Rotulo;
import jalis.relatorio.editor.item.Texto;
import jalis.relatorio.editor.propriedade.TabelaPropriedades;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;

public class Editor
extends JDialog
implements ActionListener,
DisposeListener {
    Pagina pagina = new Pagina();
    JPanel panelItens = new JPanel();
    JPanel panelBarra = new JPanel();
    JPanel panelBarBotoesEsq = new JPanel();
    JPanel panelBarBotoesDir = new JPanel();
    JTree treeArvore = new JTree(this.pagina.getModeloArvore());
    JScrollPane scrollArvore = new JScrollPane(this.treeArvore);
    JScrollPane scrollPropriedades = new JScrollPane();
    JScrollPane scrollRelatorio = new JScrollPane(this.pagina);
    JSplitPane splitDivisor1 = new JSplitPane(1, this.scrollRelatorio, this.scrollPropriedades);
    JSplitPane splitDivisor2 = new JSplitPane(1, this.scrollArvore, this.splitDivisor1);
    JButton buttonSeta = this.criarBotaoComponente("seta", "Seta");
    JButton buttonBanda = this.criarBotaoComponente("banda", "Banda");
    JButton buttonRotulo = this.criarBotaoComponente("rotulo", "R\u00f3tulo");
    JButton buttonTexto = this.criarBotaoComponente("texto", "Texto");
    JButton buttonCampoBanco = this.criarBotaoComponente("campo_banco", "Dados");
    JButton buttonExpressao = this.criarBotaoComponente("expressao", "Express\u00e3o");
    JButton buttonImagem = this.criarBotaoComponente("imagem", "Imagem");
    JButton buttonCodigoBarras = this.criarBotaoComponente("cod_bar", "C\u00f3digo de Barras");
    JButton buttonForma = this.criarBotaoComponente("forma", "Forma");
    JButton buttonCodigoQRCode = this.criarBotaoComponente("qrcode_32x32", "C\u00f3digo QRCode");
    JButton buttonSalvar = new JButton("Salvar");
    JButton buttonCancelar = new JButton("Cancelar");
    JButton buttonImportar = new JButton("Importar");
    JButton buttonExportar = new JButton("Exportar");
    JButton buttonOcultarLinhas = new JButton("Ocultar linhas");
    JComboBox comboZoom = new JComboBox<String>(new String[]{"25%", "50%", "75%", "100%", "125%", "150%", "175%", "200%"});
    protected Componente[] componentes = new Componente[0];
    private boolean ok = false;

    public static Editor novaInstancia(Object pai) {
        if (pai instanceof Frame) {
            return new Editor((Frame)pai, "Editor de relat\u00f3rios", true);
        }
        if (pai instanceof Dialog) {
            return new Editor((Dialog)pai, "Editor de relat\u00f3rios", true);
        }
        return null;
    }

    public Editor(Frame frame, String title, boolean modal) {
        super(frame, title, modal);
        if (frame instanceof Laboratorio) {
            ((Laboratorio)frame).addDisposeListener(this);
        }
        try {
            this.iniciar();
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(frame, e.getMessage(), e.getStackTrace(), "Editor: 83");
        }
    }

    public Editor(Dialog dialog, String title, boolean modal) {
        super(dialog, title, modal);
        try {
            this.iniciar();
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(dialog, e.getMessage(), e.getStackTrace(), "Editor: 99");
        }
    }

    private void iniciar() {
        int larguraTela;
        DisplayMode display = this.getGraphicsConfiguration().getDevice().getDisplayMode();
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        int n = display != null ? display.getWidth() : (larguraTela = d != null ? d.width : 800);
        int alturaTela = display != null ? display.getHeight() : (d != null ? d.height : 600);
        this.setSize(new Dimension(larguraTela - 5, alturaTela - 25));
        Container content = this.getContentPane();
        content.setLayout(new BorderLayout());
        content.add((Component)this.panelItens, "North");
        content.add((Component)this.panelBarra, "South");
        content.add((Component)this.splitDivisor2, "Center");
        this.panelItens.setLayout(new FlowLayout(0, 3, 3));
        this.panelItens.add(this.buttonSeta);
        this.panelItens.add(this.buttonBanda);
        this.panelItens.add(this.buttonRotulo);
        this.panelItens.add(this.buttonTexto);
        this.panelItens.add(this.buttonCampoBanco);
        this.panelItens.add(this.buttonExpressao);
        this.panelItens.add(this.buttonImagem);
        this.panelItens.add(this.buttonCodigoBarras);
        this.panelItens.add(this.buttonForma);
        this.panelItens.add(this.buttonCodigoQRCode);
        this.buttonSeta.addActionListener(this);
        this.buttonSeta.setIcon(ImagemUtils.carregaImagemJalis("editor/seta.jpg"));
        this.buttonSeta.setBackground(Color.white);
        this.buttonBanda.addActionListener(this);
        this.buttonBanda.setIcon(ImagemUtils.carregaImagemJalis("editor/banda.jpg"));
        this.buttonBanda.setBackground(Color.white);
        this.buttonBanda.setToolTipText("Banda");
        this.buttonRotulo.addActionListener(this);
        this.buttonRotulo.setIcon(ImagemUtils.carregaImagemJalis("editor/rotulo.jpg"));
        this.buttonRotulo.setBackground(Color.white);
        this.buttonRotulo.setToolTipText("Rotulo");
        this.buttonTexto.setIcon(ImagemUtils.carregaImagemJalis("editor/texto.jpg"));
        this.buttonTexto.addActionListener(this);
        this.buttonTexto.setBackground(Color.white);
        this.buttonTexto.setToolTipText("Texto");
        this.buttonCampoBanco.addActionListener(this);
        this.buttonCampoBanco.setIcon(ImagemUtils.carregaImagemJalis("editor/campo_banco.jpg"));
        this.buttonCampoBanco.setBackground(Color.white);
        this.buttonCampoBanco.setToolTipText("Campo do Banco");
        this.buttonExpressao.addActionListener(this);
        this.buttonExpressao.setIcon(ImagemUtils.carregaImagemJalis("editor/expressao.jpg"));
        this.buttonExpressao.setBackground(Color.white);
        this.buttonExpressao.setToolTipText("Express\u00e3o");
        this.buttonImagem.addActionListener(this);
        this.buttonImagem.setIcon(ImagemUtils.carregaImagemJalis("editor/imagem.jpg"));
        this.buttonImagem.setBackground(Color.white);
        this.buttonImagem.setToolTipText("Imagem");
        this.buttonCodigoBarras.addActionListener(this);
        this.buttonCodigoBarras.setIcon(ImagemUtils.carregaImagemJalis("editor/cod_bar.jpg"));
        this.buttonCodigoBarras.setBackground(Color.white);
        this.buttonCodigoBarras.setToolTipText("Codigo de Barras");
        this.buttonForma.addActionListener(this);
        this.buttonForma.setIcon(ImagemUtils.carregaImagemJalis("editor/forma.jpg"));
        this.buttonForma.setBackground(Color.white);
        this.buttonForma.setToolTipText("Forma");
        this.buttonCodigoQRCode.addActionListener(this);
        this.buttonCodigoQRCode.setIcon(ImagemUtils.carregaImagemJalis("editor/qrcode_32x32.jpg"));
        this.buttonCodigoQRCode.setBackground(Color.white);
        this.buttonCodigoQRCode.setToolTipText("Codigo QRCode");
        this.scrollRelatorio.setBackground(Color.lightGray);
        this.scrollRelatorio.setCorner("UPPER_LEFT_CORNER", new JLabel("cm", 0));
        this.scrollRelatorio.setColumnHeaderView(this.pagina.getReguaHorizontal());
        this.scrollRelatorio.setRowHeaderView(this.pagina.getReguaVertical());
        this.panelBarra.setLayout(new BorderLayout());
        this.panelBarra.add((Component)this.panelBarBotoesEsq, "West");
        this.panelBarra.add((Component)this.panelBarBotoesDir, "Center");
        this.panelBarBotoesEsq.setLayout(new FlowLayout(0, 3, 3));
        this.panelBarBotoesEsq.setPreferredSize(new Dimension(380, 10));
        this.panelBarBotoesEsq.add(this.buttonImportar);
        this.panelBarBotoesEsq.add(this.buttonExportar);
        this.panelBarBotoesEsq.add(this.buttonOcultarLinhas);
        this.panelBarBotoesEsq.add(this.comboZoom);
        this.panelBarBotoesDir.setLayout(new FlowLayout(2, 3, 3));
        this.panelBarBotoesDir.add(this.buttonSalvar);
        this.panelBarBotoesDir.add(this.buttonCancelar);
        this.buttonImportar.addActionListener(this);
        this.buttonExportar.addActionListener(this);
        this.buttonOcultarLinhas.addActionListener(this);
        this.comboZoom.setFocusable(false);
        this.comboZoom.setSelectedIndex(3);
        this.comboZoom.addActionListener(this);
        this.buttonSalvar.addActionListener(this);
        this.buttonCancelar.addActionListener(this);
        this.buttonSalvar.setMnemonic('S');
        this.buttonCancelar.setMnemonic('C');
        this.splitDivisor1.setDividerSize(4);
        this.splitDivisor1.setDividerLocation(larguraTela - 150 - 280);
        this.splitDivisor2.setDividerSize(3);
        this.splitDivisor2.setDividerLocation(150);
        this.scrollArvore.setPreferredSize(new Dimension(150, 10));
        this.scrollArvore.setFocusable(false);
        this.treeArvore.setFocusable(false);
        this.treeArvore.setCellRenderer(new ArvoreRenderer());
        this.treeArvore.addMouseListener(this.pagina.getComponenteSelecao().getMouseListener());
        TabelaPropriedades tabProp = new TabelaPropriedades();
        this.scrollPropriedades.setViewportView(tabProp.getTablePropriedade());
        this.scrollPropriedades.setPreferredSize(new Dimension(200, 20));
        this.pagina.getModeloArvore().setArvore(this.treeArvore);
        this.pagina.getComponenteSelecao().addSelecaoListener(tabProp);
        this.pagina.getComponenteSelecao().setArvore(this.treeArvore);
        this.buttonCodigoQRCode.setVisible(false);
    }

    public boolean ok() {
        return this.ok;
    }

    public void setCamposDoBanco(String[] campos) {
        if (campos == null) {
            this.pagina.setCamposDoBanco(new String[0]);
        } else {
            StringUtil.ordenar(campos);
            this.pagina.setCamposDoBanco(campos);
        }
    }

    public void setVariaveis(String[] variaveis) {
        if (variaveis == null) {
            this.pagina.setVariaveis(new String[0]);
        } else {
            StringUtil.ordenar(variaveis);
            this.pagina.setVariaveis(variaveis);
        }
    }

    public String[] getCampos() {
        ArrayList<String> campos = new ArrayList<String>();
        for (Componente c : this.pagina.getComponentes()) {
            campos.add(c.getNome());
        }
        return campos.toArray(new String[campos.size()]);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.buttonSeta) {
            this.pagina.setItemParaCriar(null);
        } else if (o == this.buttonBanda) {
            this.pagina.setItemParaCriar(Banda.class);
        } else if (o == this.buttonRotulo) {
            this.pagina.setItemParaCriar(Rotulo.class);
        } else if (o == this.buttonTexto) {
            this.pagina.setItemParaCriar(Texto.class);
        } else if (o == this.buttonCampoBanco) {
            this.pagina.setItemParaCriar(CampoBanco.class);
        } else if (o == this.buttonExpressao) {
            this.pagina.setItemParaCriar(Expressao.class);
        } else if (o == this.buttonImagem) {
            this.pagina.setItemParaCriar(Imagem.class);
        } else if (o == this.buttonCodigoBarras) {
            this.pagina.setItemParaCriar(CodigoBarras.class);
        } else if (o == this.buttonForma) {
            this.pagina.setItemParaCriar(Forma.class);
        } else if (o == this.buttonCodigoQRCode) {
            this.pagina.setItemParaCriar(CodigoQRCode.class);
        } else if (o == this.buttonImportar) {
            JFileChooser fc = ComponenteFactory.novoJFileChooser();
            fc.setFileFilter(ComponenteFactory.novoFileFilter("Arquivo de relat\u00f3rio", "xml"));
            if (fc.showOpenDialog(this) == 0) {
                try {
                    this.setAtributos(StringUtil.lerArquivoTexto(fc.getSelectedFile().getPath()));
                }
                catch (Exception e1) {
                    Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel importar o modelo.\nMensagem: " + e1.getMessage(), 1);
                }
            }
        } else if (o == this.buttonExportar) {
            JFileChooser fc = ComponenteFactory.novoJFileChooser();
            fc.setFileFilter(ComponenteFactory.novoFileFilter("Arquivo de relat\u00f3rio", "xml"));
            if (fc.showSaveDialog(this) == 0) {
                try {
                    StringUtil.escreverArquivoTexto(this.addExtensao(fc.getSelectedFile().getPath()), this.getAtributos());
                }
                catch (Exception e1) {
                    Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel exportar o modelo do relat\u00f3rio.\nMensagem: " + e1.getMessage(), 1);
                }
            }
        } else if (o == this.buttonOcultarLinhas) {
            this.pagina.setExibirLinhasGuias(!this.pagina.getExibirLinhasGuias());
            this.buttonOcultarLinhas.setText(this.pagina.getExibirLinhasGuias() ? "Ocultar linhas" : "Mostrar linhas");
        } else if (o == this.comboZoom) {
            this.pagina.setZoom((double)(this.comboZoom.getSelectedIndex() + 1) * 0.25);
        } else if (o == this.buttonSalvar) {
            this.ok = true;
            this.dispose();
        } else if (o == this.buttonCancelar) {
            this.dispose();
        }
    }

    public String getAtributos() {
        return StringUtil.getTag("relatorio", EditorXMLFactory.getAtributosPagina(this.pagina));
    }

    public void setAtributos(String xml) {
        if (xml != null && xml.length() > 0) {
            float largura = StringUtil.getFloat(xml, "larguraPagina");
            float altura = StringUtil.getFloat(xml, "alturaPagina");
            if (largura <= 0.0f || altura <= 0.0f) {
                return;
            }
            AbstractItemModelo.limparTabelasEstaticas();
            this.pagina.setForcarRetrato(StringUtil.getBoolean(xml, "forcarRetrato"));
            this.pagina.setLargura(largura);
            this.pagina.setAltura(altura);
            String tmp = StringUtil.getValor(xml, "margens");
            this.pagina.setMargemEsquerda(StringUtil.getFloat(tmp, "esquerda"));
            this.pagina.setMargemDireita(StringUtil.getFloat(tmp, "direita"));
            this.pagina.setMargemSuperior(StringUtil.getFloat(tmp, "superior"));
            this.pagina.setMargemInferior(StringUtil.getFloat(tmp, "inferior"));
            String[] linhas = StringUtil.getValores(StringUtil.getValor(xml, "linhasGuias"), "linhaGuia");
            for (int i = 0; i < linhas.length; ++i) {
                int ori = StringUtil.getInt(linhas[i], "orientacao");
                int pos = StringUtil.getInt(linhas[i], "posicao");
                this.pagina.adicionarLinhaGuia(new LinhaGuia(this.pagina, ori, pos));
            }
            ModeloArvore modelo = this.pagina.getModeloArvore();
            DefaultMutableTreeNode raiz = (DefaultMutableTreeNode)modelo.getRoot();
            raiz.removeAllChildren();
            EditorXMLFactory.carregarBandas(this.pagina.getModeloArvore(), raiz, StringUtil.getValores(StringUtil.getValor(xml, "bandas"), "banda"));
            this.treeArvore.validate();
            this.treeArvore.repaint();
            this.pagina.repaint();
        }
    }

    public boolean vazio() {
        return this.pagina.getModeloArvore().vazio();
    }

    private String addExtensao(String arquivo) {
        String tmp = arquivo;
        if (!tmp.endsWith(".xml")) {
            tmp = tmp + ".xml";
        }
        return tmp;
    }

    public void setComponentes(Componente[] comp) {
        if (comp != null) {
            this.componentes = comp;
        }
    }

    public void setHabilitarQRCode() {
        this.buttonCodigoQRCode.setVisible(true);
    }

    private JButton criarBotaoComponente(String imagem, String toolTipText) {
        JButton button = new JButton(imagem == null ? new ImageIcon() : ImagemUtils.carregaImagemJalis("editor/" + imagem + ".jpg"));
        button.addActionListener(this);
        button.setBackground(Color.white);
        button.setPreferredSize(new Dimension(50, 40));
        button.setToolTipText(toolTipText);
        return button;
    }
}

