/*
 * Decompiled with CFR 0.152.
 */
package jalis.model.vo.recepcao.preagendamento;

import jalis.model.utils.DataBaseField;
import jalis.model.utils.DataBaseFieldNotNull;
import jalis.model.utils.DataBaseForeignKey;
import jalis.model.utils.DataBasePrimaryKey;
import jalis.model.utils.DataBaseTable;
import jalis.model.utils.FieldTimeStamp;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.util.tabela.Registro;
import java.util.Date;

@DataBaseTable(value="preagendamento")
public class PreAgendamentoVO {
    @DataBaseField(value="fil_codigo")
    @DataBasePrimaryKey
    @DataBaseFieldNotNull
    @DataBaseForeignKey
    private FilialVO filial;
    @DataBaseField(value="pre_codigo")
    @DataBasePrimaryKey
    @DataBaseFieldNotNull
    private Integer codigo;
    @DataBaseField(value="pre_datahora")
    @FieldTimeStamp
    private Date dataHoraPreAgendamento;
    @DataBaseField(value="pre_codigopaciente")
    private Integer codigoPaciente;
    @DataBaseField(value="pre_nomepaciente")
    private String nomePaciente;
    @DataBaseField(value="pre_enderecopaciente")
    private String enderecoPaciente;
    @DataBaseField(value="pre_numeroenderecopaciente")
    private String numeroEnderecoPaciente;
    @DataBaseField(value="pre_bairropaciente")
    private String bairroPaciente;
    @DataBaseField(value="pre_cidadepaciente")
    private String cidadePaciente;
    @DataBaseField(value="pre_estadopaciente")
    private String estadoPaciente;
    @DataBaseField(value="pre_fonepaciente")
    private String fonePaciente;
    @DataBaseField(value="pre_celularpaciente")
    private String celularPaciente;
    @DataBaseField(value="pre_sexopaciente")
    private String sexoPaciente;
    @DataBaseField(value="pre_situacao")
    private String situacao;
    @DataBaseField(value="pre_dataprevista")
    @FieldTimeStamp
    private Date dataPrevista;
    @DataBaseField(value="pre_horarioprevisto")
    private String horarioPrevisto;
    @DataBaseField(value="pre_unidadeSelecionada")
    private String unidadeSelecionada;
    @DataBaseField(value="pre_convenio")
    private String convenioInformado;
    @DataBaseField(value="pre_medico")
    private String medicoInformado;
    @DataBaseField(value="pre_convenionaoinformado")
    private Boolean convenioNaoInformado;
    @DataBaseField(value="pre_mediconaoinformado")
    private Boolean medicoNaoInformado;
    @DataBaseField(value="pre_descritivoexames")
    private String descritivoExames;
    @DataBaseField(value="pre_motivosituacao")
    private String motivoSituacao;
    @DataBaseField(value="pre_datahoraagendou")
    @FieldTimeStamp
    private Date dataHoraAgendou;
    @DataBaseField(value="pre_codigofilialpaciente")
    private Integer codigoFilialPaciente;
    @DataBaseField(value="pre_alterardadospaciente")
    private Boolean alteraDadosPaciente;
    @DataBaseField(value="pre_tipoexamesinformados")
    private String tipoExamesInformados;
    @DataBaseField(value="pre_datacancelamento")
    @FieldTimeStamp
    private Date dataCancelamento;
    @DataBaseField(value="usr_codagendou")
    private String usuarioAgendamento;
    @DataBaseField(value="usr_codcancelamento")
    private String usuarioCancelamento;

    public FilialVO getFilial() {
        return this.filial;
    }

    public void setFilial(FilialVO filial) {
        this.filial = filial;
    }

    public Integer getCodigo() {
        return this.codigo;
    }

    public void setCodigo(Integer codigo) {
        this.codigo = codigo;
    }

    public Date getDataHoraPreAgendamento() {
        return this.dataHoraPreAgendamento;
    }

    public void setDataHoraPreAgendamento(Date dataHoraPreAgendamento) {
        this.dataHoraPreAgendamento = dataHoraPreAgendamento;
    }

    public Integer getCodigoPaciente() {
        return this.codigoPaciente;
    }

    public void setCodigoPaciente(Integer codigoPaciente) {
        this.codigoPaciente = codigoPaciente;
    }

    public String getNomePaciente() {
        return this.nomePaciente;
    }

    public void setNomePaciente(String nomePaciente) {
        this.nomePaciente = nomePaciente;
    }

    public String getEnderecoPaciente() {
        return this.enderecoPaciente;
    }

    public void setEnderecoPaciente(String enderecoPaciente) {
        this.enderecoPaciente = enderecoPaciente;
    }

    public String getNumeroEnderecoPaciente() {
        return this.numeroEnderecoPaciente;
    }

    public void setNumeroEnderecoPaciente(String numeroEnderecoPaciente) {
        this.numeroEnderecoPaciente = numeroEnderecoPaciente;
    }

    public String getBairroPaciente() {
        return this.bairroPaciente;
    }

    public void setBairroPaciente(String bairroPaciente) {
        this.bairroPaciente = bairroPaciente;
    }

    public String getCidadePaciente() {
        return this.cidadePaciente;
    }

    public void setCidadePaciente(String cidadePaciente) {
        this.cidadePaciente = cidadePaciente;
    }

    public String getEstadoPaciente() {
        return this.estadoPaciente;
    }

    public void setEstadoPaciente(String estadoPaciente) {
        this.estadoPaciente = estadoPaciente;
    }

    public String getFonePaciente() {
        return this.fonePaciente;
    }

    public void setFonePaciente(String fonePaciente) {
        this.fonePaciente = fonePaciente;
    }

    public String getCelularPaciente() {
        return this.celularPaciente;
    }

    public void setCelularPaciente(String celularPaciente) {
        this.celularPaciente = celularPaciente;
    }

    public String getSexoPaciente() {
        return this.sexoPaciente;
    }

    public void setSexoPaciente(String sexoPaciente) {
        this.sexoPaciente = sexoPaciente;
    }

    public String getSituacao() {
        return this.situacao;
    }

    public void setSituacao(String situacao) {
        this.situacao = situacao;
    }

    public Date getDataPrevista() {
        return this.dataPrevista;
    }

    public void setDataPrevista(Date dataPrevista) {
        this.dataPrevista = dataPrevista;
    }

    public String getHorarioPrevisto() {
        return this.horarioPrevisto;
    }

    public void setHorarioPrevisto(String horarioPrevisto) {
        this.horarioPrevisto = horarioPrevisto;
    }

    public String getUnidadeSelecionada() {
        return this.unidadeSelecionada;
    }

    public void setUnidadeSelecionada(String unidadeSelecionada) {
        this.unidadeSelecionada = unidadeSelecionada;
    }

    public String getConvenioInformado() {
        return this.convenioInformado;
    }

    public void setConvenioInformado(String convenioInformado) {
        this.convenioInformado = convenioInformado;
    }

    public String getMedicoInformado() {
        return this.medicoInformado;
    }

    public void setMedicoInformado(String medicoInformado) {
        this.medicoInformado = medicoInformado;
    }

    public Boolean getConvenioNaoInformado() {
        return this.convenioNaoInformado;
    }

    public void setConvenioNaoInformado(Boolean convenioNaoInformado) {
        this.convenioNaoInformado = convenioNaoInformado;
    }

    public Boolean getMedicoNaoInformado() {
        return this.medicoNaoInformado;
    }

    public void setMedicoNaoInformado(Boolean medicoNaoInformado) {
        this.medicoNaoInformado = medicoNaoInformado;
    }

    public String getDescritivoExames() {
        return this.descritivoExames;
    }

    public void setDescritivoExames(String descritivoExames) {
        this.descritivoExames = descritivoExames;
    }

    public String getMotivoSituacao() {
        return this.motivoSituacao;
    }

    public void setMotivoSituacao(String motivoSituacao) {
        this.motivoSituacao = motivoSituacao;
    }

    public Date getDataHoraAgendou() {
        return this.dataHoraAgendou;
    }

    public void setDataHoraAgendou(Date dataHoraAgendou) {
        this.dataHoraAgendou = dataHoraAgendou;
    }

    public Integer getCodigoFilialPaciente() {
        return this.codigoFilialPaciente;
    }

    public void setCodigoFilialPaciente(Integer codigoFilialPaciente) {
        this.codigoFilialPaciente = codigoFilialPaciente;
    }

    public Boolean getAlteraDadosPaciente() {
        return this.alteraDadosPaciente;
    }

    public void setAlteraDadosPaciente(Boolean alteraDadosPaciente) {
        this.alteraDadosPaciente = alteraDadosPaciente;
    }

    public String getTipoExamesInformados() {
        return this.tipoExamesInformados;
    }

    public void setTipoExamesInformados(String tipoExamesInformados) {
        this.tipoExamesInformados = tipoExamesInformados;
    }

    public Date getDataCancelamento() {
        return this.dataCancelamento;
    }

    public void setDataCancelamento(Date dataCancelamento) {
        this.dataCancelamento = dataCancelamento;
    }

    public String getUsuarioAgendamento() {
        return this.usuarioAgendamento;
    }

    public void setUsuarioAgendamento(String usuarioAgendamento) {
        this.usuarioAgendamento = usuarioAgendamento;
    }

    public String getUsuarioCancelamento() {
        return this.usuarioCancelamento;
    }

    public void setUsuarioCancelamento(String usuarioCancelamento) {
        this.usuarioCancelamento = usuarioCancelamento;
    }

    public boolean preAgendamentoComImagens() {
        return this.tipoExamesInformados.equalsIgnoreCase("G") || this.tipoExamesInformados.equalsIgnoreCase("P");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.codigo == null ? 0 : this.codigo.hashCode());
        result = 31 * result + (this.filial == null ? 0 : this.filial.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PreAgendamentoVO other = (PreAgendamentoVO)obj;
        if (this.codigo == null ? other.codigo != null : !this.codigo.equals(other.codigo)) {
            return false;
        }
        return !(this.filial == null ? other.filial != null : !this.filial.equals(other.filial));
    }

    public String toString() {
        return "Filial " + this.filial + " cod. Pre-agendamento " + this.codigo;
    }

    public static PreAgendamentoVO registroToPreAgendamentoVO(Registro reg) {
        PreAgendamentoVO vo = new PreAgendamentoVO();
        if (reg != null) {
            vo.setAlteraDadosPaciente(reg.getBoolean("pre_alterardadospaciente"));
            vo.setBairroPaciente(reg.getString("pre_bairropaciente"));
            vo.setCelularPaciente(reg.getString("pre_celularpaciente"));
            vo.setCidadePaciente(reg.getString("pre_cidadepaciente"));
            vo.setCodigo(reg.getInt("pre_codigo"));
            vo.setCodigoFilialPaciente(reg.getInt("pre_codigofilialpaciente"));
            vo.setCodigoPaciente(reg.getInt("pre_codigopaciente"));
            vo.setConvenioInformado(reg.getString("pre_convenio"));
            vo.setConvenioNaoInformado(reg.getBoolean("pre_convenionaoinformado"));
            try {
                vo.setDataCancelamento(reg.getDate("pre_datacancelamento"));
                vo.setDataHoraAgendou(reg.getDate("pre_datahoraagendou"));
                vo.setDataHoraPreAgendamento(reg.getDate("pre_datahora"));
                vo.setDataPrevista(reg.getDate("pre_dataprevista"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            vo.setDescritivoExames(reg.getString("pre_descritivoexames"));
            vo.setEnderecoPaciente(reg.getString("pre_enderecopaciente"));
            vo.setEstadoPaciente(reg.getString("pre_estadopaciente"));
            FilialVO filialVO = new FilialVO();
            filialVO.setCodigo(reg.getInt("fil_codigo"));
            vo.setFilial(filialVO);
            vo.setFonePaciente(reg.getString("pre_fonepaciente"));
            vo.setHorarioPrevisto(reg.getString("pre_horarioprevisto"));
            vo.setMedicoInformado(reg.getString("pre_medico"));
            vo.setMedicoNaoInformado(reg.getBoolean("pre_mediconaoinformado"));
            vo.setMotivoSituacao(reg.getString("pre_motivosituacao"));
            vo.setNomePaciente(reg.getString("pre_nomepaciente"));
            vo.setNumeroEnderecoPaciente(reg.getString("pre_numeroenderecopaciente"));
            vo.setSexoPaciente(reg.getString("pre_sexopaciente"));
            vo.setSituacao(reg.getString("pre_situacao"));
            vo.setTipoExamesInformados(reg.getString("pre_tipoexamesinformados"));
            vo.setUnidadeSelecionada(reg.getString("pre_unidadeselecionada"));
            vo.setUsuarioAgendamento(reg.getString("usr_codagendou"));
            vo.setUsuarioCancelamento(reg.getString("usr_codcancelamento"));
        }
        return vo;
    }
}

