/*
 * Decompiled with CFR 0.152.
 */
package jalis.model.vo.financeiro;

import jalis.model.utils.DataBaseField;
import jalis.model.utils.DataBaseFieldNotNull;
import jalis.model.utils.DataBaseForeignKey;
import jalis.model.utils.DataBasePrimaryKey;
import jalis.model.utils.DataBaseTable;
import jalis.model.utils.FieldTimeStamp;
import jalis.model.utils.FieldTransient;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.ConvenioVO;
import jalis.model.vo.cadastro.EntidadeVO;
import jalis.model.vo.cadastro.PacienteVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.util.Funcoes;
import java.util.Date;

@DataBaseTable(value="receberpagar")
public class ReceberPagarVO
extends AbstractThreadVO {
    @DataBaseField(value="fil_codigo")
    @DataBasePrimaryKey
    @DataBaseFieldNotNull
    @DataBaseForeignKey
    private FilialVO filial;
    @DataBaseField(value="rpg_codigo")
    @DataBasePrimaryKey
    @DataBaseFieldNotNull
    private Integer codigo;
    @DataBaseField(value="rpg_datahora")
    @FieldTimeStamp
    private Date dataHora;
    @DataBaseField(value="rpg_vencimento")
    @FieldTimeStamp
    private Date vencimento;
    @DataBaseField(value="rpg_valortotal")
    private Double valorTotal;
    @DataBaseField(value="rpg_valor")
    private Double valor;
    @DataBaseField(value="rpg_numerodocumento")
    @FieldTimeStamp
    private String numeroDocumento;
    @DataBaseField(value="rpg_parcela")
    private Integer parcela;
    @DataBaseField(value="ent_codigo")
    @DataBaseForeignKey
    private EntidadeVO entidade;
    @DataBaseField(value="con_codigo")
    @DataBaseForeignKey
    private ConvenioVO convenio;
    @DataBaseField(value="pac_codigo")
    @DataBaseForeignKey
    private PacienteVO paciente;
    @DataBaseField(value="rpg_tipo")
    private String tipo;
    @DataBaseField(value="rpg_situacao")
    private String situacao;
    @DataBaseField(value="rpg_datacancelado")
    @FieldTimeStamp
    private Date dataCancelado;
    @FieldTransient
    private String razaoSocial;

    public Date getDataCancelado() {
        return this.dataCancelado;
    }

    public void setDataCancelado(Date dataCancelado) {
        this.dataCancelado = dataCancelado;
    }

    public String getSituacao() {
        return this.situacao;
    }

    public void setSituacao(String situacao) {
        this.situacao = situacao;
    }

    public String getTipo() {
        return this.tipo;
    }

    public void setTipo(String tipo) {
        this.tipo = tipo;
    }

    public FilialVO getFilial() {
        return this.filial;
    }

    public void setFilial(FilialVO filial) {
        this.filial = filial;
    }

    public Integer getCodigo() {
        return this.codigo;
    }

    public void setCodigo(Integer codigo) {
        this.codigo = codigo;
    }

    public Date getDataHora() {
        return this.dataHora;
    }

    public void setDataHora(Date dataHora) {
        this.dataHora = dataHora;
    }

    public Date getVencimento() {
        return this.vencimento;
    }

    public void setVencimento(Date vencimento) {
        this.vencimento = vencimento;
    }

    public Double getValor() {
        return this.valor;
    }

    public void setValor(Double valor) {
        this.valor = valor;
    }

    public String getNumeroDocumento() {
        return this.numeroDocumento;
    }

    public void setNumeroDocumento(String numeroDocumento) {
        this.numeroDocumento = numeroDocumento;
    }

    public void setParcela(Integer parcela) {
        this.parcela = parcela;
    }

    public Integer getParcela() {
        return this.parcela;
    }

    public EntidadeVO getEntidade() {
        return this.entidade;
    }

    public void setEntidade(EntidadeVO entidade) {
        this.entidade = entidade;
        if (entidade != null && !Funcoes.textoVazio(entidade.getRazaoSocial())) {
            this.setRazaoSocial(entidade.getRazaoSocial());
        }
        this.addCampoAlterado("entidade");
    }

    public ConvenioVO getConvenio() {
        return this.convenio;
    }

    public void setConvenio(ConvenioVO convenio) {
        this.convenio = convenio;
        if (convenio != null && !Funcoes.textoVazio(convenio.getFantasia())) {
            this.setRazaoSocial(convenio.getFantasia());
        }
        this.addCampoAlterado("convenio");
    }

    public PacienteVO getPaciente() {
        return this.paciente;
    }

    public void setPaciente(PacienteVO paciente) {
        this.paciente = paciente;
        if (paciente != null && !Funcoes.textoVazio(paciente.getNome())) {
            this.setRazaoSocial(paciente.getNome());
        }
        this.addCampoAlterado("paciente");
    }

    public void setRazaoSocial(String razaoSocial) {
        this.razaoSocial = razaoSocial;
    }

    public String getRazaoSocial() {
        return this.razaoSocial;
    }

    public void setValorTotal(Double valorTotal) {
        this.valorTotal = valorTotal;
    }

    public Double getValorTotal() {
        return this.valorTotal;
    }
}

