/*
 * Decompiled with CFR 0.152.
 */
package jalis.model.vo.financeiro;

import jalis.comum.Tipos;
import jalis.model.utils.DataBaseField;
import jalis.model.utils.DataBaseFieldNotNull;
import jalis.model.utils.DataBaseForeignKey;
import jalis.model.utils.DataBasePrimaryKey;
import jalis.model.utils.DataBaseTable;
import jalis.model.utils.FieldDate;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.auxiliares.EstacaoVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.financeiro.ContaCorrenteVO;
import jalis.util.Funcoes;
import java.util.Date;

@DataBaseTable(value="lanctocaixa")
public class LancamentoVO
extends AbstractThreadVO {
    @DataBaseField(value="fil_codigo")
    @DataBasePrimaryKey
    @DataBaseFieldNotNull
    @DataBaseForeignKey
    private FilialVO filial;
    @DataBaseField(value="lcx_codigo")
    @DataBasePrimaryKey
    @DataBaseFieldNotNull
    private Integer codigo;
    @DataBaseField(value="est_codigo")
    @DataBasePrimaryKey
    @DataBaseFieldNotNull
    @DataBaseForeignKey
    private EstacaoVO estacao;
    @DataBaseField(value="cco_reduzido")
    @DataBaseFieldNotNull
    @DataBaseForeignKey
    private ContaCorrenteVO contaCorrente;
    @DataBaseField(value="lcx_documento")
    private String documento;
    @FieldDate
    @DataBaseField(value="lcx_vencimento")
    private Date dataVencimento;
    @DataBaseField(value="lcx_valor")
    private Double valor;
    @DataBaseField(value="lcx_valortotal")
    private Double valorTotal;
    @FieldDate
    @DataBaseField(value="lcx_conciliacao")
    private Date dataConciliacao;
    @DataBaseField(value="lcx_tipo")
    private String tipo;
    @DataBaseField(value="lcx_tipopagamento")
    private String tipoPagamento;
    @DataBaseField(value="fil_codentrefilial")
    @DataBaseForeignKey
    private FilialVO filialTransferencia;
    @DataBaseField(value="lcx_nomedescfolha")
    private String nomeDescFolha;
    @DataBaseField(value="lcx_setordescfolha")
    private String setorDescFolha;
    @DataBaseField(value="lcx_autorizadodescfolha")
    private String autorizadoDescFolha;

    public String getNomeDescFolha() {
        return this.nomeDescFolha;
    }

    public void setNomeDescFolha(String nomeDescFolha) {
        this.nomeDescFolha = nomeDescFolha;
    }

    public String getSetorDescFolha() {
        return this.setorDescFolha;
    }

    public void setSetorDescFolha(String setorDescFolha) {
        this.setorDescFolha = setorDescFolha;
    }

    public String getAutorizadoDescFolha() {
        return this.autorizadoDescFolha;
    }

    public void setAutorizadoDescFolha(String autorizadoDescFolha) {
        this.autorizadoDescFolha = autorizadoDescFolha;
    }

    public FilialVO getFilialTransferencia() {
        return this.filialTransferencia;
    }

    public void setFilialTransferencia(FilialVO filialTransferencia) {
        this.filialTransferencia = filialTransferencia;
    }

    public String getTipoPagamento() {
        return this.tipoPagamento;
    }

    public void setTipoPagamento(String tipoPagamento) {
        this.tipoPagamento = tipoPagamento;
    }

    public EstacaoVO getEstacao() {
        return this.estacao;
    }

    public void setEstacao(EstacaoVO estacao) {
        this.estacao = estacao;
    }

    public void setTipo(String tipo) {
        this.tipo = tipo;
    }

    public String getTipo() {
        return this.tipo;
    }

    public ContaCorrenteVO getContaCorrente() {
        return this.contaCorrente;
    }

    public void setContaCorrente(ContaCorrenteVO contaCorrente) {
        this.contaCorrente = contaCorrente;
    }

    public Date getDataVencimento() {
        return this.dataVencimento;
    }

    public void setDataVencimento(Date dataVencimento) {
        this.dataVencimento = dataVencimento;
    }

    public Date getDataConciliacao() {
        return this.dataConciliacao;
    }

    public void setDataConciliacao(Date dataConciliacao) {
        this.dataConciliacao = dataConciliacao;
    }

    public FilialVO getFilial() {
        return this.filial;
    }

    public void setFilial(FilialVO filial) {
        this.filial = filial;
    }

    public Integer getCodigo() {
        return this.codigo;
    }

    public void setCodigo(Integer codigo) {
        this.codigo = codigo;
    }

    public Double getValor() {
        return this.valor;
    }

    public void setValor(Double valor) {
        this.valor = valor;
    }

    public Double getValorTotal() {
        return this.valorTotal;
    }

    public void setValorTotal(Double valorTotal) {
        this.valorTotal = valorTotal;
    }

    public String getDocumento() {
        return this.documento;
    }

    public void setDocumento(String documento) {
        this.documento = documento;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        if (this.getContaCorrente() != null) {
            buf.append(this.getContaCorrente().getConta()).append(" - ");
        }
        if (this.getTipoPagamento() != null) {
            buf.append(Tipos.tipoPagamento(this.getTipoPagamento())).append(" - ");
        }
        if (this.getValorTotal() != null) {
            buf.append(Funcoes.formataDecimal(this.getValorTotal()));
        }
        return buf.toString();
    }
}

