/*
 * Decompiled with CFR 0.152.
 */
package jalis.model.vo.financeiro;

import jalis.model.utils.DataBaseField;
import jalis.model.utils.DataBaseFieldNotNull;
import jalis.model.utils.DataBaseForeignKey;
import jalis.model.utils.DataBasePrimaryKey;
import jalis.model.utils.DataBaseTable;
import jalis.model.utils.FieldDate;
import jalis.model.utils.FieldTimeStamp;
import jalis.model.utils.FieldTransient;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.ConvenioVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import java.math.BigDecimal;
import java.util.Date;

@DataBaseTable(value="fatura")
public class FaturaVO
extends AbstractThreadVO {
    @DataBaseField(value="fil_codigo")
    @DataBasePrimaryKey
    @DataBaseFieldNotNull
    @DataBaseForeignKey
    private FilialVO filial;
    @DataBaseField(value="fat_codigo")
    @DataBaseFieldNotNull
    @DataBasePrimaryKey
    private Integer codigo;
    @DataBaseField(value="con_codigo")
    @DataBaseFieldNotNull
    @DataBaseForeignKey
    private ConvenioVO convenio;
    @DataBaseField(value="fat_dtvenc")
    @DataBaseFieldNotNull
    @FieldDate
    private Date vencimento;
    @DataBaseField(value="fat_totalexames")
    private Double valorTotalExames;
    @DataBaseField(value="fat_totalmateriais")
    private Double valorTotalMateriais;
    @DataBaseField(value="fat_adicional")
    private Double valorAdicional;
    @DataBaseField(value="fat_despcobranca")
    private Double valorDespesaCobranca;
    @DataBaseField(value="fat_dtemis")
    private Date dataEmissao;
    @DataBaseField(value="fat_dataarquivo")
    private Date dataArquivo;
    @DataBaseField(value="fat_percacrescimo")
    private Double percentualAcrescimo;
    @DataBaseField(value="fat_percdesconto")
    private Double percentualDesconto;
    @DataBaseField(value="fat_dtconferencia")
    private Date dataConferencia;
    @DataBaseField(value="fat_datacancelamento")
    @FieldTimeStamp
    private Date dataCancelamento;
    @FieldTransient
    private BigDecimal valorRestanteFaturar = BigDecimal.ZERO;

    public Double getValorTotal() {
        Double valorExamesMateriais = this.valorTotalExames + this.valorTotalMateriais;
        return valorExamesMateriais + this.valorAdicional + this.valorDespesaCobranca + valorExamesMateriais * this.percentualAcrescimo / 100.0 - valorExamesMateriais * this.percentualDesconto / 100.0;
    }

    public void setPercentualDesconto(Double percentualDesconto) {
        this.percentualDesconto = percentualDesconto;
    }

    public Double getPercentualDesconto() {
        return this.percentualDesconto;
    }

    public void setPercentualAcrescimo(Double percentualAcrescimo) {
        this.percentualAcrescimo = percentualAcrescimo;
    }

    public Double getPercentualAcrescimo() {
        return this.percentualAcrescimo;
    }

    public void setValorDespesaCobranca(Double valorDespesaCobranca) {
        this.valorDespesaCobranca = valorDespesaCobranca;
    }

    public Double getValorDespesaCobranca() {
        return this.valorDespesaCobranca;
    }

    public Double getValorAdicional() {
        return this.valorAdicional;
    }

    public void setValorAdicional(Double valorAdicional) {
        this.valorAdicional = valorAdicional;
    }

    public BigDecimal getValorRestanteFaturar() {
        return this.valorRestanteFaturar;
    }

    public void setValorRestanteFaturar(BigDecimal valorRestanteFaturar) {
        this.valorRestanteFaturar = valorRestanteFaturar;
    }

    public Double getValorTotalMateriais() {
        return this.valorTotalMateriais;
    }

    public void setValorTotalMateriais(Double valorTotalMateriais) {
        this.valorTotalMateriais = valorTotalMateriais;
    }

    public FilialVO getFilial() {
        return this.filial;
    }

    public void setFilial(FilialVO filial) {
        this.filial = filial;
    }

    public Integer getCodigo() {
        return this.codigo;
    }

    public void setCodigo(Integer codigo) {
        this.codigo = codigo;
    }

    public ConvenioVO getConvenio() {
        return this.convenio;
    }

    public void setConvenio(ConvenioVO convenio) {
        this.convenio = convenio;
    }

    public Date getVencimento() {
        return this.vencimento;
    }

    public Date getDataEmissao() {
        return this.dataEmissao;
    }

    public void setDataEmissao(Date dataEmissao) {
        this.dataEmissao = dataEmissao;
    }

    public Date getDataArquivo() {
        return this.dataArquivo;
    }

    public void setDataArquivo(Date dataArquivo) {
        this.dataArquivo = dataArquivo;
    }

    public void setVencimento(Date vencimento) {
        this.vencimento = vencimento;
    }

    public Double getValorTotalExames() {
        return this.valorTotalExames;
    }

    public void setValorTotalExames(Double valorTotalExames) {
        this.valorTotalExames = valorTotalExames;
    }

    public Date getDataConferencia() {
        return this.dataConferencia;
    }

    public void setDataConferencia(Date dataConferencia) {
        this.dataConferencia = dataConferencia;
        this.addCampoAlterado("dataConferencia");
    }

    public Date getDataCancelamento() {
        return this.dataCancelamento;
    }

    public void setDataCancelamento(Date dataCancelamento) {
        this.dataCancelamento = dataCancelamento;
        this.addCampoAlterado("dataCancelamento");
    }
}

