/*
 * Decompiled with CFR 0.152.
 */
package jalis.model.utils;

import jalis.model.utils.TipoDados;

public enum CondicaoWhereDao {
    Igual("Igual a", "#campo# = #valor#", new int[]{TipoDados.TIPO_NUMERO, TipoDados.TIPO_DATA}),
    Diferente("Diferente de", "#campo# <> #valor#", new int[]{TipoDados.TIPO_NUMERO, TipoDados.TIPO_DATA}),
    Contem("Cont\u00eam o texto", "#campo# ilike '%#valor#%'", new int[]{TipoDados.TIPO_TEXTO}),
    Comeca("Come\u00e7ca com o texto", "#campo# ilike '#valor#%'", new int[]{TipoDados.TIPO_TEXTO}),
    Termina("Termina com o texto", "#campo# ilike '%#valor#'", new int[]{TipoDados.TIPO_TEXTO}),
    Maior("Maior que", "#campo# > #valor#", new int[]{TipoDados.TIPO_NUMERO, TipoDados.TIPO_DATA}),
    Menor("Menor que", "#campo# < #valor#", new int[]{TipoDados.TIPO_NUMERO, TipoDados.TIPO_DATA}),
    MaiorIgual("Maior ou igual a", "#campo# >= #valor#", new int[]{TipoDados.TIPO_NUMERO, TipoDados.TIPO_DATA}),
    MenorIgual("Menor ou igual a", "#campo# <= #valor#", new int[]{TipoDados.TIPO_NUMERO, TipoDados.TIPO_DATA});

    private static CondicaoWhereDao[] condicoes;
    private String descricao;
    private String expressao;
    private int[] tipo;

    private CondicaoWhereDao(String descricao, String expressao, int[] tipo) {
        this.descricao = descricao;
        this.expressao = expressao;
        this.tipo = tipo;
    }

    public static CondicaoWhereDao[] getCondicoes() {
        return condicoes;
    }

    public String toString() {
        return this.descricao;
    }

    public String parseCondicao(String campo, String valor) {
        String exp = this.expressao;
        exp = exp.replaceAll("#campo#", campo);
        exp = exp.replaceAll("#valor#", valor);
        return exp;
    }

    public int[] getTipos() {
        return this.tipo;
    }

    static {
        condicoes = new CondicaoWhereDao[]{Igual, Diferente, Contem, Comeca, Termina, Maior, Menor, MaiorIgual, MenorIgual};
    }
}

