/*
 * Decompiled with CFR 0.152.
 */
package jalis.model.enums;

public enum EnumTipoRateio {
    OUTROS("O", "Outros-terceiros"),
    FISIO_QUIMICO("F", "F\u00edsico-qu\u00edmico"),
    MICROBIOLOGICO("M", "Microbiol\u00f3gico"),
    CROMATOGRAFIA("C", "Cromatografia");

    private String codigo = "";
    private String descricao = "";

    private EnumTipoRateio(String codigo, String descricao) {
        this.codigo = codigo;
        this.descricao = descricao;
    }

    public static String getCodigo(String descricao) {
        String codigo = "";
        for (EnumTipoRateio es : EnumTipoRateio.values()) {
            if (!descricao.equals(es.descricao)) continue;
            codigo = es.codigo;
            break;
        }
        return codigo;
    }

    public static String getDescricao(String codigo) {
        String descricao = "";
        for (EnumTipoRateio es : EnumTipoRateio.values()) {
            if (!codigo.equalsIgnoreCase(es.codigo)) continue;
            descricao = es.descricao;
            break;
        }
        return descricao;
    }

    public static EnumTipoRateio getEnum(String descricao) {
        EnumTipoRateio enumTipoRateio = OUTROS;
        for (EnumTipoRateio e : EnumTipoRateio.values()) {
            if (!descricao.equals(e.descricao)) continue;
            enumTipoRateio = e;
            break;
        }
        return enumTipoRateio;
    }

    public String getCodigo() {
        return this.codigo;
    }

    public void setCodigo(String codigo) {
        this.codigo = codigo;
    }

    public static boolean isMicrobiologico(String tipoAlimentos) {
        return tipoAlimentos.equals(MICROBIOLOGICO.getCodigo());
    }

    public static boolean isFisicoQuimico(String tipoAlimentos) {
        return tipoAlimentos.equals(FISIO_QUIMICO.getCodigo());
    }

    public static boolean isOutros(String tipoAlimentos) {
        return tipoAlimentos.equals(OUTROS.getCodigo());
    }

    public static boolean isCromatografia(String tipoAlimentos) {
        return tipoAlimentos.equals(CROMATOGRAFIA.getCodigo());
    }
}

