/*
 * Decompiled with CFR 0.152.
 */
package jalis.model.dao.util.parsers.pardini;

import jalis.comum.Conexao;
import jalis.comum.ConexaoTemporaria;
import jalis.comum.Variaveis;
import jalis.laboratorio.util.parsers.Exame;
import jalis.laboratorio.util.parsers.ExameDesmembrado;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.exame.LabExternoVO;
import jalis.model.vo.consultas.ConfiguracaoExameHPardiniVO;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.tabela.Registro;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class ImportacaoResultadoHPardiniDao {
    private static final String ASPA = "'";
    private static final String VIRGULA = ",";

    public LabExternoVO pesquisarPorCodLabExterno(int codLabExterno) throws Exception {
        LabExternoVO vo = new LabExternoVO();
        Statement st = Conexao.getStatement();
        StringBuilder sql = new StringBuilder(" select ");
        sql.append(" fil_codigo, ");
        sql.append(" lae_codigo, ");
        sql.append(" lae_configuracao, ");
        sql.append(" coalesce(lae_conferirautomatico, false) as lae_conferirautomatico, ");
        sql.append(" usr_codconferir, ");
        sql.append(" lae_codigomodeloweb ");
        sql.append(" from labexterno ");
        sql.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
        sql.append(" and lae_codigo = ").append(codLabExterno);
        try {
            ResultSet rs = ConexaoTemporaria.executeQuery(st, sql);
            if (rs.next()) {
                FilialVO filial = new FilialVO();
                filial.setCodigo(rs.getInt("fil_codigo"));
                vo.setCodigo(rs.getInt("lae_codigo"));
                vo.setFilial(filial);
                vo.setConferirAutomatico(rs.getBoolean("lae_conferirautomatico"));
                vo.setCodigoUsuarioConferir(rs.getString("usr_codconferir"));
                vo.setCodigoModeloWeb(rs.getInt("lae_codigomodeloweb"));
            }
        }
        catch (Exception e) {
            ConexaoTemporaria.anulaSQL();
            throw e;
        }
        finally {
            ConexaoTemporaria.fecharStatement(st);
        }
        return vo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ConfiguracaoExameHPardiniVO> pesquisarExamesDesmembradosNoLote(Registro reg) throws SQLException {
        ArrayList<ConfiguracaoExameHPardiniVO> desmembrados = new ArrayList<ConfiguracaoExameHPardiniVO>();
        StringBuilder sql = new StringBuilder(" select ");
        sql.append(" ldesm.fil_kodigo, ldesm.req_codigo, ldesm.exa_kodigo, ldesm.mco_kodigo, ler.leq_codigoreqapoio,  exlabext.ele_xmllabexterno ");
        sql.append(" from loteexternoexamerequisicaodesm ldesm ");
        sql.append(" left join loteexternoexamerequisicao leer ");
        sql.append(" on ldesm.fil_kodigo = leer.fil_kodigo ");
        sql.append(" and ldesm.fil_codigo = leer.fil_codigo ");
        sql.append(" and ldesm .lex_codigo = leer.lex_codigo ");
        sql.append(" and ldesm.req_codigo = leer.req_codigo ");
        sql.append(" and ldesm.exa_codigo = leer.exa_codigo ");
        sql.append(" and ldesm.mco_codigo = leer.mco_codigo ");
        sql.append(" left join loteexternorequisicao ler ");
        sql.append(" on leer.fil_kodigo = ler.fil_kodigo ");
        sql.append(" and leer.fil_codigo = ler.fil_codigo ");
        sql.append(" and leer .lex_codigo = ler.lex_codigo ");
        sql.append(" and leer.req_codigo = ler.req_codigo ");
        sql.append(" left join examematcoletalabexterno exlabext ");
        sql.append(" on ldesm.fil_kodigo = exlabext.fil_codigo ");
        sql.append(" and ldesm.exa_kodigo = exlabext.exa_codigo ");
        sql.append(" and ldesm.mco_kodigo  = exlabext.mco_codigo ");
        sql.append(" and ldesm.lae_codigo = exlabext.lae_codigo ");
        sql.append(" where ldesm.fil_kodigo = ").append(reg.getInt("fil_codigo"));
        sql.append(" and ldesm.req_codigo = ").append(reg.getInt("req_codigo"));
        sql.append(" and ldesm.exa_codigo = ").append(StringUtil.textoDBEscape(reg.getString("examePai")));
        sql.append(" and ldesm.mco_codigo = ").append(reg.getInt("mco_codigo"));
        sql.append(" and ldesm.lae_codigo = ").append(reg.getInt("lae_codigo"));
        sql.append(" and leer.ler_datahoraestorno  is null and leer.usr_codestorno is null ");
        sql.append(" and ler.leq_dataestorno is null and ler.usr_codestorno  is null ");
        Statement st = Conexao.getStatement();
        try {
            ResultSet rs = Conexao.executeQuery(st, sql.toString());
            while (rs.next()) {
                ConfiguracaoExameHPardiniVO confExame = new ConfiguracaoExameHPardiniVO();
                confExame.setCodigoExame(rs.getString("exa_kodigo"));
                confExame.setCodigoFilial(rs.getString("fil_kodigo"));
                confExame.setCodigoMaterial(rs.getString("mco_kodigo"));
                confExame.setCodigoRequisicao(rs.getString("req_codigo"));
                confExame.setCodPedApoio(rs.getString("leq_codigoreqapoio"));
                confExame.setConfigExameHPardini(rs.getString("ele_xmllabexterno"));
                desmembrados.add(confExame);
            }
        }
        catch (Throwable throwable) {
            Conexao.fecharStatement(st);
            throw throwable;
        }
        Conexao.fecharStatement(st);
        return desmembrados;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void salvarResultadoPDF(ConfiguracaoExameHPardiniVO configExameHPardini, String resultadoPDF) throws SQLException {
        Statement st = Conexao.getStatement();
        try {
            String resultado = StringUtil.textoDBEscape(resultadoPDF);
            StringBuilder sql = new StringBuilder();
            String condicaoWhere = this.getCondicaoWhere(configExameHPardini);
            sql.append(" select 1 as resultado from examerequisicaoresultado");
            sql.append(condicaoWhere);
            ResultSet rs = Conexao.executeQuery(st, sql.toString());
            sql.delete(0, sql.length());
            if (rs.next()) {
                sql.append(" update examerequisicaoresultado set");
                sql.append(" ert_resultadopdf = ").append(resultado);
                sql.append(condicaoWhere);
            } else {
                sql.append(" insert into examerequisicaoresultado (fil_codigo, exa_codigo, mco_codigo, req_codigo, ert_resultadopdf) ");
                sql.append(" values (");
                sql.append(configExameHPardini.getCodigoFilial()).append(VIRGULA);
                sql.append(ASPA.concat(configExameHPardini.getCodigoExame()).concat(ASPA)).append(VIRGULA);
                sql.append(configExameHPardini.getCodigoMaterial()).append(VIRGULA);
                sql.append(configExameHPardini.getCodigoRequisicao()).append(VIRGULA);
                sql.append(resultado).append(" );");
            }
            Conexao.executeUpdate(configExameHPardini.getCodigoFilial(), st, sql.toString());
            Conexao.arquivaSQL();
        }
        catch (Exception e) {
            try {
                Conexao.anulaSQL();
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
    }

    public void atualizarExameRequisicao(ConfiguracaoExameHPardiniVO configExameHPardini, boolean conferirAutomatico, String codigoUsuarioConferenciaAutomatica) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append(" update examerequisicao set exr_resultadoempdf = true, ");
        if (!conferirAutomatico && Funcoes.textoVazio(codigoUsuarioConferenciaAutomatica)) {
            sql.append(" exr_situacao = '").append("L").append("', ");
        }
        sql.append(" exr_datadigita = current_timestamp, ");
        sql.append(" usr_coddigitador = '").append(Variaveis.login).append(ASPA);
        if (conferirAutomatico && !Funcoes.textoVazio(codigoUsuarioConferenciaAutomatica)) {
            sql.append(" ,exr_situacao = '").append("C").append("', ");
            sql.append(" exr_dataassina = current_timestamp, ");
            sql.append(" usr_codassina = '").append(codigoUsuarioConferenciaAutomatica).append(ASPA);
        }
        sql.append(this.getCondicaoWhere(configExameHPardini));
        Statement st = Conexao.getStatement();
        try {
            Conexao.executeUpdate(configExameHPardini.getCodigoFilial(), st, sql.toString());
            Conexao.arquivaSQL();
        }
        catch (Exception e) {
            try {
                Conexao.anulaSQL();
                throw e;
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
        }
        Conexao.fecharStatement(st);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExameDesmembrado pesquisarExameDesmembradoNoLote(String filial, String reqCodigo, String laeCodigo, String exaFilho, String mcoFilho) throws SQLException {
        Statement st;
        block2: {
            ExameDesmembrado exameDesmembrado;
            st = Conexao.getStatement();
            try {
                if (st == null) break block2;
                StringBuilder buf = new StringBuilder();
                buf.append(" select a.exa_codigo ,a.mco_codigo ,p.ele_xmllabexterno, pai.ele_xmllabexterno as xmllabexternopai ");
                buf.append(" from loteexternoexamerequisicaodesm a ");
                buf.append(" left join examematcoletalabexterno p on a.fil_kodigo = p.fil_codigo and a.exa_kodigo = p.exa_codigo and a.mco_kodigo = p.mco_codigo and a.lae_codigo = p.lae_codigo ");
                buf.append(" left join examematcoletalabexterno pai on a.fil_kodigo = pai.fil_codigo and a.exa_codigo = pai.exa_codigo and a.mco_codigo = pai.mco_codigo and a.lae_codigo = pai.lae_codigo ");
                buf.append(" where a.fil_kodigo = ").append(filial);
                buf.append(" and a.req_codigo  = ").append(reqCodigo);
                buf.append(" and a.exa_kodigo = ").append(StringUtil.textoDBEscape(exaFilho));
                buf.append(" and a.mco_kodigo = ").append(mcoFilho);
                buf.append(" and a.lae_codigo = ").append(laeCodigo);
                ResultSet res = Conexao.executeQuery(st, buf.toString());
                if (!res.next()) break block2;
                ExameDesmembrado ex = new ExameDesmembrado(res.getString("exa_codigo"), res.getInt("mco_codigo"), res.getString("xmllabexternopai"));
                ex.addFilho(new Exame(exaFilho, Integer.parseInt(mcoFilho), res.getString("ele_xmllabexterno")));
                exameDesmembrado = ex;
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
            return exameDesmembrado;
        }
        Conexao.fecharStatement(st);
        return null;
    }

    private String getCondicaoWhere(ConfiguracaoExameHPardiniVO configExameHPardini) {
        StringBuilder where = new StringBuilder(" where ");
        where.append(" fil_codigo = ").append(configExameHPardini.getCodigoFilial());
        where.append(" and req_codigo = ").append(configExameHPardini.getCodigoRequisicao());
        where.append(" and exa_codigo = '").append(configExameHPardini.getCodigoExame()).append(ASPA);
        where.append(" and mco_codigo = ").append(configExameHPardini.getCodigoMaterial());
        return where.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String pesquisarSituacaoExame(String codFilial, String codLabExterno, Integer[] multiguias, String codExame, String codMaterial) throws Exception {
        String string;
        Statement st;
        block13: {
            String situacao = "";
            StringBuilder sql = new StringBuilder();
            st = Conexao.getStatement();
            ResultSet rs = null;
            try {
                String[] examePai = new String[3];
                if (multiguias.length > 1) {
                    sql.delete(0, sql.length());
                    sql.append(" select req_codigo, exa_codigo, mco_codigo from loteexternoexamerequisicaodesm ");
                    sql.append(" where fil_kodigo = ").append(codFilial);
                    sql.append(" and lae_codigo = ").append(codLabExterno);
                    sql.append(" and exa_kodigo = ").append(StringUtil.textoDBEscape(codExame));
                    sql.append(" and mco_kodigo = ").append(codMaterial);
                    sql.append(" and req_codigo in ( ");
                    for (Integer guia : multiguias) {
                        sql.append(guia).append(VIRGULA);
                    }
                    sql.replace(sql.length() - 1, sql.length(), "");
                    sql.append(")");
                    rs = Conexao.executeQuery(st, sql);
                    while (rs.next()) {
                        String situacaoExameRepetido = this.validaExamesRepetidos(codFilial, codLabExterno, multiguias, codExame, codMaterial);
                        if (situacaoExameRepetido != null) {
                            string = situacaoExameRepetido;
                            break block13;
                        }
                        examePai[0] = rs.getString("req_codigo");
                        examePai[1] = rs.getString("exa_codigo");
                        examePai[2] = rs.getString("mco_codigo");
                    }
                }
                String codExa = codExame;
                String codMat = codMaterial;
                if (!Funcoes.textoVazio(examePai[0])) {
                    codExa = examePai[1];
                    codMat = examePai[2];
                }
                sql.delete(0, sql.length());
                sql = new StringBuilder(" select distinct(exr_situacao) as exr_situacao from examerequisicao ");
                sql.append(" where exr_excluido = false ");
                sql.append(" and fil_codigo = ").append(codFilial);
                sql.append(" and exa_codigo = ").append(StringUtil.textoDBEscape(codExa));
                sql.append(" and mco_codigo = ").append(codMat);
                if (multiguias.length == 1) {
                    sql.append(" and req_codigo = ").append(multiguias[0]);
                } else {
                    sql.append(" and req_codigo in ( ");
                    for (Integer guia : multiguias) {
                        sql.append(guia).append(VIRGULA);
                    }
                    sql.replace(sql.length() - 1, sql.length(), "");
                    sql.append(")");
                }
                rs = Conexao.executeQuery(st, sql);
                situacao = rs.next() ? rs.getString("exr_situacao") : "";
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
                return situacao;
            }
            Conexao.fecharStatement(st);
            return situacao;
        }
        Conexao.fecharStatement(st);
        return string;
    }

    private String validaExamesRepetidos(String codFilial, String codLabExterno, Integer[] multiguias, String codExame, String codMaterial) throws SQLException {
        Statement st = Conexao.getStatement();
        String situacao = "";
        StringBuilder sql = new StringBuilder(" select distinct(exr_situacao) as exr_situacao from examerequisicao ");
        sql.append(" where exr_excluido = false ");
        sql.append(" and fil_codigo = ").append(codFilial);
        sql.append(" and exa_codigo = ").append(StringUtil.textoDBEscape(codExame));
        sql.append(" and mco_codigo = ").append(codMaterial);
        if (multiguias.length == 1) {
            sql.append(" and req_codigo = ").append(multiguias[0]);
        } else {
            sql.append(" and req_codigo in ( ");
            for (Integer guia : multiguias) {
                sql.append(guia).append(VIRGULA);
            }
            sql.replace(sql.length() - 1, sql.length(), "");
            sql.append(")");
        }
        ResultSet rs = Conexao.executeQuery(st, sql);
        situacao = rs.next() ? rs.getString("exr_situacao") : null;
        Conexao.fecharStatement(st);
        return situacao;
    }
}

