/*
 * Decompiled with CFR 0.152.
 */
package jalis.model.dao.util.parsers.indlab;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.util.parsers.indlab.resultado.dto.ExameResultadoIndLabDto;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.exame.LabExternoVO;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.tabela.Registro;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class ImportacaoResultadoIndLabDao {
    public Registro pesquisarExameRequisicao(String codFilial, String codRequisicao, String codExame, String codMaterial) throws SQLException {
        StringBuilder sql = new StringBuilder("select \n");
        sql.append(" a.fil_codigo, a.req_codigo, a.des_codigo, a.con_codigo, a.pac_codigo, a.req_idade, a.req_anomes, \n");
        sql.append(" b.exa_codigo, b.mco_codigo, b.exr_situacao, pegaResultadoExame(b.fil_codigo, b.req_codigo, b.exa_codigo, b.mco_codigo) as exr_resultado, ");
        sql.append(" COALESCE(g.met_codigo, e.met_codigo) as met_codigo, \n");
        sql.append(" c.pac_idade, c.pac_anomes, b.exr_datamaterial, \n");
        sql.append(" d.exa_salvaparcial, g.ele_xmllabexterno, null as examePai, a.req_xmlagendamentoids as xmlAgendamentoIDS, a.req_integracaohospital, b.exr_resposta, \n");
        sql.append(" a.req_guia, b.exr_solicitadotiss, b.exr_codautorizacao \n");
        sql.append(" from requisicao a \n");
        sql.append(" left join examerequisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo \n");
        sql.append(" left join paciente c on a.fil_codigo = c.fil_codigo and a.pac_codigo = c.pac_codigo \n");
        sql.append(" left join exames d on b.fil_codigo = d.fil_codigo and b.exa_codigo = d.exa_codigo \n");
        sql.append(" left join examematcoleta e on b.fil_codigo = e.fil_codigo and b.exa_codigo = e.exa_codigo and b.mco_codigo = e.mco_codigo \n");
        sql.append(" left join loteexternoexamerequisicao f on b.fil_codigo = f.fil_kodigo and b.req_codigo = f.req_codigo and b.exa_codigo = f.exa_codigo and b.mco_codigo = f.mco_codigo \n");
        sql.append(" left join examematcoletalabexterno g on f.fil_codigo = g.fil_codigo and f.exa_codigo = g.exa_codigo and f.mco_codigo = g.mco_codigo and f.lae_codigo = g.lae_codigo and g.ele_xmllabexterno is not null and g.ele_xmllabexterno <> '' \n");
        sql.append(" where \n");
        sql.append(" a.fil_codigo = ").append(codFilial).append(" and \n");
        sql.append(" a.req_codigo = ").append(codRequisicao).append(" and \n");
        sql.append(" b.exa_codigo = ").append(StringUtil.textoDBEscape(codExame)).append("and \n");
        sql.append(" b.mco_codigo = ").append(codMaterial);
        sql.append(" and a.req_excluida = false and b.exr_excluido = false \n");
        Statement st = Conexao.getStatement();
        ResultSet res = Conexao.executeQuery(st, sql.toString());
        Registro reg = null;
        if (res.next()) {
            reg = new Registro(res);
            reg.setValor("codigo-layout", ExameUtil.getCodigoLayout(codFilial, res.getString("con_codigo"), res.getString("des_codigo")));
            reg.setValor("cabecalho", ExameUtil.getCabecalhoRodape(codFilial, reg.getString("codigo-layout")));
            Registro formatacao = new Registro();
            formatacao.setValor("formato", reg.getValor("exr_resultado"));
            formatacao.setValor("met_codigo", reg.getValor("met_codigo"));
            reg.setValor("formatacao", formatacao);
        }
        Conexao.fecharResultSet(res);
        Conexao.fecharStatement(st);
        return reg;
    }

    public boolean exameRelacionado(Registro reg, int codigoLabExterno) throws SQLException {
        boolean relacionado = false;
        if (reg != null) {
            String fil = reg.getString("fil_codigo");
            String exa = reg.getString("exa_codigo");
            String mco = reg.getString("mco_codigo");
            StringBuilder sql = new StringBuilder("select lae_codigo, ele_xmllabexterno from examematcoletalabexterno ");
            sql.append(" where fil_codigo = ").append(fil);
            sql.append(" and exa_codigo = '").append(exa).append("' and mco_codigo = ").append(mco);
            sql.append(" and lae_codigo = ").append(codigoLabExterno);
            sql.append(" and ele_xmllabexterno is not null and ele_xmllabexterno <> '' ");
            Statement st = Conexao.getStatement();
            ResultSet rs = st.executeQuery(sql.toString());
            if (rs.next() && rs.getInt("lae_codigo") == codigoLabExterno) {
                String xml = rs.getString("ele_xmllabexterno");
                reg.setValor("ele_xmllabexterno", xml);
                exa = StringUtil.getValor(xml, "codigo");
                StringBuilder sqlBuilder = new StringBuilder();
                sqlBuilder.append("select inl_xml from examesindlab where fil_codigo = ").append(fil);
                sqlBuilder.append(" and lae_codigo = ").append(codigoLabExterno);
                sqlBuilder.append(" and inl_codigoexame = ").append(StringUtil.textoDBEscape(exa));
                rs = st.executeQuery(sqlBuilder.toString());
                if (rs.next()) {
                    reg.setValor("xmlLabExterno", rs.getString("inl_xml"));
                }
                relacionado = true;
            }
        }
        return relacionado;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String pesquisarXmlLabExternoPorCodLabExterno(String codFilial, ExameResultadoIndLabDto exameSolicitacao, int codigoLabExterno) {
        StringBuilder sql = new StringBuilder(" select inl_xml from examesindlab ");
        sql.append(" where fil_codigo = ").append(codFilial);
        sql.append(" and inl_codigoexame = ").append(StringUtil.textoDBEscape(exameSolicitacao.getMnemonicoExame()));
        sql.append(" and lae_codigo = ").append(codigoLabExterno);
        Statement st = Conexao.getStatement();
        String xmlLabExterno = "";
        try {
            ResultSet rs = st.executeQuery(sql.toString());
            xmlLabExterno = rs.next() ? rs.getString("inl_xml") : "";
        }
        catch (Exception e) {
            try {
                this.anularSQL();
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
        return xmlLabExterno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LabExternoVO pesquisarPorCodLabExterno(int codLabExterno) {
        Statement st;
        LabExternoVO vo;
        block4: {
            vo = new LabExternoVO();
            st = Conexao.getStatement();
            StringBuilder sql = new StringBuilder(" select ");
            sql.append(" fil_codigo, ");
            sql.append(" lae_codigo, ");
            sql.append(" lae_configuracao, ");
            sql.append(" coalesce(lae_conferirautomatico, false) as lae_conferirautomatico, ");
            sql.append(" usr_codconferir, ");
            sql.append(" lae_codigomodeloweb ");
            sql.append(" from labexterno ");
            sql.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
            sql.append(" and lae_codigo = ").append(codLabExterno);
            try {
                ResultSet rs = Conexao.executeQuery(st, sql);
                if (!rs.next()) break block4;
                FilialVO filial = new FilialVO();
                filial.setCodigo(rs.getInt("fil_codigo"));
                vo.setCodigo(rs.getInt("lae_codigo"));
                vo.setFilial(filial);
                vo.setConferirAutomatico(rs.getBoolean("lae_conferirautomatico"));
                vo.setCodigoUsuarioConferir(rs.getString("usr_codconferir"));
                vo.setCodigoModeloWeb(rs.getInt("lae_codigomodeloweb"));
            }
            catch (Exception e) {
                try {
                    this.anularSQL();
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
        return vo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String pesquisarSituacaoExame(String codFilial, String codLabExterno, Integer[] multiguias, String codExame, String codMaterial) throws Exception {
        String situacao = "";
        StringBuilder sql = new StringBuilder();
        Statement st = Conexao.getStatement();
        ResultSet rs = null;
        try {
            String[] examePai = new String[3];
            if (multiguias.length > 1) {
                sql.delete(0, sql.length());
                sql.append(" select req_codigo, exa_codigo, mco_codigo from loteexternoexamerequisicaodesm ");
                sql.append(" where fil_kodigo = ").append(codFilial);
                sql.append(" and lae_codigo = ").append(codLabExterno);
                sql.append(" and exa_kodigo = ").append(StringUtil.textoDBEscape(codExame));
                sql.append(" and mco_kodigo = ").append(codMaterial);
                sql.append(" and req_codigo in ( ");
                for (Integer guia : multiguias) {
                    sql.append(guia).append(",");
                }
                sql.replace(sql.length() - 1, sql.length(), "");
                sql.append(")");
                rs = Conexao.executeQuery(st, sql);
                while (rs.next()) {
                    examePai[0] = rs.getString("req_codigo");
                    examePai[1] = rs.getString("exa_codigo");
                    examePai[2] = rs.getString("mco_codigo");
                }
            }
            String codExa = codExame;
            String codMat = codMaterial;
            if (!Funcoes.textoVazio(examePai[0])) {
                codExa = examePai[1];
                codMat = examePai[2];
            }
            sql.delete(0, sql.length());
            sql = new StringBuilder(" select distinct(exr_situacao) as exr_situacao from examerequisicao ");
            sql.append(" where exr_excluido = false ");
            sql.append(" and fil_codigo = ").append(codFilial);
            sql.append(" and exa_codigo = ").append(StringUtil.textoDBEscape(codExa));
            sql.append(" and mco_codigo = ").append(codMat);
            if (multiguias.length == 1) {
                sql.append(" and req_codigo = ").append(multiguias[0]);
            } else {
                sql.append(" and req_codigo in ( ");
                for (Integer guia : multiguias) {
                    sql.append(guia).append(",");
                }
                sql.replace(sql.length() - 1, sql.length(), "");
                sql.append(")");
            }
            rs = Conexao.executeQuery(st, sql);
            situacao = rs.next() ? rs.getString("exr_situacao") : "";
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
        return situacao;
    }

    private void anularSQL() {
        try {
            Conexao.anulaSQL();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

