/*
 * Decompiled with CFR 0.152.
 */
package jalis.model.dao.util.parsers.db2;

import jalis.comum.Conexao;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.util.parsers.Exame;
import jalis.laboratorio.util.parsers.ExameDesmembrado;
import jalis.model.vo.recepcao.ExameRequisicaoVO;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class ImportacaoResultadoDBDao {
    private static final String MCO_CODIGO = "mco_codigo";
    private static final String EXA_CODIGO = "exa_codigo";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ExameDesmembrado> pesquisarExamesDesmembradosDB(String filial, String reqCodigo, String laeCodigo, String exaFilho, String mcoFilho) {
        Statement st;
        ArrayList<ExameDesmembrado> exameDesmembrado;
        block5: {
            exameDesmembrado = new ArrayList<ExameDesmembrado>();
            st = Conexao.getStatement();
            try {
                if (st == null) break block5;
                StringBuilder buf = new StringBuilder();
                buf.append(" select a.exa_codigo ");
                buf.append("       ,a.mco_codigo ");
                buf.append("       ,p.ele_xmllabexterno ");
                buf.append("   from examerequisicao a ");
                buf.append("   join examematcoletalabextdesm e on a.fil_codigo = e.fil_codigo and a.exa_codigo = e.exa_codigo and a.mco_codigo = e.mco_codigo ");
                buf.append("   join examematcoletalabexterno p on e.fil_codigo = p.fil_codigo and e.exa_kodigo = p.exa_codigo and e.mco_kodigo = p.mco_codigo and e.lae_codigo = p.lae_codigo ");
                buf.append("  where a.fil_codigo = ").append(filial);
                buf.append("    and a.req_codigo  = ").append(reqCodigo);
                buf.append("    and e.exa_kodigo = '").append(exaFilho).append("' ");
                buf.append("    and e.mco_kodigo = ").append(mcoFilho);
                buf.append("    and e.lae_codigo = ").append(laeCodigo);
                ResultSet res = Conexao.executeQuery(st, buf.toString());
                while (res.next()) {
                    ExameDesmembrado ex = new ExameDesmembrado(res.getString(EXA_CODIGO), res.getInt(MCO_CODIGO));
                    ex.addFilho(new Exame(exaFilho, Integer.parseInt(mcoFilho), res.getString("ele_xmllabexterno")));
                    exameDesmembrado.add(ex);
                }
            }
            catch (Exception e) {
                try {
                    ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace(), "ImportacaoResultadoDB: 261");
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
        return exameDesmembrado;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ExameDesmembrado> pesquisarExamesDesmembradosDBWS(String filial, String reqCodigo, String laeCodigo, String exaFilho, String mcoFilho) {
        Statement st;
        ArrayList<ExameDesmembrado> exameDesmembrado;
        block5: {
            exameDesmembrado = new ArrayList<ExameDesmembrado>();
            st = Conexao.getStatement();
            try {
                if (st == null) break block5;
                StringBuilder buf = new StringBuilder();
                buf.append(" select a.exa_codigo ");
                buf.append("       ,a.mco_codigo ");
                buf.append("       ,e.mco_kodigo ");
                buf.append("       ,p.ele_xmllabexterno ");
                buf.append("   from examerequisicao a ");
                buf.append("   join examematcoletalabextdesm e on a.fil_codigo = e.fil_codigo and a.exa_codigo = e.exa_codigo and a.mco_codigo = e.mco_codigo ");
                buf.append("   join examematcoletalabexterno p on e.fil_codigo = p.fil_codigo and e.exa_kodigo = p.exa_codigo and e.mco_kodigo = p.mco_codigo and e.lae_codigo = p.lae_codigo ");
                buf.append("  where a.fil_codigo = ").append(filial);
                buf.append("    and a.req_codigo  = ").append(reqCodigo);
                buf.append("    and e.exa_kodigo = '").append(exaFilho).append("' ");
                buf.append("    and e.mco_codigo = ").append(mcoFilho);
                buf.append("    and e.lae_codigo = ").append(laeCodigo);
                ResultSet res = Conexao.executeQuery(st, buf.toString());
                while (res.next()) {
                    ExameDesmembrado ex = new ExameDesmembrado(res.getString(EXA_CODIGO), res.getInt(MCO_CODIGO));
                    ex.addFilho(new Exame(exaFilho, res.getInt("mco_kodigo"), res.getString("ele_xmllabexterno")));
                    exameDesmembrado.add(ex);
                }
            }
            catch (Exception e) {
                try {
                    ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace(), "ImportacaoResultadoDB: 261");
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
        return exameDesmembrado;
    }

    public ExameDesmembrado pesquisarExameDesmembradoPorExamePrincipal(String codFilial, int codigoLabExterno, ExameDesmembrado examePrincipal) throws SQLException {
        StringBuilder sql = new StringBuilder(" select ");
        sql.append(" exa_codigo, mco_codigo, exa_kodigo, mco_kodigo ");
        sql.append(" from examematcoletalabextdesm ");
        sql.append(" where fil_codigo = ").append(codFilial);
        sql.append(" and lae_codigo = ").append(codigoLabExterno);
        sql.append(" and exa_codigo = '").append(examePrincipal.getCodigoExame()).append("'");
        sql.append("   and mco_codigo = ").append(examePrincipal.getCodigomaterial());
        Statement st = Conexao.getStatement();
        ResultSet rs = Conexao.executeQuery(st, sql);
        ExameDesmembrado desmembrado = new ExameDesmembrado(examePrincipal.getCodigoExame(), examePrincipal.getCodigomaterial());
        while (rs.next()) {
            if (!rs.getString(EXA_CODIGO).equals(examePrincipal.getCodigoExame()) || rs.getInt(MCO_CODIGO) != examePrincipal.getCodigomaterial()) continue;
            desmembrado.addFilho(new Exame(rs.getString("exa_kodigo"), rs.getInt("mco_kodigo")));
        }
        Conexao.fecharStatement(st);
        return desmembrado;
    }

    public boolean atualizarExameRequisicaoRemoveResultadoParcial(Statement st, ExameRequisicaoVO exameReq) throws SQLException {
        StringBuilder sql = new StringBuilder(" update examerequisicao set ");
        sql.append(" exr_situacao = '', ");
        sql.append(" exr_datadigita = null, ");
        sql.append(" usr_coddigitador = null, ");
        sql.append(" exr_resultado = null ");
        sql.append(" where fil_codigo =  ").append(exameReq.getFilial().getCodigo());
        sql.append("  and req_codigo = ").append(exameReq.getRequisicao());
        sql.append(" and exa_codigo = '").append(exameReq.getExame().getCodigo()).append("'");
        sql.append(" and mco_codigo =  ").append(exameReq.getMaterial().getCodigo());
        return st.execute(sql.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String pesquisarSituacaoExame(String codFilial, String codLabExterno, Integer[] multiguias, String codExame, String codMaterial) {
        String string;
        Statement st;
        block13: {
            String situacao = "";
            StringBuilder sql = new StringBuilder();
            st = Conexao.getStatement();
            ResultSet rs = null;
            try {
                String[] examePai = new String[3];
                if (multiguias.length > 1) {
                    sql.delete(0, sql.length());
                    sql.append(" select req_codigo, exa_codigo, mco_codigo from loteexternoexamerequisicaodesm ");
                    sql.append(" where fil_kodigo = ").append(codFilial);
                    sql.append(" and lae_codigo = ").append(codLabExterno);
                    sql.append(" and exa_kodigo = ").append(StringUtil.textoDBEscape(codExame));
                    sql.append(" and mco_kodigo = ").append(codMaterial);
                    sql.append("  and req_codigo in ( ");
                    for (Integer guia : multiguias) {
                        sql.append(guia).append(",");
                    }
                    sql.replace(sql.length() - 1, sql.length(), "");
                    sql.append(")");
                    rs = Conexao.executeQuery(st, sql);
                    while (rs.next()) {
                        String situacaoExameRepetido = this.validaExamesRepetidos(codFilial, multiguias, codExame, codMaterial);
                        if (situacaoExameRepetido != null) {
                            string = situacaoExameRepetido;
                            break block13;
                        }
                        examePai[0] = rs.getString("req_codigo");
                        examePai[1] = rs.getString(EXA_CODIGO);
                        examePai[2] = rs.getString(MCO_CODIGO);
                    }
                }
                String codExa = codExame;
                String codMat = codMaterial;
                if (!Funcoes.textoVazio(examePai[0])) {
                    codExa = examePai[1];
                    codMat = examePai[2];
                }
                sql.delete(0, sql.length());
                sql = new StringBuilder(" select distinct(exr_situacao) as exr_situacao from examerequisicao ");
                sql.append(" where exr_excluido = false ");
                sql.append(" and fil_codigo = ").append(codFilial);
                sql.append(" and exa_codigo = ").append(StringUtil.textoDBEscape(codExa));
                sql.append(" and mco_codigo = ").append(codMat);
                if (multiguias.length == 1) {
                    sql.append(" and req_codigo = ").append(multiguias[0]);
                } else {
                    sql.append(" and req_codigo in ( ");
                    for (Integer guia : multiguias) {
                        sql.append(guia).append(",");
                    }
                    sql.replace(sql.length() - 1, sql.length(), "");
                    sql.append(")");
                }
                rs = Conexao.executeQuery(st, sql);
                situacao = rs.next() ? rs.getString("exr_situacao") : "";
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
                return situacao;
            }
            Conexao.fecharStatement(st);
            return situacao;
        }
        Conexao.fecharStatement(st);
        return string;
    }

    private String validaExamesRepetidos(String codFilial, Integer[] multiguias, String codExame, String codMaterial) throws SQLException {
        Statement st = Conexao.getStatement();
        String situacao = "";
        StringBuilder sql = new StringBuilder(" select distinct(a.exr_situacao) as exr_situacao from examerequisicao a ");
        sql.append(" left join examerequisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo");
        sql.append(" left join loteexternoexamerequisicao f on b.fil_codigo = f.fil_kodigo and b.req_codigo = f.req_codigo and b.exa_codigo = f.exa_codigo and b.mco_codigo = f.mco_codigo");
        sql.append(" left join examematcoletalabexterno g on f.fil_codigo = g.fil_codigo and f.exa_codigo = g.exa_codigo and f.mco_codigo = g.mco_codigo and f.lae_codigo = g.lae_codigo");
        sql.append(" left join examematcoletalabextdesm ed on f.fil_codigo = b.fil_codigo and b.mco_codigo = ed.mco_codigo and ed.exa_codigo = b.exa_codigo");
        sql.append(" where a.exr_excluido = false ");
        sql.append(" and a.fil_codigo = ").append(codFilial);
        sql.append(" and (a.exa_codigo = ").append(StringUtil.textoDBEscape(codExame)).append(" or ed.exa_kodigo = ").append(StringUtil.textoDBEscape(codExame)).append(")");
        sql.append(" and a.mco_codigo = ").append(codMaterial);
        if (multiguias.length == 1) {
            sql.append(" and a.req_codigo = ").append(multiguias[0]);
        } else {
            sql.append(" and a.req_codigo in ( ");
            for (Integer guia : multiguias) {
                sql.append(guia).append(",");
            }
            sql.replace(sql.length() - 1, sql.length(), "");
            sql.append(")");
        }
        ResultSet rs = Conexao.executeQuery(st, sql);
        situacao = rs.next() ? rs.getString("exr_situacao") : null;
        Conexao.fecharStatement(st);
        return situacao;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String buscaCodigoExameAssociado(String filCodigo, Integer[] multiguias, Registro exame) throws SQLException {
        Statement st;
        String retorno;
        block9: {
            retorno = "";
            StringBuilder sql = new StringBuilder("select \n");
            sql.append("  b.exa_codigo as codigoExame, b.mco_codigo as codigoMaterial \n");
            sql.append("from requisicao a \n");
            sql.append("left join examerequisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo \n");
            sql.append("left join paciente c on a.fil_codigo = c.fil_codigo and a.pac_codigo = c.pac_codigo \n");
            sql.append("left join exames d on b.fil_codigo = d.fil_codigo and b.exa_codigo = d.exa_codigo \n");
            sql.append("left join loteexternoexamerequisicao f on b.fil_codigo = f.fil_kodigo and b.req_codigo = f.req_codigo and b.exa_codigo = f.exa_codigo and b.mco_codigo = f.mco_codigo \n");
            sql.append("left join examematcoletalabexterno g on f.fil_codigo = g.fil_codigo and f.exa_codigo = g.exa_codigo and f.mco_codigo = g.mco_codigo and f.lae_codigo = g.lae_codigo \n");
            sql.append("left join examematcoletalabextdesm e on f.fil_codigo = e.fil_codigo and f.exa_codigo = e.exa_codigo and f.mco_codigo = e.mco_codigo and f.lae_codigo = e.lae_codigo \n ");
            sql.append("where \n");
            sql.append("  a.fil_codigo = ").append(filCodigo).append(" \n");
            if (multiguias.length > 1) {
                sql.append("and b.req_codigo in ( ");
                for (Integer guia : multiguias) {
                    sql.append(guia).append(",");
                }
                sql.replace(sql.length() - 1, sql.length(), "");
                sql.append(") ").append(" and  \n");
            } else {
                sql.append(" and b.req_codigo = ").append(multiguias[0]).append("  and \n");
            }
            sql.append("  a.req_excluida = false and b.exr_excluido = false \n");
            if (!Funcoes.textoVazio(exame.getString(EXA_CODIGO)) && !Funcoes.textoVazio(exame.getString(MCO_CODIGO))) {
                sql.append(" and ((b.exa_codigo = '").append(exame.getString(EXA_CODIGO)).append("' \n");
                sql.append(" and b.mco_codigo = ").append(exame.getString(MCO_CODIGO)).append(") \n");
                sql.append(" or (e.exa_kodigo = '").append(exame.getString(EXA_CODIGO)).append("' \n");
                sql.append(" and e.mco_kodigo = ").append(exame.getString(MCO_CODIGO)).append(")) \n");
            } else {
                sql.append("  and g.ele_xmllabexterno is not null and g.ele_xmllabexterno <> '' \n");
                sql.append("  and (upper(g.ele_xmllabexterno) ilike '%<").append("cd_db").append(">").append(exame.getString("CodigoExameDB").toUpperCase()).append("</").append("cd_db").append(">%'");
                sql.append(" or e.exa_kodigo = '").append(exame.getString("CodigoExameDB").toUpperCase()).append("') ");
            }
            st = Conexao.getStatement();
            ResultSet resultSet = null;
            try {
                resultSet = Conexao.executeQuery(st, sql);
                if (resultSet.next()) {
                    retorno = resultSet.getString("codigoExame") + "-" + resultSet.getString("codigoMaterial");
                }
                if (resultSet == null) break block9;
            }
            catch (Throwable throwable) {
                if (resultSet != null) {
                    resultSet.close();
                }
                Conexao.fecharStatement(st);
                throw throwable;
            }
            resultSet.close();
        }
        Conexao.fecharStatement(st);
        return retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String buscaCodigoExameAssociadoComDesm(String filCodigo, Integer[] multiguias, Registro exame) throws SQLException {
        Statement st;
        String retorno;
        block9: {
            retorno = "";
            StringBuilder sql = new StringBuilder("select \n");
            sql.append("  b.exa_codigo as codigoExame, b.mco_codigo as codigoMaterial \n");
            sql.append("from requisicao a \n");
            sql.append("left join examerequisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo \n");
            sql.append("left join paciente c on a.fil_codigo = c.fil_codigo and a.pac_codigo = c.pac_codigo \n");
            sql.append("left join exames d on b.fil_codigo = d.fil_codigo and b.exa_codigo = d.exa_codigo \n");
            sql.append("left join loteexternoexamerequisicao f on b.fil_codigo = f.fil_kodigo and b.req_codigo = f.req_codigo and b.exa_codigo = f.exa_codigo and b.mco_codigo = f.mco_codigo \n");
            sql.append("left join examematcoletalabexterno g on f.fil_codigo = g.fil_codigo and f.exa_codigo = g.exa_codigo and f.mco_codigo = g.mco_codigo and f.lae_codigo = g.lae_codigo \n");
            sql.append("left join examematcoletalabextdesm e on e.fil_codigo = b.fil_codigo and b.mco_codigo = e.mco_codigo and e.exa_codigo = b.exa_codigo \n");
            sql.append("left join examematcoletalabexterno ge on f.fil_codigo = ge.fil_codigo and e.exa_kodigo = ge.exa_codigo and e.mco_kodigo = ge.mco_codigo and f.lae_codigo = ge.lae_codigo \n");
            sql.append("where \n");
            sql.append("  a.fil_codigo = ").append(filCodigo).append(" \n");
            if (multiguias.length > 1) {
                sql.append("and b.req_codigo in ( ");
                for (Integer guia : multiguias) {
                    sql.append(guia).append(",");
                }
                sql.replace(sql.length() - 1, sql.length(), "");
                sql.append(") ").append(" and \n");
            } else {
                sql.append(" and b.req_codigo = ").append(multiguias[0]).append(" and \n");
            }
            sql.append("  a.req_excluida = false and b.exr_excluido = false \n");
            if (!Funcoes.textoVazio(exame.getString(EXA_CODIGO)) && !Funcoes.textoVazio(exame.getString(MCO_CODIGO))) {
                sql.append(" and (b.exa_codigo = '").append(exame.getString(EXA_CODIGO)).append("' or e.exa_kodigo = '").append(exame.getString(EXA_CODIGO)).append("') \n");
                sql.append(" and (b.mco_codigo = ").append(exame.getString(MCO_CODIGO)).append(" or e.mco_kodigo = ").append(exame.getString(MCO_CODIGO)).append(") \n");
            } else {
                sql.append("  and ((g.ele_xmllabexterno is not null and g.ele_xmllabexterno <> '' \n");
                sql.append("  and upper(g.ele_xmllabexterno) ilike '%<").append("cd_db").append(">").append(exame.getString("CodigoExameDB").toUpperCase()).append("</").append("cd_db").append(">%')");
                sql.append("  or (ge.ele_xmllabexterno is not null and ge.ele_xmllabexterno <> '' \n");
                sql.append("  and upper(ge.ele_xmllabexterno) ilike '%<").append("cd_db").append(">").append(exame.getString("CodigoExameDB").toUpperCase()).append("</").append("cd_db").append(">%'))");
            }
            st = Conexao.getStatement();
            ResultSet resultSet = null;
            try {
                resultSet = Conexao.executeQuery(st, sql);
                if (resultSet.next()) {
                    retorno = resultSet.getString("codigoExame") + "-" + resultSet.getString("codigoMaterial");
                }
                if (resultSet == null) break block9;
            }
            catch (Throwable throwable) {
                if (resultSet != null) {
                    resultSet.close();
                }
                Conexao.fecharStatement(st);
                throw throwable;
            }
            resultSet.close();
        }
        Conexao.fecharStatement(st);
        return retorno;
    }
}

