/*
 * Decompiled with CFR 0.152.
 */
package jalis.model.dao.util.parsers.alvaro;

import jalis.comum.Conexao;
import jalis.comum.ConexaoTemporaria;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.triagem.externo.LaboratorioExterno;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.laboratorio.util.parsers.alvaro.resultado.InformaPeriodoImportacaoAlvaro;
import jalis.model.vo.consultas.ConfiguracaoExameAlvaroVO;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.binary.Base64;

public class ImportacaoResultadoAlvaroDao {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ConfiguracaoExameAlvaroVO> pesquisarExamesLoteExterno(InformaPeriodoImportacaoAlvaro periodoImportacao, boolean importaExameEmPDF) throws SQLException {
        ArrayList<ConfiguracaoExameAlvaroVO> exames = new ArrayList<ConfiguracaoExameAlvaroVO>();
        Statement st = Conexao.getStatement();
        StringBuilder sql = new StringBuilder();
        sql.append(" select ler.fil_kodigo, ler.req_codigo, ler.leq_codigoreqapoio, ler.lae_codigo, ");
        sql.append(" leer.exa_codigo, leer.mco_codigo, ldesm.exa_kodigo, ldesm.mco_kodigo, er.exr_situacao,  ");
        sql.append(" exame.ele_xmllabexterno as exameExterno, examedesm.ele_xmllabexterno as exameExternoDesm ");
        sql.append(" from loteexterno le ");
        sql.append(" left join loteexternorequisicao ler ");
        sql.append(" on le.fil_codigo = ler.fil_codigo ");
        sql.append(" and le.lex_codigo = ler.lex_codigo ");
        sql.append(" and le.lae_codigo = ler.lae_codigo ");
        sql.append(" left join loteexternoexamerequisicao leer ");
        sql.append(" on ler.fil_codigo = leer.fil_codigo ");
        sql.append(" and ler.lex_codigo = leer .lex_codigo ");
        sql.append(" and ler.req_codigo = leer.req_codigo ");
        sql.append(" and ler.lae_codigo = leer.lae_codigo ");
        sql.append(" and ler.fil_kodigo = leer.fil_kodigo ");
        sql.append(" left join loteexternoexamerequisicaodesm ldesm ");
        sql.append(" on leer.fil_codigo = ldesm.fil_codigo ");
        sql.append(" and leer.fil_kodigo = ldesm.fil_kodigo ");
        sql.append(" and leer.lex_codigo  = ldesm .lex_codigo ");
        sql.append(" and leer.lae_codigo = ldesm.lae_codigo ");
        sql.append(" and leer.exa_codigo = ldesm.exa_codigo ");
        sql.append(" and leer.mco_codigo = ldesm.mco_codigo ");
        sql.append(" left join examematcoletalabexterno exame ");
        sql.append(" on leer.fil_kodigo = exame.fil_codigo ");
        sql.append(" and leer.exa_codigo = exame.exa_codigo ");
        sql.append(" and leer.mco_codigo = exame.mco_codigo ");
        sql.append(" and leer.lae_codigo = exame.lae_codigo ");
        sql.append(" left join examematcoletalabexterno exameDesm ");
        sql.append(" on ldesm.fil_kodigo = exameDesm.fil_codigo ");
        sql.append(" and ldesm.exa_kodigo = exameDesm.exa_codigo ");
        sql.append(" and ldesm.mco_kodigo = exameDesm.mco_codigo ");
        sql.append(" and ldesm.lae_codigo = exameDesm.lae_codigo ");
        sql.append(" left join examerequisicao er ");
        sql.append(" on leer.fil_kodigo = er.fil_codigo ");
        sql.append(" and leer.req_codigo = er.req_codigo ");
        sql.append(" and leer.exa_codigo = er.exa_codigo ");
        sql.append(" and leer.mco_codigo = er.mco_codigo ");
        sql.append(" where ");
        sql.append(" ler.lae_codigo = ").append(periodoImportacao.getCodigoLabExterno());
        sql.append(this.getCondicaoPeriodo(periodoImportacao));
        sql.append(" and le.lex_dataestorno is null and le.usr_codestorno is null ");
        sql.append(" and ler.leq_dataestorno is null and ler.usr_codestorno is null ");
        sql.append(" and leer.ler_datahoraestorno is null and leer.usr_codestorno is null ");
        sql.append(" and er.exr_excluido = 'f' ");
        sql.append(" group by ");
        sql.append(" ler.fil_kodigo, ler.req_codigo, ler.leq_codigoreqapoio, ");
        sql.append(" ler.lae_codigo, leer.exa_codigo, leer.mco_codigo, er.exr_situacao, ");
        sql.append(" ldesm.exa_kodigo, ldesm.mco_kodigo, exame.ele_xmllabexterno, ");
        sql.append(" examedesm.ele_xmllabexterno ");
        sql.append(" order by ");
        sql.append(" ler.fil_kodigo, ler.req_codigo, leer.exa_codigo, ");
        sql.append(" leer.mco_codigo, ldesm.exa_kodigo, ldesm.mco_kodigo ");
        try {
            ResultSet rs = ConexaoTemporaria.executeQuery(st, sql);
            while (rs.next()) {
                ConfiguracaoExameAlvaroVO confExame = new ConfiguracaoExameAlvaroVO();
                confExame.setCodExame(rs.getString("exa_codigo"));
                confExame.setCodExameDesm(rs.getString("exa_kodigo"));
                String xmlExameAlvaro = Funcoes.textoVazio(rs.getString("exa_kodigo")) ? rs.getString("exameExterno") : rs.getString("exameExternoDesm");
                String codExameAlvaro = StringUtil.getValor(xmlExameAlvaro, "codigo");
                confExame.setCodExmApoio(codExameAlvaro);
                confExame.setCodFilial(rs.getInt("fil_kodigo"));
                confExame.setCodMaterial(rs.getString("mco_codigo"));
                confExame.setCodMaterialDesm(rs.getString("mco_kodigo"));
                confExame.setCodReqApoio(rs.getString("leq_codigoreqapoio"));
                confExame.setCodRequisicao(rs.getInt("req_codigo"));
                confExame.setSituacaoExame(rs.getString("exr_situacao"));
                if (importaExameEmPDF) {
                    confExame.setResultadoEmPDF(true);
                } else {
                    String xmlExame = rs.getString("exameExterno");
                    String conteudoTag = StringUtil.getValor(xmlExame, "formato_pdf");
                    confExame.setResultadoEmPDF(conteudoTag.equalsIgnoreCase("SIM"));
                }
                exames.add(confExame);
            }
        }
        catch (Throwable throwable) {
            Conexao.fecharStatement(st);
            throw throwable;
        }
        Conexao.fecharStatement(st);
        return exames;
    }

    private String getCondicaoPeriodo(InformaPeriodoImportacaoAlvaro periodoImportacao) throws SQLException {
        StringBuilder condicaoPeriodo = new StringBuilder(" and ");
        if (!(Funcoes.textoVazio(periodoImportacao.getDataInicial()) || Funcoes.textoVazio(periodoImportacao.getDataFinal()) || Funcoes.textoVazio(periodoImportacao.getHoraInicial()) || Funcoes.textoVazio(periodoImportacao.getHoraFinal()))) {
            String dataInicial = Funcoes.formataData("yyyy-MM-dd", periodoImportacao.getDataInicial());
            String dataFinal = Funcoes.formataData("yyyy-MM-dd", periodoImportacao.getDataFinal());
            condicaoPeriodo.append(" le.lex_datahora between '").append(dataInicial).append(" ").append(periodoImportacao.getHoraInicial()).append("'");
            condicaoPeriodo.append(" and '").append(dataFinal).append(" ").append(periodoImportacao.getHoraFinal()).append("'");
        } else {
            Integer[] multiguias = null;
            LaboratorioExterno lab = LaboratorioExterno.getLabExterno(String.valueOf(periodoImportacao.getCodigoLabExterno()));
            multiguias = ParametrosGerais.isAgruparGuiasInterface() || lab.agruparMultiguias ? RecepcaoUtil.verificaMultiGuias(periodoImportacao.getFiltroFilial(), periodoImportacao.getFiltroRequisicao(), true) : new Integer[]{Integer.valueOf(periodoImportacao.getFiltroRequisicao())};
            StringBuilder sqlGuia = new StringBuilder("(");
            for (Integer guia : multiguias) {
                sqlGuia.append(guia).append(", ");
            }
            sqlGuia.replace(sqlGuia.length() - 2, sqlGuia.length(), "");
            sqlGuia.append(")");
            condicaoPeriodo.append(" ler.fil_kodigo = ").append(periodoImportacao.getFiltroFilial());
            condicaoPeriodo.append(" and ler.req_codigo in ").append(sqlGuia.toString());
        }
        return condicaoPeriodo.toString();
    }

    public void salvarResultadoPDF(Integer codFil, Integer codReq, String codExame, String codMaterial, byte[] resultado) throws SQLException {
        Statement st = Conexao.getStatement();
        try {
            StringBuilder sql = new StringBuilder();
            String condicaoWhere = this.getCondicaoWhere(codFil, codReq, codExame, codMaterial);
            String resultadoBase64 = StringUtil.textoDBEscape(new Base64().encodeAsString(resultado));
            sql.append(" select 1 as resultado from examerequisicaoresultado");
            sql.append(condicaoWhere);
            ResultSet rs = Conexao.executeQuery(st, sql.toString());
            sql.delete(0, sql.length());
            if (rs.next()) {
                sql.append(" update examerequisicaoresultado set");
                sql.append(" ert_resultadopdf = ").append(resultadoBase64);
                sql.append(condicaoWhere);
            } else {
                sql.append(" insert into examerequisicaoresultado (fil_codigo, exa_codigo, mco_codigo, req_codigo, ert_resultadopdf) ");
                sql.append(" values (");
                sql.append(codFil).append(", ");
                sql.append(StringUtil.textoDBEscape(codExame)).append(", ");
                sql.append(codMaterial).append(", ");
                sql.append(codReq).append(", ");
                sql.append(resultadoBase64).append(" );");
            }
            Conexao.executeUpdate(codFil.toString(), st, sql.toString());
            Conexao.arquivaSQL();
        }
        catch (Exception e) {
            try {
                Conexao.anulaSQL();
                throw e;
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
        }
        Conexao.fecharStatement(st);
    }

    public void atualizarExameRequisicao(Integer codFil, Integer codReq, String codExame, String codMaterial, boolean conferirAutomatico, String codigoUsuarioConferenciaAutomatica) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append(" update examerequisicao set exr_resultadoempdf = true, ");
        if (!conferirAutomatico && Funcoes.textoVazio(codigoUsuarioConferenciaAutomatica)) {
            sql.append(" exr_situacao = '").append("L").append("', ");
        }
        sql.append(" exr_datadigita = current_timestamp, ");
        sql.append(" usr_coddigitador = '").append(Variaveis.login).append("'");
        if (conferirAutomatico && !Funcoes.textoVazio(codigoUsuarioConferenciaAutomatica)) {
            sql.append(" ,exr_situacao = '").append("C").append("', ");
            sql.append(" exr_dataassina = current_timestamp, ");
            sql.append(" usr_codassina = '").append(codigoUsuarioConferenciaAutomatica).append("'");
        }
        sql.append(this.getCondicaoWhere(codFil, codReq, codExame, codMaterial));
        Statement st = Conexao.getStatement();
        try {
            Conexao.executeUpdate(codFil.toString(), st, sql.toString());
            Conexao.arquivaSQL();
        }
        catch (Exception e) {
            try {
                Conexao.anulaSQL();
                throw e;
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
        }
        Conexao.fecharStatement(st);
    }

    public String pesquisarSituacaoExame(Integer codFil, Integer codReq, String codExame, String codMaterial) throws SQLException {
        String situacao = "";
        StringBuilder sql = new StringBuilder(" select exr_situacao from examerequisicao");
        sql.append(this.getCondicaoWhere(codFil, codReq, codExame, codMaterial));
        Statement st = Conexao.getStatement();
        ResultSet rs = Conexao.executeQuery(st, sql.toString());
        if (rs.next()) {
            situacao = rs.getString("exr_situacao");
        }
        Conexao.fecharStatement(st);
        return situacao;
    }

    private String getCondicaoWhere(Integer codFil, Integer codReq, String codExame, String codMaterial) {
        StringBuilder where = new StringBuilder(" where ");
        where.append(" fil_codigo = ").append(codFil);
        where.append(" and req_codigo = ").append(codReq);
        where.append(" and exa_codigo = ").append(StringUtil.textoDBEscape(codExame));
        where.append(" and mco_codigo = ").append(codMaterial);
        return where.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String pesquisarSituacaoExame(String codFilial, String codLabExterno, Integer[] multiguias, String codExame, String codMaterial) throws Exception {
        String string;
        Statement st;
        block13: {
            String situacao = "";
            StringBuilder sql = new StringBuilder();
            st = Conexao.getStatement();
            ResultSet rs = null;
            try {
                String[] examePai = new String[3];
                if (multiguias.length > 1) {
                    sql.delete(0, sql.length());
                    sql.append(" select req_codigo, exa_codigo, mco_codigo from loteexternoexamerequisicaodesm ");
                    sql.append(" where fil_kodigo = ").append(codFilial);
                    sql.append(" and lae_codigo = ").append(codLabExterno);
                    sql.append(" and exa_kodigo = ").append(StringUtil.textoDBEscape(codExame));
                    sql.append(" and mco_kodigo = ").append(codMaterial);
                    sql.append(" and req_codigo in ( ");
                    for (Integer guia : multiguias) {
                        sql.append(guia).append(",");
                    }
                    sql.replace(sql.length() - 1, sql.length(), "");
                    sql.append(")");
                    rs = Conexao.executeQuery(st, sql);
                    while (rs.next()) {
                        String situacaoExameRepetido = this.validaExamesRepetidos(codFilial, codLabExterno, multiguias, codExame, codMaterial);
                        if (situacaoExameRepetido != null) {
                            string = situacaoExameRepetido;
                            break block13;
                        }
                        examePai[0] = rs.getString("req_codigo");
                        examePai[1] = rs.getString("exa_codigo");
                        examePai[2] = rs.getString("mco_codigo");
                    }
                }
                String codExa = codExame;
                String codMat = codMaterial;
                if (!Funcoes.textoVazio(examePai[0])) {
                    codExa = examePai[1];
                    codMat = examePai[2];
                }
                sql.delete(0, sql.length());
                sql = new StringBuilder(" select distinct(exr_situacao) as exr_situacao from examerequisicao ");
                sql.append(" where exr_excluido = false ");
                sql.append(" and fil_codigo = ").append(codFilial);
                sql.append(" and exa_codigo = ").append(StringUtil.textoDBEscape(codExa));
                sql.append(" and mco_codigo = ").append(codMat);
                if (multiguias.length == 1) {
                    sql.append(" and req_codigo = ").append(multiguias[0]);
                } else {
                    sql.append(" and req_codigo in ( ");
                    for (Integer guia : multiguias) {
                        sql.append(guia).append(",");
                    }
                    sql.replace(sql.length() - 1, sql.length(), "");
                    sql.append(")");
                }
                rs = Conexao.executeQuery(st, sql);
                situacao = rs.next() ? rs.getString("exr_situacao") : "";
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
                return situacao;
            }
            Conexao.fecharStatement(st);
            return situacao;
        }
        Conexao.fecharStatement(st);
        return string;
    }

    private String validaExamesRepetidos(String codFilial, String codLabExterno, Integer[] multiguias, String codExame, String codMaterial) throws SQLException {
        Statement st = Conexao.getStatement();
        String situacao = "";
        StringBuilder sql = new StringBuilder(" select distinct(exr_situacao) as exr_situacao from examerequisicao ");
        sql.append(" where exr_excluido = false ");
        sql.append(" and fil_codigo = ").append(codFilial);
        sql.append(" and exa_codigo = ").append(StringUtil.textoDBEscape(codExame));
        sql.append(" and mco_codigo = ").append(codMaterial);
        if (multiguias.length == 1) {
            sql.append(" and req_codigo = ").append(multiguias[0]);
        } else {
            sql.append(" and req_codigo in ( ");
            for (Integer guia : multiguias) {
                sql.append(guia).append(",");
            }
            sql.replace(sql.length() - 1, sql.length(), "");
            sql.append(")");
        }
        ResultSet rs = Conexao.executeQuery(st, sql);
        situacao = rs.next() ? rs.getString("exr_situacao") : null;
        Conexao.fecharStatement(st);
        return situacao;
    }
}

