/*
 * Decompiled with CFR 0.152.
 */
package jalis.model.dao.triagem.externo.exportadores.indlab;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.exportacao.integracao.IntegracaoUtil;
import jalis.laboratorio.triagem.externo.exportadores.indlab.IndLabDto;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.exame.LabExternoVO;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;

public class ExportacaoParaIndLabDao {
    public int getMaiorCodigoLote(String codigoLabExterno, Statement st) throws SQLException {
        StringBuilder sql = new StringBuilder(" select max(lex_codigo) + 1 as codigo from loteexterno ");
        sql.append(" where lae_codigo = ").append(codigoLabExterno);
        sql.append(" and fil_codigo = ").append(Variaveis.filialPadrao);
        ResultSet rs = null;
        int codigo = 0;
        rs = st.executeQuery(sql.toString());
        codigo = rs.next() ? rs.getInt("codigo") : 0;
        return codigo;
    }

    public IndLabDto pesquisarDadosParaXml(Integer codFilial, List<Integer> codRequisicoes, Integer codPaciente, Statement st, Callable<Boolean> arquivar, Callable<Boolean> anular) {
        StringBuilder requisicoesIn = new StringBuilder(" (");
        codRequisicoes.forEach(r -> requisicoesIn.append(r + ", "));
        requisicoesIn.replace(requisicoesIn.length() - 2, requisicoesIn.length(), " )");
        StringBuilder sql = new StringBuilder(" select ");
        sql.append(" s.sit_descricao, p.pac_cpf, r.req_responsavel, p.pac_nomeplano, r.req_guia, r.req_urgente, r.req_dclinicos, ");
        sql.append(" r.req_matricula, p.pac_tipologradouroendereco, p.pac_endereco, p.pac_numeroendereco, ");
        sql.append(" b.bai_descricao, c.cid_nome, c.cid_uf, p.pac_cep, p.pac_fone, p.pac_celular, ");
        sql.append(" p.pac_fonecomercial, p.pac_email, m.mto_descricao, er.exr_intervalojejum ");
        sql.append(" from requisicao r ");
        sql.append(" left join examerequisicao er on r.fil_codigo = er.fil_codigo  and r.req_codigo = er.req_codigo  ");
        sql.append(" left join paciente p on r.fil_codigo = p.fil_codigo and r.pac_codigo = p.pac_codigo ");
        sql.append(" left join situacao s on r.fil_codigo = s.fil_codigo and r.sit_codigo = s.sit_codigo ");
        sql.append(" left join bairro b on r.fil_codigo = b.fil_codigo and p.bai_codigo = b.bai_codigo ");
        sql.append(" left join cidades c on r.fil_codigo = c.fil_codigo and p.cid_codigo = c.cid_codigo ");
        sql.append(" left join requisicaomedicamento rm on r.fil_codigo = rm.fil_codigo and r.req_codigo = rm.req_codigo ");
        sql.append(" left join medicamentos m on r.fil_codigo = m.fil_codigo and m.mto_codigo = rm.mto_codigo ");
        sql.append(" where r.fil_codigo = ").append(codFilial);
        sql.append(" and r.req_codigo in ").append(requisicoesIn.toString());
        sql.append(" and r.pac_codigo = ").append(codPaciente);
        sql.append(" and r.req_excluida = false ");
        sql.append(" and er.exr_excluido = false ");
        sql.append(" group by ");
        sql.append(" s.sit_descricao, p.pac_cpf, r.req_responsavel, p.pac_nomeplano, r.req_guia, r.req_urgente, r.req_dclinicos, ");
        sql.append(" r.req_matricula, p.pac_tipologradouroendereco, p.pac_endereco, p.pac_numeroendereco, ");
        sql.append(" b.bai_descricao, c.cid_nome, c.cid_uf, p.pac_cep, p.pac_fone, p.pac_celular, ");
        sql.append(" p.pac_fonecomercial, p.pac_email, m.mto_descricao, er.exr_intervalojejum ");
        IndLabDto dto = new IndLabDto();
        ArrayList<String> medicamentos = new ArrayList<String>();
        ArrayList<String> dadosClinicos = new ArrayList<String>();
        ResultSet rs = null;
        try {
            rs = st.executeQuery(sql.toString());
            while (rs.next()) {
                dto.setTipoAtendimento(rs.getString("sit_descricao"));
                dto.setCpf(rs.getString("pac_cpf"));
                dto.setResponsavel(rs.getString("req_responsavel"));
                dto.setPlano(rs.getString("pac_nomeplano"));
                dto.setGuia(rs.getString("req_guia"));
                dto.setMatricula(rs.getString("req_matricula"));
                dto.setTipoLogradouroEndereco(rs.getString("pac_tipologradouroendereco"));
                dto.setLogradouro(rs.getString("pac_endereco"));
                dto.setNumeroLogradouro(rs.getString("pac_numeroendereco"));
                dto.setBairro(rs.getString("bai_descricao"));
                dto.setCidade(rs.getString("cid_nome"));
                dto.setUf(rs.getString("cid_uf"));
                dto.setCep(rs.getString("pac_cep"));
                dto.setFone(rs.getString("pac_fone"));
                dto.setCelular(rs.getString("pac_celular"));
                dto.setFoneComercial(rs.getString("pac_fonecomercial"));
                dto.setEmail(rs.getString("pac_email"));
                medicamentos.add(rs.getString("mto_descricao"));
                dadosClinicos.add(rs.getString("req_dclinicos"));
                dto.setTempoJejum(rs.getTimestamp("exr_intervalojejum"));
                dto.setReqUrgente(rs.getBoolean("req_urgente"));
            }
            dto.setMedicamentos(medicamentos);
            dto.setDadosClinicos(dadosClinicos);
        }
        catch (Exception e) {
            try {
                anular.call();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        return dto;
    }

    public LabExternoVO pesquisarLabExterno(Integer codFilial, Integer codLabExterno, Statement st, Callable<Boolean> arquivar, Callable<Boolean> anular) {
        StringBuilder sql = new StringBuilder(" select lae_descricao, lae_agruparmultiguias ");
        sql.append(" from labexterno ");
        sql.append(" where fil_codigo = ").append(codFilial);
        sql.append(" and lae_codigo = ").append(codLabExterno);
        sql.append(" and lae_inativo = false ");
        ResultSet rs = null;
        LabExternoVO vo = new LabExternoVO();
        try {
            rs = st.executeQuery(sql.toString());
            if (rs.next()) {
                FilialVO filial = new FilialVO();
                filial.setCodigo(codFilial);
                vo.setFilial(filial);
                vo.setDescricao(rs.getString("lae_descricao"));
                vo.setAgruparmultiguias(rs.getBoolean("lae_agruparmultiguias"));
                vo.setCodigo(codLabExterno);
            }
        }
        catch (Exception e) {
            try {
                anular.call();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        return vo;
    }

    public void gravaNomeArquivoLote(String filial, String requisicao, String codigoLabExterno, String numeroLote, String nomeArquivo, String tipoIntegracao, Statement st, boolean isColetaWeb, Callable<Boolean> arquivar, Callable<Boolean> anular) {
        StringBuilder sqlpdate = new StringBuilder();
        sqlpdate.append(" update  loteexternorequisicao set leq_retornows = '").append(nomeArquivo).append("'");
        sqlpdate.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
        sqlpdate.append(" and lae_codigo = ").append(codigoLabExterno);
        sqlpdate.append(" and req_codigo = ").append(requisicao);
        sqlpdate.append(" and fil_kodigo = ").append(filial);
        sqlpdate.append(" and lex_codigo = ").append(numeroLote);
        try {
            st.executeUpdate(sqlpdate.toString());
            if (!isColetaWeb && (!filial.equals(Variaveis.filialPadrao) || tipoIntegracao.equals("F") || tipoIntegracao.equals("W"))) {
                IntegracaoUtil.insereComandoLog(Conexao.getStatement(), Variaveis.filialPadrao, filial, sqlpdate.toString());
            }
            arquivar.call();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

