/*
 * Decompiled with CFR 0.152.
 */
package jalis.model.dao.triagem.externo.exportadores.db2;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.exportacao.integracao.IntegracaoUtil;
import jalis.laboratorio.triagem.externo.LaboratorioExterno;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.concurrent.Callable;

public class ExportacaoParaDBDao {
    public int getMaiorCodigoLote(String numeroLote, String codigoConvenio, LaboratorioExterno configuracaoLabExterno, Statement st) {
        int codigoLote = 0;
        ResultSet rs = null;
        try {
            rs = st.executeQuery("select max(lex_codigo) + 1 as codigo from loteexterno where lae_codigo = " + configuracaoLabExterno.codigoLab + " and fil_codigo = " + Variaveis.filialPadrao);
            if (rs.next()) {
                codigoLote = rs.getInt("codigo");
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return codigoLote;
    }

    public void gravaEnvioRetornoDB(String codFilial, String codigoRequisicao, String codigoLabExterno, String lote, String xmlEnvio, String xmlRetorno, Statement st, boolean isColetaWeb) throws SQLException {
        StringBuilder sqlpdate = new StringBuilder();
        sqlpdate.append(" update loteexternorequisicao set leq_enviows = '").append(StringUtil.textoDB(xmlEnvio)).append("' ");
        sqlpdate.append(", leq_xmlretornows = '").append(StringUtil.textoDB(xmlRetorno)).append("' ");
        sqlpdate.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
        sqlpdate.append(" and lae_codigo = ").append(codigoLabExterno);
        sqlpdate.append(" and req_codigo = ").append(codigoRequisicao);
        sqlpdate.append(" and fil_kodigo = ").append(codFilial);
        sqlpdate.append(" and lex_codigo = ").append(lote);
        st.executeUpdate(sqlpdate.toString());
        if (!isColetaWeb && (!codFilial.equals(Variaveis.filialPadrao) || ParametrosGerais.getTipoIntegracao().equals("F") || ParametrosGerais.getTipoIntegracao().equals("W"))) {
            IntegracaoUtil.insereComandoLog(Conexao.getStatement(), Variaveis.filialPadrao, codFilial, sqlpdate.toString());
        }
    }

    public String pesquisarEtiquetaDBWSPorRequisicao(String filial, Integer[] multiguias, String[] exames, int[] materiais, Statement st) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append("select distinct lot.lex_codigo, ");
        buf.append("       lot.leq_retornows as retornoWs");
        buf.append("  from loteexternorequisicao lot ");
        buf.append("  join loteexternoexamerequisicao lotex on lot.fil_codigo = lotex.fil_codigo and lot.req_codigo = lotex.req_codigo and lot.lex_codigo = lotex.lex_codigo ");
        buf.append(" where lot.fil_kodigo = ").append(filial);
        buf.append("   and lot.req_codigo in (").append(this.getCondicao(multiguias)).append(") ");
        buf.append("   and lot.leq_retornows is not null ");
        buf.append("   and lot.leq_dataestorno is null ");
        if (exames != null && exames.length > 0 && materiais != null && materiais.length > 0) {
            buf.append("  and (lotex.exa_codigo, lotex.mco_codigo) IN (");
            for (int i = 0; i < exames.length; ++i) {
                if (i > 0) {
                    buf.append(",");
                }
                buf.append("(").append(StringUtil.textoDBEscape(exames[i]));
                buf.append(",").append(materiais[i]).append(")");
            }
            buf.append(" ) ");
        }
        StringBuilder retorno = new StringBuilder();
        ResultSet rs = st.executeQuery(buf.toString());
        while (rs.next()) {
            retorno.append(rs.getString("retornoWs"));
        }
        rs.close();
        return retorno.toString();
    }

    public void atualizarEtiquetasLoteExternoRequisicao(String etiquetaDB, String codigoTuboApoio, String codigoLabExterno, String codigoReq, String codFilial, String lote, Statement st, boolean isColetaWeb) throws SQLException {
        StringBuilder sqlpdate = new StringBuilder();
        sqlpdate.append(" update  loteexternorequisicao set leq_retornows = coalesce(leq_retornows, ' ') || '<etiqueta>' || '").append(StringUtil.textoDB(etiquetaDB)).append("' || '</etiqueta>' ");
        sqlpdate.append(", leq_codigoreqapoio = ").append(codigoTuboApoio);
        sqlpdate.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
        sqlpdate.append(" and lae_codigo = ").append(codigoLabExterno);
        sqlpdate.append(" and req_codigo = ").append(codigoReq);
        sqlpdate.append(" and fil_kodigo = ").append(codFilial);
        sqlpdate.append(" and lex_codigo = ").append(lote);
        st.executeUpdate(sqlpdate.toString());
        if (!isColetaWeb && (!codFilial.equals(Variaveis.filialPadrao) || ParametrosGerais.getTipoIntegracao().equals("F") || ParametrosGerais.getTipoIntegracao().equals("W"))) {
            IntegracaoUtil.insereComandoLog(Conexao.getStatement(), Variaveis.filialPadrao, codFilial, sqlpdate.toString());
        }
    }

    public void atualizaCodigoApoiadoExameRequisicao(List<Registro> requisicoes, String exame, String material, String codigoApoiado, Statement st, boolean isColetaWeb, Callable<Boolean> arquivar, Callable<Boolean> anular) throws SQLException {
        StringBuilder sql = new StringBuilder();
        ResultSet rs = null;
        for (Registro req : requisicoes) {
            try {
                sql.setLength(0);
                sql.append(" select exr_codigoapoiado, exr_dataetqcoleta from examerequisicao  ");
                sql.append(" where fil_codigo = ").append(req.getString("fil_codigo"));
                sql.append(" and req_codigo =  ").append(req.getString("req_codigo"));
                sql.append(" and exa_codigo = '").append(exame).append("' ");
                sql.append(" and mco_codigo = ").append(material);
                rs = st.executeQuery(sql.toString());
                if (rs.next()) {
                    sql.setLength(0);
                    sql.append(" update  examerequisicao set exr_codigoapoiado = ").append(codigoApoiado);
                    sql.append(rs.getDate("exr_dataetqcoleta") == null ? ", exr_dataetqcoleta = current_timestamp" : "");
                    sql.append(" where fil_codigo = ").append(req.getString("fil_codigo"));
                    sql.append("   and req_codigo = ").append(req.getString("req_codigo"));
                    sql.append("   and exa_codigo = '").append(exame).append("' ");
                    sql.append(" and mco_codigo = ").append(material);
                    if (isColetaWeb) {
                        st.executeUpdate(sql.toString());
                    } else {
                        Conexao.executeUpdate(req.getString("fil_codigo"), st, sql);
                    }
                }
                sql.setLength(0);
                sql.append(" select ere_codigoapoiado from examerequisicaorecipiente ");
                sql.append(" where fil_codigo = ").append(req.getString("fil_codigo"));
                sql.append(" and req_codigo =  ").append(req.getString("req_codigo"));
                sql.append(" and exa_codigo = '").append(exame).append("' ");
                sql.append(" and mco_codigo = ").append(material);
                rs = st.executeQuery(sql.toString());
                sql.setLength(0);
                if (rs.next()) {
                    sql.append(" update  examerequisicaorecipiente set ere_codigoapoiado = ").append(codigoApoiado);
                    sql.append(" where fil_codigo = ").append(req.getString("fil_codigo"));
                    sql.append(" and req_codigo =  ").append(req.getString("req_codigo"));
                    sql.append(" and exa_codigo = '").append(exame).append("' ");
                    sql.append(" and mco_codigo = ").append(material);
                }
                if (sql.length() > 0) {
                    if (isColetaWeb) {
                        st.executeUpdate(sql.toString());
                    } else {
                        Conexao.executeUpdate(req.getString("fil_codigo"), st, sql);
                    }
                }
                arquivar.call();
            }
            catch (Exception e) {
                try {
                    anular.call();
                }
                catch (Exception e1) {
                    ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel anular o c\u00f3digo do apoio.\n" + e1.getMessage(), e1.getStackTrace());
                }
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel gravar o c\u00f3digo do apoio.\n" + e.getMessage(), e.getStackTrace());
            }
        }
        if (rs != null) {
            rs.close();
        }
    }

    private String getTipoEtiqueta(int tipoEtiq, int agruparInterface) {
        if (tipoEtiq == 0) {
            tipoEtiq = agruparInterface == 1 ? 2 : 1;
        }
        return tipoEtiq == 1 ? "C" : "T";
    }

    public int pesquisarCodigoRecipiente(String codFilial, String codExame, String codMaterial, Statement st) throws SQLException {
        int codRecipiente = 0;
        StringBuilder sql = new StringBuilder(" select rec_codigo from recipcoleta where ");
        sql.append(" fil_codigo = ").append(codFilial);
        sql.append(" and exa_codigo = ").append(StringUtil.textoDBEscape(codExame));
        sql.append(" and mco_codigo = ").append(codMaterial);
        ResultSet rs = st.executeQuery(sql.toString());
        while (rs.next()) {
            codRecipiente = rs.getInt("rec_codigo");
        }
        rs.close();
        return codRecipiente;
    }

    private String getCondicao(Integer[] materiais) {
        StringBuilder condicao = new StringBuilder();
        Integer[] integerArray = materiais;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int material = integerArray[i];
            condicao.append(material).append(",");
        }
        condicao.deleteCharAt(condicao.length() - 1);
        return condicao.toString();
    }
}

