/*
 * Decompiled with CFR 0.152.
 */
package jalis.model.dao.triagem.externo.exportadores;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.exame.ExameVO;
import jalis.model.vo.cadastro.exame.MaterialColetaVO;
import jalis.model.vo.cadastro.exame.MedicamentoVO;
import jalis.model.vo.recepcao.ExameRequisicaoRecipienteVO;
import jalis.model.vo.triagem.LoteExternoRequisicaoVO;
import jalis.model.vo.triagem.RecipienteColetaVO;
import jalis.model.vo.triagem.RecipienteVO;
import jalis.util.StringUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class ExportacaoParaRedeWSDao {
    private static final String ASPA = "'";
    private static final String VIRGULA = ",";

    public int getMaiorCodigoLote(String codigoLabExterno, Statement st) {
        StringBuilder sql = new StringBuilder(" select max(lex_codigo) + 1 as codigo from loteexterno ");
        sql.append(" where lae_codigo = ").append(codigoLabExterno);
        sql.append(" and fil_codigo = ").append(Variaveis.filialPadrao);
        try {
            ResultSet rs = st.executeQuery(sql.toString());
            if (rs.next()) {
                return rs.getInt("codigo");
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return 0;
    }

    public String pesquisarCartaoSUS(String codFilial, String codRequisicao, Statement st) {
        StringBuilder sql = new StringBuilder(" select req_cartaosus from requisicao where ");
        sql.append(" fil_codigo = ").append(codFilial);
        sql.append(" and req_codigo = ").append(codRequisicao);
        String cartaoSus = "";
        try {
            ResultSet rs = st.executeQuery(sql.toString());
            if (rs.next()) {
                cartaoSus = rs.getString("req_cartaosus");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cartaoSus;
    }

    public List<MedicamentoVO> pesquisarMedicamentosPorRequisicao(String codRequisicao, String codFilial, Statement st) {
        StringBuilder sql = new StringBuilder(" select m.fil_codigo, m.mto_codigo, m.mto_descricao ");
        sql.append(" from requisicaomedicamento r ");
        sql.append(" left join medicamentos m on r.fil_codigo = m.fil_codigo and r.mto_codigo = m.mto_codigo ");
        sql.append(" where ");
        sql.append(" r.fil_codigo = ").append(codFilial);
        sql.append(" and r.req_codigo = ").append(codRequisicao);
        ArrayList<MedicamentoVO> medicamentos = new ArrayList<MedicamentoVO>();
        try {
            ResultSet rs = st.executeQuery(sql.toString());
            while (rs.next()) {
                FilialVO filial = new FilialVO();
                filial.setCodigo(rs.getInt("fil_codigo"));
                MedicamentoVO medicamento = new MedicamentoVO();
                medicamento.setFilial(filial);
                medicamento.setCodigo(rs.getInt("mto_codigo"));
                medicamento.setDescricao(rs.getString("mto_descricao"));
                medicamentos.add(medicamento);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return medicamentos;
    }

    public void atualizarRetornoWSLoteExternoRequiscao(LoteExternoRequisicaoVO vo, boolean agruparMultiguia, Statement st) throws SQLException {
        StringBuilder multiguia = new StringBuilder();
        if (agruparMultiguia) {
            Integer[] guias;
            Integer[] codReqMae = vo.getRequisicaoVO().getRequisicoesMultiguia();
            for (Integer guia : guias = RecepcaoUtil.verificaMultiGuias(st, vo.getFilialVO().getCodigo().toString(), codReqMae[0].toString(), true, false)) {
                multiguia.append(guia).append(VIRGULA);
            }
            multiguia.replace(multiguia.length() - 1, multiguia.length(), "");
        }
        StringBuilder sql = new StringBuilder();
        sql.append(" update loteexternorequisicao set leq_retornows = '").append(StringUtil.textoDB(vo.getRetornoWS())).append("', ");
        sql.append(" leq_codigoreqapoio = '").append(vo.getCodigoReqApoio()).append(ASPA);
        sql.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
        sql.append(" and lae_codigo = ").append(vo.getLabExternoVO().getCodigo());
        sql.append(" and req_codigo in ( ");
        sql.append(agruparMultiguia ? multiguia : vo.getRequisicaoVO().getCodigo());
        sql.append(" ) ");
        sql.append(" and lex_codigo = ").append(vo.getLoteExternoVO().getCodigo());
        sql.append(" and fil_kodigo = ").append(vo.getFilialVO().getCodigo()).append(";");
        st.executeUpdate(sql.toString());
    }

    public void atualizarExameRequisicaoRecipiente(List<ExameRequisicaoRecipienteVO> recipientes, Statement st) throws SQLException {
        for (ExameRequisicaoRecipienteVO vo : recipientes) {
            StringBuilder sql = new StringBuilder();
            sql.append(" select fil_codigo, exa_codigo, mco_codigo, req_codigo, rec_codigo, ere_tipo, rec_kodigo, ere_codigoapoiado ");
            sql.append(" from examerequisicaorecipiente ");
            StringBuilder where = new StringBuilder();
            where.append(" where ");
            where.append(" fil_codigo = ").append(vo.getFilial().getCodigo());
            where.append(" and req_codigo = ").append(vo.getRequisicao().getCodigo());
            where.append(" and exa_codigo = ").append(ASPA.concat(vo.getExame().getCodigo()).concat(ASPA));
            where.append(" and mco_codigo = ").append(vo.getMatColeta().getCodigo());
            sql.append((CharSequence)where);
            ResultSet rs = st.executeQuery(sql.toString());
            if (!rs.next()) continue;
            sql.delete(0, sql.length());
            sql.append("update examerequisicaorecipiente set ere_codigoapoiado = ").append(ASPA.concat(vo.getCodigoApoiado()).concat(ASPA));
            sql.append((CharSequence)where);
            st.executeUpdate(sql.toString());
        }
    }

    private RecipienteColetaVO pesquisarRecipColeta(ExameRequisicaoRecipienteVO vo) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append(" select rec_codigo, rco_qtde, fil_codigo, exa_codigo, mco_codigo, rco_volume, rco_interface ");
        sql.append(" from recipcoleta ");
        sql.append(" where ");
        sql.append(" fil_codigo = ").append(vo.getFilial().getCodigo());
        sql.append(" and exa_codigo = ").append(ASPA.concat(vo.getExame().getCodigo()).concat(ASPA));
        sql.append(" and mco_codigo = ").append(vo.getMatColeta().getCodigo());
        ResultSet rs = Conexao.getConnection().createStatement().executeQuery(sql.toString());
        RecipienteColetaVO recipienteColeta = new RecipienteColetaVO();
        if (rs.next()) {
            FilialVO filial = new FilialVO();
            filial.setCodigo(rs.getInt("fil_codigo"));
            RecipienteVO recipiente = new RecipienteVO();
            recipiente.setCodigo(rs.getInt("rec_codigo"));
            ExameVO exame = new ExameVO();
            exame.setCodigo(rs.getString("exa_codigo"));
            MaterialColetaVO materialColeta = new MaterialColetaVO();
            materialColeta.setCodigo(rs.getInt("mco_codigo"));
            recipienteColeta.setFilial(filial);
            recipienteColeta.setExame(exame);
            recipienteColeta.setMatColeta(materialColeta);
            recipienteColeta.setQuantidade(rs.getInt("rco_qtde"));
            recipienteColeta.setRco_interface(rs.getBoolean("rco_interface"));
            recipienteColeta.setRecipiente(recipiente);
            recipienteColeta.setVolume(rs.getBigDecimal("rco_volume"));
        }
        return recipienteColeta;
    }
}

