/*
 * Decompiled with CFR 0.152.
 */
package jalis.model.dao.triagem.externo;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.exportacao.integracao.IntegracaoUtil;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.util.DBUtil;
import jalis.util.StringUtil;
import jalis.util.tabela.Registro;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;

public class ImprimirEtiquetasRecoletaDao {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean requisicaoExiste(String codFilial, String codRequisicao) {
        StringBuilder sql = new StringBuilder(" select req_codigo ");
        sql.append(" from requisicao ");
        sql.append(" where fil_codigo = ").append(codFilial);
        sql.append(" and req_codigo = ").append(codRequisicao);
        Boolean existe = false;
        Statement st = Conexao.getStatement();
        try {
            ResultSet rs = st.executeQuery(sql.toString());
            existe = rs.next();
            rs.close();
        }
        catch (SQLException e) {
            try {
                this.anularSQL();
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
        return existe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean requisicaoVinculadaAoLaboratorioExterno(String codFilial, String codRequisicao, String codLabExterno) {
        Boolean requisicaoVinculada = false;
        StringBuilder sql = new StringBuilder();
        sql.append(" select a.exa_codigo, a.req_codigo, a.fil_codigo, b.mco_codigo, e.lae_codigo ");
        sql.append(" from examerequisicao a ");
        sql.append(" left join examematcoleta b on a.fil_codigo = b.fil_codigo and a.exa_codigo = b.exa_codigo and a.mco_codigo = b.mco_codigo ");
        sql.append(" left join examematcoletalabexterno c on b.fil_codigo = c.fil_codigo and b.exa_codigo = c.exa_codigo and b.mco_codigo = c.mco_codigo and c.lae_codigo = ").append(codLabExterno);
        sql.append(" left join loteexternorequisicao e ON a.fil_codigo = e.fil_codigo AND a.req_codigo = e.req_codigo ");
        sql.append(" where ");
        sql.append(" a.fil_codigo = ").append(codFilial).append(" and ");
        Statement st = Conexao.getStatement();
        try {
            boolean agruparMultiguias;
            boolean bl = agruparMultiguias = ParametrosGerais.isAgruparGuiasInterface() || DBUtil.requisicaoAgrupaMultiguiasLabExterno(Conexao.getStatement(), codFilial, codRequisicao);
            if (agruparMultiguias) {
                Object[] guias = RecepcaoUtil.verificaMultiGuias(codFilial, codRequisicao, true);
                String reqs = Arrays.toString(guias);
                reqs = reqs.replace('[', '(').replace(']', ')');
                if (guias != null && guias.length > 0) {
                    Arrays.sort(guias);
                    sql.append("  a.req_codigo in ").append(reqs);
                } else {
                    sql.append("  a.req_codigo = ").append(codRequisicao);
                }
            } else {
                sql.append("  a.req_codigo = ").append(codRequisicao);
            }
            sql.append(" and e.lae_codigo = ").append(codLabExterno);
            sql.append(" and a.exr_excluido = false ");
            sql.append(" and c.ele_xmllabexterno is not null and c.ele_xmllabexterno <> '' ");
            sql.append(" and c.ele_bloqueado = false ");
            sql.append(" and coalesce(c.ele_bloqueado, false) = false ");
            sql.append(" and a.exr_datamaterial is not null ");
            ResultSet rs = st.executeQuery(sql.toString());
            requisicaoVinculada = rs.next();
            rs.close();
        }
        catch (Exception e) {
            try {
                this.anularSQL();
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
        return requisicaoVinculada;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean requisicaoEmRecoleta(String codFilial, String codRequisicao) {
        Boolean possuiExameEmRecoleta = false;
        StringBuilder sql = new StringBuilder(" select r.fil_codigo, r.req_codigo, er.exr_situacao, er.exa_codigo, er.mco_codigo ");
        sql.append(" from requisicao r ");
        sql.append(" left join examerequisicao er on r.fil_codigo = er.fil_codigo and r.req_codigo = er.req_codigo ");
        sql.append(" where r.fil_codigo = ").append(codFilial);
        sql.append(" and r.req_codigo = ").append(codRequisicao);
        sql.append(" and er.exr_situacao = 'R' ");
        sql.append(" and (r.req_excluida is not null and r.req_excluida = false) ");
        Statement st = Conexao.getStatement();
        try {
            ResultSet rs = st.executeQuery(sql.toString());
            possuiExameEmRecoleta = rs.next();
            rs.close();
        }
        catch (Exception e) {
            try {
                this.anularSQL();
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
        return possuiExameEmRecoleta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Registro> buscaDadosRequisicao(String codFilial, String codRequisicao) {
        ArrayList<Registro> retorno = new ArrayList<Registro>();
        StringBuilder sql = new StringBuilder(" SELECT a.fil_codigo, a.req_codigo, b.pac_nome ");
        sql.append(" FROM requisicao a ");
        sql.append(" LEFT JOIN paciente b ON a.fil_codigo = b.fil_codigo AND a.pac_codigo = b.pac_codigo ");
        sql.append(" WHERE a.fil_codigo = ").append(codFilial);
        sql.append(" AND a.req_codigo = ").append(codRequisicao);
        sql.append(" AND a.req_excluida = false ");
        Statement st = Conexao.getStatement();
        try {
            ResultSet rs = st.executeQuery(sql.toString());
            while (rs.next()) {
                retorno.add(new Registro(rs));
            }
        }
        catch (Exception e) {
            try {
                this.anularSQL();
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
        return retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Registro> getExamesRequisicao(String codFilial, String codRequisicao, String codigoLabExterno) {
        ArrayList<Registro> retorno = new ArrayList<Registro>();
        StringBuilder sql = new StringBuilder(" SELECT a.fil_codigo, a.req_codigo, b.exa_codigo, f.pac_nome,");
        sql.append(" b.mco_codigo, b.exr_situacao, c.exa_descricao, d.mco_abreviatura, e.lex_codigo, e.lae_codigo ");
        sql.append(" FROM requisicao a ");
        sql.append(" LEFT JOIN examerequisicao b ON a.fil_codigo = b.fil_codigo AND a.req_codigo = b.req_codigo ");
        sql.append(" LEFT JOIN exames c ON b.fil_codigo = c.fil_codigo AND  b.exa_codigo = c.exa_codigo ");
        sql.append(" LEFT JOIN materialcoleta d ON a.fil_codigo = d.fil_codigo AND b.mco_codigo = d.mco_codigo ");
        sql.append(" LEFT JOIN loteexternorequisicao e ON a.fil_codigo = e.fil_codigo AND a.req_codigo = e.req_codigo");
        sql.append(" LEFT JOIN paciente f ON a.fil_codigo = f.fil_codigo AND a.pac_codigo = f.pac_codigo ");
        sql.append(" WHERE a.fil_codigo = ").append(codFilial);
        sql.append(" AND a.req_codigo = ").append(codRequisicao);
        sql.append(" AND a.req_excluida = false ");
        sql.append(" AND e.lae_codigo = ").append(codigoLabExterno);
        sql.append(" ORDER BY b.exa_codigo");
        Statement st = Conexao.getStatement();
        try {
            ResultSet rs = st.executeQuery(sql.toString());
            while (rs.next()) {
                retorno.add(new Registro(rs));
            }
        }
        catch (Exception e) {
            try {
                this.anularSQL();
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
        return retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNumeroAtendimento(String codFilial, String codRequisicao, String codigoLabExterno, String numLote) {
        String retorno = "";
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT a.leq_codigoreqapoio ");
        sql.append(" FROM loteexternorequisicao a ");
        sql.append(" WHERE a.fil_codigo = ").append(codFilial);
        sql.append(" AND a.req_codigo = ").append(codRequisicao);
        sql.append(" AND a.lae_codigo = ").append(codigoLabExterno);
        sql.append(" AND a.lex_codigo = ").append(numLote);
        Statement st = Conexao.getStatement();
        try {
            ResultSet rs = st.executeQuery(sql.toString());
            while (rs.next()) {
                retorno = rs.getString("leq_codigoreqapoio");
            }
        }
        catch (Exception e) {
            try {
                this.anularSQL();
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
        return retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getEtiquetaRecoleta(String codFilial, String codRequisicao, String codigoLabExterno, String numLote) {
        Statement st;
        String retorno;
        block4: {
            retorno = "";
            StringBuilder sql = new StringBuilder();
            sql.append(" SELECT leq_retornows ");
            sql.append(" FROM loteexternorequisicao ");
            sql.append(" WHERE fil_codigo = ").append(codFilial);
            sql.append(" AND req_codigo = ").append(codRequisicao);
            sql.append(" AND lae_codigo = ").append(codigoLabExterno);
            sql.append(" AND lex_codigo = ").append(numLote);
            st = Conexao.getStatement();
            try {
                ResultSet rs = st.executeQuery(sql.toString());
                if (!rs.next()) break block4;
                retorno = rs.getString("leq_retornows");
            }
            catch (Exception e) {
                try {
                    this.anularSQL();
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
        return retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getExameDB(String codFilial, String codExame, String codigoLabExterno, String matExame) {
        Statement st;
        String retorno;
        block4: {
            retorno = "";
            StringBuilder sql = new StringBuilder();
            sql.append(" SELECT a.ele_xmllabexterno ");
            sql.append(" FROM examematcoletalabexterno a ");
            sql.append(" WHERE a.fil_codigo = ").append(codFilial);
            sql.append(" AND a.exa_codigo = '").append(codExame).append("'");
            sql.append(" AND a.lae_codigo = ").append(codigoLabExterno);
            sql.append(" AND a.mco_codigo = ").append(matExame);
            st = Conexao.getStatement();
            try {
                ResultSet rs = st.executeQuery(sql.toString());
                if (!rs.next()) break block4;
                retorno = rs.getString("ele_xmllabexterno");
            }
            catch (Exception e) {
                try {
                    this.anularSQL();
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
        return retorno;
    }

    private void anularSQL() {
        try {
            Conexao.anulaSQL();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<String> getRastreioLote(String codFilial, String codRequisicao, String codigoLabExterno, String numLote) {
        ArrayList<String> retorno = new ArrayList<String>();
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT a.lrr_sequencialexame, a.lrr_codigostatustexto ");
        sql.append(" FROM loteexternoexamereqrastreio a ");
        sql.append(" WHERE a.fil_codigo = ").append(codFilial);
        sql.append(" AND a.req_codigo = ").append(codRequisicao);
        sql.append(" AND a.lae_codigo = ").append(codigoLabExterno);
        sql.append(" AND a.lex_codigo = ").append(numLote);
        sql.append(" ORDER BY a.exa_codigo");
        Statement st = Conexao.getStatement();
        try {
            ResultSet rs = st.executeQuery(sql.toString());
            while (rs.next()) {
                retorno.add(rs.getString("lrr_sequencialexame"));
                retorno.add(rs.getString("lrr_codigostatustexto"));
            }
        }
        catch (Exception e) {
            try {
                this.anularSQL();
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
        return retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verificaRastreioLote(String codFilial, String codRequisicao, String codigoLabExterno) {
        Statement st;
        block4: {
            boolean bl;
            StringBuilder sql = new StringBuilder();
            sql.append(" SELECT a.lrr_sequencialexame, a.lrr_codigostatustexto ");
            sql.append(" FROM loteexternoexamereqrastreio a ");
            sql.append(" WHERE a.fil_codigo = ").append(codFilial);
            sql.append(" AND a.req_codigo = ").append(codRequisicao);
            sql.append(" AND a.lae_codigo = ").append(codigoLabExterno);
            st = Conexao.getStatement();
            try {
                ResultSet rs = st.executeQuery(sql.toString());
                if (!rs.next()) break block4;
                bl = true;
            }
            catch (Exception e) {
                try {
                    this.anularSQL();
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
            Conexao.fecharStatement(st);
            return bl;
        }
        Conexao.fecharStatement(st);
        return false;
    }

    public void processaRetornoWS(Registro req, String etiquetaDB) throws SQLException {
        ArrayList exames = (ArrayList)req.getValor("listaexames");
        if (req.getString("fil_codigo").equalsIgnoreCase(Variaveis.filialPadrao)) {
            StringBuilder sqlpdate = new StringBuilder();
            sqlpdate.append(" UPDATE loteexternorequisicao SET leq_retornows = coalesce(leq_retornows, ' ') || '<etiquetaReenvio>' || '").append(StringUtil.textoDB(etiquetaDB)).append("' || '</etiquetaReenvio>' ");
            sqlpdate.append(" WHERE fil_codigo = ").append(req.getString("fil_codigo"));
            sqlpdate.append(" AND lae_codigo = ").append(req.getString("lae_codigo"));
            sqlpdate.append(" AND req_codigo = ").append(req.getString("req_codigo"));
            sqlpdate.append(" AND fil_kodigo = ").append(req.getString("fil_codigo"));
            sqlpdate.append(" AND lex_codigo = ").append(req.getInt("lex_codigo"));
            Conexao.getConnection().createStatement().executeUpdate(sqlpdate.toString());
            if (!req.getString("fil_codigo").equals(Variaveis.filialPadrao) || ParametrosGerais.getTipoIntegracao().equals("F") || ParametrosGerais.getTipoIntegracao().equals("W")) {
                IntegracaoUtil.insereComandoLog(Conexao.getStatement(), Variaveis.filialPadrao, Variaveis.filialPadrao, sqlpdate.toString());
            }
        }
    }
}

