/*
 * Decompiled with CFR 0.152.
 */
package jalis.model.dao.triagem.externo;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.resultados.ImpressaoResultados;
import jalis.model.vo.triagem.externo.DialogoFiltroRecoletaVO;
import jalis.util.CheckItemFiltro;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class DialogoFiltroRecoletaDao {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Registro> pesquisarRequisicoesEmRecoleta(DialogoFiltroRecoletaVO vo) {
        ArrayList<Registro> retorno = new ArrayList<Registro>();
        String dataInicial = Funcoes.formataData("yyyy-MM-dd ", vo.getDataInicial());
        String dataFinal = Funcoes.formataData("yyyy-MM-dd ", vo.getDataFinal());
        String horaInicial = Funcoes.textoVazio(vo.getHoraInicial()) ? "00:00" : vo.getHoraInicial();
        String horaFinal = Funcoes.textoVazio(vo.getHoraFinal()) ? "23:59" : vo.getHoraInicial();
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT distinct ");
        sql.append(" a.fil_codigo, a.req_codigo, a.req_data, a.req_hora, a.req_dum, a.req_obs, a.req_dclinicos, ");
        sql.append(" a.req_peso, a.req_altura, a.req_anomes, a.req_idade, con.con_codigo, con.con_razao, ");
        sql.append(" b.pac_codigo, b.pac_nome, b.pac_sexo, b.pac_datanasc, ");
        sql.append(" false as selecionado, a.req_deveguia, a.req_totpago, a.req_total, ");
        sql.append(" a.med_conselho, a.med_crm, a.med_uf, f.med_nome, ");
        sql.append(" coalesce(m.req_codigo, a.req_codigo) as req_codigomae ");
        sql.append(" FROM requisicao a ");
        sql.append(" LEFT JOIN paciente b ON a.fil_codigo = b.fil_codigo AND a.pac_codigo = b.pac_codigo ");
        sql.append(" LEFT JOIN examerequisicao c ON a.fil_codigo = c.fil_codigo AND a.req_codigo = c.req_codigo ");
        sql.append(" LEFT JOIN requisicaorequisicao m ON a.fil_codigo = m.fil_codigo AND a.req_codigo = m.req_kodigo ");
        sql.append(" LEFT JOIN examematcoletalabexterno e  ON c.fil_codigo = e.fil_codigo AND c.exa_codigo = e.exa_codigo and c.mco_codigo = e.mco_codigo AND e.lae_codigo = ").append(vo.getCodigoLabExterno());
        sql.append(" LEFT JOIN medico f  on a.fil_codigo = f.fil_codigo AND a.med_conselho = f.med_conselho AND a.med_crm = f.med_crm AND a.med_uf = f.med_uf ");
        sql.append(" LEFT JOIN convenios con on a.fil_codigo = con.fil_codigo AND a.con_codigo = con.con_codigo ");
        sql.append(" LEFT JOIN loteexternorequisicao lot on a.fil_codigo = lot.fil_codigo and e.lae_codigo = lot.lae_codigo and a.req_codigo = lot.req_codigo ");
        sql.append(" LEFT JOIN loteexterno l on lot.fil_codigo = l.fil_codigo and lot.lex_codigo = l.lex_codigo and l.lae_codigo = lot.lae_codigo ");
        sql.append(" WHERE e.ele_bloqueado = false ");
        if (vo.getItemFilial().isSelected() && !Variaveis.integrarDadosEntreFiliais) {
            this.addExpressao(sql, "a.fil_codigo", vo.getItemFilial(), false);
        } else {
            sql.append(" AND a.fil_codigo = ").append(Variaveis.filialPadrao).append(" ");
        }
        if (vo.getItemColeta().isSelected()) {
            this.addExpressao(sql, "a.col_codigo", vo.getItemColeta(), true);
        }
        if (vo.getItemDestino().isSelected()) {
            this.addExpressao(sql, "a.des_codigo", vo.getItemDestino(), true);
        }
        if (vo.getItemConvenio().isSelected()) {
            this.addExpressao(sql, "a.con_codigo", vo.getItemConvenio(), false);
        }
        if (vo.getItemExame().isSelected()) {
            this.addExpressao(sql, "c.exa_codigo", vo.getItemExame(), true);
        }
        if (vo.getTipoDataSelecionado().equalsIgnoreCase("Recoleta")) {
            sql.append(" AND c.exr_datarecoleta between '").append(dataInicial).append(horaInicial).append("'");
            sql.append(" AND '").append(dataFinal).append(horaFinal).append("'");
        } else {
            sql.append(" AND (a.req_data + a.req_hora) >= '").append(dataInicial).append(horaInicial).append("'");
            sql.append(" AND (a.req_data + a.req_hora) <= '").append(dataFinal).append(horaFinal).append("'");
        }
        sql.append(" AND l.lex_dataestorno is null AND l.usr_codestorno is null ");
        sql.append(" AND lot.leq_dataestorno is null AND lot.usr_codestorno is null ");
        sql.append(" AND c.exr_situacao = '").append("R").append("'");
        sql.append(" AND e.lae_codigo = ").append(vo.getCodigoLabExterno());
        sql.append(" AND a.req_excluida = false AND c.exr_excluido = false ");
        sql.append(" ORDER BY a.req_codigo");
        Statement st = Conexao.getStatement();
        try {
            ResultSet rs = st.executeQuery(sql.toString());
            while (rs.next()) {
                retorno.add(new Registro(rs));
            }
        }
        catch (Exception e) {
            try {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
                this.anularSQL();
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
        return retorno;
    }

    private void addExpressao(StringBuilder bui, String campo, CheckItemFiltro itemFiltro, boolean aspas) {
        if (itemFiltro.getSelecionados(0) != null && itemFiltro.getSelecionados(0).length > 0) {
            bui.append("and \n  ");
            bui.append(ImpressaoResultados.getExpressao(campo, itemFiltro.getSelecionados(0), aspas));
            bui.append(" ");
        }
    }

    private void anularSQL() {
        try {
            Conexao.anulaSQL();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

