/*
 * Decompiled with CFR 0.152.
 */
package jalis.model.dao.triagem;

import jalis.comum.Variaveis;
import jalis.laboratorio.triagem.externo.LaboratorioExterno;
import jalis.laboratorio.triagem.externo.exportadores.UtilExportadores;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.laboratorio.util.parsers.alvaro.ExameAlvaro;
import jalis.model.AbstractThreadBean;
import jalis.model.AbstractThreadDao;
import jalis.model.ThreadBeanDaoMultiplasChaves;
import jalis.model.bean.triagem.LoteExternoExameRequisicaoBean;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.triagem.LoteExternoExameRequisicaoVO;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.tabela.Registro;
import jalis.util.xml.XMLUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class LoteExternoExameRequisicaoDao
extends AbstractThreadDao
implements ThreadBeanDaoMultiplasChaves {
    @Override
    public AbstractThreadBean getBean(Map<String, Object> chaves) throws ThreadDaoException {
        ArrayList<String> wheres = new ArrayList<String>();
        for (String chave : chaves.keySet()) {
            wheres.add(chave + "=" + this.getValorParaBanco(chaves.get(chave)));
        }
        String where = " where " + StringUtil.implode(wheres, " and ");
        Set aux = LoteExternoExameRequisicaoDao.load(LoteExternoExameRequisicaoBean.class, where);
        if (aux == null || aux.size() == 0 || aux.size() > 1) {
            return null;
        }
        return (LoteExternoExameRequisicaoBean)aux.toArray()[0];
    }

    @Override
    public AbstractThreadVO getVO(Map<String, Object> chaves) throws ThreadDaoException {
        ArrayList<String> wheres = new ArrayList<String>();
        for (String chave : chaves.keySet()) {
            wheres.add(chave + "=" + this.getValorParaBanco(chaves.get(chave)));
        }
        String where = " where " + StringUtil.implode(wheres, " and ");
        Set aux = this.loadVO(LoteExternoExameRequisicaoVO.class, where);
        if (aux == null || aux.size() == 0 || aux.size() > 1) {
            return null;
        }
        return (LoteExternoExameRequisicaoVO)aux.toArray()[0];
    }

    @Override
    public AbstractThreadBean getBean(String codigo) throws ThreadDaoException {
        return null;
    }

    @Override
    public AbstractThreadVO getVO(String codigo) throws ThreadDaoException {
        return null;
    }

    private String obterAtributoTagInformacao(String xml, String atributo) throws Exception {
        ByteArrayInputStream is = new ByteArrayInputStream(StringUtil.removerAcentos(xml.toString()).getBytes());
        InputStreamReader reader = new InputStreamReader((InputStream)is, "UTF-8");
        InputSource io = new InputSource(reader);
        io.setEncoding("UTF-8");
        DocumentBuilder dbf = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = dbf.parse(io);
        Element raiz = doc.getDocumentElement();
        return raiz.getAttribute(atributo);
    }

    public List<Registro> requisicaoEnviadaParaAlvaro(String requisicaoParam, String filialParam, boolean organizaEtiqueta, Statement st, Statement st2, boolean agruparGuiasInterface) throws Exception {
        ArrayList<Registro> listaRegistro = new ArrayList<Registro>();
        LaboratorioExterno labExterno = UtilExportadores.localizaLabExterno(Variaveis.filialPadrao, st);
        Registro retorno = null;
        if (labExterno != null) {
            Integer[] req = new Integer[]{Integer.valueOf(requisicaoParam)};
            Integer[] multiguias = agruparGuiasInterface ? RecepcaoUtil.verificaMultiGuias(st, filialParam, requisicaoParam, true, false) : req;
            StringBuilder sql = new StringBuilder();
            sql.append("select * from loteexternorequisicao lot ");
            sql.append(" join loteexternoexamerequisicao lotex on lot.fil_kodigo = lotex.fil_kodigo and lot.req_codigo = lotex.req_codigo and lot.lex_codigo = lotex.lex_codigo ");
            sql.append(" where lot.fil_codigo = ").append(filialParam);
            sql.append(" and lot.req_codigo in( ").append(StringUtil.implode(Arrays.asList(multiguias), ",")).append(")");
            sql.append(" and lot.fil_kodigo=").append(filialParam);
            sql.append(" and lot.lae_codigo = ").append(labExterno.codigoLab);
            sql.append(" and leq_dataestorno is null ");
            sql.append(" and leq_retornows is not null ");
            sql.append(" and lot.usr_codestorno is null order by lot.lex_codigo desc ");
            ResultSet rs = st2.executeQuery(sql.toString());
            if (rs.next()) {
                do {
                    ArrayList<Registro> listAmostras = new ArrayList<Registro>();
                    HashSet<String> chavesControle = new HashSet<String>();
                    HashSet<String[]> controleExamesNaoALvaro = new HashSet<String[]>();
                    HashSet<String> exameControle = new HashSet<String>();
                    HashSet<ExameAlvaro> examesRequisicaoAlvaroAmostra = new HashSet<ExameAlvaro>();
                    retorno = new Registro();
                    String leq_retornows = rs.getString("leq_retornows");
                    if (leq_retornows != null && !leq_retornows.contains("<solicitacoes>") && !leq_retornows.contains("</solicitacoes>")) {
                        leq_retornows = "<solicitacoes>" + rs.getString("leq_retornows") + "</solicitacoes>";
                    }
                    if (Funcoes.textoVazio(leq_retornows)) continue;
                    List<String> solicitacoes = StringUtil.getListValoresTagAberta(leq_retornows.toString(), "solicitacao", false);
                    Collections.reverse(solicitacoes);
                    for (String solicitacao : solicitacoes) {
                        ArrayList<Registro> examesRequisicaoJalisLabExterno = this.pegaExamesRequisicao(rs.getString("lae_codigo"), rs.getString("req_codigo"), rs.getString("fil_kodigo"), rs.getString("lex_codigo"), st);
                        String idLis = this.obterAtributoTagInformacao(solicitacao, "idLis");
                        List<String> amostras = StringUtil.getListValoresTagAberta(solicitacao, "amostra", false);
                        if (Funcoes.textoVazio(idLis)) {
                            idLis = this.obterAtributoTagInformacao(amostras.get(0), "identificacao");
                        }
                        Collections.reverse(amostras);
                        for (String amostra : amostras) {
                            Registro registroAmostra = new Registro();
                            String chave = "";
                            registroAmostra.setValor("descricao", this.obterAtributoTagInformacao(amostra, "descricao"));
                            registroAmostra.setValor("identificacao", this.obterAtributoTagInformacao(amostra, "identificacao"));
                            registroAmostra.setValor("material", this.obterAtributoTagInformacao(amostra, "material"));
                            chave = this.obterAtributoTagInformacao(amostra, "identificacao") + this.obterAtributoTagInformacao(amostra, "material") + this.obterAtributoTagInformacao(amostra, "lote");
                            HashSet<String> exame = new HashSet<String>();
                            String novoLayout = StringUtil.escreveCabecalho(amostra);
                            Document doc = XMLUtil.analisarXML(new ByteArrayInputStream(novoLayout.toString().getBytes()));
                            Element raiz = doc.getDocumentElement();
                            List<Element> exames = XMLUtil.getElementosFilhos(raiz);
                            if (exames != null && !exames.isEmpty()) {
                                for (Element exa : exames) {
                                    NodeList nodeList = exa.getElementsByTagName("exame");
                                    int qtd = nodeList.getLength();
                                    if (qtd > 0) {
                                        for (int i = qtd; i > 0; --i) {
                                            Node node = nodeList.item(i - 1);
                                            if (null != node && !Funcoes.textoVazio(node.getTextContent())) {
                                                exame.add(node.getTextContent());
                                                continue;
                                            }
                                            NamedNodeMap nameNoed = node.getAttributes();
                                            if (null == (node = nameNoed.item(i - 1)) || Funcoes.textoVazio(node.getTextContent())) continue;
                                            exame.add(node.getTextContent());
                                        }
                                        continue;
                                    }
                                    if (!amostra.contains("<exame")) continue;
                                    List<String> list = StringUtil.getListValoresTagAberta(amostra, "exame", false);
                                    Document docEx = XMLUtil.analisarXML(new ByteArrayInputStream(amostra.toString().getBytes()));
                                    Element raizEx = doc.getDocumentElement();
                                    List<Element> examesEx = XMLUtil.getElementosFilhos(raiz);
                                    for (Element exameEx : exames) {
                                        if (Funcoes.textoVazio(exameEx.getAttribute("exame"))) continue;
                                        exame.add(exameEx.getAttribute("exame"));
                                    }
                                }
                            }
                            registroAmostra.setValor("exame", exame);
                            ArrayList<ExameAlvaro> examesRequisicaoAlvaroAmostraTemp = new ArrayList<ExameAlvaro>();
                            for (Registro registro : examesRequisicaoJalisLabExterno) {
                                ExameAlvaro alv = new ExameAlvaro(registro.getString("ele_xmllabexterno"));
                                alv.setExameJalis(registro.getString("exa_codigo"));
                                alv.setXmlJalis(registro.getString("ele_xmllabexterno"));
                                alv.setMaterialJalis(registro.getString("mco_codigo"));
                                alv.setRequisicao(registro.getString("req_codigo"));
                                examesRequisicaoAlvaroAmostraTemp.add(alv);
                            }
                            for (ExameAlvaro exameAlvaro : examesRequisicaoAlvaroAmostraTemp) {
                                for (String e : exame) {
                                    if (!e.equals(exameAlvaro.getCodigo())) continue;
                                    examesRequisicaoAlvaroAmostra.add(exameAlvaro);
                                    examesRequisicaoJalisLabExterno.remove(e);
                                }
                            }
                            registroAmostra.setValor("examesRequisicaoAlvaro", examesRequisicaoAlvaroAmostra);
                            registroAmostra.setValor("layout", StringUtil.getValor(amostra, "layout").replaceAll("&#xD;", "\r\n").trim() + '\n');
                            if (chavesControle.contains(chave)) continue;
                            listAmostras.add(registroAmostra);
                            chavesControle.add(chave);
                            for (String exa : exame) {
                                if (exameControle.contains(exa)) continue;
                                exameControle.add(exa);
                            }
                        }
                        controleExamesNaoALvaro.add(this.pegaExamesRequisicaoNaoAlvaro(rs.getString("req_codigo"), rs.getString("fil_kodigo"), examesRequisicaoJalisLabExterno, st));
                        retorno.setValor("examesNaoAlvaro", controleExamesNaoALvaro);
                        retorno.setValor("amostras", listAmostras);
                        retorno.setValor("baseBarras", this.obterAtributoTagInformacao(solicitacao, "baseBarras"));
                        retorno.setValor("idAlvaro", this.obterAtributoTagInformacao(solicitacao, "idAlvaro"));
                        retorno.setValor("lae_codigo", rs.getInt("lae_codigo"));
                        retorno.setValor("lex_codigo", rs.getInt("lex_codigo"));
                        retorno.setValor("fil_kodigo", rs.getInt("fil_kodigo"));
                        retorno.setValor("fil_codigo", rs.getInt("fil_codigo"));
                        retorno.setValor("req_codigo", rs.getInt("req_codigo"));
                        retorno.setValor("exa_codigo", rs.getString("exa_codigo"));
                        retorno.setValor("mco_codigo", rs.getInt("mco_codigo"));
                        listaRegistro.add(retorno);
                    }
                } while (rs.next());
            }
        }
        return listaRegistro;
    }

    public List<Registro> requisicaoEnviadaParaJalisWS(String requisicaoParam, String filialParam, boolean organizaEtiqueta, Statement st, Statement st2) throws Exception {
        ArrayList<Registro> listaRegistro = new ArrayList<Registro>();
        LaboratorioExterno labExterno = UtilExportadores.localizaLabExternoJalisWS(Variaveis.filialPadrao, st);
        Registro retorno = null;
        if (labExterno != null) {
            Integer[] multiguias = RecepcaoUtil.verificaMultiGuias(st, filialParam, requisicaoParam, true, false);
            StringBuilder sql = new StringBuilder();
            sql.append("select * from loteexternorequisicao lot ");
            sql.append(" join loteexternoexamerequisicao lotex on lot.fil_kodigo = lotex.fil_kodigo and lot.req_codigo = lotex.req_codigo and lot.lex_codigo = lotex.lex_codigo ");
            sql.append(" where lot.fil_codigo = ").append(filialParam);
            sql.append(" and lot.req_codigo in( ").append(StringUtil.implode(Arrays.asList(multiguias), ",")).append(")");
            sql.append(" and lot.fil_kodigo=").append(filialParam);
            sql.append(" and lot.lae_codigo = ").append(labExterno.codigoLab);
            sql.append(" and leq_dataestorno is null ");
            sql.append(" and leq_retornows is not null ");
            sql.append(" and lot.usr_codestorno is null order by lot.lex_codigo desc ");
            ResultSet rs = st.executeQuery(sql.toString());
            if (rs.next()) {
                do {
                    ArrayList<Registro> listAmostras = new ArrayList<Registro>();
                    HashSet<String> chavesControle = new HashSet<String>();
                    HashSet controleExamesNaoALvaro = new HashSet();
                    HashSet<String> exameControle = new HashSet<String>();
                    HashSet<ExameAlvaro> examesRequisicaoAlvaroAmostra = new HashSet<ExameAlvaro>();
                    retorno = new Registro();
                    String leq_retornows = rs.getString("leq_retornows");
                    if (leq_retornows != null && !leq_retornows.contains("<solicitacoes>") && !leq_retornows.contains("</solicitacoes>")) {
                        leq_retornows = "<solicitacoes>" + rs.getString("leq_retornows") + "</solicitacoes>";
                    }
                    if (Funcoes.textoVazio(leq_retornows)) continue;
                    List<String> solicitacoes = StringUtil.getListValoresTagAberta(leq_retornows.toString(), "solicitacao", false);
                    Collections.reverse(solicitacoes);
                    for (String solicitacao : solicitacoes) {
                        ArrayList<Registro> examesRequisicaoJalisLabExterno = this.pegaExamesRequisicao(rs.getString("lae_codigo"), rs.getString("req_codigo"), rs.getString("fil_kodigo"), rs.getString("lex_codigo"), st2);
                        String idLis = this.obterAtributoTagInformacao(solicitacao, "idLis");
                        List<String> amostras = StringUtil.getListValoresTagAberta(solicitacao, "solicitacao", false);
                        if (Funcoes.textoVazio(idLis)) {
                            idLis = this.obterAtributoTagInformacao(amostras.get(0), "identificacao");
                        }
                        Collections.reverse(amostras);
                        for (String amostra : amostras) {
                            Registro registroAmostra = new Registro();
                            String chave = "";
                            registroAmostra.setValor("descricao", this.obterAtributoTagInformacao(amostra, "descricao"));
                            registroAmostra.setValor("identificacao", this.obterAtributoTagInformacao(amostra, "identificacao"));
                            registroAmostra.setValor("material", this.obterAtributoTagInformacao(amostra, "material"));
                            chave = this.obterAtributoTagInformacao(amostra, "identificacao") + this.obterAtributoTagInformacao(amostra, "material") + this.obterAtributoTagInformacao(amostra, "lote");
                            HashSet<String> exame = new HashSet<String>();
                            String novoLayout = StringUtil.escreveCabecalho(amostra);
                            Document doc = XMLUtil.analisarXML(new ByteArrayInputStream(novoLayout.toString().getBytes()));
                            Element raiz = doc.getDocumentElement();
                            List<Element> exames = XMLUtil.getElementosFilhos(raiz);
                            if (exames != null && !exames.isEmpty()) {
                                for (Element exa : exames) {
                                    NodeList nodeList = exa.getElementsByTagName("exame");
                                    int qtd = nodeList.getLength();
                                    if (qtd > 0) {
                                        for (int i = qtd; i > 0; --i) {
                                            Node node = nodeList.item(i - 1);
                                            if (null != node && !Funcoes.textoVazio(node.getTextContent())) {
                                                exame.add(node.getTextContent());
                                                continue;
                                            }
                                            NamedNodeMap nameNoed = node.getAttributes();
                                            if (null == (node = nameNoed.item(i - 1)) || Funcoes.textoVazio(node.getTextContent())) continue;
                                            exame.add(node.getTextContent());
                                        }
                                        continue;
                                    }
                                    if (!amostra.contains("<exame")) continue;
                                    List<String> list = StringUtil.getListValoresTagAberta(amostra, "exame", false);
                                    Document docEx = XMLUtil.analisarXML(new ByteArrayInputStream(amostra.toString().getBytes()));
                                    Element raizEx = doc.getDocumentElement();
                                    List<Element> examesEx = XMLUtil.getElementosFilhos(raiz);
                                    for (Element exameEx : exames) {
                                        if (Funcoes.textoVazio(exameEx.getAttribute("exame"))) continue;
                                        exame.add(exameEx.getAttribute("exame"));
                                    }
                                }
                            }
                            registroAmostra.setValor("exame", exame);
                            ArrayList<ExameAlvaro> examesRequisicaoAlvaroAmostraTemp = new ArrayList<ExameAlvaro>();
                            for (Registro registro : examesRequisicaoJalisLabExterno) {
                                ExameAlvaro alv = new ExameAlvaro(registro.getString("ele_xmllabexterno"));
                                alv.setExameJalis(registro.getString("exa_codigo"));
                                alv.setXmlJalis(registro.getString("ele_xmllabexterno"));
                                alv.setMaterialJalis(registro.getString("mco_codigo"));
                                alv.setRequisicao(registro.getString("req_codigo"));
                                examesRequisicaoAlvaroAmostraTemp.add(alv);
                            }
                            for (ExameAlvaro exameAlvaro : examesRequisicaoAlvaroAmostraTemp) {
                                for (String e : exame) {
                                    if (!e.equals(exameAlvaro.getCodigo())) continue;
                                    examesRequisicaoAlvaroAmostra.add(exameAlvaro);
                                    examesRequisicaoJalisLabExterno.remove(e);
                                }
                            }
                            registroAmostra.setValor("examesRequisicaoAlvaro", examesRequisicaoAlvaroAmostra);
                            registroAmostra.setValor("layout", StringUtil.getValor(solicitacao, "layout").replaceAll("&#xD;", "\r\n").trim() + '\n');
                            if (chavesControle.contains(chave)) continue;
                            listAmostras.add(registroAmostra);
                            chavesControle.add(chave);
                            for (String exa : exame) {
                                if (exameControle.contains(exa)) continue;
                                exameControle.add(exa);
                            }
                        }
                        retorno.setValor("amostras", listAmostras);
                        retorno.setValor("idLis", this.obterAtributoTagInformacao(solicitacao, "idLis"));
                        retorno.setValor("lae_codigo", rs.getInt("lae_codigo"));
                        retorno.setValor("lex_codigo", rs.getInt("lex_codigo"));
                        retorno.setValor("fil_kodigo", rs.getInt("fil_kodigo"));
                        retorno.setValor("fil_codigo", rs.getInt("fil_codigo"));
                        retorno.setValor("req_codigo", rs.getInt("req_codigo"));
                        retorno.setValor("exa_codigo", rs.getString("exa_codigo"));
                        retorno.setValor("mco_codigo", rs.getInt("mco_codigo"));
                        listaRegistro.add(retorno);
                    }
                } while (rs.next());
            }
        }
        return listaRegistro;
    }

    public ArrayList<Registro> pegaExamesRequisicao(String laboratorioExterno, String requisicao, String filialDaRequisicao, String lote, Statement st) throws Exception {
        ArrayList<Registro> retorno = new ArrayList<Registro>();
        Integer[] multiguias = RecepcaoUtil.verificaMultiGuias(st, filialDaRequisicao, requisicao, true, false);
        StringBuilder buf = new StringBuilder("select a.fil_codigo, a.lex_codigo, a.req_codigo, a.lae_codigo ,a.fil_kodigo, a.exa_codigo, a.mco_codigo, b.mco_abreviatura, c.exa_descricao ");
        buf.append(", e.exr_descricaomaterial, e.exr_datamaterial, e.exr_volumediurese, e.exr_tempodiurese, f.ele_xmllabexterno ");
        buf.append(" from loteexternoexamerequisicao a ");
        buf.append(" inner join loteexternorequisicao lex on a.fil_codigo = a.fil_codigo and lex.req_codigo = a.req_codigo and lex.lae_codigo = a.lae_codigo and lex.lex_codigo = a.lex_codigo ");
        buf.append(" left join examematcoleta d on a.fil_codigo = d.fil_codigo and a.exa_codigo = d.exa_codigo and a.mco_codigo = d.mco_codigo ");
        buf.append(" left join exames c on a.fil_codigo = c.fil_codigo and a.exa_codigo = c.exa_codigo ");
        buf.append(" left join materialcoleta b on a.fil_codigo = b.fil_codigo and a.mco_codigo = b.mco_codigo ");
        buf.append(" left join examerequisicao e on a.fil_codigo = e.fil_codigo and a.req_codigo = e.req_codigo and a.exa_codigo = e.exa_codigo and a.mco_codigo = e.mco_codigo ");
        buf.append(" left join examematcoletalabexterno f on d.fil_codigo = f.fil_codigo and d.exa_codigo = f.exa_codigo and d.mco_codigo = f.mco_codigo and d.lae_codigo = f.lae_codigo ");
        buf.append(" where a.fil_codigo = ").append(Variaveis.filialPadrao);
        buf.append(" and a.fil_kodigo = ").append(filialDaRequisicao);
        buf.append(" and lex.leq_dataestorno is null and a.usr_codestorno  is null ");
        buf.append(" and a.req_codigo in( ").append(StringUtil.implode(Arrays.asList(multiguias), ",")).append(") ");
        buf.append(" and a.lex_codigo = ").append(lote);
        buf.append(" and a.lae_codigo = ").append(laboratorioExterno);
        ResultSet rs = st.executeQuery(buf.toString());
        while (rs.next()) {
            retorno.add(new Registro(rs));
        }
        return retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Registro> pegaExamesEstornados(String laboratorioExterno, String requisicao, String filialDaRequisicao, String lote, ExameAlvaro exame, Statement st) throws Exception {
        ArrayList<Registro> retorno = new ArrayList<Registro>();
        Integer[] multiguias = RecepcaoUtil.verificaMultiGuias(st, filialDaRequisicao, requisicao, true, false);
        try (ResultSet rs = null;){
            StringBuilder buf = new StringBuilder("select a.fil_codigo, a.lex_codigo, a.req_codigo, a.lae_codigo ,a.fil_kodigo, a.exa_codigo, a.mco_codigo, b.mco_abreviatura, c.exa_descricao ");
            buf.append(", e.exr_descricaomaterial, e.exr_datamaterial, e.exr_volumediurese, e.exr_tempodiurese, f.ele_xmllabexterno ");
            buf.append(" from loteexternoexamerequisicao a ");
            buf.append(" inner join loteexternorequisicao lex on a.fil_codigo = a.fil_codigo and lex.req_codigo = a.req_codigo and lex.lae_codigo = a.lae_codigo and lex.lex_codigo = a.lex_codigo ");
            buf.append(" left join examematcoleta d on a.fil_codigo = d.fil_codigo and a.exa_codigo = d.exa_codigo and a.mco_codigo = d.mco_codigo ");
            buf.append(" left join exames c on a.fil_codigo = c.fil_codigo and a.exa_codigo = c.exa_codigo ");
            buf.append(" left join materialcoleta b on a.fil_codigo = b.fil_codigo and a.mco_codigo = b.mco_codigo ");
            buf.append(" left join examerequisicao e on a.fil_codigo = e.fil_codigo and a.req_codigo = e.req_codigo and a.exa_codigo = e.exa_codigo and a.mco_codigo = e.mco_codigo ");
            buf.append(" left join examematcoletalabexterno f on d.fil_codigo = f.fil_codigo and d.exa_codigo = f.exa_codigo and d.mco_codigo = f.mco_codigo and d.lae_codigo = f.lae_codigo ");
            buf.append(" where a.fil_codigo = ").append(Variaveis.filialPadrao);
            buf.append(" and a.fil_kodigo = ").append(filialDaRequisicao);
            buf.append(" and a.req_codigo in( ").append(StringUtil.implode(Arrays.asList(multiguias), ",")).append(") ");
            buf.append(" and a.lex_codigo = ").append(lote);
            buf.append(" and a.lae_codigo = ").append(laboratorioExterno);
            buf.append(" and a.exa_codigo = '").append(exame.getExameJalis()).append("' ");
            rs = st.executeQuery(buf.toString());
            if (rs.next()) {
                Registro registro = new Registro();
                registro.setValor("fil_codigo", filialDaRequisicao);
                registro.setValor("req_codigo", requisicao);
                String leqRetornows = UtilExportadores.retornoWs(registro, laboratorioExterno, lote, st);
                if (!Funcoes.textoVazio(leqRetornows)) {
                    if (leqRetornows != null && !leqRetornows.contains("<solicitacoes>") && !leqRetornows.contains("</solicitacoes>")) {
                        leqRetornows = "<solicitacoes>" + leqRetornows + "</solicitacoes>";
                    }
                    HashSet<String> exameList = new HashSet<String>();
                    if (leqRetornows.contains("exclusoes")) {
                        List<String> solicitacoes = StringUtil.getListValoresTagAberta(leqRetornows.toString(), "exclusoes", false);
                        Collections.reverse(solicitacoes);
                        for (String solicitacao : solicitacoes) {
                            List<String> exclusoes = StringUtil.getListValoresTagAberta(solicitacao, "deletado", false);
                            for (String excluido : exclusoes) {
                                Document doc = XMLUtil.analisarXML(new ByteArrayInputStream(excluido.toString().getBytes()));
                                Element raiz = doc.getDocumentElement();
                                List<Element> exames = XMLUtil.getElementosFilhos(raiz);
                                if (exames == null || exames.isEmpty()) continue;
                                for (Element exa : exames) {
                                    String codigoExame = exa.getAttribute("codigoExame");
                                    String excluidoExame = exa.getAttribute("excluido");
                                    if (!Boolean.valueOf(excluidoExame).booleanValue()) continue;
                                    exameList.add(codigoExame);
                                }
                            }
                        }
                    }
                    do {
                        for (String exameExcluido : exameList) {
                            if (!exameExcluido.equalsIgnoreCase(exame.getCodigo())) continue;
                            buf = new StringBuilder("select a.fil_codigo, a.lex_codigo, a.req_codigo, a.lae_codigo ,a.fil_kodigo, a.exa_codigo, a.mco_codigo, b.mco_abreviatura, c.exa_descricao ");
                            buf.append(", e.exr_descricaomaterial, e.exr_datamaterial, e.exr_volumediurese, e.exr_tempodiurese, f.ele_xmllabexterno ");
                            buf.append(" from loteexternoexamerequisicao a ");
                            buf.append(" inner join loteexternorequisicao lex on a.fil_codigo = a.fil_codigo and lex.req_codigo = a.req_codigo and lex.lae_codigo = a.lae_codigo and lex.lex_codigo = a.lex_codigo ");
                            buf.append(" left join examematcoleta d on a.fil_codigo = d.fil_codigo and a.exa_codigo = d.exa_codigo and a.mco_codigo = d.mco_codigo ");
                            buf.append(" left join exames c on a.fil_codigo = c.fil_codigo and a.exa_codigo = c.exa_codigo ");
                            buf.append(" left join materialcoleta b on a.fil_codigo = b.fil_codigo and a.mco_codigo = b.mco_codigo ");
                            buf.append(" left join examerequisicao e on a.fil_codigo = e.fil_codigo and a.req_codigo = e.req_codigo and a.exa_codigo = e.exa_codigo and a.mco_codigo = e.mco_codigo ");
                            buf.append(" left join examematcoletalabexterno f on d.fil_codigo = f.fil_codigo and d.exa_codigo = f.exa_codigo and d.mco_codigo = f.mco_codigo and d.lae_codigo = f.lae_codigo ");
                            buf.append(" where a.fil_codigo = ").append(Variaveis.filialPadrao);
                            buf.append(" and a.fil_kodigo = ").append(filialDaRequisicao);
                            buf.append(" and a.req_codigo in( ").append(StringUtil.implode(Arrays.asList(multiguias), ",")).append(") ");
                            buf.append(" and a.lex_codigo = ").append(lote);
                            buf.append(" and a.lae_codigo = ").append(laboratorioExterno);
                            buf.append(" and a.exa_codigo = '").append(exame.getExameJalis()).append("' ");
                            ResultSet rs2 = st.executeQuery(buf.toString());
                            if (rs2.next()) continue;
                            retorno.add(new Registro(rs2));
                        }
                    } while (rs.next());
                }
            } else {
                buf = new StringBuilder("select * ");
                buf.append(" from examerequisicao a ");
                buf.append(" left join examematcoleta d on a.fil_codigo = d.fil_codigo and a.exa_codigo = d.exa_codigo and a.mco_codigo = d.mco_codigo ");
                buf.append(" left join exames c on a.fil_codigo = c.fil_codigo and a.exa_codigo = c.exa_codigo ");
                buf.append(" left join materialcoleta b on a.fil_codigo = b.fil_codigo and a.mco_codigo = b.mco_codigo ");
                buf.append(" left join examerequisicao e on a.fil_codigo = e.fil_codigo and a.req_codigo = e.req_codigo and a.exa_codigo = e.exa_codigo and a.mco_codigo = e.mco_codigo ");
                buf.append(" left join examematcoletalabexterno f on d.fil_codigo = f.fil_codigo and d.exa_codigo = f.exa_codigo and d.mco_codigo = f.mco_codigo ");
                buf.append(" where a.fil_codigo = ").append(Variaveis.filialPadrao);
                buf.append(" and a.req_codigo in( ").append(StringUtil.implode(Arrays.asList(multiguias), ",")).append(") ");
                buf.append(" and a.exa_codigo = '").append(exame).append("' ");
                buf.append(" and a.exr_excluido and a.usr_codexcluido is not null ");
                rs.close();
                rs = st.executeQuery(buf.toString());
                if (rs.next()) {
                    do {
                        retorno.add(new Registro(rs));
                    } while (rs.next());
                }
            }
        }
        return retorno;
    }

    public String[] pegaExamesRequisicaoNaoAlvaro(String requisicao, String filialDaRequisicao, List<Registro> examesRequisicaoJalisLabExterno, Statement st) throws Exception {
        String[] retorno = null;
        Integer[] multiguias = RecepcaoUtil.verificaMultiGuias(st, filialDaRequisicao, requisicao, true, false);
        if (!examesRequisicaoJalisLabExterno.isEmpty()) {
            ArrayList<String> retornoAux = new ArrayList<String>();
            ArrayList<String> exames = new ArrayList<String>();
            for (Registro registro : examesRequisicaoJalisLabExterno) {
                exames.add("'" + registro.getString("exa_codigo") + "'");
            }
            StringBuilder buf = new StringBuilder("select exa_codigo ");
            buf.append(" from examerequisicao a ");
            buf.append(" where a.fil_codigo = ").append(filialDaRequisicao);
            buf.append(" and a.req_codigo in( ").append(StringUtil.implode(Arrays.asList(multiguias), ",")).append(") ");
            buf.append(" and a.exa_codigo not in(").append(StringUtil.implode(exames, ",")).append(");");
            ResultSet rs = st.executeQuery(buf.toString());
            while (rs.next()) {
                retornoAux.add(rs.getString("exa_codigo"));
            }
            if (!retornoAux.isEmpty()) {
                retorno = new String[retornoAux.size()];
                for (int i = 0; i < retornoAux.size(); ++i) {
                    retorno[i] = (String)retornoAux.get(i);
                }
            }
        }
        return retorno;
    }

    public boolean retornaQuantidadeExameLabExterno(String filialPadrao, String requisicao, String exame, String material, String filialExame, Statement st) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append("  select count(1) as qtde from loteexternoexamerequisicao ");
        sql.append("where \n");
        sql.append("  fil_kodigo = ").append(filialExame).append(" and \n");
        sql.append("  req_codigo = ").append(requisicao).append(" and \n");
        sql.append("  exa_codigo = '").append(exame).append("' and \n");
        sql.append("  mco_codigo = ").append(material).append(" and \n");
        sql.append("  ler_datahoraestorno is null and \n ");
        sql.append("  usr_codestorno is null ");
        ResultSet res = st.executeQuery(sql.toString());
        if (res.next()) {
            return res.getInt("qtde") > 0;
        }
        return false;
    }

    @Override
    public AbstractThreadVO getVO(String filial, String codigo) throws ThreadDaoException {
        return null;
    }

    public ArrayList<Registro> verificaExamesMultiguia(Registro requisicao, String reqCodigo, String codLabExterno, String filial, String labExternoCod, Statement st) throws SQLException {
        ArrayList<Registro> exames = new ArrayList<Registro>();
        StringBuilder buf = new StringBuilder();
        buf.append("select fil_codigo, lex_codigo, lae_codigo, req_codigo, exa_codigo, mco_codigo, fil_kodigo  ");
        buf.append(" from loteexternoexamerequisicao where ");
        buf.append(" fil_kodigo = ").append(filial);
        buf.append(" and lae_codigo = ").append(codLabExterno);
        buf.append(" and lex_codigo = ").append(requisicao.possuiCampo("novoLote") ? requisicao.getString("novoLote") : labExternoCod);
        buf.append(" and req_codigo = ").append(reqCodigo);
        ResultSet rs = st.executeQuery(buf.toString());
        if (rs.next()) {
            do {
                Registro r = new Registro();
                r.setValor("fil_codigo", rs.getString("fil_codigo"));
                r.setValor("lex_codigo", rs.getString("lex_codigo"));
                r.setValor("lae_codigo", rs.getString("lae_codigo"));
                r.setValor("req_codigo", rs.getString("req_codigo"));
                r.setValor("exa_codigo", rs.getString("exa_codigo"));
                r.setValor("mco_codigo", rs.getString("mco_codigo"));
                r.setValor("fil_kodigo", rs.getString("fil_kodigo"));
                exames.add(r);
            } while (rs.next());
        }
        return exames;
    }
}

