/*
 * Decompiled with CFR 0.152.
 */
package jalis.model.dao.resultados;

import jalis.comum.Conexao;
import jalis.laboratorio.util.impressao.sql.ValorIn;
import jalis.model.vo.resultado.RequisicaoPaginasImpressasVO;
import jalis.util.Funcoes;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;

public class RequisicaoPaginasImpressasDAO {
    public void registraImpressao(RequisicaoPaginasImpressasVO reqPaginasImpressasVO) throws SQLException {
        Statement st = Conexao.getStatement();
        this.registraImpressao(reqPaginasImpressasVO, st, false);
        Conexao.arquivaSQL();
    }

    public void registraImpressao(RequisicaoPaginasImpressasVO reqPaginasImpressasVO, Statement st, boolean isColetaWeb) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append(" INSERT INTO requisicaopaginasimpressas (fil_codigo, req_codigo, usr_codigo, rpi_datahora, rpi_qtdepaginas) values ( ");
        buf.append(reqPaginasImpressasVO.getFilCodigo()).append(", ").append(reqPaginasImpressasVO.getReqCodigo());
        buf.append(", '").append(reqPaginasImpressasVO.getUsrCodigo()).append("', '").append(reqPaginasImpressasVO.getDataHora()).append("', ").append(reqPaginasImpressasVO.getQtdePaginas()).append(" ) ");
        if (isColetaWeb) {
            st.executeUpdate(buf.toString());
        } else {
            Conexao.execute(reqPaginasImpressasVO.getFilCodigo(), st, buf.toString());
        }
    }

    public int getQtdePaginasImpressa(String filCodigo, String[] usuarios, String dataInicial, String dataFinal, String reqCodigo, Statement st) throws SQLException {
        dataInicial = this.verificaData(dataInicial);
        dataFinal = this.verificaData(dataFinal);
        StringBuilder buf = new StringBuilder();
        ValorIn users = null;
        int qtdePaginasImpressas = 0;
        if (this.contemUsuarios(usuarios)) {
            users = new ValorIn(usuarios);
        }
        buf.append(" select SUM(rpi_qtdepaginas) as qtdePaginasImpressas from requisicaopaginasimpressas ");
        buf.append(" where fil_codigo = ").append(filCodigo);
        buf.append("   and req_codigo = ").append(reqCodigo);
        if (this.contemUsuarios(usuarios)) {
            buf.append("   and usr_codigo in (").append(users.toString()).append(")");
        }
        buf.append("   and rpi_datahora >= '").append(Funcoes.formataData("yyyy/MM/dd", dataInicial)).append(" 00:00'");
        buf.append("   and rpi_datahora <= '").append(Funcoes.formataData("yyyy/MM/dd", dataFinal)).append(" 23:59'");
        ResultSet rs = st.executeQuery(buf.toString());
        if (rs.next()) {
            qtdePaginasImpressas = rs.getInt("qtdePaginasImpressas");
        }
        return qtdePaginasImpressas;
    }

    private String verificaData(String data) {
        if (Funcoes.textoVazio(data)) {
            return Funcoes.formataData(new Date());
        }
        return data;
    }

    private boolean contemUsuarios(String[] usuarios) {
        return usuarios != null;
    }
}

