/*
 * Decompiled with CFR 0.152.
 */
package jalis.model.dao.relatorio.recepcao;

import jalis.service.relatorio.recepcao.RelatorioRequisicoesService;
import jalis.util.Funcoes;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class RelatorioRequisicoesDao {
    private static RelatorioRequisicoesService service;

    public String getLayoutRelatorio(int tipoRelatorio, Statement st) {
        String layout = "";
        StringBuilder builder = new StringBuilder();
        builder.append("select rel_xml from relatoriosistema where rel_codigo = ");
        builder.append(RelatorioRequisicoesService.getModuloAcesso(tipoRelatorio));
        try {
            ResultSet rs = st.executeQuery(builder.toString());
            if (rs.next()) {
                layout = rs.getString("rel_xml");
            }
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return layout;
    }

    public String buscaTaxasRequisicao(int filial, int requisicao, Statement st) {
        String retorno = "";
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT t.tax_descricao, r.rtx_valor");
        sql.append(" FROM requisicaotaxa r ");
        sql.append(" LEFT JOIN taxa t ON r.fil_codigo = t.fil_codigo AND r.tax_codigo = t.tax_codigo");
        sql.append(" WHERE r.fil_codigo = ").append(filial);
        sql.append(" AND r.req_codigo = ").append(requisicao);
        sql.append(" ORDER BY r.tax_codigo ");
        try {
            ResultSet rs = st.executeQuery(sql.toString());
            while (rs.next()) {
                if (retorno.contains(rs.getString("tax_descricao")) || retorno.contains(rs.getString("rtx_valor"))) continue;
                if (!Funcoes.textoVazio(retorno)) {
                    retorno = retorno + " ;  ";
                }
                retorno = retorno + rs.getString("tax_descricao") + ": " + String.format("%.2f", rs.getDouble("rtx_valor"));
            }
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return retorno;
    }

    public String getDescricaoEspecie(int codEspecie, String filialPadrao, Statement st) {
        String retorno = "";
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT e.epc_descricao ");
        sql.append(" FROM especie e ");
        sql.append(" WHERE e.fil_codigo = ").append(filialPadrao);
        sql.append(" AND e.epc_codigo = ").append(codEspecie);
        try {
            ResultSet rs = st.executeQuery(sql.toString());
            if (rs.next()) {
                retorno = rs.getString("epc_descricao");
            }
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return retorno;
    }

    public String getDescricaoRaca(int codRaca, String filialPadrao, Statement st) {
        String retorno = "";
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT r.rac_descricao ");
        sql.append(" FROM raca r ");
        sql.append(" WHERE r.fil_codigo = ").append(filialPadrao);
        sql.append(" AND r.rac_codigo = ").append(codRaca);
        try {
            ResultSet rs = st.executeQuery(sql.toString());
            if (rs.next()) {
                retorno = rs.getString("rac_descricao");
            }
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return retorno;
    }
}

