/*
 * Decompiled with CFR 0.152.
 */
package jalis.model.dao.relatorio.recepcao;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.laboratorio.relatorios.recepcao.RelatorioRegistroContatoPaciente;
import jalis.relatorio.bean.RetornoFiltroIdade;
import jalis.service.relatorio.recepcao.RelatorioRegistroContatoPacienteService;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class RelatorioRegistroContatoPacienteDao {
    private HashMap<String, String> ordem = new HashMap();

    public RelatorioRegistroContatoPacienteDao() {
        this.ordem.put("C\u00f3digo", "pac.pac_codigo asc");
        this.ordem.put("Nome", "UPPER(pac.pac_nome) asc");
        this.ordem.put("Cidade/Estado", "UPPER(cid.cid_nome) asc, cid.cid_uf asc");
    }

    public List<Object> geraRelatorio(String[] filtroFilial, String[] filtroCidade, String[] filtroConvenio, String[] filtroDestino, Object[] filtroMedico, String[] filtroColeta, Object[] filtroPaciente, String[] filtroSetor, String filtroDataInicial, String filtroDataFinal, String filtroEstado, String ordemRelatorio) throws SQLException {
        String sql = this.montaSQL(filtroFilial, filtroCidade, filtroConvenio, filtroDestino, filtroMedico, filtroColeta, filtroPaciente, filtroSetor, filtroDataInicial, filtroDataFinal, filtroEstado, ordemRelatorio);
        ArrayList<Object> listDados = new ArrayList<Object>();
        Statement st = Conexao.getStatement();
        ResultSet rs = Conexao.executeQuery(st, sql);
        while (rs.next()) {
            Object[] registro = new Object[RelatorioRegistroContatoPacienteService.getCampos().length];
            for (int posicao = 0; posicao < RelatorioRegistroContatoPacienteService.getCampos().length; ++posicao) {
                registro[posicao] = RelatorioRegistroContatoPacienteService.getCampos()[posicao].equals("sexoPaciente") ? Tipos.tipoSexo(rs.getString(RelatorioRegistroContatoPacienteService.getCampos()[posicao])) : (RelatorioRegistroContatoPacienteService.getCampos()[posicao].equals("tituloRelatorio") ? "Relat\u00f3rio de Registro de Contato com Pacientes" : rs.getObject(RelatorioRegistroContatoPacienteService.getCampos()[posicao]));
            }
            listDados.add(registro);
        }
        return listDados;
    }

    public String getModeloRealtorio() throws SQLException {
        String codigoRelatorio = "";
        StringBuilder buf = new StringBuilder();
        buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
        buf.append(RelatorioRegistroContatoPaciente.getModuloAcesso());
        ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
        if (rs.next()) {
            codigoRelatorio = rs.getString("rel_xml");
        }
        return codigoRelatorio;
    }

    private String montaSQL(String[] filtroFilial, String[] filtroCidade, String[] filtroConvenio, String[] filtroDestino, Object[] filtroMedico, String[] filtroColeta, Object[] filtroPaciente, String[] filtroSetor, String filtroDataInicial, String filtroDataFinal, String filtroEstado, String ordemRelatorio) {
        StringBuilder buf = new StringBuilder();
        buf.append(" SELECT ");
        buf.append(" req.req_codigo as codigoRequisicao, ");
        buf.append(" req.req_data AS dataUltimoAtendimento, ");
        buf.append(" pac.pac_codigo AS codigoPaciente, ");
        buf.append(" pac.pac_nome AS nomePaciente, ");
        buf.append(" pac.pac_nomesocial AS nomeSocialPaciente, ");
        buf.append(" pac.pac_sexo AS sexoPaciente, ");
        buf.append(" pac.pac_datanasc AS dataNascimentoPaciente, ");
        buf.append(" pac.pac_vip AS vipPaciente, ");
        buf.append(" pac.pac_grpsangue AS grupoSanguineoPaciente, ");
        buf.append(" pac.pac_fatorrh AS fatorRhPaciente, ");
        buf.append(" pac.pac_fatordu AS fatorDuPaciente, ");
        buf.append(" pac.pac_cor AS corPaciente, ");
        buf.append(" pac.pac_observ AS observacaoPaciente, ");
        buf.append(" pac.pac_dadoclinico AS dadoClinicoPaciente, ");
        buf.append(" pac.pac_peso AS pesoPaciente, ");
        buf.append(" pac.pac_altura AS alturaPaciente, ");
        buf.append(" pac.pac_titularconv AS titularConvenioPaciente, ");
        buf.append(" pac.pac_profissao AS profissaoPaciente, ");
        buf.append(" pac.pac_rg AS rgPaciente, ");
        buf.append(" pac.pac_cpf AS cpfPaciente, ");
        buf.append(" pac.pac_estcivil AS estadoCivilPaciente, ");
        buf.append(" pac.pac_numfilho AS numeroFilhosPaciente, ");
        buf.append(" pac.pac_dum AS dumPaciente, ");
        buf.append(" pac.pac_celular AS celularPaciente, ");
        buf.append(" pac.pac_fonecomercial AS foneComercialPaciente, ");
        buf.append(" pac.pac_fone AS fonePaciente, ");
        buf.append(" pac.pac_cep AS cepPaciente, ");
        buf.append(" pac.pac_complemento AS complementoPaciente, ");
        buf.append(" pac.pac_endereco AS enderecoPaciente, ");
        buf.append(" pac.cid_codigo AS codigoCidadePaciente, ");
        buf.append(" cid.cid_nome AS cidadePaciente, ");
        buf.append(" pac.pac_email AS emailPaciente, ");
        buf.append(" pac.pac_idade AS idadePaciente, ");
        buf.append(" pac.pac_mae AS maePaciente, ");
        buf.append(" pac.pac_pai AS paiPaciente, ");
        buf.append(" pac.pac_whatsapp AS whatsAppPaciente, ");
        buf.append(" pac.pac_cartaosus AS cartaoSUSPaciente, ");
        buf.append(" pac.pac_fumante AS fumantePaciente, ");
        buf.append(" pac.pac_diabetico AS diabeticoPaciente, ");
        buf.append(" pac.pac_maladireta AS malaDireta, ");
        buf.append(" pac.pac_proprietario AS proprietarioAnimal, ");
        buf.append(" pac.pac_pelagem AS pelagemAnimal, ");
        buf.append(" rac.rac_descricao AS descricaoRacaAnimal, ");
        buf.append(" epc.epc_descricao AS descricaoEspecieAnimal, ");
        buf.append(" hrc.usr_codigo AS usuarioContato, ");
        buf.append(" hrc.hrc_datacontato AS dataContato, ");
        buf.append(" hrc.hrc_horacontato AS horaContato, ");
        buf.append(" hrc.hrc_datahoracadastro AS dataHoraCadastro, ");
        buf.append(" hrc.hrc_observacao AS observacaoHistorico, ");
        buf.append(" mct.mct_codigo AS motivoCodigo, ");
        buf.append(" mct.mct_descricao AS motivoDescricao, ");
        buf.append(" mct.mct_exigeobservacao AS motivoExigeObservacao, ");
        buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
        buf.append(" FROM historicoregistrocontato hrc ");
        buf.append(" left join examerequisicao exr on  hrc.fil_codigo = exr.fil_codigo and hrc.req_codigo = exr.req_codigo ");
        buf.append(" left join requisicao req on req.fil_codigo = hrc.fil_codigo and req.req_codigo = hrc.req_codigo ");
        buf.append(" left join motivocontato mct on hrc.fil_codigo = mct.fil_codigo and hrc.mct_codigo = mct.mct_codigo ");
        buf.append(" left join examesetor est on\treq.fil_codigo = est.fil_codigo and exr.exa_codigo = est.exa_codigo and est.ese_default is true ");
        buf.append(" left join paciente pac on hrc.fil_codigo = pac.fil_codigo and hrc.pac_codigo = pac.pac_codigo ");
        buf.append(" left join cidades cid on pac.fil_codigo = cid.fil_codigo and pac.cid_codigo = cid.cid_codigo ");
        buf.append(" left join medico med on req.fil_codigo = med.fil_codigo and req.med_crm = med.med_crm  and req.med_uf = med.med_uf \tand req.med_conselho = med.med_conselho");
        buf.append(" left join raca rac on req.fil_codigo = rac.fil_codigo and pac.rac_codigo = rac.rac_codigo ");
        buf.append(" left join especie epc on req.fil_codigo = epc.fil_codigo and pac.epc_codigo = epc.epc_codigo ");
        buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ".replace("a.", "req."));
        buf.append("WHERE ");
        buf.append("hrc.fil_codigo IN (").append(this.getValorFiltroFilial(filtroFilial)).append(") ");
        buf.append(this.getValorFiltroCidade(filtroCidade));
        buf.append(this.getValorFiltroConvenio(filtroConvenio));
        buf.append(this.getValorFiltroDestino(filtroDestino));
        buf.append(this.getValorFiltroMedico(filtroMedico));
        buf.append(this.getValorFiltroColeta(filtroColeta));
        buf.append(this.getValorFiltroPaciente(filtroPaciente));
        buf.append(this.getValorFiltroSetor(filtroSetor));
        buf.append(this.getValorFiltroDataInicial(filtroDataInicial));
        buf.append(this.getValorFiltroDataFinal(filtroDataFinal));
        buf.append(this.getValorFiltroEstado(filtroEstado));
        buf.append(" AND hrc.pac_codigo is not null ");
        buf.append(" and (exr.exr_excluido is null or exr.exr_excluido = 'f') ");
        buf.append(" and (req.req_excluida is null or req.req_excluida = 'f') ");
        buf.append("GROUP BY ");
        buf.append("req.fil_codigo, ");
        buf.append("req.req_codigo, ");
        buf.append("pac.pac_codigo, ");
        buf.append("pac.pac_nome, ");
        buf.append("pac.pac_nomesocial, ");
        buf.append("pac.pac_sexo, ");
        buf.append("pac.pac_datanasc, ");
        buf.append("pac.pac_vip, ");
        buf.append("pac.pac_grpsangue, ");
        buf.append("pac.pac_fatorrh, ");
        buf.append("pac.pac_fatordu, ");
        buf.append("pac.pac_cor, ");
        buf.append("pac.pac_observ, ");
        buf.append("pac.pac_dadoclinico, ");
        buf.append("pac.pac_peso, ");
        buf.append("pac.pac_altura, ");
        buf.append("pac.pac_titularconv, ");
        buf.append("pac.pac_profissao, ");
        buf.append("pac.pac_rg, ");
        buf.append("pac.pac_cpf, ");
        buf.append("pac.pac_estcivil, ");
        buf.append("pac.pac_numfilho, ");
        buf.append("pac.pac_dum, ");
        buf.append("pac.pac_celular, ");
        buf.append("pac.pac_fonecomercial, ");
        buf.append("pac.pac_fone, ");
        buf.append("pac.pac_cep, ");
        buf.append("pac.pac_complemento, ");
        buf.append("pac.pac_endereco, ");
        buf.append("pac.cid_codigo, ");
        buf.append("cid.cid_nome, ");
        buf.append("pac.pac_email, ");
        buf.append("pac.pac_idade, ");
        buf.append("pac.med_crm, ");
        buf.append("pac.med_conselho, ");
        buf.append("pac.med_uf, ");
        buf.append("pac.pac_mae, ");
        buf.append("pac.pac_pai, ");
        buf.append("pac.pac_whatsapp, ");
        buf.append("pac.pac_cartaosus, ");
        buf.append("pac.pac_fumante, ");
        buf.append("pac.pac_diabetico, ");
        buf.append("pac.pac_maladireta, ");
        buf.append("pac.pac_proprietario, ");
        buf.append("pac.pac_pelagem, ");
        buf.append("rac.rac_descricao, ");
        buf.append("epc.epc_descricao, ");
        buf.append("hrc.usr_codigo, ");
        buf.append("mct.mct_codigo, ");
        buf.append("hrc.hrc_datacontato, ");
        buf.append("hrc.hrc_horacontato, ");
        buf.append("hrc.hrc_datahoracadastro, ");
        buf.append("hrc.hrc_observacao, ");
        buf.append("mct.mct_descricao, ");
        buf.append("mct.mct_exigeobservacao, ");
        buf.append("cid.cid_uf, ");
        buf.append("hrc.fil_codigo, ");
        buf.append("filial.fil_codigo, filial.fil_descricao, filial.fil_cnpj, filial.fil_endereco, filial.fil_complemento, filial.fil_cep, filial.fil_fone, filial.fil_fax, filial.fil_razaosocial, filial.fil_cnes, cidadefilial.cid_codigo, cidadefilial.cid_nome, cidadefilial.cid_uf, bairrofilial.bai_codigo, bairrofilial.bai_descricao ");
        buf.append("ORDER BY ");
        buf.append(this.getValorOrdem(ordemRelatorio));
        return buf.toString();
    }

    private String getValorFiltroFilial(String[] filtroFilial) {
        StringBuilder buf = new StringBuilder();
        if (!Funcoes.objectIsNull(filtroFilial)) {
            for (int i = 0; i < filtroFilial.length; ++i) {
                buf.append(filtroFilial[i]);
                if (i >= filtroFilial.length - 1) continue;
                buf.append(", ");
            }
        } else {
            buf.append(Variaveis.filialPadrao);
        }
        return buf.toString();
    }

    private String getValorFiltroCidade(String[] filtroCidade) {
        StringBuilder buf = new StringBuilder();
        if (!Funcoes.objectIsNull(filtroCidade)) {
            buf.append(" AND pac.cid_codigo IN (");
            for (int i = 0; i < filtroCidade.length; ++i) {
                buf.append(filtroCidade[i]);
                if (i >= filtroCidade.length - 1) continue;
                buf.append(", ");
            }
            buf.append(") ");
        }
        return buf.toString();
    }

    private Object getValorFiltroConvenio(String[] filtroConvenio) {
        StringBuilder buf = new StringBuilder();
        if (!Funcoes.objectIsNull(filtroConvenio)) {
            buf.append(" AND req.con_codigo IN (");
            for (int i = 0; i < filtroConvenio.length; ++i) {
                buf.append(filtroConvenio[i]);
                if (i >= filtroConvenio.length - 1) continue;
                buf.append(", ");
            }
            buf.append(") ");
        }
        return buf.toString();
    }

    private Object getValorFiltroDestino(String[] filtroDestino) {
        StringBuilder buf = new StringBuilder();
        if (!Funcoes.objectIsNull(filtroDestino)) {
            buf.append(" AND req.des_codigo IN (");
            for (int i = 0; i < filtroDestino.length; ++i) {
                buf.append(StringUtil.textoDBEscape(filtroDestino[i]));
                if (i >= filtroDestino.length - 1) continue;
                buf.append(", ");
            }
            buf.append(") ");
        }
        return buf.toString();
    }

    private String getValorFiltroMedico(Object[] filtroMedico) {
        StringBuilder buf = new StringBuilder();
        if (!Funcoes.objectIsNull(filtroMedico) && filtroMedico.length <= ParametrosGerais.getQuantidadeMaximoFiltroAvancado()) {
            buf.append(" AND (");
            for (int i = 0; i < filtroMedico.length; ++i) {
                Object[] medico = (Object[])filtroMedico[i];
                buf.append("(req.med_conselho = '");
                buf.append(medico[0]);
                buf.append("' and req.med_crm = '");
                buf.append(medico[1]);
                buf.append("' and req.med_uf = '");
                buf.append(medico[2]);
                buf.append("')");
                if (!this.adicionaMaisMedico(filtroMedico, i)) continue;
                buf.append(" OR ");
            }
            buf.append(")");
        }
        return buf.toString();
    }

    private boolean adicionaMaisMedico(Object[] crm, int i) {
        return i < crm.length - 1;
    }

    private String getValorFiltroColeta(String[] filtroColeta) {
        StringBuilder buf = new StringBuilder();
        if (!Funcoes.objectIsNull(filtroColeta)) {
            buf.append(" AND req.col_codigo IN (");
            for (int i = 0; i < filtroColeta.length; ++i) {
                buf.append(StringUtil.textoDBEscape(filtroColeta[i]));
                if (i >= filtroColeta.length - 1) continue;
                buf.append(", ");
            }
            buf.append(") ");
        }
        return buf.toString();
    }

    private String getValorFiltroPaciente(Object[] filtroPaciente) {
        StringBuilder buf = new StringBuilder();
        if (!Funcoes.objectIsNull(filtroPaciente)) {
            buf.append(" AND pac.pac_codigo IN (");
            for (int i = 0; i < filtroPaciente.length; ++i) {
                Object[] paciente = (Object[])filtroPaciente[i];
                buf.append(paciente[0]);
                if (i >= filtroPaciente.length - 1) continue;
                buf.append(", ");
            }
            buf.append(") ");
        }
        return buf.toString();
    }

    private String getValorFiltroSetor(String[] filtroSetor) {
        StringBuilder buf = new StringBuilder();
        if (!Funcoes.objectIsNull(filtroSetor)) {
            buf.append(" AND est.set_codigo IN (");
            for (int i = 0; i < filtroSetor.length; ++i) {
                buf.append(filtroSetor[i]);
                if (i >= filtroSetor.length - 1) continue;
                buf.append(", ");
            }
            buf.append(") ");
        }
        return buf.toString();
    }

    private String getValorFiltroDataInicial(String filtroDataInicial) {
        StringBuilder buf = new StringBuilder();
        if (!Funcoes.textoVazio(filtroDataInicial)) {
            buf.append(" AND hrc.hrc_datacontato BETWEEN '").append(Funcoes.formataData("yyyy/MM/dd", filtroDataInicial)).append("' ");
        }
        return buf.toString();
    }

    private Object getValorFiltroDataFinal(String filtroDataFinal) {
        StringBuilder buf = new StringBuilder();
        if (!Funcoes.textoVazio(filtroDataFinal)) {
            buf.append(" AND '").append(Funcoes.formataData("yyyy/MM/dd", filtroDataFinal)).append("' ");
        }
        return buf.toString();
    }

    private String getValorDivisao(RetornoFiltroIdade idade) {
        if (idade.getTipoIdadeIdentificador().equalsIgnoreCase("A")) {
            return "/ 365";
        }
        if (idade.getTipoIdadeIdentificador().equalsIgnoreCase("M")) {
            return "/ 30";
        }
        return "";
    }

    private String getValorFiltroEstado(String filtroEstado) {
        StringBuilder buf = new StringBuilder();
        if (!filtroEstado.equalsIgnoreCase("Todos")) {
            buf.append("  AND cid.cid_uf = '").append(filtroEstado.toString()).append("' ");
        }
        return buf.toString();
    }

    private String getValorOrdem(String ordemRelatorio) {
        return "hrc.fil_codigo, ".concat(this.ordem.get(ordemRelatorio).concat(" ")).concat(", hrc.hrc_datacontato desc, hrc.hrc_horacontato desc ");
    }
}

