/*
 * Decompiled with CFR 0.152.
 */
package jalis.model.dao.relatorio.recepcao;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.laboratorio.relatorios.recepcao.RelatorioPacientesAtendidos;
import jalis.relatorio.bean.RetornoFiltroIdade;
import jalis.service.relatorio.recepcao.RelatorioPacientesAtendidosService;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class RelatorioPacientesAtendidosDao {
    private HashMap<String, String> ordem = new HashMap();
    private String filtroSituacaoExame;
    private static final String[] situacao = new String[]{"Todas", Tipos.tipoSituacaoExame(""), Tipos.tipoSituacaoExame("T"), Tipos.tipoSituacaoExame("F"), Tipos.tipoSituacaoExame("R"), Tipos.tipoSituacaoExame("L"), Tipos.tipoSituacaoExame("C"), Tipos.tipoSituacaoExame("O"), Tipos.tipoSituacaoExame("I"), Tipos.tipoSituacaoExame("E"), Tipos.tipoSituacaoExame("A"), Tipos.tipoSituacaoExame("P"), Tipos.tipoSituacaoExame("N")};

    public RelatorioPacientesAtendidosDao() {
        this.ordem.put("C\u00f3digo", "pac.pac_codigo asc");
        this.ordem.put("Nome", "UPPER(pac.pac_nome) asc");
        this.ordem.put("Cidade", "UPPER(cid.cid_nome) asc");
        this.ordem.put("Estado", "cid.cid_uf asc");
        this.ordem.put("Cidade/Estado", "UPPER(cid.cid_nome) asc, cid.cid_uf asc");
        this.ordem.put("Endere\u00e7o", "UPPER(pac.pac_endereco) asc");
        this.ordem.put("E-mail", "UPPER(pac.pac_email) asc");
        this.ordem.put("Data Nascimento", "pac.pac_datanasc asc");
        this.ordem.put("\u00dalt. atendimento crescente", "MAX(req.req_data), pac.pac_codigo ");
        this.ordem.put("\u00dalt. atendimento decrescente", "MAX(req.req_data) desc, pac.pac_codigo ");
    }

    public List<Object> geraRelatorio(String[] filtroFilial, String[] filtroCidade, String[] filtroEmpresa, String[] filtroConvenio, String[] filtroExame, String[] filtroDestino, Object[] filtroMedico, String[] filtroColeta, Object[] filtroPaciente, String[] filtroSetor, String filtroDataInicial, String filtroDataFinal, RetornoFiltroIdade filtroIdadeInicial, RetornoFiltroIdade filtroIdadeFinal, String filtroEstado, String filtroSexo, String filtroFumante, String filtroDiabetico, String ordemRelatorio, boolean filtroComEmail, boolean filtroVIP, boolean filtroIdadeAtual) throws SQLException {
        String sql = this.montaSQL(filtroFilial, filtroCidade, filtroEmpresa, filtroConvenio, filtroExame, filtroDestino, filtroMedico, filtroColeta, filtroPaciente, filtroSetor, filtroDataInicial, filtroDataFinal, filtroIdadeInicial, filtroIdadeFinal, filtroEstado, filtroSexo, filtroFumante, filtroDiabetico, ordemRelatorio, filtroComEmail, filtroVIP, filtroIdadeAtual);
        ArrayList<Object> listDados = new ArrayList<Object>();
        Statement st = Conexao.getStatement();
        ResultSet rs = Conexao.executeQuery(st, sql);
        while (rs.next()) {
            Object[] registro = new Object[RelatorioPacientesAtendidosService.getCampos().length];
            for (int posicao = 0; posicao < RelatorioPacientesAtendidosService.getCampos().length; ++posicao) {
                registro[posicao] = RelatorioPacientesAtendidosService.getCampos()[posicao].equals("sexoPaciente") ? Tipos.tipoSexo(rs.getString(RelatorioPacientesAtendidosService.getCampos()[posicao])) : (RelatorioPacientesAtendidosService.getCampos()[posicao].equals("tituloRelatorio") ? RelatorioPacientesAtendidosService.getTitulo() : rs.getObject(RelatorioPacientesAtendidosService.getCampos()[posicao]));
            }
            listDados.add(registro);
        }
        return listDados;
    }

    public String getModeloRealtorio() throws SQLException {
        String codigoRelatorio = "";
        StringBuilder buf = new StringBuilder();
        buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
        buf.append(RelatorioPacientesAtendidos.getModuloAcesso());
        ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
        if (rs.next()) {
            codigoRelatorio = rs.getString("rel_xml");
        }
        return codigoRelatorio;
    }

    private String montaSQL(String[] filtroFilial, String[] filtroCidade, String[] filtroEmpresa, String[] filtroConvenio, String[] filtroExame, String[] filtroDestino, Object[] filtroMedico, String[] filtroColeta, Object[] filtroPaciente, String[] filtroSetor, String filtroDataInicial, String filtroDataFinal, RetornoFiltroIdade filtroIdadeInicial, RetornoFiltroIdade filtroIdadeFinal, String filtroEstado, String filtroSexo, String filtroFumante, String filtroDiabetico, String ordemRelatorio, boolean filtroComEmail, boolean filtroVIP, boolean filtroIdadeAtual) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("SELECT ");
        buffer.append("ARRAY_TO_STRING(ARRAY_AGG(DISTINCT req.req_codigo), ', ') AS codigoRequisicao, ");
        buffer.append("MAX(req.req_data) AS dataUltimoAtendimento, ");
        buffer.append("pac.pac_codigo AS codigoPaciente, ");
        buffer.append("pac.pac_nome AS nomePaciente, ");
        buffer.append("pac.pac_nomesocial AS nomeSocialPaciente, ");
        buffer.append("pac.pac_sexo AS sexoPaciente, ");
        buffer.append("pac.pac_datanasc AS dataNascimentoPaciente, ");
        buffer.append("pac.pac_vip AS vipPaciente, ");
        buffer.append("pac.pac_grpsangue AS grupoSanguineoPaciente, ");
        buffer.append("pac.pac_fatorrh AS fatorRhPaciente, ");
        buffer.append("pac.pac_fatordu AS fatorDuPaciente, ");
        buffer.append("pac.pac_cor AS corPaciente, ");
        buffer.append("pac.pac_observ AS observacaoPaciente, ");
        buffer.append("pac.pac_dadoclinico AS dadoClinicoPaciente, ");
        buffer.append("pac.pac_peso AS pesoPaciente, ");
        buffer.append("pac.pac_altura AS alturaPaciente, ");
        buffer.append("pac.pac_titularconv AS titularConvenioPaciente, ");
        buffer.append("pac.pac_profissao AS profissaoPaciente, ");
        buffer.append("pac.pac_rg AS rgPaciente, ");
        buffer.append("pac.pac_cpf AS cpfPaciente, ");
        buffer.append("pac.pac_estcivil AS estadoCivilPaciente, ");
        buffer.append("pac.pac_numfilho AS numeroFilhosPaciente, ");
        buffer.append("pac.pac_dum AS dumPaciente, ");
        buffer.append("pac.pac_celular AS celularPaciente, ");
        buffer.append("pac.pac_fonecomercial AS foneComercialPaciente, ");
        buffer.append("pac.pac_fone AS fonePaciente, ");
        buffer.append("pac.pac_cep AS cepPaciente, ");
        buffer.append("pac.pac_complemento AS complementoPaciente, ");
        buffer.append("pac.pac_endereco AS enderecoPaciente, ");
        buffer.append("pac.cid_codigo AS codigoCidadePaciente, ");
        buffer.append("cid.cid_nome AS cidadePaciente, ");
        buffer.append("pac.pac_email AS emailPaciente, ");
        buffer.append("pac.pac_idade AS idadePaciente, ");
        buffer.append("pac.pac_mae AS maePaciente, ");
        buffer.append("pac.pac_pai AS paiPaciente, ");
        buffer.append("pac.pac_whatsapp AS whatsAppPaciente, ");
        buffer.append("pac.pac_cartaosus AS cartaoSUSPaciente, ");
        buffer.append("pac.pac_fumante AS fumantePaciente, ");
        buffer.append("pac.pac_diabetico AS diabeticoPaciente, ");
        buffer.append("pac.pac_maladireta AS malaDireta, ");
        buffer.append("pac.pac_proprietario AS proprietarioAnimal, ");
        buffer.append("pac.pac_pelagem AS pelagemAnimal, ");
        buffer.append("rac.rac_descricao AS descricaoRacaAnimal, ");
        buffer.append("epc.epc_descricao AS descricaoEspecieAnimal, ");
        buffer.append("idg.ige_descricao as generoPaciente, ");
        buffer.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
        buffer.append("FROM requisicao req ");
        buffer.append("LEFT JOIN examerequisicao exr ON req.fil_codigo = exr.fil_codigo AND req.req_codigo = exr.req_codigo AND NOT exr.exr_excluido ");
        buffer.append("LEFT JOIN examesetor est ON req.fil_codigo = est.fil_codigo AND exr.exa_codigo = est.exa_codigo ");
        buffer.append("LEFT JOIN paciente pac ON req.fil_codigo = pac.fil_codigo AND req.pac_codigo = pac.pac_codigo ");
        buffer.append("LEFT JOIN cidades cid ON req.fil_codigo = cid.fil_codigo AND pac.cid_codigo = cid.cid_codigo ");
        buffer.append("LEFT JOIN medico med ON req.fil_codigo = med.fil_codigo AND req.med_crm = med.med_crm AND req.med_uf = med.med_uf AND req.med_conselho = med.med_conselho ");
        buffer.append("LEFT JOIN raca rac ON req.fil_codigo = rac.fil_codigo AND pac.rac_codigo = rac.rac_codigo ");
        buffer.append("LEFT JOIN especie epc ON req.fil_codigo = epc.fil_codigo AND pac.epc_codigo = epc.epc_codigo ");
        buffer.append("LEFT JOIN identidadegenero idg on coalesce(pac.pac_genero, 0) = idg.ige_codigo ");
        buffer.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ".replace("a.", "req."));
        buffer.append("WHERE ");
        buffer.append("req.fil_codigo IN (").append(this.getValorFiltroFilial(filtroFilial)).append(") ");
        buffer.append(this.getValorFiltroCidade(filtroCidade));
        buffer.append(this.getValorFiltroEmpresa(filtroEmpresa));
        buffer.append(this.getValorFiltroConvenio(filtroConvenio));
        buffer.append(this.getValorFiltroExame(filtroExame));
        buffer.append(this.getValorFiltroDestino(filtroDestino));
        buffer.append(this.getValorFiltroMedico(filtroMedico));
        buffer.append(this.getValorFiltroColeta(filtroColeta));
        buffer.append(this.getValorFiltroPaciente(filtroPaciente));
        buffer.append(this.getValorFiltroSetor(filtroSetor));
        buffer.append(this.getValorFiltroDataInicial(filtroDataInicial));
        buffer.append(this.getValorFiltroDataFinal(filtroDataFinal));
        buffer.append(this.getValorFiltroIdade(filtroIdadeInicial, filtroIdadeFinal, filtroIdadeAtual));
        buffer.append(this.getValorFiltroEstado(filtroEstado));
        buffer.append(this.getValorFiltroSexo(filtroSexo));
        buffer.append(this.getValorFiltroFumante(filtroFumante));
        buffer.append(this.getValorFiltroDiabetico(filtroDiabetico));
        buffer.append(this.getValorFiltroSituacao());
        buffer.append(filtroComEmail ? "AND (pac.pac_email IS NOT NULL AND LENGTH(TRIM(pac.pac_email)) <> 0) " : "");
        buffer.append(filtroVIP ? "AND pac.pac_vip " : "");
        buffer.append("AND NOT req.req_excluida ");
        buffer.append("GROUP BY ");
        buffer.append("req.fil_codigo, ");
        buffer.append("pac.pac_codigo, ");
        buffer.append("pac.pac_nome, ");
        buffer.append("pac.pac_nomesocial, ");
        buffer.append("pac.pac_sexo, ");
        buffer.append("pac.pac_datanasc, ");
        buffer.append("pac.pac_vip, ");
        buffer.append("pac.pac_grpsangue, ");
        buffer.append("pac.pac_fatorrh, ");
        buffer.append("pac.pac_fatordu, ");
        buffer.append("pac.pac_cor, ");
        buffer.append("pac.pac_observ, ");
        buffer.append("pac.pac_dadoclinico, ");
        buffer.append("pac.pac_peso, ");
        buffer.append("pac.pac_altura, ");
        buffer.append("pac.pac_titularconv, ");
        buffer.append("pac.pac_profissao, ");
        buffer.append("pac.pac_rg, ");
        buffer.append("pac.pac_cpf, ");
        buffer.append("pac.pac_estcivil, ");
        buffer.append("pac.pac_numfilho, ");
        buffer.append("pac.pac_dum, ");
        buffer.append("pac.pac_celular, ");
        buffer.append("pac.pac_fonecomercial, ");
        buffer.append("pac.pac_fone, ");
        buffer.append("pac.pac_cep, ");
        buffer.append("pac.pac_complemento, ");
        buffer.append("pac.pac_endereco, ");
        buffer.append("pac.cid_codigo, ");
        buffer.append("cid.cid_nome, ");
        buffer.append("pac.pac_email, ");
        buffer.append("pac.pac_idade, ");
        buffer.append("pac.med_crm, ");
        buffer.append("pac.med_conselho, ");
        buffer.append("pac.med_uf, ");
        buffer.append("pac.pac_mae, ");
        buffer.append("pac.pac_pai, ");
        buffer.append("pac.pac_whatsapp, ");
        buffer.append("pac.pac_cartaosus, ");
        buffer.append("pac.pac_fumante, ");
        buffer.append("pac.pac_diabetico, ");
        buffer.append("pac.pac_maladireta, ");
        buffer.append("pac.pac_proprietario, ");
        buffer.append("pac.pac_pelagem, ");
        buffer.append("rac.rac_descricao, ");
        buffer.append("epc.epc_descricao, ");
        buffer.append("cid.cid_uf, ");
        buffer.append("idg.ige_codigo, ");
        buffer.append("filial.fil_codigo, filial.fil_descricao, filial.fil_cnpj, filial.fil_endereco, filial.fil_complemento, filial.fil_cep, filial.fil_fone, filial.fil_fax, filial.fil_razaosocial, filial.fil_cnes, cidadefilial.cid_codigo, cidadefilial.cid_nome, cidadefilial.cid_uf, bairrofilial.bai_codigo, bairrofilial.bai_descricao ");
        buffer.append("ORDER BY ");
        buffer.append(this.getValorOrdem(ordemRelatorio));
        return buffer.toString();
    }

    private String getValorFiltroFilial(String[] filtroFilial) {
        StringBuilder buf = new StringBuilder();
        if (!Funcoes.objectIsNull(filtroFilial)) {
            for (int i = 0; i < filtroFilial.length; ++i) {
                buf.append(filtroFilial[i]);
                if (i >= filtroFilial.length - 1) continue;
                buf.append(", ");
            }
        } else {
            buf.append(Variaveis.filialPadrao);
        }
        return buf.toString();
    }

    private String getValorFiltroSituacao() {
        StringBuilder buf = new StringBuilder();
        if (!Funcoes.objectIsNull(this.filtroSituacaoExame)) {
            buf.append(" AND exr.exr_situacao IN ('");
            if (this.filtroSituacaoExame.equals(situacao[1])) {
                buf.append("");
            } else if (this.filtroSituacaoExame.equals(situacao[2])) {
                buf.append("T");
            } else if (this.filtroSituacaoExame.equals(situacao[3])) {
                buf.append("F");
            } else if (this.filtroSituacaoExame.equals(situacao[4])) {
                buf.append("R");
            } else if (this.filtroSituacaoExame.equals(situacao[5])) {
                buf.append("L");
            } else if (this.filtroSituacaoExame.equals(situacao[6])) {
                buf.append("C");
            } else if (this.filtroSituacaoExame.equals(situacao[7])) {
                buf.append("O");
            } else if (this.filtroSituacaoExame.equals(situacao[8])) {
                buf.append("I");
            } else if (this.filtroSituacaoExame.equals(situacao[9])) {
                buf.append("E");
            } else if (this.filtroSituacaoExame.equals(situacao[10])) {
                buf.append("A");
            } else if (this.filtroSituacaoExame.equals(situacao[11])) {
                buf.append("P");
            } else if (this.filtroSituacaoExame.equals(situacao[12])) {
                buf.append("N");
            } else {
                buf.append(this.filtrarTodasAsSituacoes());
            }
            buf.append("'");
            buf.append(") ");
        }
        return buf.toString();
    }

    private String filtrarTodasAsSituacoes() {
        String separador = "','";
        StringBuilder situacoes = new StringBuilder();
        situacoes.append("T").append(separador);
        situacoes.append("R").append(separador);
        situacoes.append("A").append(separador);
        situacoes.append("P").append(separador);
        situacoes.append("L").append(separador);
        situacoes.append("U").append(separador);
        situacoes.append("C").append(separador);
        situacoes.append("O").append(separador);
        situacoes.append("I").append(separador);
        situacoes.append("E").append(separador);
        situacoes.append("N").append(separador);
        situacoes.append("");
        return situacoes.toString();
    }

    private String getValorFiltroCidade(String[] filtroCidade) {
        StringBuilder buf = new StringBuilder();
        if (!Funcoes.objectIsNull(filtroCidade)) {
            buf.append(" AND pac.cid_codigo IN (");
            for (int i = 0; i < filtroCidade.length; ++i) {
                buf.append(filtroCidade[i]);
                if (i >= filtroCidade.length - 1) continue;
                buf.append(", ");
            }
            buf.append(") ");
        }
        return buf.toString();
    }

    private String getValorFiltroEmpresa(String[] filtroEmpresa) {
        StringBuilder buf = new StringBuilder();
        if (!Funcoes.objectIsNull(filtroEmpresa)) {
            buf.append(" AND pac.ent_codempresa IN (");
            for (int i = 0; i < filtroEmpresa.length; ++i) {
                buf.append(filtroEmpresa[i]);
                if (i >= filtroEmpresa.length - 1) continue;
                buf.append(", ");
            }
            buf.append(") ");
        }
        return buf.toString();
    }

    private Object getValorFiltroConvenio(String[] filtroConvenio) {
        StringBuilder buf = new StringBuilder();
        if (!Funcoes.objectIsNull(filtroConvenio)) {
            buf.append(" AND req.con_codigo IN (");
            for (int i = 0; i < filtroConvenio.length; ++i) {
                buf.append(filtroConvenio[i]);
                if (i >= filtroConvenio.length - 1) continue;
                buf.append(", ");
            }
            buf.append(") ");
        }
        return buf.toString();
    }

    private Object getValorFiltroExame(String[] filtroExame) {
        StringBuilder buf = new StringBuilder();
        if (!Funcoes.objectIsNull(filtroExame)) {
            buf.append(" AND exr.exa_codigo IN (");
            for (int i = 0; i < filtroExame.length; ++i) {
                buf.append(StringUtil.textoDBEscape(filtroExame[i]));
                if (i >= filtroExame.length - 1) continue;
                buf.append(", ");
            }
            buf.append(") ");
        }
        return buf.toString();
    }

    private Object getValorFiltroDestino(String[] filtroDestino) {
        StringBuilder buf = new StringBuilder();
        if (!Funcoes.objectIsNull(filtroDestino)) {
            buf.append(" AND req.des_codigo IN (");
            for (int i = 0; i < filtroDestino.length; ++i) {
                buf.append(StringUtil.textoDBEscape(filtroDestino[i]));
                if (i >= filtroDestino.length - 1) continue;
                buf.append(", ");
            }
            buf.append(") ");
        }
        return buf.toString();
    }

    private String getValorFiltroMedico(Object[] filtroMedico) {
        StringBuilder buf = new StringBuilder();
        if (!Funcoes.objectIsNull(filtroMedico) && filtroMedico.length <= ParametrosGerais.getQuantidadeMaximoFiltroAvancado()) {
            buf.append(" AND (");
            for (int i = 0; i < filtroMedico.length; ++i) {
                Object[] medico = (Object[])filtroMedico[i];
                buf.append("(req.med_conselho = '");
                buf.append(medico[0]);
                buf.append("' and req.med_crm = '");
                buf.append(medico[1]);
                buf.append("' and req.med_uf = '");
                buf.append(medico[2]);
                buf.append("')");
                if (!this.adicionaMaisMedico(filtroMedico, i)) continue;
                buf.append(" OR ");
            }
            buf.append(")");
        }
        return buf.toString();
    }

    private boolean adicionaMaisMedico(Object[] crm, int i) {
        return i < crm.length - 1;
    }

    private String getValorFiltroColeta(String[] filtroColeta) {
        StringBuilder buf = new StringBuilder();
        if (!Funcoes.objectIsNull(filtroColeta)) {
            buf.append(" AND req.col_codigo IN (");
            for (int i = 0; i < filtroColeta.length; ++i) {
                buf.append(StringUtil.textoDBEscape(filtroColeta[i]));
                if (i >= filtroColeta.length - 1) continue;
                buf.append(", ");
            }
            buf.append(") ");
        }
        return buf.toString();
    }

    private String getValorFiltroPaciente(Object[] filtroPaciente) {
        StringBuilder buf = new StringBuilder();
        if (!Funcoes.objectIsNull(filtroPaciente)) {
            buf.append(" AND pac.pac_codigo IN (");
            for (int i = 0; i < filtroPaciente.length; ++i) {
                Object[] paciente = (Object[])filtroPaciente[i];
                buf.append(paciente[0]);
                if (i >= filtroPaciente.length - 1) continue;
                buf.append(", ");
            }
            buf.append(") ");
        }
        return buf.toString();
    }

    private String getValorFiltroSetor(String[] filtroSetor) {
        StringBuilder buf = new StringBuilder();
        if (!Funcoes.objectIsNull(filtroSetor)) {
            buf.append(" AND est.set_codigo IN (");
            for (int i = 0; i < filtroSetor.length; ++i) {
                buf.append(filtroSetor[i]);
                if (i >= filtroSetor.length - 1) continue;
                buf.append(", ");
            }
            buf.append(") ");
        }
        return buf.toString();
    }

    private String getValorFiltroDataInicial(String filtroDataInicial) {
        StringBuilder buf = new StringBuilder();
        if (!Funcoes.textoVazio(filtroDataInicial)) {
            buf.append(" AND req.req_data BETWEEN '").append(Funcoes.formataData("yyyy/MM/dd", filtroDataInicial)).append("' ");
        }
        return buf.toString();
    }

    private Object getValorFiltroDataFinal(String filtroDataFinal) {
        StringBuilder buf = new StringBuilder();
        if (!Funcoes.textoVazio(filtroDataFinal)) {
            buf.append(" AND '").append(Funcoes.formataData("yyyy/MM/dd", filtroDataFinal)).append("' ");
        }
        return buf.toString();
    }

    private String getValorFiltroIdade(RetornoFiltroIdade idadeInicial, RetornoFiltroIdade idadeFinal, boolean filtroIdadeAtual) {
        StringBuilder buf = new StringBuilder();
        if (idadeInicial.getIdade() != null || idadeFinal.getIdade() != null) {
            buf.append(" AND pac.pac_datanasc IS NOT NULL ");
            StringBuilder condicoes = new StringBuilder();
            if (filtroIdadeAtual) {
                condicoes.append(" and extract (day from (now() - pac_datanasc) ").append(this.getValorDivisao(idadeInicial)).append(") ");
                condicoes.append(" >= ").append(idadeInicial.getIdadePorTipoSelecionado());
                condicoes.append(" and extract (day from (now() - pac_datanasc) ").append(this.getValorDivisao(idadeFinal)).append(") ");
                condicoes.append(" <= ").append(idadeFinal.getIdadePorTipoSelecionado());
                buf.append((CharSequence)condicoes);
            } else {
                condicoes.append(" AND CASE ");
                condicoes.append(" WHEN req.req_anomes = '").append("A").append("' THEN (req.req_idade * 365) ");
                condicoes.append(" WHEN req.req_anomes = '").append("M").append("' THEN (req.req_idade * 30) ");
                condicoes.append(" WHEN req.req_anomes = '").append("D").append("' THEN (req.req_idade) ");
                condicoes.append(" WHEN req.req_anomes IS NULL THEN 0 END ");
                if (!Funcoes.textoVazio(idadeInicial.getIdade())) {
                    buf.append(condicoes.toString()).append(" >= ").append(idadeInicial.getIdade()).append(" ");
                }
                if (!Funcoes.textoVazio(idadeFinal.getIdade())) {
                    buf.append(condicoes.toString()).append(" <= ").append(idadeFinal.getIdade()).append(" ");
                }
            }
        }
        return buf.toString();
    }

    private String getValorDivisao(RetornoFiltroIdade idade) {
        if (idade.getTipoIdadeIdentificador().equalsIgnoreCase("A")) {
            return "/ 365";
        }
        if (idade.getTipoIdadeIdentificador().equalsIgnoreCase("M")) {
            return "/ 30";
        }
        return "";
    }

    private String getValorFiltroEstado(String filtroEstado) {
        StringBuilder buf = new StringBuilder();
        if (!filtroEstado.equalsIgnoreCase("Todos")) {
            buf.append("  AND cid.cid_uf = '").append(filtroEstado.toString()).append("' ");
        }
        return buf.toString();
    }

    private String getValorFiltroSexo(String filtroSexo) {
        StringBuilder buf = new StringBuilder();
        if (!filtroSexo.equalsIgnoreCase("Todos")) {
            buf.append(" AND pac.pac_sexo = '").append(filtroSexo.toString().substring(0, 1)).append("' ");
        }
        return buf.toString();
    }

    private String getValorFiltroFumante(String filtroFumante) {
        StringBuilder buf = new StringBuilder();
        if (filtroFumante.equalsIgnoreCase("N\u00e3o Informado")) {
            buf.append(" AND pac.pac_fumante = '").append("I").append("' ");
        } else if (filtroFumante.equalsIgnoreCase("N\u00e3o")) {
            buf.append(" AND pac.pac_fumante = '").append("S").append("' ");
        } else if (filtroFumante.equalsIgnoreCase("Sim")) {
            buf.append(" AND pac.pac_fumante = '").append("N").append("' ");
        }
        return buf.toString();
    }

    private String getValorFiltroDiabetico(String filtroDiabetico) {
        StringBuilder buf = new StringBuilder();
        if (filtroDiabetico.equalsIgnoreCase("N\u00e3o Informado")) {
            buf.append("  AND pac.pac_diabetico = '").append("I").append("' ");
        } else if (filtroDiabetico.equalsIgnoreCase("Sim")) {
            buf.append("  AND pac.pac_diabetico = '").append("S").append("' ");
        } else if (filtroDiabetico.equalsIgnoreCase("N\u00e3o")) {
            buf.append("  AND pac.pac_diabetico = '").append("N").append("' ");
        }
        return buf.toString();
    }

    private String getValorOrdem(String ordemRelatorio) {
        return "req.fil_codigo, ".concat(this.ordem.get(ordemRelatorio).concat(" "));
    }

    public String getFiltroSituacaoExame() {
        return this.filtroSituacaoExame;
    }

    public void setFiltroSituacaoExame(String filtroSituacaoExame) {
        this.filtroSituacaoExame = filtroSituacaoExame;
    }
}

