/*
 * Decompiled with CFR 0.152.
 */
package jalis.model.dao.relatorio;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.laboratorio.relatorios.gerencial.recepcao.RelatorioRequisicoesRecoleta;
import jalis.model.vo.relatorio.RelatorioRequisicoesRecoletaVO;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.relatorio.TipoDadoBanco;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class RelatorioRequisicoesRecoletaDAO {
    private static final String ORDEM_CODIGO = "C\u00f3digo";
    private String[] filtroFiliais;
    private String[] filtroDestinos;
    private String[] filtroColetas;
    private String[] filtroConvenios;
    private String[] filtroMedicos;
    private String[] conselhos;
    private String[] ufs;
    private String[] crms;
    private String[] filtroExames;
    private String[] filtroMateriais;
    private String[] filtroSetores;
    private String[] filtroMotivoRecoleta;
    private String dataFinal;
    private String dataInicial;
    private String horaInicial;
    private String horaFinal;
    private Object filtroIntervaloHora;
    private Object filtroApresentarHistorico;
    private Object filtroOrdem;

    public List<Object> gerarDados() throws SQLException {
        Statement st = Conexao.getStatement();
        Statement stTemp = Conexao.getStatement();
        ResultSet rs = Conexao.executeQuery(st, this.montaSQL());
        ArrayList<Object> listDados = new ArrayList<Object>();
        while (rs.next()) {
            RelatorioRequisicoesRecoletaVO info = new RelatorioRequisicoesRecoletaVO();
            for (int i = 1; i < rs.getMetaData().getColumnCount(); ++i) {
                String tipoDado = this.getTipoDado(rs.getMetaData().getColumnType(i));
                if (tipoDado.equalsIgnoreCase(TipoDadoBanco.DATE.toString())) {
                    if (!rs.getMetaData().getColumnName(i).startsWith("data")) continue;
                    info.getDados().put(rs.getMetaData().getColumnName(i), Funcoes.formataData(rs.getDate(rs.getMetaData().getColumnName(i))));
                    continue;
                }
                if (tipoDado.equalsIgnoreCase(TipoDadoBanco.TIME.toString())) {
                    if (!rs.getMetaData().getColumnName(i).startsWith("hora")) continue;
                    info.getDados().put(rs.getMetaData().getColumnName(i), rs.getTime(rs.getMetaData().getColumnName(i)));
                    continue;
                }
                if (tipoDado.equalsIgnoreCase(TipoDadoBanco.TIMESTAMP.toString())) {
                    info.getDados().put(rs.getMetaData().getColumnName(i), Funcoes.formataDataEHora(rs.getString(rs.getMetaData().getColumnName(i))));
                    continue;
                }
                if (rs.getMetaData().getColumnName(i).equalsIgnoreCase("situacaoExameRequisicao")) {
                    info.getDados().put(rs.getMetaData().getColumnName(i), Tipos.tipoSituacaoExame(rs.getString(rs.getMetaData().getColumnName(i))));
                    continue;
                }
                info.getDados().put(rs.getMetaData().getColumnName(i), rs.getString(rs.getMetaData().getColumnName(i)));
            }
            listDados.add(info);
        }
        return listDados;
    }

    private String getTipoDado(int columnType) {
        String tipo = "";
        for (TipoDadoBanco tipoDado : TipoDadoBanco.values()) {
            if (columnType != tipoDado.getCodigo()) continue;
            tipo = tipoDado.getDescricao();
        }
        return tipo;
    }

    public String gerarModeloRelatorio() throws SQLException {
        String codigoRelatorio = "";
        StringBuilder buf = new StringBuilder();
        buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
        if (Boolean.valueOf(this.getFiltroApresentarHistorico().toString()).booleanValue()) {
            buf.append(RelatorioRequisicoesRecoleta.getModuloAcessoHistoricoRecoleta());
        } else {
            buf.append(RelatorioRequisicoesRecoleta.getModuloAcesso());
        }
        ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
        if (rs.next()) {
            codigoRelatorio = rs.getString("rel_xml");
        }
        return codigoRelatorio;
    }

    private StringBuilder montaSQL() {
        String[] motivoRecoleta;
        String[] setor;
        String[] materialColeta;
        String[] exame;
        String[] convenio;
        String[] coleta;
        StringBuilder buf = new StringBuilder();
        buf.append("select ");
        if (Boolean.valueOf(this.getFiltroApresentarHistorico().toString()).booleanValue()) {
            buf.append(" ers.usr_codigo as usuarioRecoletaHistorico, ");
            buf.append(" ers_datahora as dataRecoletaHistorico, ");
            buf.append(" mr.mrc_descricao     as motivoRecoletaHistorico, ");
            buf.append(" ers_motivorecoleta   as justificativaRecoletaHistorico, ");
        }
        buf.append("null as quantidadeExamesRecoleta, null as quantidadeRequisicoesRecoleta,'' as codigoFilialCodigoRequisicao, a.req_codigo as codigoRequisicao, a.req_data as dataRequisicao, b.exr_dataentregaprev as dataEntregaExameRequisicao, ");
        buf.append("(a.req_codigo || b.exa_codigo) as codigoRequisicaoComCodigoExame, ");
        buf.append("b.exr_datamaterial as dataColetaExameRequisicao, a.req_dtfatura as dataFaturaRequisicao, ");
        buf.append("a.req_urgente as urgenteRequisicao, a.req_dataentregaprev as dataEntregaRequisicao,  ");
        buf.append("a.req_dclinicos as dadosClinicosRequisicao, a.req_notacaixa as notaCaixaRequisicao, ");
        buf.append("a.req_obs as observacaoRequisicao, a.req_totpago as totalPagoRequisicao, a.req_total as totalRequisicao, a.req_totaltaxa as totalTaxaRequisicao, ");
        buf.append("a.req_horaentregaprev as horaEntregaRequisicao, a.req_horafatura as horaFaturaRequisicao, ");
        buf.append("a.req_hora as horaRequisicao, a.req_gestante as gestanteRequisicao, a.req_dum as dumRequisicao, ");
        buf.append("a.req_matricula as matriculaRequisicao, a.req_anomes as anomesIdadeRequisicao, a.req_idade as idadeRequisicao, ");
        buf.append("a.req_avisarpaciente as avisarPacienteRequisicao, a.req_senhaweb as senhaWebRequisicao,  ");
        buf.append("a.req_titular as titularRequisicao, a.req_altura as alturaRequisicao, a.req_peso as pesoRequisicao,  ");
        buf.append("a.req_vlracrescimo as valorAcrescimoRequisicao, a.req_acrescimo as percentualAcrescimoRequisicao, ");
        buf.append("a.req_vlrdesconto as valorDescontoRequisicao, a.req_desconto as percentualDescontoRequisicao, ");
        buf.append("a.req_telacoleta as coletadoRequisicao, a.req_datarequisicao as dataAberturaRequisicao, ");
        buf.append("a.req_neonato as neonatoRequisicao, a.req_validadeguia as validadeGuiaRequisicao,  ");
        buf.append("a.req_guia as guiaRequisicao, a.req_imprimirseparado as imprimirSeparadoRequisicao, ");
        buf.append("a.req_quarto as quartoRequisicao, a.req_leito as leitoRequisicao,");
        buf.append("b.exr_motivorecoleta as motivoRecoleta, ");
        buf.append("ala.ala_codigo as codigoAla, ala.ala_descricao as descricaoAla,");
        buf.append("b.exr_situacao as situacaoExameRequisicao, b.exr_entrpara as entregueParaExameRequisicao,  ");
        buf.append("b.exr_dataassina as dataAssinaturaExameRequisicao, b.exr_datadigita as dataDigitacaoExameRequisicao, ");
        buf.append("b.exr_dataentreguerst as dataEntregueExameRequisicao, ");
        buf.append("b.exr_dataimpresso as dataImpressaoExameRequisicao, b.exr_datafatura as dataFaturaExameRequisicao, ");
        buf.append("calculaprecototalexamerequisicao(a.fil_codigo, a.con_codigo, a.req_codigo, b.exa_codigo, b.mco_codigo, true, false, true, b.exr_vlrchexame, b.exr_vlrch, b.exr_valorporte, b.exr_valorcusto, b.exr_valoruco, b.exr_vlrbalcaoconvenio, b.exr_datafatura IS NOT NULL OR b.usr_codfatura IS NOT NULL, b.exr_vlrmaterial, b.exr_vlrbalcaoconvenio, convenio.con_precosdiferenciados, convenio.con_reajuste, convenio.con_cobrmaterial, convenio.con_percpgtomaterial, convenio.con_percpgto, convenio.con_tpcalcfatu, convenio.con_tpcalcch, convenio.con_perguntarpercbalcao, convenio.con_acrescimo, convenio.con_bonus, convenio.tpe_codigo, convenio.con_acrescimoporte, convenio.con_acrescimouco, convenio.con_descontoporte, convenio.con_descontouco, convenio.con_valorch, ").append(ParametrosGerais.getCasasPrecoExame()).append(", ").append(ParametrosGerais.getArredondamentoPrecoExame().ordinal()).append(", ").append(ParametrosGerais.getPrecoMetodologia() ? "true" : "false").append(", b.met_codigo").append(") as valorTotalExameRequisicao, ");
        buf.append("calculaprecototalexamerequisicao(a.fil_codigo, a.con_codigo, a.req_codigo, b.exa_codigo, b.mco_codigo, false, true, true, b.exr_vlrchexame, b.exr_vlrch, b.exr_valorporte, b.exr_valorcusto, b.exr_valoruco, b.exr_vlrbalcaoconvenio, b.exr_datafatura IS NOT NULL OR b.usr_codfatura IS NOT NULL, b.exr_vlrmaterial, b.exr_vlrbalcaoconvenio, convenio.con_precosdiferenciados, convenio.con_reajuste, convenio.con_cobrmaterial, convenio.con_percpgtomaterial, convenio.con_percpgto, convenio.con_tpcalcfatu, convenio.con_tpcalcch, convenio.con_perguntarpercbalcao, convenio.con_acrescimo, convenio.con_bonus, convenio.tpe_codigo, convenio.con_acrescimoporte, convenio.con_acrescimouco, convenio.con_descontoporte, convenio.con_descontouco, convenio.con_valorch, ").append(ParametrosGerais.getCasasPrecoExame()).append(", ").append(ParametrosGerais.getArredondamentoPrecoExame().ordinal()).append(", ").append(ParametrosGerais.getPrecoMetodologia() ? "true" : "false").append(", b.met_codigo").append(") as valorFaturarExameRequisicao, ");
        buf.append("b.exr_vlrexame as valorExameExameRequisicao, ");
        buf.append("COALESCE(d.emc_custosimples,0.0) as valorCustoSimplesExameAtual, ");
        buf.append("COALESCE(b.exr_custosimples,0.0) as valorCustoSimplesExameHistorico, ");
        buf.append("b.exr_vlrchexame as valorCHExameExameRequisicaoOriginal, ");
        buf.append("calculachexamerequisicao(a.fil_codigo, a.con_codigo, a.req_codigo, b.exa_codigo, b.mco_codigo) as valorCHExameExameRequisicao, ");
        buf.append("b.exr_matexterno as materialExternoExameRequisicao, ");
        buf.append("b.exr_interfaciado as interfaceadoExameRequisicao, b.exr_lotereag as loteReagenteExameRequisicao,  ");
        buf.append("b.exr_quantreag as quantidadeReagenteExameRequisicao, ");
        buf.append("b.exr_vlrch as valorCHExameRequisicaoOriginal, ");
        buf.append("calculachconvenio(a.fil_codigo, a.con_codigo, a.req_codigo, b.exa_codigo, b.mco_codigo) as valorCHExameRequisicao, ");
        buf.append("b.exr_vlrmaterial as valorMaterialExameRequisicao, b.exr_vlrbalcaoconvenio as valorPagoBalcaoExameRequisicao, ");
        buf.append("b.exr_datamapa as dataImpressaoMapaExameRequisicao, b.exr_codautorizacao as codigoAutorizacaoExameRequisicao, ");
        buf.append("b.exr_data as dataInsercaoExameRequisicao, b.exr_obs as observacaoExameRequisicao, ");
        buf.append("b.exr_datacortesia as dataCortesiaExameRequisicao, b.exr_serialreag as serialReagenteExameRequisicao, ");
        buf.append("b.exr_autorizar as autorizarExameRequisicao,");
        buf.append("CASE WHEN b.exr_intervalojejum IS NULL THEN TO_CHAR(b.exr_tempojejum, 'HH24:MI') ELSE TO_CHAR(b.exr_intervalojejum, 'HH24:MI') END AS tempoJejumExameRequisicao, ");
        buf.append("b.exr_descricaomaterial as descricaoMaterialInformadoExameRequisicao, ");
        buf.append(" COALESCE(b.exr_avisarentrega, false) as avisarPacienteExameRequisicao, ");
        buf.append("coalesce(b.exr_urgente, false) as urgenteExameRequisicao, ");
        buf.append("a.req_complementodestino as complementoDestinoRequisicao, ");
        buf.append("a.req_codcopia as codigoCopiaRequisicao, ");
        buf.append("paciente.pac_codigo as codigoPaciente, paciente.pac_nome as nomePaciente, paciente.pac_nomesocial as nomeSocialPaciente, ");
        buf.append("paciente.pac_datanasc as dataNascimentoPaciente, paciente.pac_sexo as sexoPaciente, ");
        buf.append("paciente.pac_vip as vipPaciente, paciente.pac_grpsangue as grupoSanguineoPaciente, ");
        buf.append("paciente.pac_fatorrh as fatorrhPaciente, paciente.pac_fatordu as fatorduPaciente, ");
        buf.append("paciente.pac_cor as corPaciente, paciente.pac_observ as observacaoPaciente, ");
        buf.append("paciente.pac_dadoclinico as dadosClinicosPaciente, paciente.pac_peso as pesoPaciente, ");
        buf.append("paciente.pac_altura as alturaPaciente, paciente.pac_matricconv as matriculaConvenioPaciente, ");
        buf.append("paciente.pac_titularconv as titularConvenioPaciente, paciente.pac_profissao as profissaoPaciente, ");
        buf.append("paciente.pac_fumante as fumantePaciente, paciente.pac_diabetico as diabeticoPaciente, ");
        buf.append("paciente.pac_rg as rgPaciente, paciente.pac_cpf as cpfPaciente, ");
        buf.append("paciente.pac_estcivil as estadoCivilPaciente, paciente.pac_numfilho as numeroFilhosPaciente, ");
        buf.append("paciente.pac_datahora as dataHoraCadastroPaciente, paciente.pac_dum as dumPaciente, ");
        buf.append("paciente.pac_fax as faxPaciente, paciente.pac_celular as celularPaciente, ");
        buf.append("paciente.pac_fonecomercial as foneComercialPaciente, paciente.pac_fone as fonePaciente, ");
        buf.append("paciente.pac_cep as cepPaciente, paciente.pac_complemento as complementoPaciente, ");
        buf.append("paciente.pac_endereco as enderecoPaciente, paciente.pac_numeroendereco as numeroEnderecoPaciente, paciente.pac_email as emailPaciente, ");
        buf.append("paciente.pac_tipologradouroendereco as tipoLogradouroPaciente, ");
        buf.append("paciente.pac_anomes as anomesIdadePaciente, paciente.pac_idade as idadePaciente, ");
        buf.append("paciente.pac_fonecontato as foneContatoPaciente, paciente.pac_nomecontato as contatoPaciente, ");
        buf.append("paciente.pac_mae as maePaciente, paciente.pac_pai as paiPaciente, ");
        buf.append("cidpaciente.cid_codigo as codigoCidadePaciente, cidpaciente.cid_nome as descricaoCidadePaciente, ");
        buf.append("cidpaciente.cid_uf as estadoCidadePaciente, ");
        buf.append("baipaciente.bai_codigo as codigoBairroPaciente, baipaciente.bai_descricao as descricaoBairroPaciente, ");
        buf.append("usrrequisicao.usr_codigo as codigoUsuarioRequisicao, usrrequisicao.usr_nome as nomeUsuarioRequisicao, ");
        buf.append("usrabertura.usr_codigo as codigoUsuarioAberturaRequisicao, usrabertura.usr_nome as nomeUsuarioAberturaRequisicao, ");
        buf.append("destino.des_codigo as codigoDestino, destino.des_descricao as descricaoDestino,  ");
        buf.append("destino.des_impressora as impressoraDestino, destino.des_naoimprimir as naoImprimirDestino,  ");
        buf.append("destino.des_cep as cepDestino, destino.des_complemento as complementoDestino, ");
        buf.append("destino.des_endereco as enderecoDestino, destino.des_fone as foneDestino, ");
        buf.append("destino.des_enviarweb as enviarWebDestino,  ");
        buf.append("ciddestino.cid_codigo as codigoCidadeDestino, ciddestino.cid_nome as descricaoCidadeDestino, ");
        buf.append("ciddestino.cid_uf as estadoCidadeDestino, ");
        buf.append("baidestino.bai_codigo as codigoBairroDestino, baidestino.bai_descricao as descricaoBairroDestino, ");
        buf.append("coleta.col_codigo as codigoColeta, coleta.col_descricao as descricaoColeta,  ");
        buf.append("coleta.col_cep as cepColeta, coleta.col_complemento as complementoColeta, ");
        buf.append("coleta.col_endereco as enderecoColeta, coleta.col_fone as foneColeta, ");
        buf.append("cidcoleta.cid_codigo as codigoCidadeColeta, cidcoleta.cid_nome as descricaoCidadeColeta, ");
        buf.append("cidcoleta.cid_uf as estadoCidadeColeta, ");
        buf.append("baicoleta.bai_codigo as codigoBairroColeta, baicoleta.bai_descricao as descricaoBairroColeta, ");
        buf.append("setor.set_codigo as codigoSetor, setor.set_descricao as descricaoSetor, ");
        buf.append("setor.set_responsavel as responsavelSetor, setor.set_sigla as siglaSetor, ");
        buf.append("setor.set_cor as corSetor,  ");
        buf.append("usrsetor.usr_codigo as codigoUsuarioSetor, usrsetor.usr_nome as nomeUsuarioSetor, ");
        buf.append("convenio.con_codigo as codigoConvenio, convenio.con_razao as razaoSocialConvenio,  ");
        buf.append("convenio.con_fantasia as fantasiaConvenio, convenio.con_cnpjcpf as cnpjConvenio,  ");
        buf.append("convenio.con_tppgto as tipoPagamentoConvenio, ");
        buf.append("convenio.con_fatfmaterial as faturarFaltaMaterialConvenio, convenio.con_descexame as habilitarDescontoConvenio,  ");
        buf.append("convenio.con_multa as multaConvenio,  ");
        buf.append("convenio.con_mora as moraConvenio, convenio.con_fatfiliais as faturarFiliaisConvenio, ");
        buf.append("convenio.con_nr1via as quantidade1ViaConvenio, convenio.con_nrexames as numeroExamesConvenio,  ");
        buf.append("convenio.con_viasfatura as viasFaturaConvenio, convenio.con_impbloqueto as imprimirBloquetoConvenio,  ");
        buf.append("convenio.con_nr2via as quantidade2ViaConvenio, convenio.con_tpcalcfatu as tipoCalculoFaturaConvenio,  ");
        buf.append("convenio.con_percpgto as percentualBalcaoConvenio, convenio.con_cobrexame as cobrarExameBalcaoConvenio, ");
        buf.append("convenio.con_inscrest as inscricaoEstadualConvenio, convenio.con_titdep as titularDependenteConvenio, ");
        buf.append("convenio.con_maskcart as mascaraCarteiraConvenio, convenio.con_contato as contatoConvenio, ");
        buf.append("convenio.con_informarmat as obrigaMatriculaConvenio, convenio.con_cep as cepConvenio,  ");
        buf.append("convenio.con_complemento as complementoConvenio, convenio.con_endereco as enderecoConvenio,  ");
        buf.append("convenio.con_cepcobranca as cepCobrancaConvenio, convenio.con_complcobranca as complementoCobrancaConvenio,  ");
        buf.append("convenio.con_endcobranca as enderecoCobrancaConvenio, convenio.con_fax as faxConvenio, ");
        buf.append("convenio.con_numeroendereco as numeroEnderecoConvenio, convenio.con_numeroendcobranca as numeroEnderecoCobrancaConvenio, ");
        buf.append("convenio.con_tipologradouroendereco as tipoLogradouroConvenio, convenio.con_tipologradouroendcobranca tipoLogradouroCobrancaConvenio, ");
        buf.append("convenio.con_fone as foneConvenio, convenio.con_valorfilme as valorFilmeConvenio,  ");
        buf.append("convenio.con_valorch as valorCHConvenio, convenio.con_site as siteConvenio, ");
        buf.append("convenio.con_email2 as email2Convenio, convenio.con_email1 as email1Convenio,  ");
        buf.append("convenio.con_tpcalcch as tipoCalculoCHConvenio, convenio.con_inscmunic as inscricaoMunicipalConvenio,  ");
        buf.append("convenio.con_bonus as percentualBonusConvenio, convenio.con_senhaweb as senhaWebConvenio,  ");
        buf.append("convenio.con_acrescimo as percentualAcrescimoConvenio, ");
        buf.append("convenio.con_proibidoweb as proibidoWebConvenio, convenio.con_validadeguia as obrigaValidadeGuiaConvenio,  ");
        buf.append("convenio.con_codigoguia as obrigaGuiaConvenio, convenio.con_diasvalidade as diasValidadeGuia,  ");
        buf.append("convenio.con_ordemfatura as ordemFaturaConvenio, convenio.con_cobrmaterial as cobrarMateriaisConvenio, ");
        buf.append("prioridade.pri_codigo as codigoPrioridade, prioridade.pri_descricao as descricaoPrioridade, ");
        buf.append("tabela.tpe_codigo as codigoTabela, tabela.tpe_descricao as descricaoTabela,  ");
        buf.append("tabela.tpe_valorch as valorCHTabela, tabela.tpe_moeda as moedaTabela, ");
        buf.append("cidconvenio.cid_codigo as codigoCidadeConvenio, cidconvenio.cid_nome as descricaoCidadeConvenio,  ");
        buf.append("cidconvenio.cid_uf as estadoCidadeConvenio, ");
        buf.append("baiconvenio.bai_codigo as codigoBairroConvenio, baiconvenio.bai_descricao as descricaoBairroConvenio, ");
        buf.append("medico.med_conselho as conselhoMedico, medico.med_crm as crmMedico, medico.med_uf as ufMedico, medico.med_nome as nomeMedico,  ");
        buf.append("medico.med_abrev as abreviaturaMedico, ");
        buf.append("medico.med_tipo as tipoMedico,  ");
        buf.append("medico.med_comissao as comissaoMedico, medico.med_cep as cepMedico, medico.med_complemento as complementoMedico,  ");
        buf.append("medico.med_endereco as enderecoMedico, medico.med_celular as celularMedico, medico.med_fax as faxMedico,  ");
        buf.append("medico.med_numeroendereco as numeroEnderecoMedico, medico.med_tipologradouroendereco as tipoLogradouroMedico, ");
        buf.append("medico.med_fone as foneMedico, medico.med_email as emailMedico, medico.med_site as siteMedico, medico.med_senhaweb as senhaWebMedico, ");
        buf.append("cidmedico.cid_codigo as codigoCidadeMedico, cidmedico.cid_nome as descricaoCidadeMedico, cidmedico.cid_uf as estadoCidadeMedico,  ");
        buf.append("baimedico.bai_codigo as codigoBairroMedico, baimedico.bai_descricao as descricaoBairroMedico, ");
        buf.append("usrassina.usr_codigo as codigoUsuarioAssina, usrassina.usr_nome as nomeUsuarioAssina, ");
        buf.append("usrdigitador.usr_codigo as codigoUsuarioDigitador, usrdigitador.usr_nome as nomeUsuarioDigitador, ");
        buf.append("usrmaterial.usr_codigo as codigoUsuarioMaterial, usrmaterial.usr_nome as nomeUsuarioMaterial, ");
        buf.append("usrfatura.usr_codigo as codigoUsuarioFatura, usrFatura.usr_nome as nomeUsuarioFatura, ");
        buf.append("usrentrega.usr_codigo as codigoUsuarioEntrega, usrentrega.usr_nome as nomeUsuarioEntrega, ");
        buf.append("usrimpressao.usr_codigo as codigoUsuarioImpressao, usrimpressao.usr_nome as nomeUsuarioImpressao, ");
        buf.append("usrexame.usr_codigo as codigoUsuarioExame, usrexame.usr_nome as nomeUsuarioExame, ");
        buf.append("usrcortesia.usr_codigo as codigoUsuarioCortesia, usrcortesia.usr_nome as nomeUsuarioCortesia, ");
        buf.append("c.exa_codigo as codigoExame, c.exa_descricao as descricaoExame, c.exa_sexo as sexoExame,  ");
        buf.append("c.exa_horaentrada as horaEntradaExame, c.exa_horasaida as horaSaidaExame, ");
        buf.append("c.exa_filtro as filtroPesquisaExame, c.exa_proibido as proibidoExame, ");
        buf.append("c.exa_idademax as idadeMaximaExame, c.exa_idademin as idadeMinimaExame, ");
        buf.append("c.exa_idademaxtipo as tipoIdadeMaximaExame, c.exa_idademintipo as tipoIdadeMinimaExame, ");
        buf.append("c.exa_proibidoweb as proibidoWebExame, c.exa_qtdeamostras as quantidadeAmostrasExame, ");
        buf.append("d.emc_default as padraoExame, d.emc_ordem as ordemExame,  ");
        buf.append("d.emc_pagina as paginaExame, d.emc_codigocbhpm as codigoCBHPMExame, ");
        buf.append("d.emc_codigoamb as codigoAMBExame, d.emc_solicitarjejum as solicitarJejumExame, ");
        buf.append("d.emc_obrigamedicamento as solicitarMedicamentoExame,  ");
        buf.append("d.emc_obrigadum as solicitarDUMExame,  ");
        buf.append("d.emc_obrigapeso as solicitarPesoExame, ");
        buf.append("d.emc_obrigaaltura as solicitarAlturaExame, ");
        buf.append("d.emc_obrigavolume as solicitarVolumeExame, ");
        buf.append("d.emc_obrigatempodiurese as solicitarTempoDiureseExame, ");
        buf.append("d.emc_marcarexterno as marcarExternoExame, ");
        buf.append("coletado.mco_codigo as codigoMaterialColetado, coletado.mco_descricao as descricaoMaterialColetado, ");
        buf.append("coletado.mco_abreviatura as abreviaturaMaterialColetado, ");
        buf.append("prazo.prz_codigo as codigoPrazoEntrega, prazo.prz_descricao as descricaoPrazoEntrega, ");
        buf.append("prazo.prz_dias as diasPrazoEntrega, prazo.prz_horaentrada as horaEntradaPrazoEntrega, ");
        buf.append("prazo.prz_horasaida as horaSaidaPrazoEntrega, prazo.prz_prazo as rotinaPrazoEntrega, ");
        buf.append("metodologia.met_codigo as codigoMetodologia, metodologia.met_descricao as descricaoMetodologia, ");
        buf.append("a.est_codigo as codigoEstacao, estacoes.est_descricao as descricaoEstacao, ");
        buf.append("idg.ige_descricao as generoPaciente, ");
        buf.append("a.req_descricaoproduto as descricaoProdutoRequisicao, ");
        buf.append("a.req_datafabricacao as dataFabricacaoProdutoRequisicao, ");
        buf.append("a.req_numeroregistroproduto as numeroRegistroProdutoRequisicao, ");
        buf.append("a.req_temperaturacoletaproduto as temperaturaColetaProdutoRequisicao, ");
        buf.append("a.req_numeroloteproduto as numeroLoteProdutoRequisicao, ");
        buf.append("a.req_datavalidade as dataValidadeProdutoRequisicao, ");
        buf.append("a.req_marcaproduto as marcaProdutoRequisicao, ");
        buf.append("a.req_lacreproduto as lacreProdutoRequisicao, ");
        buf.append("a.req_lacreprodutocontra as lacreContraProvaProdutoRequisicao, ");
        buf.append("a.req_lacreprodutocontraempresa as lacreContraProvaEmpresaProdutoRequisicao, ");
        buf.append("a.req_doctoreferenciaproduto as documentoReferenciaProdutoRequisicao, ");
        buf.append("a.req_temperaturarecebimento as temperaturaRecebimentoProdutoRequisicao, ");
        buf.append("a.req_sanitariasproduto as caracteristicasSanitariasProdutoRequisicao, ");
        buf.append("a.req_condicoesambproduto as condicoesAmbientaisProdutoRequisicao, ");
        buf.append("a.req_procedimentocoletaproduto as procedimentoColetaProdutoRequisicao, ");
        buf.append("a.req_tiporecebimentoproduto as tipoRecebimentoProdutoRequisicao, ");
        buf.append("a.req_partidaproduto as partidaProdutoRequisicao, ");
        buf.append("a.req_qtdeamostraproduto as qtdeAmostrasProdutoRequisicao, ");
        buf.append("a.req_qtdeunidadeproduto as qtdeUnidadeProdutoRequisicao, ");
        buf.append("a.unm_codigo as codigoUnidadeProdutoRequisicao, ");
        buf.append("unidademedida.unm_descricao as descricaoUnidadeProdutoRequisicao, ");
        buf.append("a.emb_codigo as codigoEmbalagemProdutoRequisicao, ");
        buf.append("emb.emb_descricao as descricaoEmbalagemProdutoRequisicao, ");
        buf.append("paccontatos.pco_nome as nomeResponsavelRequisicao_, ");
        buf.append("paccontatos.pco_cargo as cargoResponsavelRequisicao_, ");
        buf.append("paccontatos.pco_email as emailResponsavelRequisicao_, ");
        buf.append("paccontatos.pco_fone as foneResponsavelRequisicao_, ");
        buf.append("ent.ent_fantasia as nomeResponsavelRequisicao, ");
        buf.append("ent.ent_cargo as cargoResponsavelRequisicao, ");
        buf.append("ent.ent_email as emailResponsavelRequisicao, ");
        buf.append("ent.ent_fone as foneResponsavelRequisicao, ");
        buf.append("paciente.bai_codigocobranca as codigoBairroCobrancaPaciente, ");
        buf.append("baicobranca.bai_descricao as descricaoBairroCobrancaPaciente, ");
        buf.append("paciente.cid_codigocobranca as codigoCidadeCobrancaPaciente, ");
        buf.append("cidcobranca.cid_nome as descricaoCidadeCobrancaPaciente, ");
        buf.append("cidcobranca.cid_uf as estadoCidadeCobrancaPaciente, ");
        buf.append("paciente.pac_razaosocial as razaoSocialPaciente, ");
        buf.append("paciente.pac_cnpj as cnpjPaciente, ");
        buf.append("paciente.pac_ie as inscricaoEstadualPaciente, ");
        buf.append("paciente.pac_proprietario as proprietarioPaciente, ");
        buf.append("paciente.pac_sif as sifPaciente, ");
        buf.append("paciente.pac_enderecocobranca as enderecoCobrancaPaciente, ");
        buf.append("paciente.pac_numeroenderecocobranca as numeroEnderecoCobrancaPaciente, ");
        buf.append("paciente.pac_tipologradouroendcobranca as tipoLogradouroCobrancaPaciente, ");
        buf.append("paciente.pac_complementocobranca as complementoCobrancaPaciente, ");
        buf.append("paciente.pac_cepcobranca as cepCobrancaPaciente, ");
        buf.append("paciente.pac_fonecobranca as foneCobrancaPaciente, ");
        buf.append("paciente.pac_responsavelcobranca as responsavelCobrancaPaciente, ");
        buf.append("mr.mrc_descricao as descricaoMotivoRecoleta, ");
        buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
        buf.append("from requisicao a ");
        buf.append("\t\t join examerequisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo ");
        buf.append("\t\t join exames c on b.fil_codigo = c.fil_codigo and b.exa_codigo = c.exa_codigo ");
        buf.append("\t\t join paciente on a.fil_codigo = paciente.fil_codigo and a.pac_codigo = paciente.pac_codigo ");
        buf.append("\t\t join usuario usrrequisicao on a.usr_codigo = usrrequisicao.usr_codigo ");
        buf.append("\t\t join convenios convenio on a.fil_codigo = convenio.fil_codigo and a.con_codigo = convenio.con_codigo ");
        buf.append("\t\t join tabelaprecoexames tabela on convenio.fil_codigo = tabela.fil_codigo and convenio.tpe_codigo = tabela.tpe_codigo ");
        buf.append("\t\t join medico on a.fil_codigo = medico.fil_codigo and a.med_conselho = medico.med_conselho and a.med_crm = medico.med_crm and a.med_uf = medico.med_uf ");
        buf.append("\t\t join cidades cidconvenio on convenio.fil_codigo = cidconvenio.fil_codigo and convenio.cid_codigo = cidconvenio.cid_codigo ");
        buf.append("\t\t join examematcoleta d on b.fil_codigo = d.fil_codigo and b.exa_codigo = d.exa_codigo and b.mco_codigo = d.mco_codigo ");
        buf.append("\t\t join materialcoleta coletado on d.fil_codigo = coletado.fil_codigo and d.mco_codigo = coletado.mco_codigo ");
        buf.append("left join prioridade on convenio.fil_codigo = prioridade.fil_codigo and convenio.pri_codigo = prioridade.pri_codigo ");
        buf.append("left join estacoes on a.est_codigo = estacoes.est_codigo ");
        buf.append("left join usuario usrassina on b.usr_codassina = usrassina.usr_codigo ");
        buf.append("left join usuario usrdigitador on b.usr_coddigitador = usrdigitador.usr_codigo ");
        buf.append("left join usuario usrmaterial on b.usr_codmaterial = usrmaterial.usr_codigo ");
        buf.append("left join usuario usrfatura on b.usr_codfatura = usrfatura.usr_codigo ");
        buf.append("left join usuario usrentrega on b.usr_codentrega = usrentrega.usr_codigo ");
        buf.append("left join usuario usrimpressao on b.usr_codimpressao = usrimpressao.usr_codigo ");
        buf.append("left join usuario usrexame on b.usr_codigo = usrexame.usr_codigo ");
        buf.append("left join usuario usrcortesia on b.usr_codcortesia = usrcortesia.usr_codigo ");
        buf.append("left join usuario usrabertura on a.usr_codabertura = usrabertura.usr_codigo ");
        buf.append("left join destino on a.fil_codigo = destino.fil_codigo and a.des_codigo = destino.des_codigo ");
        buf.append("left join bairro baidestino on destino.fil_codigo = baidestino.fil_codigo and destino.bai_codigo = baidestino.bai_codigo ");
        buf.append("left join cidades ciddestino on destino.fil_codigo = ciddestino.fil_codigo and destino.cid_codigo = ciddestino.cid_codigo ");
        buf.append("left join coletas coleta on a.fil_codigo = coleta.fil_codigo and a.col_codigo = coleta.col_codigo ");
        buf.append("left join bairro baicoleta on coleta.fil_codigo = baicoleta.fil_codigo and coleta.bai_codigo = baicoleta.bai_codigo ");
        buf.append("left join cidades cidcoleta on coleta.fil_codigo = cidcoleta.fil_codigo and coleta.cid_codigo = cidcoleta.cid_codigo ");
        buf.append("left join embalagemproduto emb on a.fil_codigo = emb.fil_codigo and a.emb_codigo = emb.emb_codigo ");
        buf.append("left join entidade ent on a.fil_codigo = ent.fil_codigo and a.ent_codigo = ent.ent_codigo ");
        buf.append("left join examesetor e on b.fil_codigo = e.fil_codigo and b.exa_codigo = e.exa_codigo and e.ese_default = true ");
        buf.append("left join setores setor on e.fil_codigo = setor.fil_codigo and e.set_codigo = setor.set_codigo ");
        buf.append("left join usuario usrsetor on setor.usr_codigo = usrsetor.usr_codigo ");
        buf.append("left join metodologia on d.fil_codigo = metodologia.fil_codigo and d.met_codigo = metodologia.met_codigo ");
        buf.append("left join prazoentrega prazo on d.fil_codigo = prazo.fil_codigo and d.prz_codigo = prazo.prz_codigo ");
        buf.append("left join bairro baiconvenio on convenio.fil_codigo = baiconvenio.fil_codigo and convenio.bai_codigo = baiconvenio.bai_codigo ");
        buf.append("left join pacientescontatos paccontatos on a.fil_codigo = paccontatos.fil_codigo and a.pac_codigo = paccontatos.pac_codigo and a.pco_codigo = paccontatos.pco_codigo ");
        buf.append("left join cidades cidcobranca on paciente.fil_codigo = cidcobranca.fil_codigo and paciente.cid_codigocobranca = cidcobranca.cid_codigo ");
        buf.append("left join bairro baicobranca on paciente.fil_codigo = baicobranca.fil_codigo and paciente.bai_codigocobranca = baicobranca.bai_codigo ");
        buf.append("left join cidades cidpaciente on paciente.fil_codigo = cidpaciente.fil_codigo and paciente.cid_codigo = cidpaciente.cid_codigo ");
        buf.append("left join bairro baipaciente on paciente.fil_codigo = baipaciente.fil_codigo and paciente.bai_codigo = baipaciente.bai_codigo ");
        buf.append("left join cidades cidmedico on medico.fil_codigo = cidmedico.fil_codigo and medico.cid_codigo = cidmedico.cid_codigo ");
        buf.append("left join bairro baimedico on medico.fil_codigo = baimedico.fil_codigo and medico.bai_codigo = baimedico.bai_codigo ");
        buf.append("left join alahospital ala on a.fil_codigo = ala.fil_codigo and a.ala_codigo = ala.ala_codigo ");
        buf.append("left join unidademedida on a.fil_codigo = unidademedida.fil_codigo and a.unm_codigo = unidademedida.unm_codigo ");
        buf.append("left join identidadegenero idg on coalesce(paciente.pac_genero, 0) = idg.ige_codigo ");
        if (Boolean.valueOf(this.getFiltroApresentarHistorico().toString()).booleanValue()) {
            buf.append("left join examerequisicaosituacoes ers on b.fil_codigo = ers.fil_codigo and b.exa_codigo = ers.exa_codigo and b.mco_codigo = ers.mco_codigo and b.req_codigo = ers.req_codigo and ers.ers_situacao = 'R' ");
            buf.append("left join motivorecoleta mr on ers.fil_codigo = mr.fil_codigo and ers.mrc_codigo = mr.mrc_codigo ");
        } else {
            buf.append("left join motivorecoleta mr on d.fil_codigo = mr.fil_codigo and b.mrc_codigo = mr.mrc_codigo ");
        }
        buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
        String[] filiais = this.getFiltroFiliais();
        if (filiais == null) {
            filiais = new String[]{Variaveis.filialPadrao};
        }
        buf.append("where a.fil_codigo in (");
        for (int i = 0; i < filiais.length; ++i) {
            buf.append(filiais[i]);
            if (i >= filiais.length - 1) continue;
            buf.append(", ");
        }
        buf.append(") ");
        String[] destino = this.getFiltroDestinos();
        if (destino != null) {
            buf.append(" and a.des_codigo in (");
            for (int i = 0; i < destino.length; ++i) {
                buf.append(StringUtil.textoDBEscape(destino[i]));
                if (i >= destino.length - 1) continue;
                buf.append(", ");
            }
            buf.append(")");
        }
        if ((coleta = this.getFiltroColetas()) != null) {
            buf.append(" and a.col_codigo in (");
            for (int i = 0; i < coleta.length; ++i) {
                buf.append(StringUtil.textoDBEscape(coleta[i]));
                if (i >= coleta.length - 1) continue;
                buf.append(", ");
            }
            buf.append(")");
        }
        if ((convenio = this.getFiltroConvenios()) != null) {
            buf.append(" and a.con_codigo in (");
            for (int i = 0; i < convenio.length; ++i) {
                buf.append(convenio[i]);
                if (i >= convenio.length - 1) continue;
                buf.append(", ");
            }
            buf.append(")");
        }
        String[] conselho = this.getConselhos();
        String[] crm = this.getCrms();
        String[] uf = this.getUfs();
        if (conselho != null && crm != null && uf != null && crm.length <= ParametrosGerais.getQuantidadeMaximoFiltroAvancado()) {
            buf.append(" and (");
            for (int i = 0; i < crm.length; ++i) {
                buf.append("(a.med_conselho = '");
                buf.append(conselho[i]);
                buf.append("' and a.med_crm = '");
                buf.append(crm[i]);
                buf.append("' and a.med_uf = '");
                buf.append(uf[i]);
                buf.append("')");
                if (i >= crm.length - 1) continue;
                buf.append(" or ");
            }
            buf.append(")");
        }
        if ((exame = this.getFiltroExames()) != null) {
            buf.append(" and b.exa_codigo in (");
            for (int i = 0; i < exame.length; ++i) {
                buf.append("'");
                buf.append(exame[i]);
                buf.append("'");
                if (i >= exame.length - 1) continue;
                buf.append(", ");
            }
            buf.append(")");
        }
        if ((materialColeta = this.getFiltroMateriais()) != null) {
            buf.append(" and b.mco_codigo in (");
            for (int i = 0; i < materialColeta.length; ++i) {
                buf.append("'");
                buf.append(materialColeta[i]);
                buf.append("'");
                if (i >= materialColeta.length - 1) continue;
                buf.append(", ");
            }
            buf.append(")");
        }
        if ((setor = this.getFiltroSetores()) != null) {
            buf.append(" and e.set_codigo in (");
            for (int i = 0; i < setor.length; ++i) {
                buf.append(setor[i]);
                if (i >= setor.length - 1) continue;
                buf.append(", ");
            }
            buf.append(")");
        }
        if ((motivoRecoleta = this.getFiltroMotivoRecoleta()) != null) {
            buf.append(" and mr.mrc_codigo in (");
            for (int i = 0; i < motivoRecoleta.length; ++i) {
                buf.append(motivoRecoleta[i]);
                if (i >= motivoRecoleta.length - 1) continue;
                buf.append(", ");
            }
            buf.append(")");
        }
        buf.append(" and b.exr_datarecoleta IS NOT NULL ");
        if (Boolean.valueOf(this.getFiltroIntervaloHora().toString()).booleanValue()) {
            String campoData = " cast(b.exr_datarecoleta as date) ";
            String campoHora = " cast(b.exr_datarecoleta as time) ";
            if (Funcoes.verificaData(this.getDataInicial())) {
                buf.append(" and ").append(campoData).append(" >= '");
                buf.append(Funcoes.formataData("yyyy-MM-dd", this.getDataInicial()));
                buf.append("'");
            }
            if (Funcoes.verificaData(this.getDataFinal())) {
                buf.append(" and ").append(campoData).append(" <= '");
                buf.append(Funcoes.formataData("yyyy-MM-dd", this.getDataFinal()));
                buf.append("'");
            }
            if (Funcoes.verificaHora(this.getHoraInicial())) {
                buf.append(" and ").append(campoHora).append(" >= '");
                buf.append(this.getHoraInicial());
                buf.append("'");
            }
            if (Funcoes.verificaHora(this.getHoraFinal())) {
                buf.append(" and ").append(campoHora).append(" <= '");
                buf.append(this.getHoraFinal());
                buf.append("'");
            }
        } else {
            String campoData = " b.exr_datarecoleta ";
            buf.append(" and (").append(campoData).append(" >= '");
            buf.append(Funcoes.formataData("yyyy-MM-dd", this.getDataInicial()));
            buf.append(" ");
            buf.append(!Funcoes.textoVazio(this.getHoraInicial()) ? this.getHoraInicial() : "00:00:00");
            buf.append("') ");
            if (!Funcoes.textoVazio(this.getDataFinal())) {
                buf.append(" and (").append(campoData).append(" <= '");
                buf.append(Funcoes.formataData("yyyy-MM-dd", this.getDataFinal()));
                buf.append(" ");
                buf.append(!Funcoes.textoVazio(this.getHoraFinal()) ? this.getHoraFinal() : "23:59:59");
                buf.append("')");
            }
        }
        buf.append(" and a.req_excluida = false and b.exr_excluido = false ");
        buf.append(" order by ");
        buf.append(" a.fil_codigo ");
        if (this.getFiltroOrdem().equals(ORDEM_CODIGO)) {
            buf.append(" ,a.req_codigo ");
        } else {
            buf.append(" ,upper(paciente.pac_nome)");
            buf.append(" ,a.req_codigo ");
        }
        buf.append("   , b.exa_codigo ");
        if (Boolean.valueOf(this.getFiltroApresentarHistorico().toString()).booleanValue()) {
            buf.append("  , ers.ers_datahora");
        }
        return buf;
    }

    public String[] getFiltroFiliais() {
        return this.filtroFiliais;
    }

    public void setFiltroFiliais(String[] filtroFiliais) {
        this.filtroFiliais = filtroFiliais;
    }

    public String[] getFiltroDestinos() {
        return this.filtroDestinos;
    }

    public void setFiltroDestinos(String[] filtroDestinos) {
        this.filtroDestinos = filtroDestinos;
    }

    public String[] getFiltroColetas() {
        return this.filtroColetas;
    }

    public void setFiltroColetas(String[] filtroColetas) {
        this.filtroColetas = filtroColetas;
    }

    public String[] getFiltroConvenios() {
        return this.filtroConvenios;
    }

    public void setFiltroConvenios(String[] filtroConvenios) {
        this.filtroConvenios = filtroConvenios;
    }

    public String[] getFiltroMedicos() {
        return this.filtroMedicos;
    }

    public void setFiltroMedicos(String[] filtroMedicos) {
        this.filtroMedicos = filtroMedicos;
    }

    public String[] getConselhos() {
        return this.conselhos;
    }

    public void setConselhos(String[] conselhos) {
        this.conselhos = conselhos;
    }

    public String[] getUfs() {
        return this.ufs;
    }

    public void setUfs(String[] ufs) {
        this.ufs = ufs;
    }

    public String[] getCrms() {
        return this.crms;
    }

    public void setCrms(String[] crms) {
        this.crms = crms;
    }

    public String[] getFiltroExames() {
        return this.filtroExames;
    }

    public void setFiltroExames(String[] filtroExames) {
        this.filtroExames = filtroExames;
    }

    public String[] getFiltroMateriais() {
        return this.filtroMateriais;
    }

    public void setFiltroMateriais(String[] filtroMateriais) {
        this.filtroMateriais = filtroMateriais;
    }

    public String[] getFiltroSetores() {
        return this.filtroSetores;
    }

    public void setFiltroSetores(String[] filtroSetores) {
        this.filtroSetores = filtroSetores;
    }

    public String[] getFiltroMotivoRecoleta() {
        return this.filtroMotivoRecoleta;
    }

    public void setFiltroMotivoRecoleta(String[] filtroMotivoRecoleta) {
        this.filtroMotivoRecoleta = filtroMotivoRecoleta;
    }

    public String getDataFinal() {
        return this.dataFinal;
    }

    public void setDataFinal(String dataFinal) {
        this.dataFinal = dataFinal;
    }

    public String getDataInicial() {
        return this.dataInicial;
    }

    public void setDataInicial(String dataInicial) {
        this.dataInicial = dataInicial;
    }

    public String getHoraInicial() {
        return this.horaInicial;
    }

    public void setHoraInicial(String horaInicial) {
        this.horaInicial = horaInicial;
    }

    public String getHoraFinal() {
        return this.horaFinal;
    }

    public void setHoraFinal(String horaFinal) {
        this.horaFinal = horaFinal;
    }

    public Object getFiltroIntervaloHora() {
        return this.filtroIntervaloHora;
    }

    public void setFiltroIntervaloHora(Object filtroIntervaloHora) {
        this.filtroIntervaloHora = filtroIntervaloHora;
    }

    public Object getFiltroApresentarHistorico() {
        return this.filtroApresentarHistorico;
    }

    public void setFiltroApresentarHistorico(Object filtroApresentarHistorico) {
        this.filtroApresentarHistorico = filtroApresentarHistorico;
    }

    public Object getFiltroOrdem() {
        return this.filtroOrdem;
    }

    public void setFiltroOrdem(Object filtroOrdem) {
        this.filtroOrdem = filtroOrdem;
    }
}

