/*
 * Decompiled with CFR 0.152.
 */
package jalis.model.dao.relatorio;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.gerador.Relatorio;
import jalis.service.cadastro.exame.MetodologiaService;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.StringUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class RelatorioExamesOperadoraSaudeDAO {
    private static HashMap<String, String> camposUtilizados = new HashMap();
    private static String LIGACOES = "";

    public ModeloGridTable getConsultaRelatorio(String[] operadoras, String[] exames, String[] metodos, String[] modelos, boolean isCheckSomenteNaoConfigurados, String filtroOrdem) throws SQLException {
        Statement st = Conexao.getStatement();
        LIGACOES = this.getSelect(operadoras, exames, metodos, modelos, isCheckSomenteNaoConfigurados, filtroOrdem);
        StringBuilder sqlFinal = new StringBuilder();
        sqlFinal.append(" select ");
        sqlFinal.append(Relatorio.getFieldsSelect(camposUtilizados));
        sqlFinal.append(LIGACOES);
        ResultSet rs = Conexao.executeQuery(st, sqlFinal.toString());
        ModeloGridTable modelo = null;
        if (rs.next()) {
            String[] listaCamposUtilizados = new String[camposUtilizados.size()];
            Iterator<String> it = camposUtilizados.keySet().iterator();
            int i = 0;
            while (it.hasNext()) {
                listaCamposUtilizados[i] = it.next().toString();
                ++i;
            }
            modelo = new ModeloGridTable(listaCamposUtilizados);
            do {
                Object[] o = new Object[listaCamposUtilizados.length];
                for (int i2 = 0; i2 < listaCamposUtilizados.length; ++i2) {
                    String modeloDescricaoPadrao;
                    String opeDescricao = this.retornaDescricaoOperadoraSaude(rs.getString("descricaoOperadoraSaude"));
                    if (listaCamposUtilizados[i2].equalsIgnoreCase("codigoExame")) {
                        o[i2] = rs.getString("codigoExame");
                        continue;
                    }
                    if (listaCamposUtilizados[i2].equalsIgnoreCase("descricaoExame")) {
                        o[i2] = rs.getString("descricaoExame");
                        continue;
                    }
                    if (listaCamposUtilizados[i2].equalsIgnoreCase("codigoMaterialColeta")) {
                        o[i2] = rs.getString("codigoMaterialColeta");
                        continue;
                    }
                    if (listaCamposUtilizados[i2].equalsIgnoreCase("descricaoMaterialColeta")) {
                        o[i2] = rs.getString("descricaoMaterialColeta");
                        continue;
                    }
                    if (listaCamposUtilizados[i2].equalsIgnoreCase("abreviaturaMaterialColeta")) {
                        o[i2] = rs.getString("abreviaturaMaterialColeta");
                        continue;
                    }
                    if (listaCamposUtilizados[i2].equalsIgnoreCase("modeloCodigo")) {
                        o[i2] = rs.getString("modeloCodigo");
                        continue;
                    }
                    if (listaCamposUtilizados[i2].equalsIgnoreCase("modeloDescricao")) {
                        o[i2] = rs.getString("modeloDescricao");
                        continue;
                    }
                    if (listaCamposUtilizados[i2].equalsIgnoreCase("metodoCodigo")) {
                        o[i2] = rs.getString("metodoCodigo");
                        continue;
                    }
                    if (listaCamposUtilizados[i2].equalsIgnoreCase("metodoDescricao")) {
                        String metodologiaDescricao = new MetodologiaService().retornaDescricaoMetodologia(Variaveis.filialPadrao, rs.getString("codigoExame"), rs.getString("codigoMaterialColeta"), rs.getString("metodoCodigo"));
                        o[i2] = metodologiaDescricao;
                        continue;
                    }
                    if (listaCamposUtilizados[i2].equalsIgnoreCase("codigoFilial")) {
                        o[i2] = rs.getString("codigoFilial");
                        continue;
                    }
                    if (listaCamposUtilizados[i2].equalsIgnoreCase("descricaoFilial")) {
                        o[i2] = rs.getString("descricaoFilial");
                        continue;
                    }
                    if (listaCamposUtilizados[i2].equalsIgnoreCase("cnpjFilial")) {
                        o[i2] = rs.getString("cnpjFilial");
                        continue;
                    }
                    if (listaCamposUtilizados[i2].equalsIgnoreCase("enderecoFilial")) {
                        o[i2] = rs.getString("enderecoFilial");
                        continue;
                    }
                    if (listaCamposUtilizados[i2].equalsIgnoreCase("complementoFilial")) {
                        o[i2] = rs.getString("complementoFilial");
                        continue;
                    }
                    if (listaCamposUtilizados[i2].equalsIgnoreCase("cepFilial")) {
                        o[i2] = rs.getString("cepFilial");
                        continue;
                    }
                    if (listaCamposUtilizados[i2].equalsIgnoreCase("foneFilial")) {
                        o[i2] = rs.getString("foneFilial");
                        continue;
                    }
                    if (listaCamposUtilizados[i2].equalsIgnoreCase("faxFilial")) {
                        o[i2] = rs.getString("faxFilial");
                        continue;
                    }
                    if (listaCamposUtilizados[i2].equalsIgnoreCase("razaoSocialFilial")) {
                        o[i2] = rs.getString("razaoSocialFilial");
                        continue;
                    }
                    if (listaCamposUtilizados[i2].equalsIgnoreCase("CNESFilial")) {
                        o[i2] = rs.getString("CNESFilial");
                        continue;
                    }
                    if (listaCamposUtilizados[i2].equalsIgnoreCase("codigoCidadeFilial")) {
                        o[i2] = rs.getString("codigoCidadeFilial");
                        continue;
                    }
                    if (listaCamposUtilizados[i2].equalsIgnoreCase("descricaoCidadeFilial")) {
                        o[i2] = rs.getString("descricaoCidadeFilial");
                        continue;
                    }
                    if (listaCamposUtilizados[i2].equalsIgnoreCase("estadoCidadeFilial")) {
                        o[i2] = rs.getString("estadoCidadeFilial");
                        continue;
                    }
                    if (listaCamposUtilizados[i2].equalsIgnoreCase("codigoBairroFilial")) {
                        o[i2] = rs.getString("codigoBairroFilial");
                        continue;
                    }
                    if (listaCamposUtilizados[i2].equalsIgnoreCase("descricaoBairroFilial")) {
                        o[i2] = rs.getString("descricaoBairroFilial");
                        continue;
                    }
                    if (listaCamposUtilizados[i2].equalsIgnoreCase("codigoAgrupado")) {
                        o[i2] = rs.getString("codigoAgrupado");
                        continue;
                    }
                    if (listaCamposUtilizados[i2].equalsIgnoreCase("descricaoAbreviadaOperadora")) {
                        o[i2] = rs.getString("codigoAgrupado");
                        continue;
                    }
                    if (listaCamposUtilizados[i2].equalsIgnoreCase("descricaoOperadoraSaude") && !Funcoes.textoVazio(rs.getString("descricaoOperadoraSaude"))) {
                        o[i2] = opeDescricao;
                        continue;
                    }
                    if (listaCamposUtilizados[i2].equalsIgnoreCase("materialColetaPadraoExame") && !Funcoes.textoVazio(rs.getString("materialColetaPadraoExame"))) {
                        String materialDescricaoPadrao = this.getDescricaoMaterialPadrao(Variaveis.filialPadrao, rs.getString("codigoExame"), rs.getString("codigoMaterialColeta"), rs.getString("metodoPadraoExameMatColeta"));
                        o[i2] = materialDescricaoPadrao;
                        continue;
                    }
                    if (listaCamposUtilizados[i2].equalsIgnoreCase("metodoPadraoExameMatColeta") && !Funcoes.textoVazio(rs.getString("metodoPadraoExameMatColeta"))) {
                        String metodologiaDescricaoPadrao = new MetodologiaService().retornaDescricaoMetodologia(Variaveis.filialPadrao, rs.getString("codigoExame"), rs.getString("codigoMaterialColeta"), rs.getString("metodoPadraoExameMatColeta"));
                        o[i2] = metodologiaDescricaoPadrao;
                        continue;
                    }
                    if (!listaCamposUtilizados[i2].equalsIgnoreCase("modeloPadraoExameMatColeta") || Funcoes.textoVazio(rs.getString("modeloPadraoExameMatColeta")) || Funcoes.textoVazio(modeloDescricaoPadrao = this.getDescricaoModeloPadrao(Variaveis.filialPadrao, rs.getString("codigoExame"), rs.getString("codigoMaterialColeta"), rs.getString("modeloPadraoExameMatColeta")))) continue;
                    o[i2] = modeloDescricaoPadrao;
                }
                modelo.addLine(o);
            } while (rs.next());
        }
        return modelo;
    }

    public String getSelect(String[] operadoras, String[] exames, String[] metodos, String[] modelos, boolean isCheckSomenteNaoConfigurados, String filtroOrdem) {
        int i;
        StringBuilder sqlLigacao = new StringBuilder();
        camposUtilizados = new HashMap();
        camposUtilizados.put("codigoAgrupado", " CASE WHEN elm_exportartexto ILIKE '%integracaoibitinga%' THEN 'IBI' WHEN elm_exportartexto ILIKE '%integracaovtrp%' THEN 'VTRP' WHEN elm_exportartexto ILIKE '%integracaoupy%' THEN 'UPY' ELSE 'N\u00c3O CONFIGURADOS' END ");
        camposUtilizados.put("descricaoAbreviadaOperadora", "''");
        camposUtilizados.put("codigoExame", "a.exa_codigo");
        camposUtilizados.put("descricaoExame", "a.exa_descricao");
        camposUtilizados.put("codigoMaterialColeta", "e.mco_codigo");
        camposUtilizados.put("descricaoMaterialColeta", "e.mco_descricao");
        camposUtilizados.put("abreviaturaMaterialColeta", "e.mco_abreviatura");
        camposUtilizados.put("modeloCodigo", "lay.lay_codigo");
        camposUtilizados.put("modeloDescricao", "lay.lay_descricao");
        camposUtilizados.put("metodoCodigo", "exl.met_codigo");
        camposUtilizados.put("metodoDescricao", "''");
        camposUtilizados.put("descricaoOperadoraSaude", "exl.elm_exportartexto");
        camposUtilizados.put("codigoFilial", "filial.fil_codigo");
        camposUtilizados.put("descricaoFilial", "filial.fil_descricao");
        camposUtilizados.put("materialColetaPadraoExame", "b.emc_default");
        camposUtilizados.put("metodoPadraoExameMatColeta", "b.met_codigo");
        camposUtilizados.put("modeloPadraoExameMatColeta", "ela.lay_codigo");
        camposUtilizados.putAll(Constantes.MAPA_SELECT_FILIAL);
        sqlLigacao.append(" from exames a ");
        sqlLigacao.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
        sqlLigacao.append(" left join examematcoleta b on a.fil_codigo = b.fil_codigo and a.exa_codigo = b.exa_codigo ");
        sqlLigacao.append(" left join metodologia d on a.fil_codigo = d.fil_codigo and b.met_codigo = d.met_codigo ");
        sqlLigacao.append(" left join materialcoleta e on a.fil_codigo = e.fil_codigo  and b.mco_codigo = e.mco_codigo ");
        sqlLigacao.append(" left join examelayoutmetodo exl on b.fil_codigo = exl.fil_codigo and b.exa_codigo = exl.exa_codigo and b.mco_codigo = exl.mco_codigo ");
        sqlLigacao.append(" left join examelayout ela on exl.fil_codigo = ela.fil_codigo and exl.exa_codigo = ela.exa_codigo and exl.mco_codigo = ela.mco_codigo and ");
        sqlLigacao.append(" exl.lay_codigo = ela.lay_codigo and exl.ela_idadeini = ela.ela_idadeini and exl.ela_idadefim = ela.ela_idadefim and ");
        sqlLigacao.append(" exl.ela_idadeinitipo = ela.ela_idadeinitipo and exl.ela_idadefimtipo = ela.ela_idadefimtipo ");
        sqlLigacao.append(" left join layout lay on exl.fil_codigo = lay.fil_codigo and exl.lay_codigo = lay.lay_codigo ");
        sqlLigacao.append("where a.fil_codigo = ");
        sqlLigacao.append(Variaveis.filialPadrao);
        if (operadoras != null && !isCheckSomenteNaoConfigurados) {
            sqlLigacao.append(" and (");
            for (i = 0; i < operadoras.length; ++i) {
                String operadoraSelecionada = this.formataOperadora(operadoras[i]);
                if (Funcoes.textoVazio(operadoraSelecionada)) continue;
                sqlLigacao.append(" exl.elm_exportartexto ilike ").append("'%").append(operadoraSelecionada).append("%' ");
                if (i >= operadoras.length - 1) continue;
                sqlLigacao.append("or");
            }
            sqlLigacao.append(")");
        }
        if (exames != null) {
            sqlLigacao.append(" and a.exa_codigo in ('");
            for (i = 0; i < exames.length; ++i) {
                sqlLigacao.append(exames[i]).append("'");
                if (i >= exames.length - 1) continue;
                sqlLigacao.append(", '");
            }
            sqlLigacao.append(") ");
        }
        if (modelos != null) {
            sqlLigacao.append(" and lay.lay_codigo in (");
            for (i = 0; i < modelos.length; ++i) {
                sqlLigacao.append(modelos[i]);
                if (i >= modelos.length - 1) continue;
                sqlLigacao.append(", ");
            }
            sqlLigacao.append(") ");
        }
        if (metodos != null) {
            sqlLigacao.append(" and exl.met_codigo in (");
            for (i = 0; i < metodos.length; ++i) {
                sqlLigacao.append(metodos[i]);
                if (i >= metodos.length - 1) continue;
                sqlLigacao.append(", ");
            }
            sqlLigacao.append(") ");
        }
        if (isCheckSomenteNaoConfigurados) {
            sqlLigacao.append(" and exl.elm_exportartexto = '' ");
        }
        sqlLigacao.append("order by  codigoAgrupado, ");
        if (filtroOrdem.equals("C\u00f3digo")) {
            sqlLigacao.append(" a.exa_codigo ");
        } else if (filtroOrdem.equals("Descri\u00e7\u00e3o")) {
            sqlLigacao.append(" a.exa_descricao ");
        } else if (filtroOrdem.equals("Material")) {
            sqlLigacao.append(" e.mco_codigo ");
        } else if (filtroOrdem.equals("Modelo")) {
            sqlLigacao.append(" lay.lay_codigo ");
        }
        return sqlLigacao.toString();
    }

    private String formataOperadora(String operadora) {
        switch (operadora) {
            case "Unimed Ibitinga": {
                return "integracaoibitinga";
            }
            case "Unimed VTRP": {
                return "integracaovtrp";
            }
            case "UPY Lab": {
                return "integracaoupy";
            }
        }
        return "";
    }

    private String retornaDescricaoOperadoraSaude(String operadoraSql) {
        String operadoraSaude = "";
        String operadora = StringUtil.removerTagCompletaXML(operadoraSql, "linha", true);
        if (!Funcoes.textoVazio(operadora)) {
            operadora = operadora.replace("<", "").replace(">", ",").replace("/", "");
            String[] opes = operadora.split(",");
            ArrayList<String> operadorasSelecionadas = this.removerDuplicados(opes);
            for (int x = 0; x < operadorasSelecionadas.size(); ++x) {
                operadoraSaude = this.formataDescricaoOperadora(operadorasSelecionadas.get(x));
            }
        }
        return operadoraSaude;
    }

    public ArrayList<String> removerDuplicados(String[] operadoras) {
        ArrayList<String> temporario = new ArrayList<String>();
        for (String e : operadoras) {
            if (temporario.contains(e.trim()) || Funcoes.textoVazio(e)) continue;
            temporario.add(e.trim());
        }
        return temporario;
    }

    private String formataDescricaoOperadora(String operadora) {
        switch (operadora) {
            case "integracaoibitinga": {
                return "Unimed Ibitinga";
            }
            case "integracaovtrp": {
                return "Unimed VTRP";
            }
            case "integracaoupy": {
                return "UPY Lab";
            }
        }
        return "";
    }

    public String getLayoutRelatorio(long moduloAcesso) throws SQLException {
        String layout = "";
        StringBuilder builder = new StringBuilder();
        builder.append("select rel_xml from relatoriosistema where rel_codigo = ");
        builder.append(moduloAcesso);
        ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), builder.toString());
        if (rs.next()) {
            layout = rs.getString("rel_xml");
        }
        return layout;
    }

    public String getDescricaoModeloPadrao(String filial, String exame, String material, String codigo) throws SQLException {
        String descricaoModelo = "";
        StringBuilder buf = new StringBuilder();
        buf.append(" select ");
        buf.append("       lay.lay_descricao ");
        buf.append(" FROM exames a ");
        buf.append(" LEFT JOIN examematcoleta b ON a.fil_codigo = b.fil_codigo AND a.exa_codigo = b.exa_codigo ");
        buf.append(" LEFT JOIN materialcoleta e ON a.fil_codigo = e.fil_codigo AND b.mco_codigo = e.mco_codigo ");
        buf.append(" LEFT JOIN examelayoutmetodo exl ON b.fil_codigo = exl.fil_codigo AND b.exa_codigo = exl.exa_codigo AND b.mco_codigo = exl.mco_codigo ");
        buf.append(" LEFT JOIN examelayout ela ON exl.fil_codigo = ela.fil_codigo ");
        buf.append(" AND exl.exa_codigo = ela.exa_codigo ");
        buf.append(" AND exl.mco_codigo = ela.mco_codigo ");
        buf.append(" AND exl.lay_codigo = ela.lay_codigo ");
        buf.append(" AND exl.ela_idadeini = ela.ela_idadeini ");
        buf.append(" AND exl.ela_idadefim = ela.ela_idadefim ");
        buf.append(" AND exl.ela_idadeinitipo = ela.ela_idadeinitipo ");
        buf.append(" AND exl.ela_idadefimtipo = ela.ela_idadefimtipo ");
        buf.append(" JOIN metodologia met ON exl.fil_codigo = met.fil_codigo AND exl.met_codigo = met.met_codigo ");
        buf.append(" JOIN layout lay ON exl.fil_codigo = lay.fil_codigo AND exl.lay_codigo = lay.lay_codigo ");
        buf.append(" where a.fil_codigo = ");
        buf.append(filial);
        buf.append(" and a.exa_codigo = upper('");
        buf.append(exame);
        buf.append("') and b.mco_codigo = ");
        buf.append(material);
        buf.append(" and ela.ela_padrao = 't' ");
        buf.append(" group by  lay.lay_descricao ");
        Statement st = Conexao.getStatement();
        ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
        while (rs.next()) {
            descricaoModelo = rs.getString("lay_descricao");
        }
        return descricaoModelo;
    }

    public String getDescricaoMaterialPadrao(String filial, String exame, String material, String codigo) throws SQLException {
        String descricaoMaterial = "";
        StringBuilder buf = new StringBuilder();
        buf.append(" select ");
        buf.append(" e.mco_abreviatura ");
        buf.append(" from exames a ");
        buf.append(" LEFT JOIN examematcoleta b ON a.fil_codigo = b.fil_codigo AND a.exa_codigo = b.exa_codigo ");
        buf.append(" LEFT JOIN materialcoleta e ON a.fil_codigo = e.fil_codigo AND b.mco_codigo = e.mco_codigo ");
        buf.append(" LEFT JOIN examelayoutmetodo exl ON b.fil_codigo = exl.fil_codigo AND b.exa_codigo = exl.exa_codigo AND b.mco_codigo = exl.mco_codigo   ");
        buf.append(" join metodologia met on exl.fil_codigo = met.fil_codigo and exl.met_codigo = met.met_codigo  ");
        buf.append(" join layout lay on exl.fil_codigo = lay.fil_codigo and exl.lay_codigo = lay.lay_codigo ");
        buf.append(" where exl.fil_codigo = ");
        buf.append(filial);
        buf.append(" and exl.exa_codigo = upper('");
        buf.append(exame);
        buf.append("') and exl.mco_codigo = ");
        buf.append(material);
        buf.append(" and met.met_codigo = ");
        buf.append(codigo);
        buf.append(" and b.emc_default = 't' ");
        buf.append(" group by  e.mco_abreviatura ");
        Statement st = Conexao.getStatement();
        ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
        while (rs.next()) {
            descricaoMaterial = rs.getString("mco_abreviatura");
        }
        return descricaoMaterial;
    }
}

