/*
 * Decompiled with CFR 0.152.
 */
package jalis.model.dao.recepcao.selecionarimagem;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.model.vo.recepcao.selecionarimagem.PacienteImagensVO;
import jalis.model.vo.recepcao.selecionarimagem.RequisicaoImagensVO;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class SelecionarImagemDao {
    public void deleteRequisicaoImagem(String codigoFilial, String rimCodigo) throws SQLException {
        Statement st = Conexao.getStatement();
        StringBuilder buf = new StringBuilder();
        buf.append("delete from requisicaoimagens ");
        buf.append("where fil_codigo = ").append(Variaveis.filialPadrao);
        buf.append("  and rim_codigo = ").append(rimCodigo);
        Conexao.executeUpdate(codigoFilial, st, buf);
    }

    public void deletePacienteImagens(String codigoFilial, String rimCodigo) throws SQLException {
        Statement st = Conexao.getStatement();
        StringBuilder buf = new StringBuilder();
        buf.append("delete from pacienteimagens ");
        buf.append("where fil_codigo = ").append(Variaveis.filialPadrao);
        buf.append("  and pim_codigo = ").append(rimCodigo);
        Conexao.executeUpdate(codigoFilial, st, buf);
    }

    public void inserirRequisicaoImagem(String codigoFilial, String requisicao, String descricaoImagem, String tipoOperacao, String imagem, String extensaoImagem) throws SQLException {
        Statement st = Conexao.getStatement();
        StringBuilder buf = new StringBuilder();
        buf.append("insert into requisicaoimagens(fil_codigo, req_codigo, rim_descricao, rim_tipo, rim_datahora, usr_codigo, rim_imagem, rim_extensao) values (");
        buf.append(codigoFilial).append(", ");
        buf.append(requisicao).append(", ");
        buf.append(StringUtil.textoDBEscape(descricaoImagem)).append(", ");
        buf.append("'").append(tipoOperacao).append("', ");
        buf.append("'").append(Funcoes.formataData("yyyy-MM-dd HH:mm:ss", new Date())).append("', ");
        buf.append(StringUtil.textoDBEscape(Variaveis.login)).append(", ");
        buf.append(StringUtil.textoDBEscape(imagem)).append(", ");
        buf.append("'").append(extensaoImagem).append("')");
        Conexao.executeUpdate(codigoFilial, st, buf);
    }

    public void inserirPacienteImagem(String codigoFilial, String paciente, String descricaoImagem, String imagem) throws SQLException {
        Statement st = Conexao.getStatement();
        StringBuilder buf = new StringBuilder();
        buf.append("insert into pacienteimagens(fil_codigo, pac_codigo, pim_descricao, pim_datahora, usr_codigo, pim_imagem) values (");
        buf.append(codigoFilial).append(", ");
        buf.append(paciente).append(", ");
        buf.append(StringUtil.textoDBEscape(descricaoImagem)).append(", ");
        buf.append("'").append(Funcoes.formataData("yyyy-MM-dd HH:mm:ss", new Date())).append("', ");
        buf.append(StringUtil.textoDBEscape(Variaveis.login)).append(", ");
        buf.append(StringUtil.textoDBEscape(imagem)).append(")");
        Conexao.executeUpdate(codigoFilial, st, buf);
    }

    public List<PacienteImagensVO> setPaciente(PacienteImagensVO pacienteImagensVO) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append("select pim_codigo, pim_descricao, pim_datahora, usr_codigo ");
        buf.append("from pacienteimagens ");
        buf.append("where fil_codigo = ").append(pacienteImagensVO.getFilial().getCodigo());
        buf.append("  and pac_codigo = ").append(pacienteImagensVO.getPacienteVO().getCodigo());
        buf.append(" order by pim_descricao ");
        Statement st = Conexao.getStatement();
        ResultSet rs = Conexao.executeQuery(st, buf);
        ArrayList<PacienteImagensVO> listaPacientes = new ArrayList<PacienteImagensVO>();
        while (rs.next()) {
            PacienteImagensVO pacienteImagens = new PacienteImagensVO();
            pacienteImagens.setPimCodigo(rs.getString("pim_codigo"));
            pacienteImagens.setPimDescricao(rs.getString("pim_descricao"));
            pacienteImagens.setPimDataHora(Funcoes.formataData("dd/MM/yyyy kk:mm", rs.getTimestamp("pim_datahora")));
            UsuarioVO usuarioVO = new UsuarioVO();
            usuarioVO.setCodigo(rs.getString("usr_codigo"));
            pacienteImagens.setUsuarioVO(usuarioVO);
            listaPacientes.add(pacienteImagens);
        }
        return listaPacientes;
    }

    public List<RequisicaoImagensVO> setRequisicao(RequisicaoImagensVO requisicaoImagensVO) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append("select rim_codigo, rim_descricao, rim_tipo, rim_datahora, usr_codigo, rim_extensao ");
        buf.append("from requisicaoimagens ");
        buf.append("where fil_codigo = ").append(requisicaoImagensVO.getFilial().getCodigo());
        buf.append("  and req_codigo = ").append(requisicaoImagensVO.getRequisicaoVO().getCodigo());
        buf.append(" order by rim_descricao ");
        Statement st = Conexao.getStatement();
        ResultSet rs = Conexao.executeQuery(st, buf);
        ArrayList<RequisicaoImagensVO> listaRequisicao = new ArrayList<RequisicaoImagensVO>();
        while (rs.next()) {
            RequisicaoImagensVO requisicaoImagens = new RequisicaoImagensVO();
            requisicaoImagens.setRimCodigo(rs.getString("rim_codigo"));
            requisicaoImagens.setRimDescricao(rs.getString("rim_descricao"));
            requisicaoImagens.setRimTipo(rs.getString("rim_tipo"));
            requisicaoImagens.setRimDataHora(Funcoes.formataData("dd/MM/yyyy kk:mm", rs.getTimestamp("rim_datahora")));
            UsuarioVO usuarioVO = new UsuarioVO();
            usuarioVO.setCodigo(rs.getString("usr_codigo"));
            requisicaoImagens.setUsuarioVO(usuarioVO);
            requisicaoImagens.setExtensaoDoArquivo(rs.getString("rim_extensao"));
            listaRequisicao.add(requisicaoImagens);
        }
        return listaRequisicao;
    }

    public String retornaImagem(String codigoFilial, String rimCodigo) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append("select rim_imagem, rim_extensao ");
        buf.append("from requisicaoimagens ");
        buf.append("where fil_codigo = ").append(codigoFilial);
        buf.append("  and rim_codigo = ").append(rimCodigo);
        Statement st = Conexao.getStatement();
        ResultSet rs = Conexao.executeQuery(st, buf);
        if (rs.next()) {
            return rs.getString(1);
        }
        return null;
    }

    public String[] retornaImagens(String codigoFilial, String codigoRequisicao, String[] tiposImagem) throws SQLException {
        String[] imagens = new String[]{};
        StringBuilder buf = new StringBuilder();
        buf.append("select rim_imagem ");
        buf.append("from requisicaoimagens ");
        buf.append("where fil_codigo = ").append(codigoFilial);
        buf.append("  and req_codigo = ").append(codigoRequisicao);
        buf.append("  and (rim_extensao <> 'PDF' and rim_extensao <> 'pdf') ");
        if (!Funcoes.objectIsNull(tiposImagem)) {
            buf.append(" and rim_tipo in (");
            StringBuilder bufferTipo = new StringBuilder();
            for (String tipo : tiposImagem) {
                if (!bufferTipo.toString().isEmpty()) {
                    bufferTipo.append(", ");
                }
                bufferTipo.append("'").append(tipo).append("'");
            }
            buf.append((CharSequence)bufferTipo).append(") ");
            buf.append("order by rim_tipo asc");
        }
        Statement st = Conexao.getStatement();
        ResultSet rs = Conexao.executeQuery(st, buf);
        while (rs.next()) {
            imagens = ArraysUtil.concatenar(imagens, new String[]{rs.getString(1)});
        }
        return imagens;
    }

    public String[] retornaPdf(String codigoFilial, String codigoRequisicao, String[] tiposImagem) throws SQLException {
        String[] pdf = new String[]{};
        StringBuilder buf = new StringBuilder();
        buf.append("select rim_imagem ");
        buf.append("from requisicaoimagens ");
        buf.append("where fil_codigo = ").append(codigoFilial);
        buf.append("  and req_codigo = ").append(codigoRequisicao);
        buf.append("  and (rim_extensao = 'pdf' or rim_extensao = 'PDF') ");
        if (!Funcoes.objectIsNull(tiposImagem)) {
            buf.append(" and rim_tipo in (");
            StringBuilder bufferTipo = new StringBuilder();
            for (String tipo : tiposImagem) {
                if (!bufferTipo.toString().isEmpty()) {
                    bufferTipo.append(", ");
                }
                bufferTipo.append("'").append(tipo).append("'");
            }
            buf.append((CharSequence)bufferTipo).append(") ");
            buf.append("order by rim_tipo asc");
        }
        Statement st = Conexao.getStatement();
        ResultSet rs = Conexao.executeQuery(st, buf);
        while (rs.next()) {
            pdf = ArraysUtil.concatenar(pdf, new String[]{rs.getString(1)});
        }
        return pdf;
    }

    public void atualizarRequisicaoImagem(String codigoFilial, String codigoRequisicao, String descricaoImagem, String tipoOperacao, String codigoImagem) throws SQLException {
        Statement st = Conexao.getStatement();
        StringBuilder buf = new StringBuilder();
        buf.append("update requisicaoimagens set ");
        buf.append("rim_descricao = ").append(StringUtil.textoDBEscape(descricaoImagem)).append(", ");
        buf.append("rim_tipo = '").append(tipoOperacao).append("' ");
        buf.append("where fil_codigo = ").append(codigoFilial);
        buf.append(" and req_codigo = ").append(codigoRequisicao);
        buf.append(" and rim_codigo = ").append(codigoImagem);
        Conexao.executeUpdate(codigoFilial, st, buf);
    }

    public String getCodigosNotasSemImagensObrigatorias(String codigoFilial, String codigosRequisicoes, String[] tipoObrigatorio) throws SQLException {
        StringBuilder codigosNotas = new StringBuilder();
        StringBuilder bufferSQL = new StringBuilder();
        StringBuilder bufferTipo = new StringBuilder();
        bufferSQL.append("select distinct case when ");
        for (String tipo : tipoObrigatorio) {
            if (!bufferTipo.toString().isEmpty()) {
                bufferTipo.append(" OR ");
            }
            bufferTipo.append("sum(case when rim.rim_tipo = '");
            bufferTipo.append(tipo);
            bufferTipo.append("' then 1 else 0 end) = 0");
        }
        bufferSQL.append((CharSequence)bufferTipo);
        bufferSQL.append(" then fer.fer_notaipergs else 0 end as codigo_nota ");
        bufferSQL.append("from faturaexamerequisicao fer ");
        bufferSQL.append("left join requisicaoimagens rim ");
        bufferSQL.append("on rim.fil_codigo = fer.fil_codigo ");
        bufferSQL.append("and rim.req_codigo = fer.req_codigo ");
        bufferSQL.append("where fer.fil_codigo = ").append(codigoFilial);
        bufferSQL.append(" and fer.req_codigo in (").append(codigosRequisicoes).append(") ");
        bufferSQL.append("group by fer.fer_notaipergs ");
        bufferSQL.append("order by codigo_nota asc");
        Statement st = Conexao.getStatement();
        ResultSet rs = Conexao.executeQuery(st, bufferSQL);
        while (rs.next()) {
            if (rs.getInt("codigo_nota") == 0) continue;
            if (!codigosNotas.toString().isEmpty()) {
                codigosNotas.append(", ");
            }
            codigosNotas.append(rs.getInt("codigo_nota"));
        }
        return codigosNotas.toString();
    }
}

