/*
 * Decompiled with CFR 0.152.
 */
package jalis.model.dao.recepcao.coletar;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.dados.DadosConvenios;
import jalis.comum.dados.DadosExameRequisicao;
import jalis.comum.dados.DadosExames;
import jalis.comum.dados.DadosMaterial;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.recepcao.coletar.salux.FiltroColetaSalux;
import jalis.laboratorio.recepcao.util.DadosRequisicao;
import jalis.util.ConvenioUtil;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class ColetarMaterialSaluxDao {
    public static final String CONVENIOS = "convenios";
    public static final String ORDENARALTERACAO = "ordenarPorAlteracao";
    public static final String SITUACOESCONSIDERARURGENTE = "ordenarPorAlteracao";
    public static final String ACESSOLABAPOIO = "acesso";
    public static final String FILTRO_COLETA_SALUX = "filtroColetaSalux";
    private boolean alterarColetado = false;

    public List<DadosRequisicao> buscaDados(Registro registro) {
        Statement st = Conexao.getStatement();
        ArrayList<DadosRequisicao> listaDadosRequisicao = new ArrayList<DadosRequisicao>();
        DadosRequisicao dadosRequisicao = null;
        try {
            StringBuilder buf = new StringBuilder("");
            buf.append(" select a.req_codigo ");
            buf.append("       ,a.req_urgente ");
            buf.append("       ,c.pac_nome ");
            buf.append("       ,c.pac_nomesocial ");
            buf.append("       ,a.req_idade ");
            buf.append("       ,a.req_anomes ");
            buf.append("       ,c.pac_obscoleta");
            buf.append("       ,c.pac_sexo ");
            buf.append("       ,c.pac_foto ");
            buf.append("       ,d.med_nome ");
            buf.append("       ,e.con_fantasia ");
            buf.append("       ,a.con_codigo ");
            buf.append("       ,a.usr_codabertura ");
            buf.append("       ,a.req_obs ");
            buf.append("       ,a.req_integracaohospital ");
            buf.append("       ,c.pac_digital ");
            buf.append("       ,a.req_boxcoleta ");
            buf.append("       ,a.sit_codigo as situacaoRequisicao ");
            buf.append("       ,f.sit_descricao ");
            buf.append("\t\t\t ,a.des_codigo ");
            buf.append("\t\t\t ,c.pac_datanasc ");
            buf.append("\t\t\t ,a.req_data ");
            buf.append("\t\t\t ,a.req_dclinicos ");
            buf.append("\t\t\t ,ala.ala_codigo ");
            buf.append("\t\t\t ,ala.ala_descricao ");
            buf.append("\t\t\t ,a.req_leito ");
            buf.append("\t\t\t ,a.req_quarto ");
            buf.append("\t\t\t ,a.req_idsolicitacaosalux ");
            buf.append("\t\t\t ,a.req_datainiciocoletasalux ");
            buf.append("     ,(select max(coalesce(exr_datacoletar, exr_datamaterial)) from examerequisicao where fil_codigo = a.fil_codigo and req_codigo = a.req_codigo and exr_situacao = '").append("T").append("') as ultimaalteracao ");
            buf.append("   from requisicao a ");
            buf.append("   left join paciente c on a.fil_codigo = c.fil_codigo and a.pac_codigo = c.pac_codigo ");
            buf.append("   left join medico d on a.fil_codigo = d.fil_codigo and a.med_conselho = d.med_conselho and upper(a.med_crm) = upper(d.med_crm) and a.med_uf = d.med_uf ");
            buf.append("   left join convenios e on a.fil_codigo = e.fil_codigo and a.con_codigo = e.con_codigo ");
            buf.append("   left join situacao f on a.fil_codigo = f.fil_codigo and a.sit_codigo = f.sit_codigo ");
            buf.append("   left join alahospital ala on a.fil_codigo = ala.fil_codigo and a.ala_codigo = ala.ala_codigo");
            buf.append("  where a.fil_codigo = ").append(Variaveis.filialPadrao);
            buf.append("    and a.req_data >= current_date  - ").append(String.valueOf(ParametrosGerais.getRetrocessoColeta()));
            buf.append("    and not a.req_telacoleta ");
            buf.append("    and not a.req_excluida ");
            buf.append("    and a.req_idsolicitacaosalux is not null and a.req_idsolicitacaosalux <> ''");
            buf.append(this.getSqlFiltroColetaSalux(registro));
            if (registro.getString(CONVENIOS) != null && !Funcoes.textoVazio(registro.getString(CONVENIOS).toString())) {
                buf.append("  and a.con_codigo in (").append(registro.getString(CONVENIOS).toString()).append(") ");
            }
            if (registro.getBoolean(ACESSOLABAPOIO)) {
                if (registro.getBoolean(ACESSOLABAPOIO)) {
                    buf.append(" and (COALESCE(e.con_permitirpesquisaapoio, false) OR NOT COALESCE(e.con_apoiado, false))  ");
                } else {
                    buf.append(" and COALESCE(e.con_apoiado, false) = false ");
                }
            }
            buf.append("  order by ");
            if (!registro.getBoolean("ordenarPorAlteracao")) {
                buf.append("           a.req_data ");
                buf.append("          ,a.req_hora ");
                buf.append("          ,a.req_codigo ");
            } else {
                buf.append(" ultimaalteracao, a.req_codigo ");
            }
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                do {
                    DadosConvenios conv = ConvenioUtil.getDadosConvenios(Variaveis.filialPadrao, rs.getInt("con_codigo"));
                    dadosRequisicao = new DadosRequisicao(rs.getInt("req_codigo"), rs.getString("pac_nome"), rs.getString("pac_nomesocial"), rs.getString("req_idade") + " " + Tipos.tipoIdade(rs.getString("req_anomes")), Tipos.tipoSexo(rs.getString("pac_sexo")), rs.getString("usr_codabertura"), conv, rs.getString("med_nome"), rs.getString("req_obs"), rs.getString("req_integracaohospital"), rs.getString("pac_foto"), rs.getString("pac_digital"), rs.getString("pac_obscoleta"), this.getRequisicaoPossuiEtiquetaColetaImpressa(rs.getInt("req_codigo")), rs.getTimestamp("ultimaalteracao"), rs.getString("sit_descricao"), rs.getString("des_codigo"), rs.getDate("pac_datanasc"), rs.getDate("req_data"), rs.getString("req_dclinicos"));
                    dadosRequisicao.setEmColetaSalux(rs.getTimestamp("req_datainiciocoletasalux") != null);
                    dadosRequisicao.setUrgente(rs.getBoolean("req_urgente"));
                    dadosRequisicao.setIdRequisicaoSalux(rs.getString("req_idsolicitacaosalux"));
                    dadosRequisicao.setCodigoSituacao(rs.getString("situacaoRequisicao"));
                    if (!DBUtil.campoNull(rs.getString("req_boxcoleta"))) {
                        dadosRequisicao.setBoxColeta(rs.getString("req_boxcoleta"));
                    }
                    listaDadosRequisicao.add(dadosRequisicao);
                } while (rs.next());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return listaDadosRequisicao;
    }

    private boolean getRequisicaoPossuiEtiquetaColetaImpressa(int codigoRequisicao) {
        try {
            StringBuilder sql = new StringBuilder();
            sql.append(" select (case when (a.exr_dataetqcoleta is not null and a.usr_codetqcoleta is not null) then true else false end) as etiquetaImpressa ");
            sql.append(" from examerequisicao a where a.req_codigo = ");
            sql.append(codigoRequisicao);
            ResultSet resultSet = Conexao.executeQuery(Conexao.getStatement(), sql.toString());
            while (resultSet.next()) {
                if (resultSet.getBoolean("etiquetaImpressa")) continue;
                return false;
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "Erro ao buscar informa\u00e7\u00e3o se a etiqueta de coleta j\u00e1 foi impressa.", e.getStackTrace());
        }
        return true;
    }

    private String getSqlFiltroColetaSalux(Registro registro) {
        StringBuilder sql = new StringBuilder();
        FiltroColetaSalux filtroEmUso = (FiltroColetaSalux)((Object)registro.getValor(FILTRO_COLETA_SALUX));
        switch (filtroEmUso) {
            case SEM_MARCACAO_COLETA: {
                sql.append("  and  a.req_datainiciocoletasalux is null ");
                break;
            }
            case EM_COLETA: {
                sql.append("  and  a.req_datainiciocoletasalux is not null ");
                break;
            }
            default: {
                sql.append("");
            }
        }
        return sql.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DadosRequisicao carregarDadosExamesRequisicao(DadosRequisicao requisicao, boolean alterarColetado, boolean ordenarSetor) throws SQLException {
        ResultSet rsExames = null;
        Statement stExames = Conexao.getStatement();
        DadosExameRequisicao dadosExameRequisicao = null;
        this.alterarColetado = alterarColetado;
        try {
            StringBuilder buf2 = new StringBuilder();
            buf2.append(" select a.exa_codigo ");
            buf2.append("       ,a.mco_codigo ");
            buf2.append("       ,a.exr_datamaterial ");
            buf2.append("       ,a.usr_codmaterial ");
            buf2.append("       ,b.mco_descricao ");
            buf2.append("       ,b.mco_solicitarmat ");
            buf2.append("       ,b.mco_solicitararea ");
            buf2.append("       ,b.mco_abreviatura ");
            buf2.append("       ,a.exr_matexterno ");
            buf2.append("       ,a.exr_resposta ");
            buf2.append("       ,a.exr_situacao ");
            buf2.append("       ,c.emc_instrcoleta ");
            buf2.append("       ,c.emc_pergunta ");
            buf2.append("       ,coalesce(a.exr_urgente, false) as exr_urgente ");
            buf2.append("       ,c.emc_obrigabiometriapaciente as biometria ");
            buf2.append("       ,(case when (a.exr_dataetqcoleta is not null and a.usr_codetqcoleta is not null) then true else false end) as etiquetaImpressa");
            buf2.append("       ,a.exr_descricaomaterial as descricaoMaterial ");
            buf2.append("       ,exa.exa_descricao ");
            buf2.append("       ,a.exr_dataentregaprev ");
            buf2.append("       ,a.exr_sequencialsalux ");
            buf2.append("       ,c.prz_codigo ");
            buf2.append("       ,case when a.exr_notificacao is null or a.exr_notificacao = '' then exa.exa_corponotificacao else a.exr_notificacao end as notificacao ");
            buf2.append("   from requisicao r ");
            buf2.append("   join examerequisicao a on r.fil_codigo = a.fil_codigo and r.req_codigo = a.req_codigo");
            buf2.append("   join exames exa on a.fil_codigo = exa.fil_codigo and a.exa_codigo = exa.exa_codigo ");
            buf2.append("   left join materialcoleta b on a.fil_codigo = b.fil_codigo and a.mco_codigo = b.mco_codigo ");
            buf2.append("   left join examematcoleta c on a.fil_codigo = c.fil_codigo and a.exa_codigo = c.exa_codigo and a.mco_codigo = c.mco_codigo ");
            if (ordenarSetor) {
                buf2.append(" left join examesetor exmsetor on a.fil_codigo = exmsetor.fil_codigo and upper(a.exa_codigo) = upper(exmsetor.exa_codigo) and exmsetor.ese_default = true ");
            }
            buf2.append("  where a.fil_codigo = ").append(Variaveis.filialPadrao);
            buf2.append("    and a.req_codigo = ").append(requisicao.getCodigo());
            buf2.append("    and not a.exr_excluido ");
            buf2.append("    and not a.exr_excluido ");
            buf2.append("    and r.req_idsolicitacaosalux is not null");
            buf2.append("  order by a.mco_codigo ");
            if (ordenarSetor) {
                buf2.append("        ,exmsetor.set_codigo ");
            }
            buf2.append("          ,c.emc_pagina ");
            buf2.append("          ,c.emc_ordem ");
            buf2.append("         ,a.exa_codigo ");
            buf2.append("         ,a.mco_codigo ");
            DadosRequisicao requisicaoOriginal = requisicao.clone();
            rsExames = stExames.executeQuery(buf2.toString());
            requisicao.limpaExames();
            while (rsExames.next()) {
                DadosMaterial mat = this.getDadosMaterial(rsExames);
                if (mat == null) continue;
                DadosExames dadosExames = this.getDadosExames(rsExames);
                if (requisicaoOriginal.getExames() != null && !requisicaoOriginal.getExames().isEmpty()) {
                    for (int i = 0; i < requisicaoOriginal.getExames().size(); ++i) {
                        DadosExameRequisicao exaReq = requisicaoOriginal.getExame(i);
                        DadosExames dadoExame = exaReq.getExame();
                        if (!dadoExame.equals(dadosExames)) continue;
                        dadosExames = dadoExame;
                        break;
                    }
                }
                dadosExameRequisicao = this.getDadosExameRequisicao(dadosExames, mat, rsExames, requisicao.getCodigo());
                requisicao.adicionaExame(dadosExameRequisicao);
            }
            DadosRequisicao dadosRequisicao = requisicao;
            return dadosRequisicao;
        }
        finally {
            if (rsExames != null) {
                rsExames.close();
            }
        }
    }

    private DadosExameRequisicao getDadosExameRequisicao(DadosExames dadosExames, DadosMaterial mat, ResultSet rsExames, Integer codigoRequisicao) throws SQLException {
        DadosExameRequisicao dadosExameRequisicao = null;
        if (this.isSituacaoColetar(rsExames.getString("exr_situacao")) || DBUtil.campoNull(rsExames.getString("exr_datamaterial"))) {
            dadosExameRequisicao = new DadosExameRequisicao(dadosExames, mat, "", null, rsExames.getBoolean("exr_matexterno"), this.trataRetorno(rsExames.getString("exr_resposta")), rsExames.getString("exr_situacao"), true, rsExames.getBoolean("exr_urgente"), rsExames.getBoolean("etiquetaImpressa"), rsExames.getString("descricaoMaterial"), codigoRequisicao, rsExames.getString("notificacao"));
            dadosExameRequisicao.setSequenciaSalux(rsExames.getString("exr_sequencialsalux"));
            dadosExameRequisicao.setDataHoraEntregraPrevista(rsExames.getTimestamp("exr_dataentregaprev"));
            return dadosExameRequisicao;
        }
        dadosExameRequisicao = new DadosExameRequisicao(dadosExames, mat, rsExames.getString("usr_codmaterial"), rsExames.getTimestamp("exr_datamaterial"), rsExames.getBoolean("exr_matexterno"), this.trataRetorno(rsExames.getString("exr_resposta")), this.trataRetorno(rsExames.getString("exr_situacao")), this.possuiAcessoAlterarColetado(rsExames.getString("exr_situacao")), rsExames.getBoolean("exr_urgente"), rsExames.getBoolean("etiquetaImpressa"), rsExames.getString("descricaoMaterial"), codigoRequisicao, rsExames.getString("notificacao"));
        dadosExameRequisicao.setSequenciaSalux("exr_sequencialsalux");
        dadosExameRequisicao.setDataHoraEntregraPrevista(rsExames.getTimestamp("exr_dataentregaprev"));
        return dadosExameRequisicao;
    }

    private boolean possuiAcessoAlterarColetado(String situacao) {
        return this.alterarColetado ? true : !Funcoes.textoVazio(situacao);
    }

    private String trataRetorno(String resposta) {
        return DBUtil.campoNull(resposta) ? "" : resposta;
    }

    private boolean isSituacaoColetar(String situacao) {
        return situacao != null && situacao.startsWith("T");
    }

    private DadosMaterial getDadosMaterial(ResultSet rsExames) throws SQLException {
        DadosMaterial dadosMaterial = new DadosMaterial(rsExames.getInt("mco_codigo"), rsExames.getString("mco_descricao"), rsExames.getBoolean("mco_solicitarmat"), rsExames.getBoolean("mco_solicitararea"));
        dadosMaterial.setAbreviatura(rsExames.getString("mco_abreviatura"));
        return dadosMaterial;
    }

    private DadosExames getDadosExames(ResultSet rsExames) throws SQLException {
        DadosExames dadosExames = new DadosExames(rsExames.getString("exa_codigo"), rsExames.getString("exa_descricao"));
        dadosExames.setColeta(rsExames.getString("emc_instrcoleta"));
        dadosExames.setPerguntas(rsExames.getString("emc_pergunta"));
        dadosExames.setRespostaPergunta(rsExames.getString("exr_resposta"));
        dadosExames.setMaterialColetadoExame(rsExames.getString("mco_codigo"));
        dadosExames.setCodPrazo(rsExames.getString("prz_codigo"));
        return dadosExames;
    }

    public Registro pesquisarRequisicaoPorCodigo(String codigo) throws SQLException {
        Statement st = Conexao.getStatement();
        StringBuilder select = new StringBuilder("select a.req_codigo ");
        select.append("       ,a.req_urgente ");
        select.append("       ,c.pac_nome ");
        select.append("       ,c.pac_nomesocial ");
        select.append("       ,c.pac_obscoleta");
        select.append("       ,a.req_idade ");
        select.append("       ,a.req_anomes ");
        select.append("       ,c.pac_sexo ");
        select.append("       ,c.pac_foto ");
        select.append("       ,d.med_nome ");
        select.append("       ,e.con_fantasia ");
        select.append("       ,a.con_codigo ");
        select.append("       ,a.usr_codabertura ");
        select.append("       ,a.req_obs ");
        select.append("       ,a.req_integracaohospital ");
        select.append("       ,c.pac_digital ");
        select.append("       ,a.req_boxcoleta ");
        select.append("       ,a.des_codigo ");
        select.append("       ,f.sit_descricao ");
        select.append("       ,a.est_codigo ");
        select.append("       ,c.pac_datanasc ");
        select.append("       ,a.req_data ");
        select.append("       ,a.req_dclinicos ");
        select.append("       ,a.req_idsolicitacaosalux ");
        select.append(" from requisicao a ");
        select.append("   left join paciente c on a.fil_codigo = c.fil_codigo and a.pac_codigo = c.pac_codigo ");
        select.append("   left join medico d on a.fil_codigo = d.fil_codigo and a.med_conselho = d.med_conselho and upper(a.med_crm)=upper(d.med_crm) and a.med_uf = d.med_uf ");
        select.append("   left join convenios e on a.fil_codigo = e.fil_codigo and a.con_codigo = e.con_codigo ");
        select.append("   left join situacao f on a.fil_codigo = f.fil_codigo and a.sit_codigo = f.sit_codigo ");
        select.append(" where a.fil_codigo = ").append(Variaveis.filialPadrao);
        select.append("    and a.req_codigo = ").append(codigo);
        select.append("    and not a.req_excluida ");
        select.append("    and a.req_idsolicitacaosalux is not null ");
        ResultSet rs = Conexao.executeQuery(st, select.toString());
        Registro registro = new Registro();
        if (rs.next()) {
            registro.carregar(rs);
        }
        rs.close();
        st.close();
        return registro;
    }

    public List<Registro> pesquisarExamesPorRequisicao(String codigoRequisicao) throws SQLException {
        StringBuilder select = new StringBuilder(" select a.exa_codigo ");
        select.append("       ,a.mco_codigo ");
        select.append("       ,a.exr_datamaterial ");
        select.append("       ,a.usr_codmaterial ");
        select.append("       ,b.mco_descricao ");
        select.append("       ,b.mco_solicitarmat ");
        select.append("       ,a.exr_matexterno ");
        select.append("       ,a.exr_resposta ");
        select.append("       ,a.exr_situacao ");
        select.append("       ,a.exr_urgente ");
        select.append("       ,c.emc_obrigabiometriapaciente as biometria ");
        select.append("       ,(case when (a.exr_dataetqcoleta is not null and a.usr_codetqcoleta is not null) then true else false end) as etiquetaImpressa");
        select.append("       ,a.exr_descricaomaterial as descricaoMaterial, case when a.exr_notificacao is null or a.exr_notificacao = '' then ex.exa_corponotificacao else a.exr_notificacao end as notificacao ");
        select.append("   from examerequisicao a ");
        select.append("   left join materialcoleta b on a.fil_codigo = b.fil_codigo and a.mco_codigo = b.mco_codigo ");
        select.append("   left join examematcoleta c on a.fil_codigo = c.fil_codigo and a.exa_codigo = c.exa_codigo and a.mco_codigo = c.mco_codigo ");
        select.append("   left join exames ex on a.fil_codigo = ex.fil_codigo and a.exa_codigo = ex.exa_codigo ");
        select.append(ParametrosGerais.getOrdenarSetor() ? " left join examesetor exmsetor on a.fil_codigo = exmsetor.fil_codigo and upper(a.exa_codigo) = upper(exmsetor.exa_codigo) and exmsetor.ese_default = true " : "");
        select.append(" where a.fil_codigo = ").append(Variaveis.filialPadrao);
        select.append("   and a.req_codigo = ").append(codigoRequisicao);
        select.append("   and not a.exr_excluido ");
        select.append(" order by a.mco_codigo ");
        select.append(ParametrosGerais.getOrdenarSetor() ? " ,exmsetor.set_codigo " : "");
        select.append(" ,c.emc_pagina ");
        select.append(" ,c.emc_ordem ");
        select.append(" ,a.exa_codigo ");
        select.append(" ,a.mco_codigo ");
        Statement st = Conexao.getStatement();
        ResultSet rs = st.executeQuery(select.toString());
        ArrayList<Registro> registros = new ArrayList<Registro>();
        while (rs.next()) {
            registros.add(new Registro(rs));
        }
        rs.close();
        st.close();
        return registros;
    }
}

