/*
 * Decompiled with CFR 0.152.
 */
package jalis.model.dao.recepcao;

import jalis.comum.Conexao;
import jalis.model.vo.recepcao.RequisicaoImagensVO;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class RequisicaoImagensDao {
    public void excluirRequisicaoImagem(RequisicaoImagensVO requisicaoImagemVO) throws SQLException {
        Statement st = Conexao.getStatement();
        StringBuilder buf = new StringBuilder();
        buf.append("delete from requisicaoimagens ");
        buf.append("where fil_codigo = ").append(requisicaoImagemVO.getCodigoFilial());
        buf.append("  and rim_codigo = ").append(requisicaoImagemVO.getCodigoRequisicaoImagens());
        buf.append("  and req_codigo = ").append(requisicaoImagemVO.getCodigoRequisicao());
        Conexao.executeUpdate(requisicaoImagemVO.getCodigoFilial(), st, buf);
        Conexao.arquivaSQL();
    }

    public void inserirRequisicaoImagem(RequisicaoImagensVO requisicaoImagemVO) throws SQLException {
        Statement st = Conexao.getStatement();
        StringBuilder buf = new StringBuilder();
        buf.append("insert into requisicaoimagens(fil_codigo, req_codigo, rim_descricao, rim_tipo, rim_datahora, usr_codigo, rim_imagem, rim_extensao) values (");
        buf.append(requisicaoImagemVO.getCodigoFilial()).append(", ");
        buf.append(requisicaoImagemVO.getCodigoRequisicao()).append(", ");
        buf.append(StringUtil.textoDBEscape(requisicaoImagemVO.getDescricaoRequisicaoImagens())).append(", ");
        buf.append("'").append(requisicaoImagemVO.getTipoOperacao()).append("', ");
        buf.append("'").append(Funcoes.formataData("MM-dd-yyyy kk:mm:ss", requisicaoImagemVO.getDataHora())).append("', ");
        buf.append(StringUtil.textoDBEscape(requisicaoImagemVO.getCodigoUsuario())).append(", ");
        buf.append(StringUtil.textoDBEscape(requisicaoImagemVO.getImagem())).append(", ");
        buf.append("'").append(requisicaoImagemVO.getExtensao()).append("')");
        Conexao.executeUpdate(requisicaoImagemVO.getCodigoFilial(), st, buf);
        Conexao.arquivaSQL();
    }

    public List<RequisicaoImagensVO> buscaRequisicaoImagens(RequisicaoImagensVO requisicaoImagensVO) throws SQLException {
        ArrayList<RequisicaoImagensVO> listaRequisicao = new ArrayList<RequisicaoImagensVO>();
        StringBuilder buf = new StringBuilder();
        buf.append("select rim_codigo, rim_descricao, rim_tipo, rim_datahora, usr_codigo, rim_imagem, rim_extensao ");
        buf.append("from requisicaoimagens ");
        buf.append("where fil_codigo = ").append(requisicaoImagensVO.getCodigoFilial());
        buf.append("  and req_codigo = ").append(requisicaoImagensVO.getCodigoRequisicao());
        buf.append(" order by rim_descricao ");
        Statement st = Conexao.getStatement();
        ResultSet rs = Conexao.executeQuery(st, buf);
        while (rs.next()) {
            RequisicaoImagensVO requisicaoImagem = new RequisicaoImagensVO();
            requisicaoImagem.setCodigoFilial(requisicaoImagensVO.getCodigoFilial());
            requisicaoImagem.setCodigoRequisicao(requisicaoImagensVO.getCodigoRequisicao());
            requisicaoImagem.setCodigoRequisicaoImagens(rs.getString("rim_codigo"));
            requisicaoImagem.setCodigoUsuario(rs.getString("usr_codigo"));
            requisicaoImagem.setDataHora(rs.getTimestamp("rim_datahora"));
            requisicaoImagem.setDescricaoRequisicaoImagens(rs.getString("rim_descricao"));
            requisicaoImagem.setTipoOperacao(rs.getString("rim_tipo"));
            requisicaoImagem.setImagem(rs.getString("rim_imagem"));
            requisicaoImagem.setExtensao(rs.getString("rim_extensao"));
            listaRequisicao.add(requisicaoImagem);
        }
        return listaRequisicao;
    }

    public boolean requisicaoImagensCadastrado(RequisicaoImagensVO requisicaoImagensVO) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append("select rim_codigo ");
        buf.append("from requisicaoimagens ");
        buf.append("where fil_codigo = ").append(requisicaoImagensVO.getCodigoFilial());
        buf.append("  and req_codigo = ").append(requisicaoImagensVO.getCodigoRequisicao());
        buf.append("  and rim_codigo = ").append(requisicaoImagensVO.getCodigoRequisicaoImagens());
        buf.append(" order by rim_descricao ");
        Statement st = Conexao.getStatement();
        ResultSet rs = Conexao.executeQuery(st, buf);
        if (rs.next()) {
            return rs.getInt("rim_codigo") > 0;
        }
        return false;
    }

    public void atualizarRequisicaoImagem(RequisicaoImagensVO requisicaoImagensVO) throws SQLException {
        Statement st = Conexao.getStatement();
        StringBuilder buf = new StringBuilder();
        buf.append("update requisicaoimagens set ");
        buf.append("rim_descricao = ").append(StringUtil.textoDBEscape(requisicaoImagensVO.getDescricaoRequisicaoImagens())).append(", ");
        buf.append("rim_tipo = '").append(requisicaoImagensVO.getTipoOperacao()).append("' ");
        buf.append("where fil_codigo = ").append(requisicaoImagensVO.getCodigoFilial());
        buf.append(" and req_codigo = ").append(requisicaoImagensVO.getCodigoRequisicao());
        buf.append(" and rim_codigo = ").append(requisicaoImagensVO.getCodigoRequisicaoImagens());
        Conexao.executeUpdate(requisicaoImagensVO.getCodigoFilial(), st, buf);
        Conexao.arquivaSQL();
    }
}

