/*
 * Decompiled with CFR 0.152.
 */
package jalis.model.dao.recepcao;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.integracaohospitais.util.ProtocoloIntegracaoHospital;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.model.AbstractThreadBean;
import jalis.model.AbstractThreadDao;
import jalis.model.ThreadBeanDaoMultiplasChaves;
import jalis.model.bean.recepcao.AgendamentoBean;
import jalis.model.bean.recepcao.RequisicaoBean;
import jalis.model.dao.recepcao.ExameRequisicaoDao;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.recepcao.ExameRequisicaoVO;
import jalis.model.vo.recepcao.RequisicaoVO;
import jalis.util.DBUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RequisicaoDao
extends AbstractThreadDao
implements ThreadBeanDaoMultiplasChaves {
    @Override
    public AbstractThreadBean getBean(Map<String, Object> chaves) throws ThreadDaoException {
        ArrayList<String> wheres = new ArrayList<String>();
        for (String chave : chaves.keySet()) {
            wheres.add(chave + "=" + this.getValorParaBanco(chaves.get(chave)));
        }
        String where = " where " + StringUtil.implode(wheres, " and ");
        Set aux = RequisicaoDao.load(RequisicaoBean.class, where);
        if (aux == null || aux.size() == 0 || aux.size() > 1) {
            return null;
        }
        RequisicaoBean req = (RequisicaoBean)aux.toArray()[0];
        req.setExames(new ExameRequisicaoDao().getVOs(chaves));
        try {
            Integer[] reqs = RecepcaoUtil.verificaMultiGuias(req.getFilial().getCodigo().toString(), req.getCodigo().toString());
            req.setRequisicoesMultiguia(reqs);
            if (reqs != null && reqs.length > 0) {
                ArrayList<ExameRequisicaoVO> lista = new ArrayList<ExameRequisicaoVO>();
                for (int i = 0; i < reqs.length; ++i) {
                    HashMap<String, Object> chaveMulti = new HashMap<String, Object>();
                    chaveMulti.put("fil_codigo", req.getFilial().getCodigo().toString());
                    chaveMulti.put("req_codigo", reqs[i]);
                    ArrayList<ExameRequisicaoVO> auxLista = new ExameRequisicaoDao().getVOs(chaveMulti);
                    if (auxLista == null || auxLista.size() <= 0) continue;
                    lista.addAll(auxLista);
                }
                req.setExamesMultiguia(lista);
            }
        }
        catch (Exception e) {
            throw new ThreadDaoException(e.getMessage());
        }
        return req;
    }

    @Override
    public AbstractThreadVO getVO(Map<String, Object> chaves) throws ThreadDaoException {
        ArrayList<String> wheres = new ArrayList<String>();
        for (String chave : chaves.keySet()) {
            wheres.add(chave + "=" + this.getValorParaBanco(chaves.get(chave)));
        }
        String where = " where " + StringUtil.implode(wheres, " and ");
        Set aux = this.loadVO(RequisicaoVO.class, where);
        if (aux == null || aux.size() == 0 || aux.size() > 1) {
            return null;
        }
        RequisicaoVO req = (RequisicaoVO)aux.toArray()[0];
        req.setExames(new ExameRequisicaoDao().getVOs(chaves));
        try {
            Integer[] reqs = RecepcaoUtil.verificaMultiGuias(req.getFilial().getCodigo().toString(), req.getCodigo().toString());
            req.setRequisicoesMultiguia(reqs);
            if (reqs != null && reqs.length > 0) {
                ArrayList<ExameRequisicaoVO> lista = new ArrayList<ExameRequisicaoVO>();
                for (int i = 0; i < reqs.length; ++i) {
                    HashMap<String, Object> chaveMulti = new HashMap<String, Object>();
                    chaveMulti.put("fil_codigo", req.getFilial().getCodigo().toString());
                    chaveMulti.put("req_codigo", reqs[i]);
                    ArrayList<ExameRequisicaoVO> auxLista = new ExameRequisicaoDao().getVOs(chaveMulti);
                    if (auxLista == null || auxLista.size() <= 0) continue;
                    lista.addAll(auxLista);
                }
                req.setExamesMultiguia(lista);
            }
        }
        catch (Exception e) {
            throw new ThreadDaoException(e.getMessage());
        }
        return req;
    }

    @Override
    @Deprecated
    public AbstractThreadBean getBean(String codigo) throws ThreadDaoException {
        return null;
    }

    @Override
    @Deprecated
    public AbstractThreadVO getVO(String codigo) throws ThreadDaoException {
        String where = " where fil_codigo = " + Variaveis.filialPadrao + " and req_codigo = " + codigo;
        Set requisicoes = this.loadVO(RequisicaoVO.class, where);
        if (requisicoes == null || requisicoes.size() == 0 || requisicoes.size() > 1) {
            return null;
        }
        return (AbstractThreadVO)requisicoes.toArray()[0];
    }

    public void atualizarSituacaoExamesSemResultadoAColetarSemCommit(String filial, String requisicao, String situacao) throws SQLException {
        if (filial == null || requisicao == null || situacao == null) {
            return;
        }
        Statement st = Conexao.getStatement();
        StringBuilder bufLogSituacao = new StringBuilder();
        bufLogSituacao.append(" select exa_codigo as exame ");
        bufLogSituacao.append("       ,mco_codigo as material ");
        bufLogSituacao.append("       ,exr_situacao as situacao ");
        bufLogSituacao.append("   from examerequisicao ");
        bufLogSituacao.append("  where fil_codigo = ").append(filial);
        bufLogSituacao.append("    and req_codigo = ").append(requisicao);
        bufLogSituacao.append("    and ((exr_situacao IS NULL or exr_situacao = '') or exr_situacao = '").append("T").append("') ");
        ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), bufLogSituacao);
        if (rs.next()) {
            do {
                DBUtil.gravaLogSituacaoExameRequisicao(st, filial, requisicao, rs.getString("exame"), rs.getString("material"), Variaveis.login, situacao, false);
            } while (rs.next());
            StringBuilder buf = new StringBuilder();
            buf.append(" update examerequisicao ");
            buf.append("    set exr_situacao = '").append(situacao).append("' ");
            buf.append("  where fil_codigo = ").append(filial);
            buf.append("    and req_codigo = ").append(requisicao);
            buf.append("    and ((exr_situacao IS NULL or exr_situacao = '') or exr_situacao = '").append("T").append("') ");
            Conexao.executeUpdate(filial, st, buf.toString());
        }
        if (ParametrosGerais.getProtocoloIntegracaoHospital() == ProtocoloIntegracaoHospital.MV) {
            // empty if block
        }
    }

    public void atualizarSituacaoExamesSemResultadoFaltaMaterialSemCommit(String filial, String requisicao, String situacao) throws SQLException {
        if (filial == null || requisicao == null || situacao == null) {
            return;
        }
        Statement st = Conexao.getStatement();
        StringBuilder bufLogSituacao = new StringBuilder();
        bufLogSituacao.append(" select exa_codigo as exame ");
        bufLogSituacao.append("       ,mco_codigo as material ");
        bufLogSituacao.append("       ,exr_situacao as situacao ");
        bufLogSituacao.append("   from examerequisicao ");
        bufLogSituacao.append("  where fil_codigo = ").append(filial);
        bufLogSituacao.append("    and req_codigo = ").append(requisicao);
        bufLogSituacao.append("    and ((exr_situacao IS NULL or exr_situacao = '') or exr_situacao = '").append("F").append("') ");
        ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), bufLogSituacao);
        if (rs.next()) {
            do {
                DBUtil.gravaLogSituacaoExameRequisicao(st, filial, requisicao, rs.getString("exame"), rs.getString("material"), Variaveis.login, situacao, false);
            } while (rs.next());
            StringBuilder buf = new StringBuilder();
            buf.append(" update examerequisicao ");
            buf.append("    set exr_situacao = '").append(situacao).append("' ");
            if (situacao.equalsIgnoreCase("T")) {
                buf.append(", usr_codcoletar = '").append(Variaveis.login).append("' ");
                buf.append(", exr_datacoletar = '").append(Funcoes.formataData("yyyy-MM-dd HH:mm:ss.SSS", new Date())).append("' ");
            }
            buf.append("  where fil_codigo = ").append(filial);
            buf.append("    and req_codigo = ").append(requisicao);
            buf.append("    and ((exr_situacao IS NULL or exr_situacao = '') or exr_situacao = '").append("F").append("') ");
            Conexao.executeUpdate(filial, st, buf.toString());
        }
        if (ParametrosGerais.getProtocoloIntegracaoHospital() == ProtocoloIntegracaoHospital.MV) {
            // empty if block
        }
    }

    public void atualizarSituacaoExamesSemResultadoSemCommit(String filial, String requisicao, String situacao) throws SQLException {
        if (filial == null || requisicao == null || situacao == null) {
            return;
        }
        Statement st = Conexao.getStatement();
        StringBuilder bufLogSituacao = new StringBuilder();
        bufLogSituacao.append(" select exa_codigo as exame ");
        bufLogSituacao.append("       ,mco_codigo as material ");
        bufLogSituacao.append("       ,exr_situacao as situacao ");
        bufLogSituacao.append("   from examerequisicao ");
        bufLogSituacao.append("  where fil_codigo = ").append(filial);
        bufLogSituacao.append("    and req_codigo = ").append(requisicao);
        bufLogSituacao.append("    and (exr_situacao IS NULL or exr_situacao = '') ");
        ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), bufLogSituacao);
        if (rs.next()) {
            do {
                DBUtil.gravaLogSituacaoExameRequisicao(st, filial, requisicao, rs.getString("exame"), rs.getString("material"), Variaveis.login, situacao, false);
            } while (rs.next());
            StringBuilder buf = new StringBuilder();
            buf.append(" update examerequisicao ");
            buf.append("    set exr_situacao = '").append(situacao).append("' ");
            buf.append("  where fil_codigo = ").append(filial);
            buf.append("    and req_codigo = ").append(requisicao);
            buf.append("    and (exr_situacao IS NULL or exr_situacao = '') ");
            Conexao.executeUpdate(filial, st, buf.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalizarAgendamentoRequisicaoSemCommit(String filial, String requisicao, List<ExameRequisicaoVO> exameRequisicaoVOsAgendados, String usuario) throws SQLException {
        if (filial == null || requisicao == null || exameRequisicaoVOsAgendados == null) {
            return;
        }
        Statement st = Conexao.getStatement();
        Statement stAtualizaExame = Conexao.getStatement();
        Statement stAtualizaSituacao = Conexao.getStatement();
        StringBuilder buf = new StringBuilder();
        buf.append(" select emc.prz_codigo as codigoPrazo ");
        buf.append("       ,exr.exa_codigo as codigoExame ");
        buf.append("       ,exr.mco_codigo as codigoMaterial ");
        buf.append("       ,exr.exr_situacao as situacaoExame ");
        buf.append("       ,exr.exr_datacoletar as dataColetarExame ");
        buf.append("       ,exr.usr_codcoletar as usuarioColetarExame ");
        buf.append("       ,req.con_codigo as codigoConvenio ");
        buf.append("       ,req.req_codigo as reqCodigo ");
        buf.append("       ,exr.fil_codigo as filial ");
        buf.append("       ,exr.exr_dataguia as dataGuia ");
        buf.append("       ,req.des_codigo as codigoDestino ");
        buf.append("       ,req.req_dtfatura as dataFatura ");
        buf.append("  from examerequisicao exr ");
        buf.append("  join requisicao req on exr.fil_codigo = req.fil_codigo and exr.req_codigo = req.req_codigo ");
        buf.append("  left Join agendamentoexamerequisicao agx ON agx.fil_codigo = exr.fil_codigo AND agx.req_codigo = exr.req_codigo AND agx.exa_codigo = exr.exa_codigo AND agx.mco_codigo = exr.mco_codigo ");
        buf.append("  join examematcoleta emc on exr.fil_codigo = emc.fil_codigo and exr.exa_codigo = emc.exa_codigo and exr.mco_codigo = emc.mco_codigo ");
        buf.append(" where exr.fil_codigo = ").append(filial);
        buf.append("   and exr.req_codigo = ").append(requisicao);
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        try {
            Date dataAtual = new Date();
            while (rs.next()) {
                ExameRequisicaoVO exameRequisicaoVO = null;
                for (ExameRequisicaoVO exrRequisicaoVO : exameRequisicaoVOsAgendados) {
                    if (!exrRequisicaoVO.getExame().getCodigo().equalsIgnoreCase(rs.getString("codigoExame")) || !exrRequisicaoVO.getMaterial().getCodigo().equals(rs.getInt("codigoMaterial")) || !exrRequisicaoVO.getRequisicao().equals(rs.getInt("reqCodigo")) || !exrRequisicaoVO.getFilial().getCodigo().equals(rs.getInt("filial"))) continue;
                    exameRequisicaoVO = exrRequisicaoVO;
                    break;
                }
                if (exameRequisicaoVO == null) continue;
                Date entrega = null;
                if (exameRequisicaoVO.getDataMaterial() != null) {
                    entrega = ExameUtil.calculaDataEntrega(filial, rs.getString("codigoPrazo"), rs.getString("codigoExame"), rs.getString("codigoMaterial"), rs.getString("codigoConvenio"), exameRequisicaoVO.getDataMaterial(), rs.getString("codigoDestino"), new Date());
                }
                buf.setLength(0);
                buf.append(" update examerequisicao ");
                buf.append(" set exr_situacao = '").append(exameRequisicaoVO.getSituacao() == null ? "" : exameRequisicaoVO.getSituacao()).append("' ");
                if (exameRequisicaoVO.getSituacao() != null && exameRequisicaoVO.getSituacao().equalsIgnoreCase("T")) {
                    if (rs.getString("usuarioColetarExame") == null || !rs.getString("situacaoExame").equalsIgnoreCase(exameRequisicaoVO.getSituacao())) {
                        buf.append(", usr_codcoletar = '").append(usuario).append("' ");
                    }
                    if (rs.getString("dataColetarExame") == null || !rs.getString("situacaoExame").equalsIgnoreCase(exameRequisicaoVO.getSituacao())) {
                        buf.append(" , exr_datacoletar = '").append(Funcoes.formataData("yyyy-MM-dd HH:mm:ss.SSS", dataAtual)).append("' ");
                    }
                }
                if (!Funcoes.textoVazio(rs.getString("dataGuia"))) {
                    buf.append(", exr_dataguia = '").append(rs.getString("dataFatura")).append("' ");
                }
                if (exameRequisicaoVO.getDataMaterial() != null) {
                    buf.append(" ,exr_datamaterial = '").append(Funcoes.formataData("yyyy-MM-dd HH:mm:ss", exameRequisicaoVO.getDataMaterial())).append("' ");
                } else {
                    buf.append(" ,exr_datamaterial = null ");
                }
                buf.append(" ,usr_codmaterial = '").append(usuario).append("' ");
                buf.append(" ,exr_dataentregaprev = ");
                if (entrega != null && !entrega.toString().isEmpty()) {
                    buf.append("'").append(Funcoes.formataData("yyyy-MM-dd HH:mm:ss", entrega)).append("'");
                } else {
                    buf.append("null ");
                }
                buf.append("       ,exr_avisarentrega = ").append(entrega == null || entrega.toString().isEmpty() ? "true" : "false");
                buf.append("  where fil_codigo = ").append(filial);
                buf.append("    and req_codigo = ").append(requisicao);
                buf.append("    and exa_codigo = '").append(exameRequisicaoVO.getExame().getCodigo()).append("' ");
                buf.append("    and mco_codigo = ").append(exameRequisicaoVO.getMaterial().getCodigo());
                DBUtil.gravaLogSituacaoExameRequisicao(stAtualizaSituacao, filial, requisicao, rs.getString("codigoExame"), rs.getString("codigoMaterial"), Variaveis.login, exameRequisicaoVO.getSituacao(), false);
                Conexao.executeUpdate(filial, stAtualizaExame, buf.toString());
                if (ParametrosGerais.getProtocoloIntegracaoHospital() == ProtocoloIntegracaoHospital.MV) {
                    // empty if block
                }
                if (!exameRequisicaoVO.getSituacao().equalsIgnoreCase("R")) continue;
                try {
                    DBUtil.setExameSituacaoInterfaceamento(Conexao.getStatement(), filial, requisicao, exameRequisicaoVO.getExame().getCodigo(), String.valueOf(exameRequisicaoVO.getMaterial().getCodigo()), 0);
                }
                catch (SQLException e) {
                    ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace(), "RequisicaoDao (419)");
                }
            }
        }
        catch (Throwable throwable) {
            Conexao.fecharStatement(st, stAtualizaSituacao, stAtualizaExame);
            throw throwable;
        }
        Conexao.fecharStatement(st, stAtualizaSituacao, stAtualizaExame);
    }

    public void marcarOrigemRequisicaoAgendamentoSemCommit(String filial, String requisicao, boolean agendamentoFinalizado) throws SQLException {
        if (filial == null || requisicao == null) {
            return;
        }
        StringBuilder buf = new StringBuilder();
        buf.append(" update requisicao ");
        buf.append("    set req_origemagendamento = true ");
        if (agendamentoFinalizado) {
            buf.append("     ,req_excluida = false ");
            buf.append("     ,req_dataexcluida = null ");
        }
        buf.append("  where fil_codigo = ").append(filial);
        buf.append("    and req_codigo = ").append(requisicao);
        Conexao.executeUpdate(filial, Conexao.getStatement(), buf.toString());
    }

    public void atualizaDatasAgendamentoFinalizadoSemCommit(String filial, String requisicao, Date data) throws SQLException {
        if (filial == null || requisicao == null || data == null) {
            return;
        }
        StringBuilder buf = new StringBuilder();
        buf.append(" update requisicao ");
        buf.append("    set req_dtfatura = '").append(Funcoes.formataData("yyyy-MM-dd HH:mm:ss", data)).append("' ");
        buf.append("       ,req_data = '").append(Funcoes.formataData("yyyy-MM-dd HH:mm:ss", data)).append("' ");
        buf.append("       ,req_hora = '").append(Funcoes.formataHora(data, false)).append("' ");
        buf.append("  where fil_codigo = ").append(filial);
        buf.append("    and req_codigo = ").append(requisicao);
        this.atualizaDataGuiaRequisicao(filial, requisicao, data);
        Conexao.executeUpdate(filial, Conexao.getStatement(), buf.toString());
    }

    public void atualizaDataGuiaRequisicao(String filial, String requisicao, Date data) throws SQLException {
        if (filial == null || requisicao == null || data == null) {
            return;
        }
        Statement st = Conexao.getStatement();
        StringBuilder buf = new StringBuilder();
        buf.append(" select exa_codigo, mco_codigo ");
        buf.append("       ,exr.exr_dataguia as dataGuia ");
        buf.append("  from examerequisicao exr ");
        buf.append(" where exr.fil_codigo = ").append(filial);
        buf.append("   and exr.req_codigo = ").append(requisicao);
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        while (rs.next()) {
            buf.setLength(0);
            if (Funcoes.textoVazio(rs.getString("dataGuia"))) continue;
            buf.append(" update examerequisicao set ");
            buf.append(" exr_dataguia = '").append(Funcoes.formataData("yyyy-MM-dd HH:mm:ss", data)).append("' ");
            buf.append(" where fil_codigo = ").append(filial);
            buf.append("   and req_codigo = ").append(requisicao);
            buf.append("   and exa_codigo = '").append(rs.getString("exa_codigo")).append("' ");
            buf.append("   and mco_codigo = ").append(rs.getString("mco_codigo"));
            Conexao.executeUpdate(filial, Conexao.getStatement(), buf.toString());
        }
    }

    public void desvincularRequisicaoAgendamento(String filial, String codigoRequisicao) throws SQLException {
        if (filial == null || codigoRequisicao == null) {
            return;
        }
        StringBuilder buf = new StringBuilder();
        buf.append(" update requisicao ");
        buf.append("    set req_excluida = false ");
        buf.append("       ,req_dataexcluida = NULL ");
        buf.append("       ,req_origemagendamento = true ");
        buf.append("  where fil_codigo = ").append(filial);
        buf.append("    and req_codigo = ").append(codigoRequisicao);
        Conexao.executeUpdate(filial, Conexao.getStatement(), buf.toString());
    }

    public void desvincularRequisicaoAgendamentoCancelamento(String filial, String codigoRequisicao) throws SQLException {
        if (filial == null || codigoRequisicao == null) {
            return;
        }
        StringBuilder buf = new StringBuilder();
        buf.append(" update requisicao ");
        buf.append("    set req_excluida = true ");
        buf.append("       ,req_dataexcluida = NULL ");
        buf.append("       ,req_origemagendamento = true ");
        buf.append("       ,req_motivoexclusao = '").append(Variaveis.login).append(" ").append(Funcoes.formataData(new Date())).append(" Requisi\u00e7\u00e3o cancelada na tela de agendamento").append("'");
        buf.append("  where fil_codigo = ").append(filial);
        buf.append("    and req_codigo = ").append(codigoRequisicao);
        Conexao.executeUpdate(filial, Conexao.getStatement(), buf.toString());
    }

    public int getQuantidadeAgendamentos(String filial, String codigoRequisicao) throws SQLException {
        if (filial == null || codigoRequisicao == null) {
            return 0;
        }
        StringBuilder buf = new StringBuilder();
        buf.append(" select count(1) as qtde ");
        buf.append("   from agendamento agd ");
        buf.append("   join requisicao req on agd.fil_codigo = req.fil_codigo and agd.req_codigo = req.req_codigo and req.req_excluida and req.req_origemagendamento ");
        buf.append("  where agd.fil_codigo = ").append(filial);
        buf.append("    and agd.req_codigo = ").append(codigoRequisicao);
        buf.append("    and agd.agd_situacao NOT IN ('").append("C").append("', '").append("R").append("') ");
        ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
        if (rs.next()) {
            return rs.getInt("qtde");
        }
        return 0;
    }

    public int marcarRequisicaoExcluida(String filial, String codigoRequisicao) throws SQLException {
        if (filial == null || codigoRequisicao == null) {
            return 0;
        }
        StringBuilder buf = new StringBuilder();
        buf.append(" update requisicao ");
        buf.append("    set req_excluida = true ");
        buf.append("       ,req_dataexcluida = '").append(Funcoes.formataData("yyyy-MM-dd HH:mm:ss", new Date())).append("' ");
        buf.append("  where fil_codigo = ").append(filial);
        buf.append("    and req_codigo = ").append(codigoRequisicao);
        int qtde = Conexao.executeUpdate(filial, Conexao.getStatement(), buf.toString());
        if (ParametrosGerais.getProtocoloIntegracaoHospital() == ProtocoloIntegracaoHospital.MV) {
            // empty if block
        }
        return qtde;
    }

    public int marcarExamesRequisicaoExcluidos(String filial, String codigoRequisicao) throws SQLException {
        if (filial == null || codigoRequisicao == null) {
            return 0;
        }
        StringBuilder buf = new StringBuilder();
        buf.append(" update examerequisicao ");
        buf.append("    set exr_excluido = true ");
        buf.append("       ,exr_dataexcluido = '").append(Funcoes.formataData("yyyy-MM-dd HH:mm:ss", new Date())).append("' ");
        buf.append("  where fil_codigo = ").append(filial);
        buf.append("    and req_codigo = ").append(codigoRequisicao);
        int qtde = Conexao.executeUpdate(filial, Conexao.getStatement(), buf.toString());
        if (ParametrosGerais.getProtocoloIntegracaoHospital() == ProtocoloIntegracaoHospital.MV) {
            // empty if block
        }
        return qtde;
    }

    public void gravaMaiorDataEntregaSemCommit(RequisicaoVO requisicaoVO) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append(" update requisicao SET req_dataentregaprev = (select max(exr_dataentregaprev) ");
        sql.append("   from examerequisicao where req_codigo = ");
        sql.append(requisicaoVO.getCodigo());
        sql.append("    and fil_codigo = ");
        sql.append(requisicaoVO.getFilial().getCodigo()).append(")");
        sql.append(", req_horaentregaprev = '").append(requisicaoVO.getHora()).append("'");
        sql.append("  where fil_codigo = ").append(requisicaoVO.getFilial().getCodigo());
        sql.append("    and req_codigo = ").append(requisicaoVO.getCodigo());
        Conexao.execute(Variaveis.filialPadrao, Conexao.getStatement(), sql.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal valorExameCustoSimples(String codExame, String codMatCol, String codFilial) {
        Statement st = Conexao.getStatement();
        BigDecimal retorno = BigDecimal.ZERO.setScale(4);
        try {
            retorno = RequisicaoDao.valorExameCustoSimples(st, codExame, codMatCol, codFilial);
        }
        catch (SQLException e) {
            try {
                new ThreadDaoException("N\u00e3o foi poss\u00edvel finalizar consulta de custo simples do exame.");
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
        return retorno;
    }

    public static BigDecimal valorExameCustoSimples(Statement st, String codExame, String codMatCol, String codFilial) throws SQLException {
        ResultSet rs = null;
        StringBuilder sql = new StringBuilder();
        sql.append(" select coalesce(emc_custosimples, '0.0000') as valorCustoSimples from examematcoleta ");
        sql.append("  where upper(exa_codigo) = upper('").append(codExame).append("')");
        sql.append(" and mco_codigo = ").append(codMatCol);
        sql.append(" and fil_codigo = ").append(codFilial);
        rs = st.executeQuery(sql.toString());
        if (rs.next()) {
            return rs.getBigDecimal("valorCustoSimples");
        }
        return BigDecimal.ZERO.setScale(4);
    }

    public int getCodigoConvenio(String filial, String codigoRequisicao) throws SQLException {
        if (filial == null || codigoRequisicao == null) {
            return 0;
        }
        StringBuilder buf = new StringBuilder();
        buf.append(" select con_codigo ");
        buf.append("   from requisicao ");
        buf.append("  where fil_codigo = ").append(filial);
        buf.append("    and req_codigo = ").append(codigoRequisicao);
        ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
        if (rs.next()) {
            return rs.getInt(1);
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] buscaRequisicaoAgendamentoIDS(String codigoTransacao) throws SQLException {
        Statement st;
        block9: {
            String[] stringArray;
            StringBuilder buf = new StringBuilder();
            buf.append(" select req_codigo as codigo ");
            buf.append("       ,fil_codigo as filial ");
            buf.append("   from requisicao ");
            buf.append("  where req_codigoapoiado = '").append(codigoTransacao).append("' ");
            st = Conexao.getStatement();
            try {
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                if (!rs.next()) break block9;
                stringArray = new String[]{rs.getString("filial"), rs.getString("codigo")};
            }
            catch (Throwable throwable) {
                try {
                    Conexao.fecharStatement(st);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                Conexao.fecharStatement(st);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return stringArray;
        }
        String[] stringArray = null;
        try {
            Conexao.fecharStatement(st);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stringArray;
    }

    @Override
    public AbstractThreadVO getVO(String filial, String codigo) throws ThreadDaoException {
        String where = " where fil_codigo = " + filial + " and req_codigo = " + codigo;
        Set requisicoes = this.loadVO(RequisicaoVO.class, where);
        if (requisicoes == null || requisicoes.size() == 0 || requisicoes.size() > 1) {
            return null;
        }
        return (AbstractThreadVO)requisicoes.toArray()[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String buscaSituacaoDeAgendamento(String codigoRequisicao, String codigoFilial) {
        StringBuffer sql = new StringBuffer();
        sql.append("select agd_situacao from agendamento where req_codigo = ");
        sql.append(codigoRequisicao);
        sql.append(" and fil_codigo = ");
        sql.append(codigoFilial);
        String result = null;
        Statement st = null;
        ResultSet rs = null;
        try {
            st = Conexao.getStatement();
            rs = Conexao.executeQuery(st, sql.toString());
            while (rs.next()) {
                result = rs.getString("agd_situacao");
            }
            st.close();
            rs.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            return result;
        }
    }

    public void updateDadosGuiaEMatricula(String filial, String dataGuia, String guia, String matricula, String requisicao) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append("update requisicao set req_dataguia = '").append(dataGuia).append("'");
        sql.append(", req_guia = '").append(guia).append("'");
        sql.append(", req_matricula = '").append(matricula).append("'");
        sql.append(" where fil_codigo = ").append(filial);
        sql.append(" and req_codigo = ").append(requisicao);
        Statement st = null;
        st = Conexao.getStatement();
        Conexao.executeUpdate(filial, st, sql.toString());
    }

    public int getNumeroDeLotesPorRequisicao(String codigoFilial, String codigoRequisicao) throws SQLException {
        StringBuilder sql = new StringBuilder("select count(1) as numeroDeLotes from lotefilialrequisicao ");
        sql.append("where fil_codigo = ").append(codigoFilial);
        sql.append("and req_codigo = ").append(codigoRequisicao);
        Statement st = Conexao.getStatement();
        ResultSet rs = Conexao.executeQuery(st, sql);
        int numeroDeLotesPorRequisicao = 0;
        if (rs.next()) {
            numeroDeLotesPorRequisicao = rs.getInt("numeroDeLotes");
        }
        return numeroDeLotesPorRequisicao;
    }

    public void atualizarPeriodoGestacional(String codigoFilial, String codigoRequisicao, String periodoGestacional) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append("update requisicao set req_periodogestacional = ").append(periodoGestacional);
        sql.append(", req_gestante = 't' ");
        sql.append(" where fil_codigo = ").append(codigoFilial);
        sql.append(" and req_codigo = ").append(codigoRequisicao);
        Statement st = null;
        st = Conexao.getStatement();
        Conexao.executeUpdate(codigoFilial, st, sql.toString());
        st.close();
    }

    public RequisicaoVO buscaPeriodoGestacional(String codigoFilial, String codigoRequisicao) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append("select req_periodogestacional, req_gestante ");
        sql.append(" from requisicao ");
        sql.append(" where fil_codigo = ").append(codigoFilial);
        sql.append(" and req_codigo = ").append(codigoRequisicao);
        sql.append(" and req_gestante = 't' ");
        Statement st = null;
        st = Conexao.getStatement();
        ResultSet rs = Conexao.executeQuery(st, sql);
        RequisicaoVO requisicaoVO = null;
        if (rs.next()) {
            requisicaoVO = new RequisicaoVO();
            requisicaoVO.setCodigo(Integer.valueOf(codigoRequisicao));
            requisicaoVO.setGestante(rs.getBoolean("req_gestante"));
            requisicaoVO.setPeriodoGestacional(rs.getInt("req_periodogestacional"));
        }
        return requisicaoVO;
    }

    public void atualizarDataSintoma(String codigoFilial, String codigoRequisicao, String dataSintoma) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append("update requisicao set req_datasintoma = '").append(Funcoes.formataData("yyyy-MM-dd", dataSintoma)).append("'");
        sql.append(" where fil_codigo = ").append(codigoFilial);
        sql.append(" and req_codigo = ").append(codigoRequisicao);
        Statement st = Conexao.getStatement();
        Conexao.executeUpdate(codigoFilial, st, sql.toString());
        st.close();
    }

    public void atualizarMunicipioResidencia(String codigoFilial, String codigoRequisicao, String municipioResidencia) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append("update requisicao set req_municipioresidencia = '").append(municipioResidencia).append("'");
        sql.append(" where fil_codigo = ").append(codigoFilial);
        sql.append(" and req_codigo = ").append(codigoRequisicao);
        Statement st = Conexao.getStatement();
        Conexao.executeUpdate(codigoFilial, st, sql.toString());
        st.close();
    }

    public void atualizarApresentacaoSintoma(String codigoFilial, String codigoRequisicao, String apresentouSintoma) throws SQLException {
        StringBuilder sql = new StringBuilder();
        if (!Funcoes.textoVazio(apresentouSintoma)) {
            boolean apresentacao = apresentouSintoma.equalsIgnoreCase("Sim");
            sql.append("update requisicao set req_apresentousintoma = ").append(apresentacao);
            sql.append(" where fil_codigo = ").append(codigoFilial);
            sql.append(" and req_codigo = ").append(codigoRequisicao);
            Statement st = Conexao.getStatement();
            Conexao.executeUpdate(codigoFilial, st, sql.toString());
            st.close();
        }
    }

    public void atualizarSenhaPainel(RequisicaoVO requisicao, String dataHoraEntrada, String dataHoraSolicitacao, String senha) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append("update requisicao set req_datachamadasenha = '").append(Funcoes.formatDataEHora(dataHoraEntrada)).append("',");
        sql.append(" req_dataretiradasenha = '").append(Funcoes.formatDataEHora(dataHoraSolicitacao)).append("',");
        sql.append(" req_senhachamada = '").append(senha).append("'");
        sql.append(" where fil_codigo = ").append(requisicao.getFilial().getCodigo());
        sql.append(" and req_codigo = ").append(requisicao.getCodigo());
        Statement st = Conexao.getStatement();
        Conexao.executeUpdate(requisicao.getFilial().getCodigo().toString(), st, sql.toString());
        st.close();
    }

    public void atualizarSituacaoExamesSemResultadoSemCommit(AgendamentoBean agendamento, String situacao) throws SQLException {
        if (agendamento.getFilial().getCodigo() == null || agendamento.getRequisicao().getCodigo() == null || situacao == null) {
            return;
        }
        Statement st = Conexao.getStatement();
        StringBuilder bufLogSituacao = new StringBuilder();
        bufLogSituacao.append(" select exa_codigo as exame ");
        bufLogSituacao.append("       ,mco_codigo as material ");
        bufLogSituacao.append("       ,exr_situacao as situacao ");
        bufLogSituacao.append("   from examerequisicao ");
        bufLogSituacao.append("  where fil_codigo = ").append(agendamento.getFilial().getCodigo());
        bufLogSituacao.append("    and req_codigo = ").append(agendamento.getRequisicao().getCodigo());
        if (agendamento.getAgendamentoExameRequisicaoBean() != null && agendamento.getAgendamentoExameRequisicaoBean().size() > 0) {
            bufLogSituacao.append(" and exa_codigo in ( ");
            StringBuilder bufExames = new StringBuilder("");
            for (int i = 0; i < agendamento.getAgendamentoExameRequisicaoBean().size(); ++i) {
                if (!agendamento.getAgendamentoExameRequisicaoBean().get(i).getRequisicao().equals(agendamento.getRequisicao().getCodigo())) continue;
                if (!bufExames.toString().isEmpty()) {
                    bufExames.append(", ");
                }
                bufExames.append("'").append(agendamento.getAgendamentoExameRequisicaoBean().get(i).getExame()).append("'");
            }
            if (bufExames.toString().trim().isEmpty()) {
                bufExames.append("null");
            }
            bufLogSituacao.append((CharSequence)bufExames);
            bufLogSituacao.append(" ) ");
        }
        bufLogSituacao.append("    and ((exr_situacao IS NULL or exr_situacao = '') or exr_situacao = '").append("F").append("' ");
        bufLogSituacao.append("    or exr_situacao = '").append("R").append("' ");
        bufLogSituacao.append("    or exr_situacao = '").append("T").append("') ");
        ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), bufLogSituacao);
        if (rs.next()) {
            do {
                DBUtil.gravaLogSituacaoExameRequisicao(st, agendamento.getFilial().getCodigo().toString(), agendamento.getRequisicao().getCodigo().toString(), rs.getString("exame"), rs.getString("material"), Variaveis.login, situacao, false);
            } while (rs.next());
            StringBuilder buf = new StringBuilder();
            buf.append(" update examerequisicao ");
            buf.append("    set exr_situacao = '").append(situacao).append("' ");
            if (situacao.equalsIgnoreCase("T")) {
                buf.append(", usr_codcoletar = '").append(Variaveis.login).append("' ");
                buf.append(", exr_datacoletar = '").append(Funcoes.formataData("yyyy-MM-dd HH:mm:ss.SSS", new Date())).append("' ");
            }
            buf.append("  where fil_codigo = ").append(agendamento.getFilial().getCodigo());
            buf.append("    and req_codigo = ").append(agendamento.getRequisicao().getCodigo());
            if (agendamento.getAgendamentoExameRequisicaoBean() != null && agendamento.getAgendamentoExameRequisicaoBean().size() > 0) {
                buf.append(" and exa_codigo in ( ");
                StringBuilder bufExames = new StringBuilder("");
                for (int i = 0; i < agendamento.getAgendamentoExameRequisicaoBean().size(); ++i) {
                    if (!agendamento.getAgendamentoExameRequisicaoBean().get(i).getRequisicao().equals(agendamento.getRequisicao().getCodigo())) continue;
                    if (!bufExames.toString().isEmpty()) {
                        bufExames.append(", ");
                    }
                    bufExames.append("'").append(agendamento.getAgendamentoExameRequisicaoBean().get(i).getExame()).append("'");
                }
                buf.append((CharSequence)bufExames);
                buf.append(" ) ");
            }
            buf.append("    and (exr_situacao IS NULL ");
            buf.append("    or exr_situacao = '").append("").append("' ");
            buf.append("    or exr_situacao = '").append("F").append("' ");
            buf.append("    or exr_situacao = '").append("R").append("' ");
            buf.append("    or exr_situacao = '").append("T").append("') ");
            Conexao.executeUpdate(agendamento.getFilial().getCodigo().toString(), st, buf.toString());
            ArrayList<ExameRequisicaoVO> examesMultiguia = agendamento.getRequisicao().getExamesMultiguia();
            if (examesMultiguia != null && !examesMultiguia.isEmpty()) {
                this.atualizarExamesMultiguia(st, examesMultiguia, situacao);
            }
        }
    }

    private void atualizarExamesMultiguia(Statement st, ArrayList<ExameRequisicaoVO> examesMultiguia, String situacao) throws SQLException {
        for (ExameRequisicaoVO bean : examesMultiguia) {
            this.atualizarExameRequisicao(bean, situacao, st);
        }
    }

    public void atualizarExameRequisicao(ExameRequisicaoVO bean, String situacao, Statement st) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append(" update examerequisicao ");
        buf.append("    set exr_situacao = '").append(situacao).append("' ");
        if (situacao.equalsIgnoreCase("T")) {
            buf.append(", usr_codcoletar = '").append(Variaveis.login).append("' ");
            buf.append(", exr_datacoletar = '").append(Funcoes.formataData("yyyy-MM-dd HH:mm:ss.SSS", new Date())).append("' ");
        }
        buf.append("  where fil_codigo = ").append(bean.getFilial().getCodigo());
        buf.append("    and req_codigo = ").append(bean.getRequisicao());
        buf.append("    and exa_codigo = '").append(bean.getExame().getCodigo()).append("'");
        buf.append("    and (exr_situacao IS NULL ");
        buf.append("    or exr_situacao = '").append("").append("' ");
        buf.append("    or exr_situacao = '").append("F").append("' ");
        buf.append("    or exr_situacao = '").append("R").append("' ");
        buf.append("    or exr_situacao = '").append("T").append("') ");
        Conexao.executeUpdate(bean.getFilial().getCodigo().toString(), st, buf.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getQuantidadeExames(String filial, String requisicao) {
        Statement st;
        int qtd;
        block4: {
            qtd = 0;
            st = Conexao.getStatement();
            try {
                StringBuilder buf = new StringBuilder();
                buf.append(" SELECT COUNT(exa_codigo) FROM examerequisicao");
                buf.append(" WHERE fil_codigo = ").append(filial);
                buf.append(" AND req_codigo = ").append(requisicao);
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                if (!rs.next()) break block4;
                qtd = rs.getInt("count");
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
        return qtd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Registro> getExamesRequisicao(String filial, String requisicao) {
        ArrayList<Registro> listaExames = new ArrayList<Registro>();
        Statement st = Conexao.getStatement();
        try {
            StringBuilder buf = new StringBuilder();
            buf.append(" SELECT exa_codigo, mco_codigo FROM examerequisicao");
            buf.append(" WHERE fil_codigo = ").append(filial);
            buf.append(" AND req_codigo = ").append(requisicao);
            buf.append(" AND exr_excluido = false ");
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            while (rs.next()) {
                Registro reg = new Registro();
                reg.setValor("exame", rs.getString("exa_codigo"));
                reg.setValor("material", rs.getInt("mco_codigo"));
                listaExames.add(reg);
            }
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
        return listaExames;
    }
}

