/*
 * Decompiled with CFR 0.152.
 */
package jalis.model.dao.recepcao;

import jalis.comum.Conexao;
import jalis.model.AbstractThreadBean;
import jalis.model.AbstractThreadDao;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.recepcao.PendenciasPacienteVO;
import jalis.util.Funcoes;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class PendenciasPacienteDao
extends AbstractThreadDao {
    public ArrayList getListaRequisicao(String codigoFilial, String codigoPaciente, String codigo) throws SQLException {
        ArrayList<PendenciasPacienteVO> listaRequisicao = new ArrayList<PendenciasPacienteVO>();
        PendenciasPacienteVO pendenciasPacienteVO = null;
        StringBuilder buf = new StringBuilder();
        buf.append("select");
        buf.append(" req.req_codigo as codigoRequisicao,");
        buf.append(" req.req_data as dataRequisicao,");
        buf.append(" req.req_dataentregaprev as dataEntrega,");
        buf.append(" (case when (req.req_deveguia or ('{T}'::boolean[] <@ array_agg(exareq.exr_deveguia))) then 'Deve guia' else (case when req.req_guia is null or req.req_guia='' then (case when req.req_guiaprincipal is null then '' else req.req_guiaprincipal end) else req.req_guia end) end) as guiaSituacao,");
        buf.append(" med.med_nome as medico,");
        buf.append(" con.con_fantasia as convenio,");
        buf.append(" req.des_codigo as destino,");
        buf.append(" req.req_total as totalRequisicao,");
        buf.append(" req.req_totpago as valorPago,");
        buf.append(" (case when (req.req_total-req.req_totpago)<0 then 0 else (req.req_total-req.req_totpago) end) as saldoDevedor,");
        buf.append(" req.req_guia as guia,");
        buf.append(" req.req_guiaprincipal as guiaPrincipal,");
        buf.append(" req.req_deveguia as deveGuia,");
        buf.append(" req.pac_codigo,");
        buf.append(" COALESCE(pac.pac_nomepagador, pac.pac_nome) as pac_nomepagador, ");
        buf.append(" COALESCE(pac.pac_cpfpagador, pac.pac_cpf) as pac_cpfpagador, ");
        buf.append(" req.req_notacaixa,");
        buf.append(" (req.req_total - req.req_vlracrescimo + req.req_vlrdesconto - req.req_vlrmateriais - req.req_totaltaxa) as req_vlrexames,");
        buf.append(" req.req_vlrmateriais,");
        buf.append(" req.req_desconto,");
        buf.append(" req.req_vlrdesconto,");
        buf.append(" req.req_acrescimo,");
        buf.append(" req.req_vlracrescimo,");
        buf.append(" req.req_totaltaxa,");
        buf.append(" req.req_guiaprincipalrepasse,");
        buf.append(" req.req_guiarepasse,");
        buf.append(" req.req_matricularepasse,");
        buf.append(" req.req_deveguiarepasse,");
        buf.append(" req.req_validadecarteirarepasse,");
        buf.append(" req.req_validadeguiarepasse,");
        buf.append(" req.req_nomeplanorepasse,");
        buf.append(" req.con_codigo");
        buf.append(" from");
        buf.append(" requisicao req");
        buf.append(" left join medico med");
        buf.append(" on req.fil_codigo = med.fil_codigo");
        buf.append(" and req.med_crm = med.med_crm");
        buf.append(" and req.med_uf = med.med_uf");
        buf.append(" and req.med_conselho = med.med_conselho");
        buf.append(" left join convenios con");
        buf.append(" on req.fil_codigo = con.fil_codigo");
        buf.append(" and req.con_codigo = con.con_codigo");
        buf.append(" left join paciente pac");
        buf.append(" on pac.fil_codigo = req.fil_codigo");
        buf.append(" and pac.pac_codigo = req.pac_codigo");
        buf.append(" left join examerequisicao exareq");
        buf.append(" on req.fil_codigo = exareq.fil_codigo");
        buf.append(" and req.req_codigo = exareq.req_codigo");
        buf.append(" and exareq.exr_excluido = false");
        buf.append(" and exareq.exr_datacortesia is null");
        buf.append(" where");
        buf.append(" req.fil_codigo = ").append(codigoFilial);
        buf.append(" and req.pac_codigo = ").append(codigoPaciente);
        buf.append(" and req.req_excluida = false");
        buf.append(" and (((req.req_totpago + req.req_vlrdesconto) < req.req_total + req.req_vlrdesconto) or (req.req_deveguia or exareq.exr_deveguia))");
        if (!Funcoes.textoVazio(codigo)) {
            buf.append(" and req.req_codigo <> ").append(codigo);
        }
        buf.append(" group by");
        buf.append(" codigoRequisicao,");
        buf.append(" dataRequisicao,");
        buf.append(" dataEntrega,");
        buf.append(" medico,");
        buf.append(" convenio,");
        buf.append(" destino,");
        buf.append(" totalRequisicao,");
        buf.append(" valorPago,");
        buf.append(" saldoDevedor,");
        buf.append(" guia,");
        buf.append(" guiaPrincipal,");
        buf.append(" deveGuia,");
        buf.append(" req.pac_codigo,");
        buf.append(" pac.pac_nomepagador,");
        buf.append(" pac.pac_cpfpagador,");
        buf.append(" req.req_notacaixa,");
        buf.append(" req_vlrexames,");
        buf.append(" req.req_vlrmateriais,");
        buf.append(" req.req_desconto,");
        buf.append(" req.req_vlrdesconto,");
        buf.append(" req.req_acrescimo,");
        buf.append(" req.req_vlracrescimo,");
        buf.append(" req.req_totaltaxa,");
        buf.append(" req.req_guiaprincipalrepasse,");
        buf.append(" req.req_guiarepasse,");
        buf.append(" req.req_matricularepasse,");
        buf.append(" req.req_deveguiarepasse,");
        buf.append(" req.req_validadecarteirarepasse,");
        buf.append(" req.req_validadeguiarepasse,");
        buf.append(" req.req_nomeplanorepasse,");
        buf.append(" req.con_codigo,");
        buf.append(" pac.pac_nome, ");
        buf.append(" pac.pac_nomepagador, ");
        buf.append(" pac.pac_cpf, ");
        buf.append(" pac.pac_cpfpagador ");
        buf.append(" order by req.req_codigo desc");
        Statement st = Conexao.getStatement();
        ResultSet rs = Conexao.executeQuery(st, buf);
        while (rs.next()) {
            pendenciasPacienteVO = new PendenciasPacienteVO();
            pendenciasPacienteVO.setCodigoFilial(Integer.parseInt(codigoFilial));
            pendenciasPacienteVO.setCodigoRequisicao(rs.getInt("codigoRequisicao"));
            pendenciasPacienteVO.setDataRequisicao(rs.getDate("dataRequisicao"));
            pendenciasPacienteVO.setDataEntregaRequisicao(rs.getDate("dataEntrega"));
            pendenciasPacienteVO.setGuiaSituacaoRequisicao(rs.getString("guiaSituacao"));
            pendenciasPacienteVO.setMedicoRequisicao(rs.getString("medico"));
            pendenciasPacienteVO.setConvenioRequisicao(rs.getString("convenio"));
            pendenciasPacienteVO.setDestinoRequisicao(rs.getString("destino"));
            pendenciasPacienteVO.setValorTotalRequisicao(rs.getDouble("totalRequisicao"));
            pendenciasPacienteVO.setValorPagoRequisicao(rs.getDouble("valorPago"));
            pendenciasPacienteVO.setSaldoDevedorRequisicao(rs.getDouble("saldoDevedor"));
            pendenciasPacienteVO.setGuiaRequisicao(rs.getString("guia"));
            pendenciasPacienteVO.setGuiaPrincipalRequisicao(rs.getString("guiaPrincipal"));
            pendenciasPacienteVO.setDeveGuiaRequisicao(rs.getBoolean("deveGuia"));
            pendenciasPacienteVO.setCodigoPaciente(rs.getInt("pac_codigo"));
            pendenciasPacienteVO.setNomePagador(rs.getString("pac_nomepagador"));
            pendenciasPacienteVO.setCpfPagador(rs.getString("pac_cpfpagador"));
            pendenciasPacienteVO.setNotaCaixa(rs.getString("req_notacaixa"));
            pendenciasPacienteVO.setVlrExames(rs.getDouble("req_vlrexames"));
            pendenciasPacienteVO.setVlrMateriais(rs.getDouble("req_vlrmateriais"));
            pendenciasPacienteVO.setDesconto(rs.getDouble("req_desconto"));
            pendenciasPacienteVO.setVlrDesconto(rs.getDouble("req_vlrdesconto"));
            pendenciasPacienteVO.setAcrescimo(rs.getDouble("req_acrescimo"));
            pendenciasPacienteVO.setVlrAcrescimo(rs.getDouble("req_vlracrescimo"));
            pendenciasPacienteVO.setTotalTaxa(rs.getDouble("req_totaltaxa"));
            pendenciasPacienteVO.setGuiaPrincipalRepasse(rs.getString("req_guiaprincipalrepasse"));
            pendenciasPacienteVO.setGuiaRepasse(rs.getString("req_guiarepasse"));
            pendenciasPacienteVO.setMatriculaRepasse(rs.getString("req_matricularepasse"));
            pendenciasPacienteVO.setDeveGuiaRepasse(rs.getBoolean("req_deveguiarepasse"));
            pendenciasPacienteVO.setValidadeCarteira(rs.getDate("req_validadecarteirarepasse"));
            pendenciasPacienteVO.setValidadeGuiaRepasse(rs.getDate("req_validadeguiarepasse"));
            pendenciasPacienteVO.setNomePlanoRepasse(rs.getString("req_nomeplanorepasse"));
            pendenciasPacienteVO.setCodigoConvenio(rs.getInt("con_codigo"));
            listaRequisicao.add(pendenciasPacienteVO);
        }
        return listaRequisicao;
    }

    public ArrayList getListaExame(String codigoFilial, String codigoRequisicao) throws SQLException {
        ArrayList<PendenciasPacienteVO> listaExame = new ArrayList<PendenciasPacienteVO>();
        PendenciasPacienteVO pendenciasPacienteVO = null;
        StringBuilder buf = new StringBuilder();
        buf.append("select");
        buf.append(" exareq.exa_codigo as codigo,");
        buf.append(" exa.exa_descricao as descricao,");
        buf.append(" exareq.exr_situacao as situacao,");
        buf.append(" exareq.exr_guia as guia,");
        buf.append(" exareq.mco_codigo as codigoMaterial,");
        buf.append(" matcol.mco_abreviatura as abreviaturaMaterial,");
        buf.append(" con.con_examesporguia as qntPorGuia,");
        buf.append(" con_codigoguia as codigoGuia,");
        buf.append(" con_validadeguia as validadeGuia,");
        buf.append(" exareq.exr_dataguia as dataGuia,");
        buf.append(" exareq.exr_validadeguia as dataValidadeGuia,");
        buf.append(" exareq.exr_deveguia as deveGuia");
        buf.append(" from");
        buf.append(" examerequisicao exareq");
        buf.append(" left join exames exa");
        buf.append(" on exareq.fil_codigo = exa.fil_codigo");
        buf.append(" and exareq.exa_codigo = exa.exa_codigo");
        buf.append(" left join materialcoleta matcol");
        buf.append(" on exareq.fil_codigo = matcol.fil_codigo");
        buf.append(" and exareq.mco_codigo = matcol.mco_codigo");
        buf.append(" left join requisicao req");
        buf.append(" on exareq.fil_codigo = req.fil_codigo");
        buf.append(" and exareq.req_codigo = req.req_codigo");
        buf.append(" left join convenios con");
        buf.append(" on exareq.fil_codigo = con.fil_codigo");
        buf.append(" and req.con_codigo = con.con_codigo");
        buf.append(" where");
        buf.append(" exareq.fil_codigo = ").append(codigoFilial);
        buf.append(" and exareq.exr_excluido = false");
        buf.append(" and exareq.req_codigo = ").append(codigoRequisicao);
        Statement st = Conexao.getStatement();
        ResultSet rs = Conexao.executeQuery(st, buf);
        while (rs.next()) {
            pendenciasPacienteVO = new PendenciasPacienteVO();
            pendenciasPacienteVO.setCodigoExame(rs.getString("codigo"));
            pendenciasPacienteVO.setDescricaoExame(rs.getString("descricao"));
            pendenciasPacienteVO.setSituacaoExame(rs.getString("situacao"));
            pendenciasPacienteVO.setGuiaExame(rs.getString("guia"));
            pendenciasPacienteVO.setCodigoMaterialExame(rs.getInt("codigoMaterial"));
            pendenciasPacienteVO.setAbreviaturaMaterialExame(rs.getString("abreviaturaMaterial"));
            pendenciasPacienteVO.setQntPorGuiaExame(rs.getInt("qntPorGuia"));
            pendenciasPacienteVO.setCodigoGuiaExame(rs.getBoolean("codigoGuia"));
            pendenciasPacienteVO.setValidadeGuiaExame(rs.getBoolean("validadeGuia"));
            pendenciasPacienteVO.setDataGuiaExame(rs.getDate("dataGuia"));
            pendenciasPacienteVO.setDataValidadeGuiaExame(rs.getDate("dataValidadeGuia"));
            pendenciasPacienteVO.setDeveGuiaExame(rs.getBoolean("deveGuia"));
            listaExame.add(pendenciasPacienteVO);
        }
        return listaExame;
    }

    public void atualizaRequisicao(PendenciasPacienteVO pendenciasPacienteVO) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append(" update requisicao ");
        buf.append(" set req_guia = ?");
        buf.append(" ,req_guiaprincipal = ?");
        buf.append(" ,req_deveguia = ?");
        buf.append(" where fil_codigo = ?");
        buf.append(" and req_codigo = ?");
        PreparedStatement psRequisicao = Conexao.getPreparedStatement(buf.toString());
        psRequisicao.setString(1, pendenciasPacienteVO.getGuiaRequisicao());
        psRequisicao.setString(2, pendenciasPacienteVO.getGuiaPrincipalRequisicao());
        psRequisicao.setBoolean(3, pendenciasPacienteVO.isDeveGuiaRequisicao());
        psRequisicao.setInt(4, pendenciasPacienteVO.getCodigoFilial());
        psRequisicao.setInt(5, pendenciasPacienteVO.getCodigoRequisicao());
        psRequisicao.executeUpdate();
        Conexao.arquivaSQL();
    }

    public void atualizaExame(PendenciasPacienteVO pendenciasPacienteVO) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append(" update examerequisicao ");
        buf.append(" set exr_deveguia = ? ");
        buf.append(" ,exr_guia = ? ");
        buf.append(" ,exr_validadeguia = ? ");
        buf.append(" ,exr_dataguia = ? ");
        buf.append(" where fil_codigo = ? ");
        buf.append(" and req_codigo = ? ");
        buf.append(" and exa_codigo = ? ");
        buf.append(" and mco_codigo = ? ");
        PreparedStatement psExame = Conexao.getPreparedStatement(buf.toString());
        Date dataValidade = null;
        Date dataGuia = null;
        if (!Funcoes.objectIsNull(pendenciasPacienteVO.getDataValidadeGuiaExame())) {
            dataValidade = new Date(pendenciasPacienteVO.getDataValidadeGuiaExame().getTime());
        }
        if (!Funcoes.objectIsNull(pendenciasPacienteVO.getDataGuiaExame())) {
            dataGuia = new Date(pendenciasPacienteVO.getDataGuiaExame().getTime());
        }
        psExame.setBoolean(1, pendenciasPacienteVO.isDeveGuiaExame());
        psExame.setString(2, pendenciasPacienteVO.getGuiaExame());
        psExame.setDate(3, dataValidade);
        psExame.setDate(4, dataGuia);
        psExame.setInt(5, pendenciasPacienteVO.getCodigoFilial());
        psExame.setInt(6, pendenciasPacienteVO.getCodigoRequisicao());
        psExame.setString(7, pendenciasPacienteVO.getCodigoExame());
        psExame.setInt(8, pendenciasPacienteVO.getCodigoMaterialExame());
        psExame.executeUpdate();
        Conexao.arquivaSQL();
    }

    public void atualizaValorPagoRequisicao(PendenciasPacienteVO pendenciasPacienteVO) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append(" update requisicao ");
        buf.append(" set req_totpago = ?");
        buf.append(" , req_total = ?");
        buf.append(" , req_desconto = ?");
        buf.append(" , req_vlrdesconto = ?");
        buf.append(" , req_acrescimo = ?");
        buf.append(" , req_vlracrescimo = ?");
        buf.append(" where fil_codigo = ? and req_codigo = ?");
        PreparedStatement psRequisicao = Conexao.getPreparedStatement(buf.toString());
        psRequisicao.setDouble(1, pendenciasPacienteVO.getValorPagoRequisicao());
        psRequisicao.setDouble(2, pendenciasPacienteVO.getValorTotalRequisicao());
        psRequisicao.setDouble(3, pendenciasPacienteVO.getDesconto());
        psRequisicao.setDouble(4, pendenciasPacienteVO.getVlrDesconto());
        psRequisicao.setDouble(5, pendenciasPacienteVO.getAcrescimo());
        psRequisicao.setDouble(6, pendenciasPacienteVO.getVlrAcrescimo());
        psRequisicao.setInt(7, pendenciasPacienteVO.getCodigoFilial());
        psRequisicao.setInt(8, pendenciasPacienteVO.getCodigoRequisicao());
        psRequisicao.executeUpdate();
        Conexao.arquivaSQL();
    }

    @Override
    public AbstractThreadBean getBean(String codigo) throws ThreadDaoException {
        return null;
    }

    @Override
    public AbstractThreadVO getVO(String codigo) throws ThreadDaoException {
        return null;
    }

    @Override
    public AbstractThreadVO getVO(String filial, String codigo) throws ThreadDaoException {
        return null;
    }
}

