/*
 * Decompiled with CFR 0.152.
 */
package jalis.model.dao.recepcao;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.model.AbstractThreadBean;
import jalis.model.AbstractThreadDao;
import jalis.model.bean.recepcao.OrcamentoBean;
import jalis.model.bean.recepcao.OrcamentoConvenioBean;
import jalis.model.bean.recepcao.OrcamentoConvenioExameBean;
import jalis.model.bean.recepcao.OrcamentoTaxaBean;
import jalis.model.dao.recepcao.OrcamentoConvenioDao;
import jalis.model.dao.recepcao.OrcamentoTaxaDao;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.ConvenioVO;
import jalis.model.vo.cadastro.PacienteVO;
import jalis.model.vo.cadastro.TaxaVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.model.vo.cadastro.exame.ExameVO;
import jalis.model.vo.cadastro.exame.MaterialColetaVO;
import jalis.model.vo.cadastro.exame.MetodologiaVO;
import jalis.model.vo.cadastro.exame.SituacaoVO;
import jalis.model.vo.cadastro.financeiro.FormaPagamentoVO;
import jalis.model.vo.recepcao.OrcamentoVO;
import jalis.relatorio.bean.ExameTerceirizadoBean;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;

public class OrcamentoDao
extends AbstractThreadDao {
    public AbstractThreadBean getBean(String filial, String codigo) throws ThreadDaoException {
        String where = " where fil_codigo = " + filial + " and orc_codigo = " + codigo;
        Set orcamentos = OrcamentoDao.load(OrcamentoBean.class, where);
        if (orcamentos == null || orcamentos.size() == 0 || orcamentos.size() > 1) {
            return null;
        }
        OrcamentoBean orcamento = (OrcamentoBean)orcamentos.toArray()[0];
        this.loadConvenios(orcamento);
        this.loadTaxas(orcamento);
        orcamento.setUtilizado(this.verificaOrcamentoUtilizado(orcamento));
        return orcamento;
    }

    public boolean verificaOrcamentoUtilizado(OrcamentoBean bean) {
        if (bean == null) {
            return false;
        }
        StringBuilder buf = new StringBuilder();
        buf.append(" select count(orc_codigo) as qtde ");
        buf.append("   from requisicao ");
        buf.append("  where fil_codigo = ").append(bean.getFilial().getCodigo());
        buf.append("    and orc_codigo = ").append(bean.getCodigo());
        try {
            ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), buf);
            if (rs.next()) {
                return rs.getInt("qtde") > 0;
            }
            return false;
        }
        catch (SQLException sqle) {
            return false;
        }
    }

    public ArrayList<String> verificaOrcamentoUtilizadoLista(OrcamentoBean bean) {
        ArrayList<String> listaRequisicoes = new ArrayList<String>();
        StringBuilder buf = new StringBuilder();
        buf.append("select req_codigo from requisicao ");
        buf.append(" where fil_codigo = ").append(bean.getFilial().getCodigo());
        buf.append("\tand\t not req_excluida ");
        buf.append(" \tand\t orc_codigo = ").append(bean.getCodigo());
        Statement st = Conexao.getStatement();
        try {
            ResultSet rs = st.executeQuery(buf.toString());
            while (rs.next()) {
                listaRequisicoes.add(rs.getString("req_codigo"));
            }
            st.close();
            rs.close();
        }
        catch (SQLException e) {
            return null;
        }
        return listaRequisicoes;
    }

    @Override
    public AbstractThreadVO getVO(String filial, String codigo) throws ThreadDaoException {
        String where = " where fil_codigo = " + filial + " and orc_codigo = " + codigo;
        Set orcamentos = this.loadVO(OrcamentoVO.class, where);
        if (orcamentos == null || orcamentos.size() == 0 || orcamentos.size() > 1) {
            return null;
        }
        return (OrcamentoVO)orcamentos.toArray()[0];
    }

    public void loadConvenios(OrcamentoBean bean) throws ThreadDaoException {
        OrcamentoConvenioDao dao = new OrcamentoConvenioDao();
        ArrayList<OrcamentoConvenioBean> lista = new ArrayList<OrcamentoConvenioBean>();
        Set<OrcamentoConvenioBean> convenios = dao.getBeans(bean.getFilial().getCodigo().toString(), bean.getCodigo().toString());
        if (convenios != null) {
            Iterator<OrcamentoConvenioBean> it = convenios.iterator();
            while (it.hasNext()) {
                lista.add(it.next());
            }
        }
        Collections.sort(lista, new Comparator(){

            public int compare(Object o1, Object o2) {
                return o1 != null && o2 != null ? ((OrcamentoConvenioBean)o1).getConvenio().getCodigo().compareTo(((OrcamentoConvenioBean)o2).getConvenio().getCodigo()) : 0;
            }
        });
        bean.setConvenios(lista);
    }

    public void loadTaxas(OrcamentoBean bean) throws ThreadDaoException {
        OrcamentoTaxaDao dao = new OrcamentoTaxaDao();
        ArrayList<OrcamentoTaxaBean> lista = new ArrayList<OrcamentoTaxaBean>();
        Set<OrcamentoTaxaBean> taxas = dao.getBeans(bean.getFilial().getCodigo().toString(), bean.getCodigo().toString());
        if (null != taxas && !taxas.isEmpty()) {
            Iterator<OrcamentoTaxaBean> it = taxas.iterator();
            while (it.hasNext()) {
                lista.add(it.next());
            }
        }
        Collections.sort(lista, new Comparator(){

            public int compare(Object o1, Object o2) {
                return o1 != null && o2 != null ? ((OrcamentoTaxaBean)o1).getTaxa().getCodigo().compareTo(((OrcamentoTaxaBean)o2).getTaxa().getCodigo()) : 0;
            }
        });
        bean.setTaxas(lista);
    }

    @Override
    public AbstractThreadBean getBean(String codigo) throws ThreadDaoException {
        return this.getBean(Variaveis.filialPadrao, codigo);
    }

    @Override
    public AbstractThreadVO getVO(String codigo) throws ThreadDaoException {
        return this.getVO(Variaveis.filialPadrao, codigo);
    }

    public String consultaTerceirizazao(ExameTerceirizadoBean exameTerceirizadoBean) {
        StringBuilder sql = new StringBuilder();
        sql.append(" select CASE WHEN (SELECT array_to_string(array_agg(exa_codigo ), ', ') FROM examematcoletalabexterno WHERE ");
        if (!Funcoes.textoVazio(exameTerceirizadoBean.getFilialCodigo())) {
            sql.append(" fil_codigo = ").append(exameTerceirizadoBean.getFilialCodigo()).append(" AND ");
        }
        if (!Funcoes.textoVazio(exameTerceirizadoBean.getExameCodigo())) {
            sql.append(" exa_codigo = '").append(exameTerceirizadoBean.getExameCodigo()).append("' AND ");
        }
        if (!Funcoes.textoVazio(exameTerceirizadoBean.getMaterialColetado())) {
            sql.append(" mco_codigo = ").append(exameTerceirizadoBean.getMaterialColetado()).append(" AND ");
        }
        if (!Funcoes.textoVazio(exameTerceirizadoBean.getMetodologia())) {
            sql.append(" met_codigo = ").append(exameTerceirizadoBean.getMetodologia()).append(" AND ");
        }
        sql.append(" (ele_bloqueado IS NULL OR ele_bloqueado = FALSE)) IS NOT NULL THEN 'Terceirizado' ELSE ''  END AS terceirizado ");
        try {
            ResultSet resultSetTerceirizado = Conexao.executeQuery(Conexao.getStatement(), sql.toString());
            if (resultSetTerceirizado.next()) {
                return resultSetTerceirizado.getString("terceirizado");
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    public Set<OrcamentoBean> loadAprovados(String textFieldDataFinal, String textFieldDataFinalAprovacao, String textFieldDataInicial, String textFieldDataInicialAprovacao, String textFieldSolicitante, String usuariosSelecionados, String solicitante, String clientes) throws ThreadDaoException {
        StringBuilder where = new StringBuilder();
        where.append(" where  fil_codigo = ").append(Variaveis.filialPadrao);
        if (!Funcoes.textoVazio(textFieldDataFinal.trim()) && !Funcoes.textoVazio(textFieldDataInicial.trim())) {
            where.append(" and cast(orc_datahora as date) >= '").append(Funcoes.formataData("yyyy-MM-dd", textFieldDataInicial.trim())).append("'");
            where.append(" and cast(orc_datahora as date) <= '").append(Funcoes.formataData("yyyy-MM-dd", textFieldDataFinal.trim())).append("'");
        } else if (!Funcoes.textoVazio(textFieldDataInicial.trim())) {
            where.append(" and  cast(orc_datahora as date) >= '").append(Funcoes.formataData("yyyy-MM-dd", textFieldDataInicial.trim())).append("'");
        } else if (!Funcoes.textoVazio(textFieldDataFinal.trim())) {
            where.append(" and  cast(orc_datahora as date) <= '").append(Funcoes.formataData("yyyy-MM-dd", textFieldDataFinal.trim())).append("'");
        }
        if (!Funcoes.textoVazio(textFieldDataFinalAprovacao.trim()) && !Funcoes.textoVazio(textFieldDataInicialAprovacao.trim())) {
            where.append(" and cast(orc_dataaprovado as date) >= '").append(Funcoes.formataData("yyyy-MM-dd", textFieldDataInicialAprovacao.trim())).append("'");
            where.append(" and cast(orc_dataaprovado as date) <= '").append(Funcoes.formataData("yyyy-MM-dd", textFieldDataFinalAprovacao.trim())).append("'");
        } else if (!Funcoes.textoVazio(textFieldDataInicialAprovacao.trim())) {
            where.append(" and cast(orc_dataaprovado as date) >= '").append(Funcoes.formataData("yyyy-MM-dd", textFieldDataInicialAprovacao.trim())).append("'");
        } else if (!Funcoes.textoVazio(textFieldDataFinalAprovacao.trim())) {
            where.append(" and cast(orc_dataaprovado as date) <= '").append(Funcoes.formataData("yyyy-MM-dd", textFieldDataFinalAprovacao.trim())).append("'");
        }
        if (!Funcoes.textoVazio(usuariosSelecionados.trim())) {
            where.append(" and usr_codaprovado in (").append(usuariosSelecionados.trim()).append(") ");
        }
        if (!Funcoes.textoVazio(clientes.trim())) {
            where.append(" and pac_codigo in (").append(clientes.trim()).append(") ");
        }
        if (!Funcoes.textoVazio(solicitante.trim())) {
            where.append(" and upper(orc_solicitante) like upper('%").append(solicitante.trim()).append("%')");
        }
        where.append(" and orc_dataaprovado is not null and usr_codaprovado is not null ");
        Set orcamentoBeans = OrcamentoDao.load(OrcamentoBean.class, where.toString());
        for (OrcamentoBean orcamentoBean : orcamentoBeans) {
            this.loadConvenios(orcamentoBean);
            this.loadTaxas(orcamentoBean);
        }
        return orcamentoBeans;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void carregarFormaPagamento(OrcamentoBean orcamento) {
        Statement st;
        block4: {
            st = Conexao.getStatement();
            try {
                if (!DBUtil.campoExiste(st, "orcamento", "fpg_codigo")) break block4;
                StringBuilder buf = new StringBuilder();
                buf.append(" select a.fpg_codigo ");
                buf.append("       ,b.fpg_descricao ");
                buf.append("   from orcamento a ");
                buf.append("   left join formapagto b on a.fil_codigo = b.fil_codigo and a.fpg_codigo = b.fpg_codigo ");
                buf.append("  where a.fil_codigo = ").append(orcamento.getFilial().getCodigo());
                buf.append("    and a.orc_codigo = ").append(orcamento.getCodigo());
                ResultSet rs = Conexao.executeQuery(st, buf);
                if (!rs.next()) break block4;
                FormaPagamentoVO vo = new FormaPagamentoVO();
                vo.setFilial(orcamento.getFilial());
                vo.setCodigo(rs.getInt("fpg_codigo"));
                vo.setDescricao(rs.getString("fpg_descricao"));
                orcamento.setFormaPagamento(vo);
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void atualizarFormaPagamento(OrcamentoBean orcamento) {
        Statement st;
        block4: {
            st = Conexao.getStatement();
            try {
                if (!DBUtil.campoExiste(st, "orcamento", "fpg_codigo")) break block4;
                StringBuilder buf = new StringBuilder();
                buf.append(" update orcamento ");
                buf.append("    set fpg_codigo = ").append(orcamento.getFormaPagamento() != null ? orcamento.getFormaPagamento().getCodigo() : null);
                buf.append("  where fil_codigo = ").append(orcamento.getFilial().getCodigo());
                buf.append("    and orc_codigo = ").append(orcamento.getCodigo());
                Conexao.executeUpdate(orcamento.getFilial().getCodigo().toString(), st, buf.toString());
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int contadorAlteracoes(OrcamentoBean bean) {
        Statement st;
        int retorno;
        block5: {
            if (bean == null) {
                return 0;
            }
            retorno = 0;
            StringBuilder buf = new StringBuilder();
            buf.append(" select count(orc_codigo) as qtde ");
            buf.append("   from orcamentolog ");
            buf.append("  where fil_codigo = ").append(bean.getFilial().getCodigo());
            buf.append("    and orc_codigo = ").append(bean.getCodigo());
            st = Conexao.getStatement();
            try {
                ResultSet rs = Conexao.executeQuery(st, buf);
                if (!rs.next()) break block5;
                retorno = rs.getInt(1);
            }
            catch (SQLException sqle) {
                try {
                    sqle.printStackTrace();
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
        return retorno;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AbstractThreadBean getBeanManual(String filial, String codigo) throws ThreadDaoException {
        OrcamentoBean bean;
        Statement st;
        block10: {
            StringBuilder buf = new StringBuilder("select ").append("a.fil_codigo, a.orc_codigo, a.orc_datahora, a.orc_observacao, ").append("a.orc_percentualdesconto, a.orc_valordesconto, ").append("a.orc_validade, a.orc_solicitante, ").append("a.orc_contato, a.orc_email, ").append("a.usr_codigo, a.orc_proprietario, ").append("a.pac_codigo, a.orc_percentualacrescimo, ").append("a.orc_valoracrescimo, a.usr_codaprovado, ").append("a.orc_dataaprovado, a.orc_aprovadopor, ").append("a.orc_fone, a.orc_fonecontato, ").append("a.fpg_codigo, a.sit_codigo, ").append("a.med_conselho, a.med_crm, ").append("a.med_uf, ").append("b.pac_nome, b.pac_nomesocial, b.pac_celular, b.pac_fone, ").append("c.med_nome, ").append("d.fpg_descricao, e.sit_descricao, ").append("f.usr_nome, g.usr_nome as usr_nomeaprovado ").append(" from orcamento a ").append(" left join paciente b on a.fil_codigo = b.fil_codigo and a.pac_codigo = b.pac_codigo ").append(" left join medico c on a.fil_codigo = c.fil_codigo and a.med_conselho = c.med_conselho and a.med_crm = c.med_crm and a.med_uf = c.med_uf ").append(" left join formapagto d on a.fil_codigo = d.fil_codigo and a.fpg_codigo = d.fpg_codigo ").append(" left join situacao e on a.fil_codigo = e.fil_codigo and a.sit_codigo = e.sit_codigo ").append(" left join usuario f on a.usr_codigo = f.usr_codigo ").append(" left join usuario g on a.usr_codaprovado = g.usr_codigo ").append(" where a.fil_codigo = " + filial).append("   and a.orc_codigo = " + codigo);
            st = Conexao.getStatement();
            ResultSet rs = null;
            bean = null;
            try {
                rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    FilialVO f = new FilialVO();
                    f.setCodigo(rs.getInt("fil_codigo"));
                    FormaPagamentoVO fpg = new FormaPagamentoVO();
                    fpg.setCodigo(rs.getInt("fpg_codigo"));
                    fpg.setDescricao(rs.getString("fpg_descricao"));
                    SituacaoVO sit = new SituacaoVO();
                    sit.setCodigo(rs.getInt("sit_codigo"));
                    sit.setDescricao(rs.getString("sit_descricao"));
                    PacienteVO pac = new PacienteVO();
                    pac.setCodigo(rs.getInt("pac_codigo"));
                    pac.setNome(rs.getString("pac_nome"));
                    pac.setNomeSocial(rs.getString("pac_nomesocial"));
                    pac.setCelular(rs.getString("pac_celular"));
                    pac.setFone(rs.getString("pac_fone"));
                    UsuarioVO usr = new UsuarioVO();
                    usr.setCodigo(rs.getString("usr_codigo"));
                    usr.setNome(rs.getString("usr_nome"));
                    UsuarioVO usrAprovado = new UsuarioVO();
                    usrAprovado.setCodigo(rs.getString("usr_codaprovado"));
                    usrAprovado.setNome(rs.getString("usr_nomeaprovado"));
                    bean = new OrcamentoBean();
                    bean.setFilial(f);
                    bean.setFormaPagamento(DBUtil.campoNull(rs.getString("fpg_codigo")) ? null : fpg);
                    bean.setPaciente(DBUtil.campoNull(rs.getString("pac_codigo")) ? null : pac);
                    bean.setSituacao(DBUtil.campoNull(rs.getString("sit_codigo")) ? null : sit);
                    bean.setUsuario(usr);
                    bean.setUsuarioAprovacao(DBUtil.campoNull(rs.getString("usr_codaprovado")) ? null : usrAprovado);
                    bean.setAprovadorPor(rs.getString("orc_aprovadopor"));
                    bean.setCodigo(rs.getInt("orc_codigo"));
                    bean.setContato(rs.getString("orc_contato"));
                    bean.setDataHora(rs.getTimestamp("orc_datahora"));
                    bean.setDataHoraAprovacao(rs.getTimestamp("orc_dataaprovado"));
                    bean.setEmail(rs.getString("orc_email"));
                    bean.setFone(rs.getString("orc_fone"));
                    bean.setFoneContato(rs.getString("orc_fonecontato"));
                    bean.setMedicoConselho(rs.getString("med_conselho"));
                    bean.setMedicoCRM(rs.getString("med_crm"));
                    bean.setMedicoUF(rs.getString("med_uf"));
                    bean.setObservacao(rs.getString("orc_observacao"));
                    bean.setPercentualAcrescimo(rs.getDouble("orc_percentualacrescimo"));
                    bean.setPercentualDesconto(rs.getDouble("orc_percentualdesconto"));
                    bean.setProprietario(rs.getString("orc_proprietario"));
                    bean.setSolicitante(rs.getString("orc_solicitante"));
                    bean.setValidade(rs.getString("orc_validade"));
                    bean.setValorAcrescimo(rs.getDouble("orc_valoracrescimo"));
                    bean.setValorDesconto(rs.getDouble("orc_valordesconto"));
                    bean.setUtilizado(this.verificaOrcamentoUtilizado(bean));
                    bean.setConvenios(this.loadConveniosManual(bean));
                    bean.setTaxas(this.loadTaxasManual(bean));
                }
                if (null == rs) break block10;
            }
            catch (Exception e) {
                try {
                    throw new ThreadDaoException(e.getMessage());
                }
                catch (Throwable throwable) {
                    if (null != rs) {
                        try {
                            rs.close();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
            }
            try {
                rs.close();
            }
            catch (SQLException f) {
                // empty catch block
            }
        }
        Conexao.fecharStatement(st);
        return bean;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrayList<OrcamentoConvenioBean> loadConveniosManual(OrcamentoBean orcamento) throws ThreadDaoException {
        Statement st;
        ArrayList<OrcamentoConvenioBean> lista;
        block11: {
            if (null == orcamento) {
                return null;
            }
            lista = new ArrayList<OrcamentoConvenioBean>();
            StringBuilder buf = new StringBuilder("select ").append("a.fil_codigo, a.orc_codigo, a.con_codigo, ").append("a.oco_valortotal, a.oco_descontoautorizado, ").append("a.usr_coddesconto, ").append("b.con_fantasia, b.con_razao, ").append("f.usr_nome ").append(" from orcamentoconvenio a ").append(" left join convenios b on a.fil_codigo = b.fil_codigo and a.con_codigo = b.con_codigo ").append(" left join usuario f on a.usr_coddesconto = f.usr_codigo ").append(" where a.fil_codigo = " + orcamento.getFilial().getCodigo()).append("   and a.orc_codigo = " + orcamento.getCodigo()).append(" order by a.con_codigo ");
            st = Conexao.getStatement();
            ResultSet rs = null;
            try {
                rs = Conexao.executeQuery(st, buf.toString());
                while (rs.next()) {
                    FilialVO f = new FilialVO();
                    f.setCodigo(rs.getInt("fil_codigo"));
                    ConvenioVO con = new ConvenioVO();
                    con.setCodigo(rs.getInt("con_codigo"));
                    con.setFantasia(rs.getString("con_fantasia"));
                    con.setRazaoSocial(rs.getString("con_razao"));
                    UsuarioVO usr = new UsuarioVO();
                    usr.setCodigo(rs.getString("usr_coddesconto"));
                    usr.setNome(rs.getString("usr_nome"));
                    OrcamentoVO orc = new OrcamentoVO();
                    orc.setCodigo(rs.getInt("orc_codigo"));
                    OrcamentoConvenioBean bean = new OrcamentoConvenioBean();
                    bean.setFilial(f);
                    bean.setOrcamento(orc);
                    bean.setConvenio(con);
                    bean.setOrcamento((OrcamentoVO)orcamento.toVO());
                    bean.setUsuarioDesconto(DBUtil.campoNull(rs.getString("usr_coddesconto")) ? null : usr);
                    bean.setValorTotal(rs.getDouble("oco_valortotal"));
                    bean.setDescontoAutorizado(rs.getDouble("oco_descontoautorizado"));
                    bean.setExames(this.loadExamesManual(bean));
                    lista.add(bean);
                }
                if (null == rs) break block11;
            }
            catch (Exception e) {
                try {
                    throw new ThreadDaoException(e.getMessage());
                }
                catch (Throwable throwable) {
                    if (null != rs) {
                        try {
                            rs.close();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
            }
            try {
                rs.close();
            }
            catch (SQLException f) {
                // empty catch block
            }
        }
        Conexao.fecharStatement(st);
        return lista;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrayList<OrcamentoConvenioExameBean> loadExamesManual(OrcamentoConvenioBean convenio) throws ThreadDaoException {
        Statement st;
        ArrayList<OrcamentoConvenioExameBean> lista;
        block11: {
            if (null == convenio) {
                return null;
            }
            lista = new ArrayList<OrcamentoConvenioExameBean>();
            StringBuilder buf = new StringBuilder("select ").append("a.fil_codigo, a.orc_codigo, a.con_codigo, a.exa_codigo, a.mco_codigo, ").append("a.oce_valor, a.oce_naopermitido, a.oce_valordesconto, ").append("a.oce_ordemadicao, a.oce_valoracrescimo, a.oce_quantidade, ").append("a.met_codigo, b.exa_descricao, c.mco_descricao, c.mco_abreviatura, ").append("d.met_descricao ").append(" from orcamentoconvenioexame a ").append(" left join exames b on a.fil_codigo = b.fil_codigo and a.exa_codigo = b.exa_codigo ").append(" left join materialcoleta c on a.fil_codigo = c.fil_codigo and a.mco_codigo = c.mco_codigo ").append(" left join metodologia d on a.fil_codigo = d.fil_codigo and a.met_codigo = d.met_codigo ").append(" where a.fil_codigo = " + convenio.getFilial().getCodigo()).append("   and a.orc_codigo = " + convenio.getOrcamento().getCodigo()).append("   and a.con_codigo = " + convenio.getConvenio().getCodigo()).append(" order by a.oce_ordemadicao ");
            st = Conexao.getStatement();
            ResultSet rs = null;
            try {
                rs = Conexao.executeQuery(st, buf.toString());
                while (rs.next()) {
                    FilialVO f = new FilialVO();
                    f.setCodigo(rs.getInt("fil_codigo"));
                    ConvenioVO con = new ConvenioVO();
                    con.setCodigo(rs.getInt("con_codigo"));
                    MetodologiaVO met = new MetodologiaVO();
                    met.setCodigo(rs.getInt("met_codigo"));
                    ExameVO exm = new ExameVO();
                    exm.setCodigo(rs.getString("exa_codigo"));
                    exm.setDescricao(rs.getString("exa_descricao"));
                    MaterialColetaVO mat = new MaterialColetaVO();
                    mat.setCodigo(rs.getInt("mco_codigo"));
                    mat.setDescricao(rs.getString("mco_descricao"));
                    mat.setAbreviatura(rs.getString("mco_abreviatura"));
                    OrcamentoConvenioExameBean bean = new OrcamentoConvenioExameBean();
                    bean.setFilial(f);
                    bean.setConvenio(con);
                    bean.setExame(exm);
                    bean.setMaterial(mat);
                    bean.setMetodologia(DBUtil.campoNull("met_codigo") ? null : met);
                    bean.setNaoPermitido(rs.getBoolean("oce_naopermitido"));
                    bean.setOrdemAdicao(rs.getInt("oce_ordemadicao"));
                    bean.setQuantidadeExame(rs.getInt("oce_quantidade"));
                    bean.setValor(rs.getDouble("oce_valor"));
                    bean.setValorAcrescimo(rs.getDouble("oce_valoracrescimo"));
                    bean.setValorDesconto(rs.getDouble("oce_valordesconto"));
                    lista.add(bean);
                }
                if (null == rs) break block11;
            }
            catch (Exception e) {
                try {
                    throw new ThreadDaoException(e.getMessage());
                }
                catch (Throwable throwable) {
                    if (null != rs) {
                        try {
                            rs.close();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
            }
            try {
                rs.close();
            }
            catch (SQLException f) {
                // empty catch block
            }
        }
        Conexao.fecharStatement(st);
        return lista;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrayList<OrcamentoTaxaBean> loadTaxasManual(OrcamentoBean orcamento) throws ThreadDaoException {
        Statement st;
        ArrayList<OrcamentoTaxaBean> lista;
        block11: {
            if (null == orcamento) {
                return null;
            }
            lista = new ArrayList<OrcamentoTaxaBean>();
            StringBuilder buf = new StringBuilder("select ").append("a.fil_codigo, a.orc_codigo, a.tax_codigo, ").append("a.ota_valor, a.ota_quantidade, ").append("b.tax_descricao, b.tax_valor ").append(" from orcamentotaxa a ").append(" left join taxa b on a.fil_codigo = b.fil_codigo and a.tax_codigo = b.tax_codigo ").append(" where a.fil_codigo = " + orcamento.getFilial().getCodigo()).append("   and a.orc_codigo = " + orcamento.getCodigo()).append(" order by a.tax_codigo ");
            st = Conexao.getStatement();
            ResultSet rs = null;
            try {
                rs = Conexao.executeQuery(st, buf.toString());
                while (rs.next()) {
                    FilialVO f = new FilialVO();
                    f.setCodigo(rs.getInt("fil_codigo"));
                    TaxaVO tax = new TaxaVO();
                    tax.setCodigo(rs.getInt("tax_codigo"));
                    tax.setDescricao(rs.getString("tax_descricao"));
                    tax.setValor(rs.getDouble("tax_valor"));
                    OrcamentoTaxaBean bean = new OrcamentoTaxaBean();
                    bean.setFilial(f);
                    bean.setTaxa(tax);
                    bean.setValor(rs.getDouble("ota_valor"));
                    bean.setQuantidade(rs.getDouble("ota_quantidade"));
                    lista.add(bean);
                }
                if (null == rs) break block11;
            }
            catch (Exception e) {
                try {
                    throw new ThreadDaoException(e.getMessage());
                }
                catch (Throwable throwable) {
                    if (null != rs) {
                        try {
                            rs.close();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
            }
            try {
                rs.close();
            }
            catch (SQLException f) {
                // empty catch block
            }
        }
        Conexao.fecharStatement(st);
        return lista;
    }
}

