/*
 * Decompiled with CFR 0.152.
 */
package jalis.model.dao.recepcao;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.model.AbstractThreadBean;
import jalis.model.AbstractThreadDao;
import jalis.model.ThreadBeanDaoMultiplasChaves;
import jalis.model.bean.recepcao.ExameRequisicaoBean;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.model.vo.cadastro.exame.ExameVO;
import jalis.model.vo.cadastro.exame.MaterialColetaVO;
import jalis.model.vo.recepcao.ExameRequisicaoVO;
import jalis.service.cadastro.exame.ExameSetorService;
import jalis.service.recepcao.ExameRequisicaoLaminasService;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.tabela.Registro;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ExameRequisicaoDao
extends AbstractThreadDao
implements ThreadBeanDaoMultiplasChaves {
    public ArrayList<ExameRequisicaoVO> getVOs(Map<String, Object> chaves) throws ThreadDaoException {
        ArrayList<String> wheres = new ArrayList<String>();
        for (String chave : chaves.keySet()) {
            wheres.add(chave + "=" + this.getValorParaBanco(chaves.get(chave)));
        }
        String where = " where " + StringUtil.implode(wheres, " and ");
        Set aux = ExameRequisicaoDao.load(ExameRequisicaoVO.class, where);
        if (aux == null || aux.size() == 0) {
            return null;
        }
        return new ArrayList<ExameRequisicaoVO>(aux);
    }

    public ArrayList<ExameRequisicaoVO> getVOsIn(Map<String, Object> chaves, Statement st, String filialPadrao, boolean isColetaWeb) throws ThreadDaoException, SQLException {
        ArrayList<String> wheres = new ArrayList<String>();
        for (String chave : chaves.keySet()) {
            wheres.add(chave + " in (" + chaves.get(chave) + ")");
        }
        String where = " where " + StringUtil.implode(wheres, " and ");
        String sql = ExameRequisicaoDao.getSql(ExameRequisicaoVO.class, where);
        Set aux = null;
        if (isColetaWeb) {
            ResultSet rs = st.executeQuery(sql);
            return this.preencheVO(rs);
        }
        aux = ExameRequisicaoDao.load2(ExameRequisicaoVO.class, where, st, filialPadrao);
        if (aux == null || aux.isEmpty()) {
            return new ArrayList<ExameRequisicaoVO>();
        }
        return new ArrayList<ExameRequisicaoVO>(aux);
    }

    public ArrayList<ExameRequisicaoVO> preencheVO(ResultSet rs) throws SQLException {
        ArrayList<ExameRequisicaoVO> retorno = new ArrayList<ExameRequisicaoVO>();
        while (rs.next()) {
            ExameRequisicaoVO vo = new ExameRequisicaoVO();
            vo.setVolumeDiurese(rs.getDouble("exr_volumediurese"));
            vo.setValorExame(rs.getDouble("exr_vlrexame"));
            vo.setItemExameWareline(rs.getInt("exr_itemexamewareline"));
            vo.setRequisicao(rs.getInt("req_codigo"));
            vo.setCodigo(rs.getInt("req_codigo"));
            vo.setValorCh(rs.getDouble("exr_vlrch"));
            vo.setOrdem(rs.getInt("exr_ordem"));
            vo.setValorChExame(rs.getDouble("exr_vlrchexame"));
            vo.setSequencialSalux(rs.getString("exr_sequencialsalux"));
            FilialVO filVO = new FilialVO();
            filVO.setCodigo(rs.getInt("fil_codigo"));
            vo.setFilial(filVO);
            MaterialColetaVO matVO = new MaterialColetaVO();
            matVO.setCodigo(rs.getInt("mco_codigo"));
            vo.setMaterial(matVO);
            vo.setValorMaterial(rs.getDouble("exr_vlrmaterial"));
            vo.setMaterialExterno(rs.getBoolean("exr_matexterno"));
            vo.setSolicitadoTISS(rs.getBoolean("exr_solicitadotiss"));
            vo.setAvisarEntrega(rs.getBoolean("exr_avisarentrega"));
            vo.setDeveGuia(rs.getBoolean("exr_deveguia"));
            vo.setExcluido(rs.getBoolean("exr_excluido"));
            vo.setUrgente(rs.getBoolean("exr_urgente"));
            vo.setInterfaceado(rs.getBoolean("exr_interfaciado"));
            vo.setNaoFaturar(rs.getBoolean("exr_naofaturar"));
            vo.setAutorizar(rs.getBoolean("exr_autorizar"));
            vo.setDataEntrega(rs.getDate("exr_dataentreguerst"));
            vo.setDataColetar(rs.getDate("exr_datacoletar"));
            vo.setDataFatura(rs.getDate("exr_datafatura"));
            vo.setDataAutorizacao(rs.getDate("exr_dataautorizacao"));
            vo.setDataGuia(rs.getDate("exr_dataguia"));
            vo.setDataEntregaPrevista(rs.getDate("exr_dataentregaprev"));
            vo.setDataEtiquetaColeta(rs.getDate("exr_dataetqcoleta"));
            vo.setDataSolicitadoTISS(rs.getDate("exr_datasolicitadotiss"));
            vo.setDataMaterial(rs.getDate("exr_datamaterial"));
            vo.setDataCortesia(rs.getDate("exr_datacortesia"));
            vo.setData(rs.getDate("exr_data"));
            vo.setSituacao(rs.getString("exr_situacao"));
            vo.setGuia(rs.getString("exr_guia"));
            vo.setUsuarioEntrega(rs.getString("usr_codentrega"));
            vo.setResposta(rs.getString("exr_resposta"));
            UsuarioVO usrVO = new UsuarioVO();
            usrVO.setCodigo(rs.getString("usr_codigo"));
            vo.setUsuario(usrVO);
            ExameVO exaVO = new ExameVO();
            exaVO.setCodigo(rs.getString("exa_codigo"));
            vo.setExame(exaVO);
            vo.setNotificacao(rs.getString("exr_notificacao"));
            vo.setObservacao(rs.getString("exr_obs"));
            vo.setCodAutorizacao(rs.getString("exr_codautorizacao"));
            vo.setEntreguePara(rs.getString("exr_entrpara"));
            vo.setUsuarioColetar(rs.getString("usr_codcoletar"));
            vo.setPercentualBalcao(rs.getDouble("exr_vlrbalcaoconvenio"));
            vo.setMaterialInformado(rs.getString("exr_descricaomaterial"));
            retorno.add(vo);
        }
        return retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<ExameRequisicaoVO> getVOsAgendameto(Map<String, Object> chaves, String codigo) throws Exception {
        ArrayList<String> wheres = new ArrayList<String>();
        ArrayList<ExameRequisicaoVO> retorno = new ArrayList<ExameRequisicaoVO>();
        for (String chave : chaves.keySet()) {
            wheres.add("exr." + chave + "=" + this.getValorParaBanco(chaves.get(chave)));
        }
        String where = " where " + StringUtil.implode(wheres, " and ");
        StringBuilder sql = new StringBuilder();
        sql.append("  SELECT exr.fil_codigo, ");
        sql.append("  \t\t\t exr.exr_excluido, ");
        sql.append("  \t\t\t exr.exr_situacao, ");
        sql.append("  \t\t\t exr.exr_datamaterial, ");
        sql.append("  \t\t\t exa.exa_codigo, ");
        sql.append("  \t\t\t exa.exa_descricao, ");
        sql.append(" \t\t\t\t mco.mco_codigo, ");
        sql.append(" \t\t\t\t mco.mco_descricao, ");
        sql.append(" \t\t\t\t exr.exr_matexterno, ");
        sql.append(" \t\t\t\t exr.exr_datacortesia, ");
        sql.append(" \t\t\t\t exr.exr_naofaturar, ");
        sql.append(" \t\t\t\t exr.exr_urgente, ");
        sql.append("         agx.req_codigo, ");
        sql.append("         (select case when count(*) >0 then true else false end from agendamentoexamerequisicao where fil_codigo = ").append(chaves.get("fil_codigo")).append(" and agd_codigo = ").append(codigo).append(") as contemregistros");
        sql.append("    from examerequisicao  exr ");
        sql.append("  left join requisicao a on a.fil_codigo = exr.fil_codigo and a.req_codigo = exr.req_codigo ");
        sql.append("  left JOIN exames exa ON exr.fil_codigo = exa.fil_codigo AND exr.exa_codigo = exa.exa_codigo ");
        sql.append("  left JOIN examematcoleta emc ON exr.fil_codigo = emc.fil_codigo AND exr.exa_codigo = emc.exa_codigo AND exr.mco_codigo = emc.mco_codigo ");
        sql.append("  left JOIN materialcoleta mco ON emc.fil_codigo = mco.fil_codigo AND emc.mco_codigo = mco.mco_codigo ");
        sql.append("  left Join agendamentoexamerequisicao agx ON agx.fil_codigo = exa.fil_codigo AND exr.req_codigo = agx.req_codigo AND agx.exa_codigo = emc.exa_codigo and agx.mco_codigo = emc.mco_codigo AND agx.agd_codigo = ").append(codigo).append(" ");
        sql.append(where);
        if (!Funcoes.textoVazio(codigo)) {
            sql.append(" and agx.agd_codigo= ").append(codigo);
        }
        Statement st = Conexao.getStatement();
        ResultSet rs = Conexao.executeQuery(st, sql.toString());
        try {
            if (rs.next()) {
                do {
                    if (rs.getBoolean("contemregistros") && !chaves.get("req_codigo").toString().equals(rs.getString("req_codigo"))) continue;
                    FilialVO filialVO = new FilialVO();
                    filialVO.setCodigo(rs.getInt("fil_codigo"));
                    ExameVO exameVO = new ExameVO();
                    exameVO.setFilial(filialVO);
                    exameVO.setCodigo(rs.getString("exa_codigo"));
                    exameVO.setDescricao(rs.getString("exa_descricao"));
                    MaterialColetaVO materialColetaVO = new MaterialColetaVO();
                    materialColetaVO.setFilial(filialVO);
                    materialColetaVO.setCodigo(rs.getInt("mco_codigo"));
                    materialColetaVO.setDescricao(rs.getString("mco_descricao"));
                    ExameRequisicaoVO exameRequisicaoVO = new ExameRequisicaoVO();
                    exameRequisicaoVO.setFilial(filialVO);
                    exameRequisicaoVO.setRequisicao(rs.getInt("req_codigo"));
                    if (!rs.getBoolean("contemregistros") && Funcoes.textoVazio(rs.getString("req_codigo"))) {
                        exameRequisicaoVO.setRequisicao((Integer)chaves.get("req_codigo"));
                    }
                    exameRequisicaoVO.setSituacao(rs.getString("exr_situacao"));
                    exameRequisicaoVO.setExame(exameVO);
                    exameRequisicaoVO.setMaterial(materialColetaVO);
                    if (!(rs.getString("exr_situacao").equals("F") || rs.getString("exr_situacao").equals("T") || rs.getString("exr_situacao").equals("") || rs.getString("exr_situacao").equals("R"))) {
                        exameRequisicaoVO.setDataMaterial(rs.getTimestamp("exr_datamaterial"));
                    }
                    exameRequisicaoVO.setExcluido(rs.getBoolean("exr_excluido"));
                    exameRequisicaoVO.setMaterialExterno(rs.getBoolean("exr_matexterno"));
                    exameRequisicaoVO.setDataCortesia(rs.getDate("exr_datacortesia"));
                    exameRequisicaoVO.setNaoFaturar(rs.getBoolean("exr_naofaturar"));
                    exameRequisicaoVO.setUrgente(rs.getBoolean("exr_urgente"));
                    retorno.add(exameRequisicaoVO);
                } while (rs.next());
            }
        }
        finally {
            st.close();
            if (rs != null) {
                rs.close();
            }
        }
        return retorno;
    }

    @Override
    public AbstractThreadBean getBean(Map<String, Object> chaves) throws ThreadDaoException {
        ArrayList<String> wheres = new ArrayList<String>();
        for (String chave : chaves.keySet()) {
            wheres.add(chave + "=" + this.getValorParaBanco(chaves.get(chave)));
        }
        String where = " where " + StringUtil.implode(wheres, " and ");
        Set aux = ExameRequisicaoDao.load(ExameRequisicaoBean.class, where);
        if (aux == null || aux.size() == 0 || aux.size() > 1) {
            return null;
        }
        ((ExameRequisicaoBean)aux.toArray()[0]).setIdentificadores(new ExameRequisicaoLaminasService().getBeans(chaves));
        chaves.remove("req_codigo");
        ((ExameRequisicaoBean)aux.toArray()[0]).setSetores(new ExameSetorService().getSetoresExameVO(chaves));
        return (ExameRequisicaoBean)aux.toArray()[0];
    }

    @Override
    public AbstractThreadVO getVO(Map<String, Object> chaves) throws ThreadDaoException {
        ArrayList<String> wheres = new ArrayList<String>();
        for (String chave : chaves.keySet()) {
            wheres.add(chave + "=" + this.getValorParaBanco(chaves.get(chave)));
        }
        String where = " where " + StringUtil.implode(wheres, " and ");
        Set aux = this.loadVO(ExameRequisicaoVO.class, where);
        if (aux == null || aux.size() == 0 || aux.size() > 1) {
            return null;
        }
        return (ExameRequisicaoVO)aux.toArray()[0];
    }

    public ArrayList<ExameRequisicaoBean> getBeans(Map<String, Object> chaves, Statement st) throws ThreadDaoException {
        ArrayList<String> wheres = new ArrayList<String>();
        for (String chave : chaves.keySet()) {
            wheres.add(chave + "=" + this.getValorParaBanco(chaves.get(chave)));
        }
        String where = " where " + StringUtil.implode(wheres, " and ");
        Set aux = ExameRequisicaoDao.load2(ExameRequisicaoBean.class, where, st, Variaveis.filialPadrao);
        if (aux == null || aux.size() == 0) {
            return null;
        }
        Object[] lista = aux.toArray();
        for (int i = 0; i < lista.length; ++i) {
            HashMap<String, Object> chave = new HashMap<String, Object>();
            chave.put("fil_codigo", chaves.get("fil_codigo"));
            chave.put("exa_codigo", ((ExameRequisicaoBean)lista[i]).getExame().getCodigo());
            ((ExameRequisicaoBean)lista[i]).setSetores(new ExameSetorService().getSetoresExameVO(chave));
            chave.put("req_codigo", ((ExameRequisicaoBean)lista[i]).getRequisicao());
            chave.put("mco_codigo", ((ExameRequisicaoBean)lista[i]).getMaterialColeta().getCodigo());
            ((ExameRequisicaoBean)lista[i]).setIdentificadores(new ExameRequisicaoLaminasService().getBeans(chave));
        }
        return new ArrayList<ExameRequisicaoBean>(aux);
    }

    @Override
    @Deprecated
    public AbstractThreadBean getBean(String codigo) throws ThreadDaoException {
        return null;
    }

    @Override
    @Deprecated
    public AbstractThreadVO getVO(String codigo) throws ThreadDaoException {
        return null;
    }

    public void marcarExameComoRecebidoTransporte(Registro registro) throws SQLException {
        DBUtil.gravaLogSituacaoExameRequisicao(Conexao.getStatement(), registro.getString("fil_codigo"), registro.getString("req_codigo"), registro.getString("exa_codigo"), registro.getString("mco_codigo"), Variaveis.login, "", false);
        StringBuilder sql = new StringBuilder();
        sql.append(" update examerequisicao set exr_datatransportechegada = '");
        sql.append(Funcoes.formataData("yyyy-MM-dd HH:mm:ss", Calendar.getInstance().getTime())).append("' ");
        sql.append(" ,usr_codtransportechegada = '");
        sql.append(Variaveis.login).append("' ");
        sql.append(" ,exr_situacao = '' ");
        sql.append(" where req_codigo = ").append(registro.getInt("req_codigo"));
        sql.append("   and fil_codigo = ").append(registro.getInt("fil_codigo"));
        sql.append("   and exa_codigo = '").append(registro.getString("exa_codigo")).append("'");
        Conexao.executeUpdate(registro.getString("fil_codigo"), Conexao.getStatement(), sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getExameModificadoRetificado(Integer codigoFilial, Integer codigoRequisicao, String codigoExame, Integer codigoMaterial) throws SQLException {
        Statement st;
        block3: {
            boolean bl;
            StringBuilder buf = new StringBuilder();
            buf.append(" select SUM(case when ers_situacao = '").append("C").append("' then 1 else 0 end) > 1 as modificado ");
            buf.append("   from examerequisicaosituacoes ");
            buf.append("  where fil_codigo = ").append(codigoFilial);
            buf.append("    and req_codigo = ").append(codigoRequisicao);
            buf.append("    and exa_codigo = '").append(codigoExame).append("' ");
            buf.append("    and mco_codigo = ").append(codigoMaterial);
            st = Conexao.getStatement();
            try {
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                if (!rs.next()) break block3;
                bl = rs.getBoolean("modificado");
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
            return bl;
        }
        boolean bl = false;
        Conexao.fecharStatement(st);
        return bl;
    }

    @Override
    public AbstractThreadVO getVO(String filial, String codigo) throws ThreadDaoException {
        return null;
    }
}

