/*
 * Decompiled with CFR 0.152.
 */
package jalis.model.dao.recepcao;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.dados.DadosExames;
import jalis.comum.dados.DadosMaterial;
import jalis.model.AbstractThreadBean;
import jalis.model.AbstractThreadDao;
import jalis.model.ThreadBeanDaoMultiplasChaves;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.recepcao.EntregaResultadoVO;
import jalis.util.ExameUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class EntregaResultadoDao
extends AbstractThreadDao
implements ThreadBeanDaoMultiplasChaves {
    public List<EntregaResultadoVO> getVOsDadosExames(String codigo, String codigoFilial) throws SQLException {
        StringBuilder buf = new StringBuilder();
        Statement st = Conexao.getStatementTratandoShutdown();
        ResultSet rs = null;
        buf.append("select a.exa_codigo, a.mco_codigo, a.exr_dataentreguerst, a.usr_codentrega, a.exr_dataentregaprev, ");
        buf.append(" a.exr_situacao, a.exr_entrpara, a.exr_obs, ");
        buf.append("a.exr_vlrchexame, a.exr_vlrexame, a.exr_vlrmaterial, a.exr_valorporte, ");
        buf.append("a.exr_valorcusto, a.exr_porte, a.exr_valoruco, a.exr_valorchexamerepasse, ");
        buf.append("a.exr_valorchrepasse, a.exr_valorporterepasse, a.exr_valorcustorepasse, ");
        buf.append("a.exr_valorucorepasse, a.exr_porterepasse, case when a.exr_notificacao is null or a.exr_notificacao = '' then ex.exa_corponotificacao else a.exr_notificacao end as notificacao ");
        buf.append(" from examerequisicao a ");
        buf.append("   left join exames ex on a.fil_codigo = ex.fil_codigo and a.exa_codigo = ex.exa_codigo ");
        if (ParametrosGerais.getOrdenarSetor()) {
            buf.append("left join examesetor b on a.fil_codigo = b.fil_codigo and a.exa_codigo = b.exa_codigo ");
        }
        buf.append("left join examematcoleta d on a.fil_codigo = d.fil_codigo and a.exa_codigo = d.exa_codigo and a.mco_codigo = d.mco_codigo ");
        buf.append("where a.fil_codigo = ");
        buf.append(codigoFilial);
        buf.append(" and a.req_codigo = ");
        buf.append(codigo);
        buf.append(" and a.exr_excluido = false ");
        if (ParametrosGerais.getOrdenarSetor()) {
            buf.append(" and b.ese_default = true ");
        }
        buf.append("order by ");
        if (ParametrosGerais.getOrdenarSetor()) {
            buf.append("b.set_codigo, ");
        }
        buf.append("d.emc_pagina, d.emc_ordem, a.exa_codigo, a.mco_codigo ");
        ArrayList<EntregaResultadoVO> entregaResultados = null;
        rs = Conexao.executeQuery(st, buf.toString());
        entregaResultados = new ArrayList<EntregaResultadoVO>();
        while (rs.next()) {
            DadosMaterial mat = ExameUtil.getDadosMaterial(codigoFilial, rs.getInt("mco_codigo"));
            DadosExames d = ExameUtil.getDadosExame(codigoFilial, rs.getString("exa_codigo"), mat);
            mat.setShowAbreviatura(true);
            d.setValorCH(rs.getBigDecimal("exr_vlrchexame"));
            d.setValorExame(rs.getBigDecimal("exr_vlrexame"));
            d.setValorMaterial(rs.getBigDecimal("exr_vlrmaterial"));
            d.setValor(d.getValorExame().add(d.getValorMaterial()));
            d.setValorPorte(rs.getBigDecimal("exr_valorporte"));
            d.setCusto(rs.getBigDecimal("exr_valorcusto"));
            d.setPorte(rs.getString("exr_porte"));
            d.setUco(rs.getBigDecimal("exr_valoruco"));
            d.setValorExameRepasse(rs.getBigDecimal("exr_valorchexamerepasse"));
            d.setValorCHRepasse(rs.getBigDecimal("exr_valorchrepasse"));
            d.setValorPorteRepasse(rs.getBigDecimal("exr_valorporterepasse"));
            d.setCustoRepasse(rs.getBigDecimal("exr_valorcustorepasse"));
            d.setPorteRepasse(rs.getString("exr_porterepasse"));
            d.setUcoRepasse(rs.getBigDecimal("exr_valorucorepasse"));
            d.setNotificacaoCorpo(rs.getString("notificacao"));
            EntregaResultadoVO obj = new EntregaResultadoVO();
            obj.setDadosExames(d);
            obj.setDadosMaterial(mat);
            obj.setExrdataentregaprev(rs.getTimestamp("exr_dataentregaprev"));
            obj.setExrdataentreguerst(rs.getTimestamp("exr_dataentreguerst"));
            obj.setExrsituacao(rs.getString("exr_situacao"));
            obj.setUsrcodentrega(rs.getString("usr_codentrega"));
            obj.setExrobs(rs.getString("exr_obs"));
            obj.setExrentrpara(rs.getString("exr_entrpara"));
            entregaResultados.add(obj);
        }
        return entregaResultados;
    }

    @Override
    public AbstractThreadBean getBean(Map<String, Object> chaves) throws ThreadDaoException {
        return null;
    }

    @Override
    public AbstractThreadVO getVO(Map<String, Object> chaves) throws ThreadDaoException {
        return null;
    }

    @Override
    public AbstractThreadBean getBean(String codigo) throws ThreadDaoException {
        return null;
    }

    @Override
    public AbstractThreadVO getVO(String codigo) throws ThreadDaoException {
        return null;
    }

    @Override
    public AbstractThreadVO getVO(String filial, String codigo) throws ThreadDaoException {
        return null;
    }
}

