/*
 * Decompiled with CFR 0.152.
 */
package jalis.model.dao.interfaceamento.liberacaoexame;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.model.vo.cadastro.PacienteVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.model.vo.cadastro.exame.ExameVO;
import jalis.model.vo.cadastro.exame.InterfaceExameRequisicaoVO;
import jalis.model.vo.cadastro.exame.InterfaceVO;
import jalis.model.vo.cadastro.exame.MaterialColetaVO;
import jalis.model.vo.cadastro.exame.MetodologiaVO;
import jalis.model.vo.interfaceamento.liberacaoexame.AbaRecoletaVO;
import jalis.model.vo.recepcao.RequisicaoVO;
import jalis.model.vo.triagem.RecipienteVO;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class AbaRecoletaDao {
    public List<AbaRecoletaVO> pesquisarRecoletasInterface(String[] filiais, String[] coletas, String[] destinos, int equipamento) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append("select a.fil_codigo, a.req_codigo, a.exa_codigo, a.mco_codigo, a.rec_codigo, ");
        sql.append("a.ier_situacao, a.ier_xmlvalores,a.usr_codigo, b.req_anomes, b.req_idade, ");
        sql.append("c.pac_nome, c.pac_sexo, d.mco_abreviatura, a.ier_rackpos, ");
        sql.append("a.int_codigo,  f.met_codigo, ");
        sql.append("(b.req_urgente or (coalesce(pegaUrgenteExame(a.fil_codigo, a.exa_codigo, a.mco_codigo, a.req_codigo), false))) as req_urgente, ");
        sql.append(" pegaDataEntregaExame(a.fil_codigo, a.exa_codigo, a.mco_codigo, a.req_codigo) as exr_dataentregaprev, ");
        sql.append(" pegaAlternativoExameInterface(a.fil_codigo, a.exa_codigo, a.mco_codigo, a.int_codigo) as emi_alternativo, a.ier_resultadoalterado ");
        sql.append(ParametrosGerais.isAgruparGuiasInterface() ? ", pegaCodigoMultiguiaMae(a.fil_codigo, a.req_codigo) as multiguia " : "");
        sql.append("from interfaceexamerequisicao a ");
        sql.append("join requisicao b on a.fil_codigo=b.fil_codigo and a.req_codigo=b.req_codigo ");
        sql.append("join paciente c on a.fil_codigo=c.fil_codigo and b.pac_codigo=c.pac_codigo ");
        sql.append("left join examematinterface f on a.fil_codigo=f.fil_codigo and a.exa_codigo=f.exa_codigo and a.mco_codigo=f.mco_codigo and a.int_codigo=f.int_codigo ");
        sql.append("join materialcoleta d on a.fil_codigo=d.fil_codigo and a.mco_codigo=d.mco_codigo ");
        sql.append("join examerequisicao e on a.fil_codigo=e.fil_codigo and a.req_codigo=e.req_codigo and a.exa_codigo=e.exa_codigo and a.mco_codigo=e.mco_codigo ");
        sql.append(this.getCondicaoWhere(filiais, coletas, destinos, equipamento));
        sql.append(ParametrosGerais.isAgruparGuiasInterface() ? " order by a.fil_codigo, multiguia, a.rec_codigo, a.exa_codigo" : " order by a.fil_codigo, a.req_codigo, a.rec_codigo, a.exa_codigo");
        PreparedStatement ps = Conexao.getPreparedStatement(sql.toString());
        ResultSet rs = ps.executeQuery();
        List<AbaRecoletaVO> lista = this.converterResultadoParaLista(rs);
        rs.close();
        ps.close();
        return lista;
    }

    private String getCondicaoWhere(String[] filiais, String[] coletas, String[] destinos, int equipamento) {
        StringBuilder where = new StringBuilder(" where ");
        if (filiais != null && filiais.length > 0) {
            where.append(" a.fil_codigo  in (");
            for (String codFilial : filiais) {
                where.append(codFilial).append(", ");
            }
            where.replace(where.length() - 2, where.length(), "");
            where.append(") and ");
        }
        if (coletas != null && coletas.length > 0) {
            where.append(" b.col_codigo  in (");
            for (String codColeta : coletas) {
                where.append("'").append(codColeta).append("', ");
            }
            where.replace(where.length() - 2, where.length(), "");
            where.append(") and ");
        }
        if (destinos != null && destinos.length > 0) {
            where.append(" b.des_codigo  in (");
            for (String codDestino : destinos) {
                where.append("'").append(codDestino).append("', ");
            }
            where.replace(where.length() - 2, where.length(), "");
            where.append(") and ");
        }
        where.append(" a.int_codigo = ").append(equipamento);
        where.append(" and (a.ier_situacao = ").append(12);
        where.append(" or e.exr_situacao = '").append("R").append("')");
        where.append(" and e.exr_excluido = false and b.req_excluida = false ");
        return where.toString();
    }

    private List<AbaRecoletaVO> converterResultadoParaLista(ResultSet rs) throws SQLException {
        ArrayList<AbaRecoletaVO> lista = new ArrayList<AbaRecoletaVO>();
        while (rs != null && rs.next()) {
            FilialVO filial = new FilialVO();
            filial.setCodigo(rs.getInt("fil_codigo"));
            PacienteVO paciente = new PacienteVO();
            paciente.setNome(rs.getString("pac_nome"));
            paciente.setSexo(rs.getString("pac_sexo"));
            RequisicaoVO requisicao = new RequisicaoVO();
            requisicao.setCodigo(rs.getInt("req_codigo"));
            requisicao.setAnoMes(rs.getString("req_anomes"));
            requisicao.setIdade(rs.getInt("req_idade"));
            requisicao.setUrgente(rs.getBoolean("req_urgente"));
            requisicao.setFilial(filial);
            requisicao.setPaciente(paciente);
            InterfaceVO inter = new InterfaceVO();
            inter.setCodigo(rs.getInt("int_codigo"));
            UsuarioVO usuario = new UsuarioVO();
            usuario.setCodigo(rs.getString("usr_codigo"));
            RecipienteVO recipiente = new RecipienteVO();
            recipiente.setCodigo(rs.getInt("rec_codigo"));
            ExameVO exame = new ExameVO();
            exame.setCodigo(rs.getString("exa_codigo"));
            MaterialColetaVO materialColeta = new MaterialColetaVO();
            materialColeta.setCodigo(rs.getInt("mco_codigo"));
            materialColeta.setAbreviatura(rs.getString("mco_abreviatura"));
            InterfaceExameRequisicaoVO ier = new InterfaceExameRequisicaoVO();
            ier.setSituacao(rs.getInt("ier_situacao"));
            ier.setXmlValores(rs.getString("ier_xmlvalores"));
            ier.setRackPos(rs.getString("ier_rackpos"));
            ier.setResultadoAlterado(rs.getInt("ier_resultadoalterado"));
            ier.setFilial(filial);
            ier.setRequisicao(requisicao);
            ier.setInterfaceamento(inter);
            ier.setUsuario(usuario);
            ier.setRecipiente(recipiente);
            ier.setExame(exame);
            ier.setMatColeta(materialColeta);
            MetodologiaVO metodologia = new MetodologiaVO();
            metodologia.setCodigo(rs.getInt("met_codigo"));
            AbaRecoletaVO abaRecoleta = new AbaRecoletaVO();
            abaRecoleta.setDataEntregaPrev(rs.getDate("exr_dataentregaprev"));
            abaRecoleta.setAlternativo(rs.getString("emi_alternativo"));
            if (this.hasColumn(rs, "multiguia")) {
                abaRecoleta.setMultiguia(rs.getString("multiguia"));
            }
            abaRecoleta.setInterfaceExameRequisicao(ier);
            abaRecoleta.setMetodologia(metodologia);
            lista.add(abaRecoleta);
        }
        return lista;
    }

    private boolean hasColumn(ResultSet rs, String column) {
        try {
            rs.findColumn(column);
            return true;
        }
        catch (SQLException sqlex) {
            return false;
        }
    }
}

