/*
 * Decompiled with CFR 0.152.
 */
package jalis.model.dao.integracaolaboratorioexterno;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.model.bean.loteexterno.LoteExternoRequisicaoRastreioBean;
import jalis.model.vo.cadastro.exame.ExameMatColetaVO;
import jalis.model.vo.cadastro.exame.ExameVO;
import jalis.model.vo.cadastro.exame.MaterialColetaVO;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class LoteExternoRequisicaoRastreioDao {
    public ExameMatColetaVO pesquisarCodigoExameValidoNaMultiguia(LoteExternoRequisicaoRastreioBean rastreio, Integer guia) throws SQLException {
        StringBuilder sql = new StringBuilder(" select leer.exa_codigo, leer.mco_codigo ");
        sql.append(" from loteexternorequisicao ler ");
        sql.append(" join loteexternoexamerequisicao leer on ler.fil_codigo = leer.fil_codigo and ler.lex_codigo = leer.lex_codigo and ler.lae_codigo = leer.lae_codigo and ler.req_codigo = leer.req_codigo ");
        sql.append(" where ler.fil_codigo = ").append(rastreio.getCodigoFilial());
        sql.append(" and ler.req_codigo = ").append(guia);
        sql.append(" and ler.lae_codigo = ").append(rastreio.getCodigoLabExterno());
        sql.append(" and leer.exa_codigo = '").append(rastreio.getCodigoExame()).append("'");
        sql.append(" and leer.mco_codigo = ").append(rastreio.getCodigoMaterial());
        sql.append(" and ler.leq_dataestorno is null and ler.usr_codestorno is null and ler.leq_retornows is not null");
        ResultSet rs = Conexao.getStatement().executeQuery(sql.toString());
        ExameMatColetaVO vo = new ExameMatColetaVO();
        if (rs.next()) {
            ExameVO exame = new ExameVO();
            exame.setCodigo(rs.getString("exa_codigo"));
            MaterialColetaVO material = new MaterialColetaVO();
            material.setCodigo(rs.getInt("mco_codigo"));
            vo.setExame(exame);
            vo.setMaterial(material);
        }
        if (rs != null) {
            rs.close();
        }
        return vo;
    }

    public void inserirLogs(LoteExternoRequisicaoRastreioBean rastreio) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append(" select lex_codigo from loteexternoexamereqrastreio ");
        StringBuilder where = new StringBuilder();
        where.append(" where fil_codigo = ").append(rastreio.getCodigoFilial());
        where.append(" and lex_codigo = ").append(rastreio.getCodigoLoteExterno());
        where.append(" and lae_codigo = ").append(rastreio.getCodigoLabExterno());
        where.append(" and req_codigo = ").append(rastreio.getCodigoRequisicao());
        where.append(" and exa_codigo = '").append(rastreio.getCodigoExame()).append("'");
        where.append(" and mco_codigo = ").append(rastreio.getCodigoMaterial());
        buf.append(where.toString());
        Statement st = Conexao.getStatement();
        ResultSet resultado = st.executeQuery(buf.toString());
        buf.delete(0, buf.length());
        if (resultado.next()) {
            buf.append(" update loteexternoexamereqrastreio set ");
            buf.append(" lrr_codigo = ").append(rastreio.getCodigoRastreio()).append(", ");
            buf.append(" lrr_idtubo = '").append(rastreio.getCodigoTubo()).append("', ");
            buf.append(" lrr_origempedido = '").append(rastreio.getOrigemPedido()).append("', ");
            buf.append(" lrr_datahorastatus = '").append(rastreio.getDataHoraStatus()).append("', ");
            buf.append(" lrr_codigostatus = ").append(rastreio.getCodigoStatus()).append(", ");
            buf.append(" lrr_descricaostatus = '").append(rastreio.getDescricaoStatus()).append("', ");
            buf.append(" lrr_datahorapedido = '").append(rastreio.getDataHoraPedido()).append("', ");
            buf.append(" lrr_sequencialexame = ").append(rastreio.getSequencialExame()).append(", ");
            buf.append(" lrr_codigostatustexto = '").append(rastreio.getCodigoStatusTexto()).append("' ");
            buf.append(where.toString());
        } else {
            buf.append("insert into loteexternoexamereqrastreio ");
            buf.append("(fil_codigo, fil_kodigo, lex_codigo, lae_codigo, req_codigo, lrr_codigo, ");
            buf.append("lrr_idtubo, lrr_origempedido, lrr_datahorastatus, lrr_codigostatus, lrr_descricaostatus, exa_codigo, mco_codigo, ");
            buf.append("lrr_datahorapedido, lrr_sequencialexame, lrr_codigostatustexto )");
            buf.append("values (");
            buf.append(rastreio.getCodigoFilial()).append(", ");
            buf.append(rastreio.getKodigoFilial()).append(", ");
            buf.append(rastreio.getCodigoLoteExterno()).append(", ");
            buf.append(rastreio.getCodigoLabExterno()).append(", ");
            buf.append(rastreio.getCodigoRequisicao()).append(", ");
            buf.append(rastreio.getCodigoRastreio()).append(", ");
            buf.append("'").append(rastreio.getCodigoTubo()).append("', ");
            buf.append("'").append(rastreio.getOrigemPedido()).append("', ");
            buf.append("'").append(rastreio.getDataHoraStatus()).append("', ");
            buf.append(rastreio.getCodigoStatus()).append(", ");
            buf.append("'").append(rastreio.getDescricaoStatus()).append("', ");
            buf.append("'").append(rastreio.getCodigoExame()).append("', ");
            buf.append(rastreio.getCodigoMaterial()).append(",");
            buf.append("'").append(rastreio.getDataHoraPedido()).append("',");
            buf.append(rastreio.getSequencialExame()).append(",");
            buf.append("'").append(rastreio.getCodigoStatusTexto()).append("'");
            buf.append(")");
        }
        Conexao.executeUpdate(rastreio.getCodigoFilial().toString(), st, buf);
        Conexao.arquivaSQL();
    }

    public Integer getMaiorCodigo() throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append("select max(lrr_codigo) as codigo from loteexternoexamereqrastreio where fil_codigo = ").append(Variaveis.filialPadrao);
        ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
        if (rs.next()) {
            return rs.getInt("codigo") + 1;
        }
        return 0;
    }

    public List<LoteExternoRequisicaoRastreioBean> buscarDados(String idtuboLab, String codigoFilial) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append("select err.fil_codigo,");
        buf.append("err.exa_codigo, ");
        buf.append("err.mco_codigo, ");
        buf.append("err.req_codigo,  ");
        buf.append("err.rec_codigo, ");
        buf.append("err.rec_kodigo, ");
        buf.append("err.ere_codigoapoiado, ");
        buf.append("leer.lex_codigo, ");
        buf.append("leer.lae_codigo, ");
        buf.append("leer.fil_kodigo ");
        buf.append("from examerequisicaorecipiente err ");
        buf.append(" inner join loteexternoexamerequisicao leer on  ");
        buf.append(" (err.fil_codigo = leer.fil_codigo and err.req_codigo = leer.req_codigo  and err.exa_codigo = leer.exa_codigo and err.mco_codigo = leer.mco_codigo)");
        buf.append("where leer.fil_codigo =");
        buf.append(codigoFilial);
        Long codigoLab = Long.parseLong(idtuboLab);
        buf.append(" and ere_codigoapoiado = '").append(codigoLab).append("'");
        ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
        ArrayList<LoteExternoRequisicaoRastreioBean> lista = new ArrayList<LoteExternoRequisicaoRastreioBean>();
        while (rs.next()) {
            LoteExternoRequisicaoRastreioBean rastreio = new LoteExternoRequisicaoRastreioBean();
            rastreio.setCodigoFilial(rs.getInt("fil_codigo"));
            rastreio.setCodigoLabExterno(rs.getInt("lae_codigo"));
            rastreio.setCodigoLoteExterno(rs.getLong("lex_codigo"));
            rastreio.setCodigoRequisicao(rs.getInt("req_codigo"));
            rastreio.setCodigoTubo(rs.getString("ere_codigoapoiado"));
            rastreio.setKodigoFilial(rs.getInt("fil_kodigo"));
            rastreio.setCodigoExame(rs.getString("exa_codigo"));
            rastreio.setCodigoMaterial(rs.getInt("mco_codigo"));
            lista.add(rastreio);
        }
        return lista;
    }

    public List<LoteExternoRequisicaoRastreioBean> getRastreabilidade(String codigoFilial, String codigoRequisicao, String codigoExame, Integer codigoMaterial) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append("select lerr.fil_codigo,");
        buf.append("lerr.fil_kodigo, ");
        buf.append("lerr.lex_codigo, ");
        buf.append("lerr.lae_codigo, ");
        buf.append("lerr.req_codigo, ");
        buf.append("lerr.lrr_codigo, ");
        buf.append("lerr.lrr_idtubo, ");
        buf.append("lerr.lrr_origempedido, ");
        buf.append("lerr.lrr_datahorastatus, ");
        buf.append("lerr.lrr_codigostatus, ");
        buf.append("lerr.lrr_codigostatustexto, ");
        buf.append("lerr.lrr_descricaostatus, ");
        buf.append("lerr.exa_codigo, ");
        buf.append("lerr.mco_codigo, ");
        buf.append("lerr.lrr_datahorapedido, ");
        buf.append("lerr.lrr_sequencialexame ");
        buf.append("from loteexternoexamereqrastreio lerr ");
        buf.append("where lerr.fil_codigo = ").append(codigoFilial);
        buf.append(" and lerr.req_codigo = ").append(codigoRequisicao);
        buf.append(" and lerr.exa_codigo = '").append(codigoExame).append("'");
        buf.append(" and lerr.mco_codigo = ").append(codigoMaterial);
        buf.append(" order by lrr_datahorastatus desc ");
        ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
        ArrayList<LoteExternoRequisicaoRastreioBean> lista = new ArrayList<LoteExternoRequisicaoRastreioBean>();
        while (rs.next()) {
            LoteExternoRequisicaoRastreioBean rastreio = new LoteExternoRequisicaoRastreioBean();
            rastreio.setCodigoFilial(rs.getInt("fil_codigo"));
            rastreio.setCodigoLabExterno(rs.getInt("lae_codigo"));
            rastreio.setCodigoLoteExterno(rs.getLong("lex_codigo"));
            rastreio.setCodigoRequisicao(rs.getInt("req_codigo"));
            rastreio.setKodigoFilial(rs.getInt("fil_kodigo"));
            rastreio.setCodigoStatus(rs.getInt("lrr_codigostatus"));
            rastreio.setCodigoStatusTexto(rs.getString("lrr_codigostatustexto"));
            rastreio.setCodigoTubo(rs.getString("lrr_idtubo"));
            rastreio.setCodigoRastreio(rs.getInt("lrr_codigo"));
            rastreio.setOrigemPedido(rs.getString("lrr_origempedido"));
            rastreio.setDataHoraStatus(rs.getString("lrr_datahorastatus"));
            rastreio.setDescricaoStatus(rs.getString("lrr_descricaostatus"));
            rastreio.setCodigoExame(rs.getString("exa_codigo"));
            rastreio.setCodigoMaterial(rs.getInt("mco_codigo"));
            rastreio.setDataHoraPedido(rs.getString("lrr_datahorapedido"));
            rastreio.setSequencialExame(rs.getInt("lrr_sequencialexame"));
            lista.add(rastreio);
        }
        return lista;
    }

    public boolean possuiLogs(String codigoFilial, String codigoRequisicao, String codigoExame, Integer codigoMaterial, String dataHoraStatus) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append("select ");
        buf.append("lrr_codigo as codigo ");
        buf.append("from loteexternoexamereqrastreio where fil_codigo = ").append(codigoFilial);
        buf.append(" and req_codigo = ").append(codigoRequisicao);
        buf.append(" and exa_codigo = '").append(codigoExame).append("' ");
        buf.append(" and mco_codigo = ").append(codigoMaterial);
        buf.append(!Funcoes.textoVazio(dataHoraStatus) ? " and lrr_datahorastatus = '".concat(dataHoraStatus).concat("'") : "");
        ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
        return rs.next();
    }

    public void inserirLogsPendentes(LoteExternoRequisicaoRastreioBean rastreio) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append("insert into loteexternoexamereqrastreio ");
        buf.append("(fil_codigo, fil_kodigo, lex_codigo, lae_codigo, req_codigo, lrr_codigo,");
        buf.append("lrr_idtubo, lrr_origempedido, lrr_datahorastatus, lrr_codigostatus,");
        buf.append("lrr_descricaostatus, exa_codigo, mco_codigo, lrr_datahorapedido, lrr_sequencialexame, lrr_codigostatustexto)");
        buf.append("values (");
        buf.append(rastreio.getCodigoFilial()).append(", ");
        buf.append(rastreio.getKodigoFilial()).append(", ");
        buf.append(rastreio.getCodigoLoteExterno()).append(", ");
        buf.append(rastreio.getCodigoLabExterno()).append(", ");
        buf.append(rastreio.getCodigoRequisicao()).append(", ");
        buf.append(rastreio.getCodigoRastreio()).append(", ");
        buf.append("'").append(rastreio.getCodigoTubo()).append("', ");
        buf.append("'").append(rastreio.getOrigemPedido()).append("', ");
        buf.append("'").append(rastreio.getDataHoraStatus()).append("', ");
        buf.append(rastreio.getCodigoStatus()).append(", ");
        buf.append("'").append(rastreio.getDescricaoStatus()).append("', ");
        buf.append("'").append(rastreio.getCodigoExame()).append("', ");
        buf.append(rastreio.getCodigoMaterial()).append(", ");
        buf.append("'").append(rastreio.getDataHoraPedido()).append("', ");
        buf.append(rastreio.getSequencialExame()).append(", ");
        buf.append(rastreio.getCodigoStatusTexto());
        buf.append(")");
        Conexao.getStatement().executeUpdate(buf.toString());
        Conexao.arquivaSQL();
    }

    public ExameMatColetaVO getExameEMaterialJalis(String codigoExame, String codigoFilial, String requisicaoCodigo, int codigoLabExterno) throws SQLException {
        Integer[] guias;
        boolean agruparMultiguias = ParametrosGerais.isAgruparGuiasInterface() || DBUtil.requisicaoAgrupaMultiguiasLabExternoLote(Conexao.getStatement(), codigoFilial, requisicaoCodigo);
        StringBuilder codigoRequisicao = new StringBuilder(requisicaoCodigo);
        if (agruparMultiguias && (guias = RecepcaoUtil.verificaMultiGuias(codigoFilial, requisicaoCodigo)) != null) {
            for (Integer guia : guias) {
                codigoRequisicao.append(", ").append(guia);
            }
        }
        StringBuilder buf = new StringBuilder();
        buf.append("select ");
        buf.append(" r.exa_codigo as exame, r.mco_codigo as material ");
        buf.append(" from examematcoletalabexterno r ");
        buf.append(" inner join examerequisicao e on e.fil_codigo = r.fil_codigo and r.exa_codigo = e.exa_codigo  and r.mco_codigo = e.mco_codigo ");
        buf.append(" where r.ele_xmllabexterno ilike '%<cd_db>").append(codigoExame).append("</cd_db>%'");
        buf.append(" and r.fil_codigo = ").append(codigoFilial);
        buf.append(" and r.lae_codigo = ").append(codigoLabExterno);
        buf.append(" and e.req_codigo in (").append(codigoRequisicao.toString()).append(" )");
        buf.append(" limit 1 ");
        ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
        ExameMatColetaVO vo = new ExameMatColetaVO();
        if (rs.next()) {
            ExameVO exame = new ExameVO();
            exame.setCodigo(rs.getString("exame"));
            MaterialColetaVO material = new MaterialColetaVO();
            material.setCodigo(rs.getInt("material"));
            vo.setExame(exame);
            vo.setMaterial(material);
        }
        if (rs != null) {
            rs.close();
        }
        return vo;
    }

    public String getDescricaoStatusDB(String codigoStatusDB) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append("select ");
        buf.append("mpp_descricaopaciente as descricao ");
        buf.append("from motivoprocedimentosdb where mpp_codigostatus = '").append(codigoStatusDB).append("'");
        ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
        if (rs.next()) {
            return rs.getString("descricao");
        }
        return "";
    }

    public boolean podeAlterarParaRecoleta(String codigoStatusDB) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append("select ");
        buf.append("mpp_recoleta as recoleta ");
        buf.append("from motivoprocedimentosdb where mpp_codigostatus = '").append(codigoStatusDB).append("'");
        ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
        if (rs.next()) {
            return rs.getBoolean("recoleta");
        }
        return false;
    }

    public String pesquisarCodigoLoteAtivo(String codFilial, String codRequisicao, int codigoLabExterno) throws SQLException {
        String codLote = "";
        StringBuilder sql = new StringBuilder(" select l.lex_codigo ");
        sql.append(" from loteexterno l  ");
        sql.append(" join loteexternorequisicao ler on l.fil_codigo = ler.fil_codigo and l.lex_codigo = ler.lex_codigo and l.lae_codigo = ler.lae_codigo ");
        sql.append(" where ");
        sql.append(" ler.fil_kodigo = ").append(codFilial);
        sql.append(" and l.lae_codigo = ").append(codigoLabExterno);
        sql.append(" and ler.req_codigo = ").append(codRequisicao);
        sql.append(" and (l.lex_dataestorno is null and l.usr_codestorno is null) ");
        sql.append(" and (ler.leq_dataestorno is null and ler.usr_codestorno is null) ");
        ResultSet rs = Conexao.getStatement().executeQuery(sql.toString());
        String string = codLote = rs.next() ? rs.getString("lex_codigo") : "";
        if (rs != null) {
            rs.close();
        }
        return codLote;
    }

    public String buscaRastreabilidadeIndLab(String codigoFilial, String codigoRequisicao, String codigoExame, int codigoMaterial) {
        String retorno = "";
        try {
            boolean agruparMultiguias;
            boolean bl = agruparMultiguias = ParametrosGerais.isAgruparGuiasInterface() || DBUtil.requisicaoAgrupaMultiguiasLabExternoLote(Conexao.getStatement(), codigoFilial, codigoRequisicao);
            if (agruparMultiguias) {
                Integer[] guias = RecepcaoUtil.verificaMultiGuias(codigoFilial, codigoRequisicao, true);
                codigoRequisicao = String.valueOf(this.getCodigoRequisicaoPai(guias));
            }
            StringBuilder buf = new StringBuilder();
            buf.append("select ler.leq_retornows from loteexternoexamerequisicao a");
            buf.append(" inner join labexterno lbex on a.lae_codigo = lbex.lae_codigo ");
            buf.append(" inner join loteexternorequisicao ler on a.fil_codigo = ler.fil_codigo and a.lex_codigo = ler.lex_codigo ");
            buf.append(" where a.fil_kodigo = ").append(codigoFilial);
            buf.append(" and ler.req_codigo =").append(codigoRequisicao);
            buf.append(" and exa_codigo = '").append(codigoExame).append("'");
            buf.append(" and mco_codigo = ").append(codigoMaterial);
            buf.append(" and ler.leq_dataestorno is null");
            ResultSet rs = Conexao.getStatement().executeQuery(buf.toString());
            if (rs.next()) {
                retorno = rs.getString("leq_retornows");
            }
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
        return retorno;
    }

    private Integer getCodigoRequisicaoPai(Integer[] requisicoes) {
        Integer retorno = null;
        if (requisicoes != null) {
            for (int i = 0; i < requisicoes.length; ++i) {
                if (requisicoes[i] > requisicoes[0]) continue;
                retorno = requisicoes[i];
            }
        }
        return retorno;
    }
}

