/*
 * Decompiled with CFR 0.152.
 */
package jalis.model.dao.integracaolaboratorioexterno;

import jalis.comum.Conexao;
import jalis.laboratorio.util.parsers.saomarcos.ExameSaoMarcos;
import jalis.model.vo.cadastro.exame.ExameSaoMarcosVO;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.tabela.Registro;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExameSaoMarcosDao {
    public Map<String, ExameSaoMarcosVO> loadExamesSaoMarcos(int codigoLabExterno, String codigoFilial) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append(this.getSql(codigoLabExterno, codigoFilial));
        Statement st = Conexao.getStatement();
        ResultSet rs = Conexao.executeQuery(st, sql.toString());
        Map<String, ExameSaoMarcosVO> exames = this.getMapObject(rs);
        return exames;
    }

    public Map<String, ExameSaoMarcosVO> loadExamesSaoMarcos(int codigoLabExterno, String codigoExame, String codigoFilial) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append(this.getSql(codigoLabExterno, codigoFilial));
        sql.append("  and sma_codexame = '").append(codigoExame).append("'");
        Statement st = Conexao.getStatement();
        ResultSet rs = Conexao.executeQuery(st, sql.toString());
        Map<String, ExameSaoMarcosVO> exames = this.getMapObject(rs);
        return exames;
    }

    private String getSql(int codigoLabExterno, String codigoFilial) {
        StringBuilder sql = new StringBuilder();
        sql.append(" select distinct fil_codigo, lae_codigo, sma_codexame, sma_descricaoexame, sma_codmaterial, sma_descricaomaterial, sma_xml");
        sql.append(" from examessaomarcos ");
        sql.append("  where fil_codigo = ").append(codigoFilial);
        sql.append("  and lae_codigo = ").append(codigoLabExterno);
        return sql.toString();
    }

    public void atualizarXml(String codigoFilial, int codigoLabExterno, String codigoExame, String xml) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append(" update examessaomarcos set sma_xml = ").append(StringUtil.textoDBEscape(xml));
        sql.append("  where fil_codigo = ").append(codigoFilial);
        sql.append("  and lae_codigo = ").append(codigoLabExterno);
        sql.append("  and sma_codexame = '").append(codigoExame).append("'");
        Statement st = Conexao.getStatement();
        Conexao.executeUpdate(codigoFilial, st, sql.toString());
    }

    public String getXml(String codigoLabExterno, String codigoExameLabApoio, String codigoFilial) throws SQLException {
        ResultSet res;
        StringBuilder sql = new StringBuilder();
        Statement st = Conexao.getStatement();
        sql.append("select sma_xml \n");
        sql.append("from examessaomarcos \n");
        sql.append("where \n  fil_codigo = ").append(codigoFilial).append(" and \n");
        sql.append("  lae_codigo = ").append(codigoLabExterno).append(" and \n");
        sql.append("  sma_codexame = '").append(codigoExameLabApoio).append("'");
        String tmp = null;
        if (!Funcoes.textoVazio(codigoExameLabApoio) && (res = Conexao.executeQuery(st, sql)).next()) {
            tmp = res.getString("sma_xml");
        }
        return tmp;
    }

    private Map<String, ExameSaoMarcosVO> getMapObject(ResultSet rs) throws SQLException {
        HashMap<String, ExameSaoMarcosVO> exames = new HashMap<String, ExameSaoMarcosVO>();
        while (rs.next()) {
            ExameSaoMarcosVO exameSaoMarcosVO = new ExameSaoMarcosVO();
            exameSaoMarcosVO.setSmaCodExame(rs.getString("sma_codexame"));
            exameSaoMarcosVO.setDescricaoExame(rs.getString("sma_descricaoexame"));
            exameSaoMarcosVO.setSmaCodMaterial(rs.getString("sma_codmaterial"));
            exameSaoMarcosVO.setSmaDescricaoMaterial(rs.getString("sma_descricaomaterial"));
            exameSaoMarcosVO.setFilCodigo(rs.getInt("fil_codigo"));
            exameSaoMarcosVO.setLaeCodigo(rs.getInt("lae_codigo"));
            exameSaoMarcosVO.setSmaxml(rs.getString("sma_xml"));
            exames.put(rs.getString("sma_codexame"), exameSaoMarcosVO);
        }
        return exames;
    }

    public boolean buscaRequisicao(String filial, String requisicao) throws SQLException {
        StringBuilder sql = new StringBuilder();
        Statement st = Conexao.getStatement();
        sql.append("select req_codigo \n");
        sql.append("from requisicao \n");
        sql.append("where \n  fil_codigo = ").append(filial).append(" and \n");
        sql.append("  req_codigo = ").append(requisicao).append(" and \n");
        sql.append("  not req_excluida");
        String req_codigo = null;
        ResultSet res = Conexao.executeQuery(st, sql);
        if (res.next()) {
            req_codigo = res.getString("req_codigo");
        }
        return !Funcoes.textoVazio(req_codigo);
    }

    public Registro localizaExame(ExameSaoMarcos exameSaoMarcos, String codigoExame, String codigoMaterial) throws SQLException {
        StringBuilder sql = new StringBuilder("select \n");
        sql.append("  a.fil_codigo, a.req_codigo, a.des_codigo, a.con_codigo, a.pac_codigo, a.req_idade, a.req_anomes, \n");
        sql.append("  b.exa_codigo, b.mco_codigo, b.exr_situacao, pegaResultadoExame(b.fil_codigo, b.req_codigo, b.exa_codigo, b.mco_codigo) as exr_resultado, COALESCE(COALESCE(g.met_codigo, gb.met_codigo), e.met_codigo) as met_codigo, \n");
        sql.append("  c.pac_idade, c.pac_anomes, b.exr_datamaterial, \n");
        sql.append("  d.exa_salvaparcial, g.ele_xmllabexterno, leer.exa_codigo as examePai, a.req_xmlagendamentoids as xmlAgendamentoIDS, a.req_integracaohospital, b.exr_resposta, \n");
        sql.append("  a.req_guia, b.exr_codautorizacao, b.exr_solicitadotiss \n");
        sql.append("from requisicao a \n");
        sql.append("left join examerequisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo \n");
        sql.append("left join paciente c on a.fil_codigo = c.fil_codigo and a.pac_codigo = c.pac_codigo \n");
        sql.append("left join exames d on b.fil_codigo = d.fil_codigo and b.exa_codigo = d.exa_codigo \n");
        sql.append("left join examematcoleta e on b.fil_codigo = e.fil_codigo and b.exa_codigo = e.exa_codigo and b.mco_codigo = e.mco_codigo \n");
        sql.append("left join loteexternoexamerequisicao f on b.fil_codigo = f.fil_kodigo and b.req_codigo = f.req_codigo and b.exa_codigo = f.exa_codigo and b.mco_codigo = f.mco_codigo \n");
        sql.append("left join examematcoletalabexterno g on f.fil_codigo = g.fil_codigo and f.exa_codigo = g.exa_codigo and f.mco_codigo = g.mco_codigo and f.lae_codigo = g.lae_codigo and g.ele_xmllabexterno is not null and g.ele_xmllabexterno <> '' \n");
        sql.append("left join requisicaorequisicao rr on a.fil_codigo = rr.fil_codigo and a.req_codigo = rr.req_kodigo  \n");
        sql.append("left join loteexternoexamerequisicao fb on rr.fil_codigo = fb.fil_kodigo and rr.req_codigo = fb.req_codigo and b.exa_codigo = fb.exa_codigo and b.mco_codigo = fb.mco_codigo \n");
        sql.append("left join examematcoletalabexterno gb on fb.fil_codigo = gb.fil_codigo and fb.exa_codigo = gb.exa_codigo and fb.mco_codigo = gb.mco_codigo and fb.lae_codigo = gb.lae_codigo and gb.ele_xmllabexterno is not null and gb.ele_xmllabexterno <> '' \n");
        sql.append("left join loteexternoexamerequisicaodesm leer on f.fil_codigo = leer.fil_codigo and f.req_codigo = leer.req_codigo  and f.exa_codigo = leer.exa_kodigo and f.mco_codigo = leer.mco_kodigo and f.lae_codigo = leer.lae_codigo\n");
        sql.append(" where \n");
        sql.append("  a.fil_codigo = ").append(exameSaoMarcos.getCodigoFilial()).append(" and \n");
        sql.append("  a.req_codigo = ").append(exameSaoMarcos.getCodigoRequisicao()).append(" and \n");
        sql.append("  b.exa_codigo = '").append(codigoExame).append("'");
        sql.append("  and b.mco_codigo = '").append(codigoMaterial).append("'");
        sql.append("  and a.req_excluida = false and b.exr_excluido = false \n");
        Statement st = Conexao.getStatement();
        ResultSet res = Conexao.executeQuery(st, sql.toString());
        Registro reg = null;
        if (res.next()) {
            reg = new Registro(res);
        }
        return reg;
    }

    public List<Registro> consultaRelacionamentoMatColeta(ExameSaoMarcos exameSaoMarcos) throws SQLException {
        StringBuilder sql = new StringBuilder("select \n");
        sql.append(" emc.fil_codigo, emc.exa_codigo, emc.mco_codigo, emc.lae_codigo, ele_xmllabexterno \n");
        sql.append("from examematcoletalabexterno emc \n");
        sql.append("where \n");
        sql.append("  emc.fil_codigo = ").append(exameSaoMarcos.getCodigoFilial()).append(" and \n");
        sql.append("  emc.lae_codigo = ").append(exameSaoMarcos.getCodigoLaboratorioExterno()).append(" and \n");
        sql.append("  emc.ele_xmllabexterno ilike '%<codigo>").append(exameSaoMarcos.getCodigoExame()).append("</codigo>%'");
        Statement st = Conexao.getStatement();
        ResultSet res = Conexao.executeQuery(st, sql.toString());
        Registro reg = null;
        ArrayList<Registro> listaExames = new ArrayList<Registro>();
        while (res.next()) {
            reg = new Registro(res);
            listaExames.add(reg);
        }
        return listaExames;
    }
}

