/*
 * Decompiled with CFR 0.152.
 */
package jalis.model.dao.integracaohospitais;

import jalis.comum.Conexao;
import jalis.comum.ConexaoTemporaria;
import jalis.comum.Variaveis;
import jalis.comum.dados.DadosConvenios;
import jalis.integracaohospitais.util.IntegracaoHospitalException;
import jalis.integracaohospitais.util.ProtocoloIntegracaoHospital;
import jalis.integracaohospitais.util.TipoIdade;
import jalis.model.AbstractThreadBean;
import jalis.model.AbstractThreadDao;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.DetalheTabelaPrecoVO;
import jalis.service.cadastro.DetalheTabelaPrecoService;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.tabela.Registro;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class IntegracaoHospitalGHospDao
extends AbstractThreadDao {
    private static final String NOME_PACIENTE = "nome_paciente";
    private static final String RG = "rg";
    private static final String CPF = "cpf";
    private static final String DATA_NASC = "data_nasc";
    private static final String ENDERECO = "endereco";
    private static final String TELEFONE = "telefone";
    private static final String COMPLEMENTO = "complemento";
    private static final String NUMERO = "nro";
    private static final String CIDADE = "cidade";
    private static final String BAIRRO = "bairro";
    private static final String PRONTUARIO = "prontuario";
    private static final String SEXO = "sexo";
    private static final String IBGE = "ibge";
    private static final String CEP = "cep";

    @Override
    public AbstractThreadBean getBean(String codigo) throws ThreadDaoException {
        return null;
    }

    @Override
    public AbstractThreadVO getVO(String codigo) throws ThreadDaoException {
        return null;
    }

    @Override
    public AbstractThreadVO getVO(String filial, String codigo) throws ThreadDaoException {
        return null;
    }

    public Integer buscaRequisicao(String filialConf, Integer solicitacao) {
        StringBuilder buf = new StringBuilder();
        try {
            Statement st = Conexao.getStatement();
            buf.append(" select exr.req_codigo as codigo ");
            buf.append("   from examerequisicao exr");
            buf.append(" left join requisicao r on r.fil_codigo = exr.fil_codigo and r.req_codigo = exr.req_codigo ");
            buf.append("  where exr.fil_codigo = ").append(filialConf);
            buf.append("    and exr_guia = ").append(!Funcoes.textoVazio(solicitacao.toString()) ? this.getTextoSql(solicitacao.toString()) : null);
            buf.append("    and exr_excluido = false and req_excluida = false");
            ResultSet rs = ConexaoTemporaria.executeQuery(st, buf.toString());
            if (rs.next()) {
                return rs.getInt("codigo");
            }
        }
        catch (Exception e) {
            HashMap<String, Object> chaves = new HashMap<String, Object>();
            chaves.put("Filial", filialConf);
            chaves.put("Solicita\u00e7\u00e3o", solicitacao);
            chaves.put("Exclu\u00edda", false);
        }
        return null;
    }

    public DetalheTabelaPrecoVO buscaExamePorCodigoAMB(String filialConf, DadosConvenios convenio, String codigoProcedimento, String codigoMaterial, String processoInserirExame, Registro reg, String codigoTerceiroProcedimento) throws Exception {
        DetalheTabelaPrecoService serviceExame = new DetalheTabelaPrecoService();
        DetalheTabelaPrecoVO vo = new DetalheTabelaPrecoVO();
        StringBuilder chaveTabela = new StringBuilder();
        chaveTabela.append("where fil_codigo = ").append(filialConf);
        chaveTabela.append("  and tpe_codigo = ").append(convenio.getTabela());
        chaveTabela.append("  and exa_codigo = '").append(reg.getString(codigoTerceiroProcedimento)).append("'");
        chaveTabela.append("  and mco_codigo= '").append(reg.getString(codigoMaterial)).append("'");
        try {
            Set listaExames = serviceExame.loadVO(chaveTabela.toString());
            Iterator it = listaExames.iterator();
            if (it.hasNext()) {
                vo = (DetalheTabelaPrecoVO)it.next();
                return vo;
            }
        }
        catch (IntegracaoHospitalException e) {
            new IntegracaoHospitalException("C\u00f3digo AMB n\u00e3o encontrado.");
        }
        return vo;
    }

    public Registro buscaDadosExame(Statement stAux, String codFil, String codReq, String codExa, String codMat) throws SQLException {
        StringBuilder buf = new StringBuilder();
        Registro reg = null;
        buf.append(" select usr_codmaterial as usuario ");
        buf.append("       ,exr_datamaterial as data ");
        buf.append("       ,exr_integracaohospital as xmlExame ");
        buf.append("       ,exr_situacao as situacao ");
        buf.append("   from examerequisicao ");
        buf.append("  where fil_codigo = ").append(codFil);
        buf.append("    and req_codigo = ").append(codReq);
        buf.append("    and exa_codigo = ").append(this.getTextoSql(codExa));
        buf.append("    and mco_codigo = ").append(codMat);
        ResultSet rs = Conexao.executeQuery(stAux, buf.toString());
        if (rs.next()) {
            reg = new Registro(rs);
        }
        return reg;
    }

    public boolean buscaDadosMedico(String filialConf, String crmIntegracao, String nomeMedico, String conselho, String uf) throws SQLException {
        Statement st = Conexao.getStatement();
        StringBuilder buf = new StringBuilder();
        buf.append(" select count(1) > 0 as medicoexiste ");
        buf.append("   from medico ");
        buf.append("  where fil_codigo = ").append(filialConf);
        buf.append("    and med_crm = ").append(this.getTextoSql(crmIntegracao));
        buf.append("    and med_conselho = ").append(this.getTextoSql(conselho));
        buf.append("    and med_uf = ").append(this.getTextoSql(uf));
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        return rs.next() && rs.getBoolean("medicoexiste");
    }

    public boolean insereMedicoIntegracao(String filialConf, String crmIntegracao, String nomeMedico, String conselho, String uf) throws SQLException {
        Statement st = ConexaoTemporaria.getStatement();
        StringBuilder buf = new StringBuilder();
        buf.append("insert into medico (fil_codigo, med_crm, med_nome, med_uf, med_conselho) ");
        buf.append(" values ( ");
        buf.append(filialConf);
        buf.append(", ").append(this.getTextoSql(crmIntegracao));
        buf.append(", ").append(this.getTextoSql(nomeMedico));
        buf.append(", ").append(this.getTextoSql(uf));
        buf.append(", ").append(this.getTextoSql(conselho));
        buf.append(" )");
        int qtd = ConexaoTemporaria.executeUpdate(Variaveis.filialPadrao, st, buf.toString(), true);
        if (qtd > 0) {
            ConexaoTemporaria.arquivaSQL();
            ConexaoTemporaria.fecharStatement(st);
            return true;
        }
        return false;
    }

    public Registro buscaDadosConvenio(String filCodigo, Registro dados) throws SQLException {
        Statement st = Conexao.getStatement();
        StringBuilder buf = new StringBuilder();
        Registro reg = null;
        buf.append(" select con_codigo ");
        buf.append("   from convenios ");
        buf.append("  where fil_codigo = ").append(filCodigo);
        buf.append("    and con_integracaohospital ilike '%<").append("protocolo").append(">").append(ProtocoloIntegracaoHospital.G_HOSP.getNome()).append("</").append("protocolo").append(">%' ");
        buf.append("    and con_integracaohospital ilike '%<").append("codigo").append(">").append(dados.getString("convenio_id")).append("</").append("codigo").append(">%' ");
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        if (rs.next()) {
            reg = new Registro(rs);
        }
        return reg;
    }

    public Integer atualizaDadosPaciente(Statement st, String filial, Integer codigoPaciente, Registro solicitacao) throws SQLException {
        StringBuilder buf = new StringBuilder();
        String nomePaciente = solicitacao.getString(NOME_PACIENTE);
        String rgPaciente = solicitacao.getString(RG);
        String cpf = solicitacao.getString(CPF);
        TipoIdade tipoIdade = new TipoIdade(solicitacao.getString(DATA_NASC), Funcoes.formataData("yyyy-MM-dd", new Date()));
        HashMap mapaEndereco = (HashMap)solicitacao.getValor(ENDERECO);
        String sexo = solicitacao.getString(SEXO);
        if (Funcoes.textoVazio(sexo) || !sexo.equalsIgnoreCase("F") && !sexo.equalsIgnoreCase("M")) {
            sexo = "I";
        }
        buf.append("UPDATE paciente set ");
        buf.append("  pac_nome                   = ").append(this.getTextoSql(nomePaciente));
        buf.append(" ,pac_anomes                 = ").append(this.getTextoSql(tipoIdade.getTipoIdade()));
        buf.append(" ,pac_idade                  = ").append(tipoIdade.getQuantidade());
        buf.append(" ,pac_sexo                   = ").append(this.getTextoSql(sexo));
        buf.append(" ,pac_cpf                    = ").append(this.getTextoSql(cpf));
        buf.append(" ,pac_rg                     = ").append(this.getTextoSql(rgPaciente));
        buf.append(" ,pac_fone                   = ").append(this.getTextoSql(solicitacao.getString(TELEFONE)));
        buf.append(" ,pac_complemento            = ").append(this.getTextoSql(solicitacao.getString(COMPLEMENTO)));
        if (this.carregouEndereco(mapaEndereco)) {
            buf.append(" ,pac_endereco               = ").append("COALESCE(").append(this.getTextoSql((String)mapaEndereco.get(ENDERECO))).append(", '') ");
            buf.append(" ,pac_numeroendereco         = ").append("COALESCE(").append(this.getTextoSql((String)mapaEndereco.get(NUMERO))).append(", '') ");
            buf.append(" ,bai_codigo                 = ").append(this.getTextoSql(this.getCodigoBairro(st, filial, (String)mapaEndereco.get(BAIRRO))));
            buf.append(" ,cid_codigo                 = ").append(this.getCodigoMunicipio(st, filial, (String)mapaEndereco.get(IBGE), (String)mapaEndereco.get(CIDADE)));
            buf.append(" ,pac_tipologradouroendereco = ").append(this.getTextoSql("OU"));
        }
        if (solicitacao.possuiCampo("pac_senhaweb")) {
            buf.append(" ,pac_senhaweb = '").append(solicitacao.getString("pac_senhaweb")).append("' ");
        }
        buf.append(" WHERE ");
        buf.append(" fil_codigo = ").append(filial);
        buf.append(" and  pac_codigo = ").append(codigoPaciente);
        buf.append(" and pac_codigoapoiado = ").append(this.getTextoSql(solicitacao.getString(PRONTUARIO)));
        return Conexao.executeUpdate(filial, st, buf.toString());
    }

    public Integer getCodigoMunicipio(Statement st, String filial, String ibge, String nomeMunicipio) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append(" select cid_codigo as codigo ");
        buf.append(" from cidades ");
        buf.append(" where fil_codigo = ").append(filial);
        buf.append(" and cid_codigoibge = ").append(this.getTextoSql(ibge));
        ResultSet rs = ConexaoTemporaria.executeQuery(st, buf.toString());
        if (rs.next()) {
            return rs.getInt("codigo");
        }
        buf = new StringBuilder();
        buf.append(" select cid_codigo as codigo ");
        buf.append(" from cidades ");
        buf.append(" where fil_codigo = ").append(filial);
        buf.append(" and cid_nome ilike ").append(this.getTextoSql(nomeMunicipio));
        rs = ConexaoTemporaria.executeQuery(st, buf.toString());
        if (rs.next()) {
            return rs.getInt("codigo");
        }
        return null;
    }

    public void atualizaLogExportaIntegracaoHospital(String codFil, Long codigoLog, String retorno, String statusIntegracao) throws SQLException {
        StringBuilder buf = new StringBuilder();
        Statement st = Conexao.getStatement();
        buf.append("UPDATE logexportaintegracaohospital SET ");
        buf.append(" lei_situacao  = ").append(this.getTextoSql(statusIntegracao));
        buf.append(" , lei_retorno = ").append(this.getTextoSql(retorno));
        buf.append(" WHERE fil_codigo = ").append(codFil);
        buf.append("   AND eih_codigo = ").append(codigoLog);
        Conexao.executeUpdate(codFil, st, buf.toString(), true);
        Conexao.arquivaSQL();
        Conexao.fecharStatement(st);
    }

    public String getCodigoBairro(Statement st, String filial, String nomeBairro) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append(" select bai_codigo as codigo ");
        buf.append("   from bairro ");
        buf.append("  where fil_codigo = ").append(filial);
        buf.append("    and bai_descricao ilike ").append(this.getTextoSql(nomeBairro));
        ResultSet rs = ConexaoTemporaria.executeQuery(st, buf.toString());
        if (rs.next()) {
            return rs.getString("codigo");
        }
        return null;
    }

    private boolean carregouEndereco(HashMap<String, String> mapaEndereco) {
        return mapaEndereco != null;
    }

    private String getTextoSql(String texto) {
        if (Funcoes.textoVazio(texto)) {
            return "null";
        }
        return "'" + StringUtil.textoDB(texto.toString()) + "'";
    }

    public Integer adicionaRequisicaoMultiguia(Statement st, String codigoFilial, Integer codigoRequisicaoPai, Integer codigoRequisicaoFilho) throws SQLException {
        StringBuilder buf = new StringBuilder("insert into requisicaorequisicao (fil_codigo, req_codigo, req_kodigo) values (");
        buf.append(codigoFilial);
        buf.append(",");
        buf.append(codigoRequisicaoPai);
        buf.append(",");
        buf.append(codigoRequisicaoFilho);
        buf.append(")");
        return ConexaoTemporaria.executeUpdate(codigoFilial, st, buf);
    }
}

