/*
 * Decompiled with CFR 0.152.
 */
package jalis.model.dao.integracaoaplicativo;

import jalis.comum.Conexao;
import jalis.comum.ConexaoAplicativo;
import jalis.laboratorio.Laboratorio;
import jalis.model.vo.integracaojalis.LogsPushAppVO;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class IntegracaoAplicativoDao {
    public void inserirLogs(LogsPushAppVO logsPushApp) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append(" insert into logpushapp (fil_codigo, lpa_codigo, lpa_datahora, lpa_enviado, req_codigo, pac_codigo) values (");
        buf.append(logsPushApp.getCodigoFilial()).append(",");
        buf.append(this.buscarCodigoLog(logsPushApp.getCodigoFilial())).append(",");
        buf.append("'").append(Funcoes.formataData("MM/dd/yyyy HH:mm:ss", Funcoes.getDataHoraServidor())).append("' ,");
        buf.append(logsPushApp.isEnviado()).append(",");
        buf.append(logsPushApp.getCodigoRequisicao()).append(",");
        buf.append(logsPushApp.getCodigoPaciente()).append(" )");
        ConexaoAplicativo.getStatement().executeUpdate(buf.toString());
        ConexaoAplicativo.arquivaSQL();
    }

    private Integer buscarCodigoLog(Integer codigoFilial) {
        StringBuilder buf = new StringBuilder();
        Statement st = Conexao.getStatement();
        buf.append(" select nextval('logpushapp_").append(codigoFilial).append("_sequence') as codigo ");
        try {
            ResultSet rs = ConexaoAplicativo.executeQuery(st, buf);
            if (rs.next()) {
                return rs.getInt("codigo");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
        }
        return null;
    }

    public List<LogsPushAppVO> buscarLogs(boolean situacao) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append(" select fil_codigo as codigoFilial ");
        buf.append("       ,lpa_codigo as codigoLog ");
        buf.append("       ,lpa_datahora as dataHora ");
        buf.append("       ,lpa_enviado as enviado ");
        buf.append("       ,req_codigo as codigoRequisicao ");
        buf.append("       ,pac_codigo as codigoPaciente ");
        buf.append("   from logpushapp ");
        buf.append("  where lpa_enviado = false ");
        buf.append("  order by lpa_datahora ");
        buf.append("          ,fil_codigo ");
        buf.append("          ,lpa_codigo ");
        ResultSet rs = ConexaoAplicativo.executeQuery(ConexaoAplicativo.getStatement(), buf);
        ArrayList<LogsPushAppVO> listaLogs = new ArrayList<LogsPushAppVO>();
        while (rs.next()) {
            LogsPushAppVO logs = new LogsPushAppVO();
            logs.setCodigoFilial(rs.getInt("codigoFilial"));
            logs.setCodigoLog(rs.getLong("codigoLog"));
            logs.setCodigoPaciente(rs.getInt("codigoPaciente"));
            logs.setCodigoRequisicao(rs.getInt("codigoRequisicao"));
            logs.setEnviado(rs.getBoolean("enviado"));
            logs.setDataHora(rs.getDate("dataHora"));
            listaLogs.add(logs);
        }
        return listaLogs;
    }

    public int quantidadeLogs() {
        StringBuilder buf = new StringBuilder();
        buf.setLength(0);
        buf.append(" select count(*) as contagem from logpushapp where lpa_enviado = false ");
        try {
            ResultSet rs = ConexaoAplicativo.executeQuery(Conexao.getStatement(), buf);
            if (rs.next()) {
                return rs.getInt("contagem");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
        }
        return 0;
    }

    public void atualizarLogs(Integer codigoFilial, Long codigoLog, boolean enviado, String retorno) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append(" update logpushapp set lpa_enviado = ").append(enviado).append(",");
        buf.append(" lpa_datahoraenvio = '").append(Funcoes.formataData("MM/dd/yyyy HH:mm:ss", Calendar.getInstance().getTime())).append("',");
        buf.append(" lpa_idpush = '").append(retorno).append("'");
        buf.append("  where fil_codigo = ").append(codigoFilial);
        buf.append("  and lpa_codigo = ").append(codigoLog);
        ConexaoAplicativo.getStatement().executeUpdate(buf.toString());
        ConexaoAplicativo.arquivaSQL();
    }
}

