/*
 * Decompiled with CFR 0.152.
 */
package jalis.model.dao.integracao;

import jalis.comum.Conexao;
import jalis.laboratorio.util.RetornoExamesMateriais;
import jalis.service.integracao.SituacaoExame;
import jalis.util.Funcoes;
import jalis.util.tabela.Registro;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ExportacaoResultadoPdfDao {
    private static final String FORMATO_DATA = "yyyy-MM-dd";

    public Map<String, ArrayList<Registro>> getRequisicoes(String filial, String[] filtroPaciente, String[] filtroConvenio, String[] filtroExame, String[] filtroCidade, String[] filtroMedico, String[] filtroMedicoConselho, String[] filtroMedicoUF, String[] filtroSituacaoExame, String filtroDateIni, String filtroDateFim, String filtroNomePadrao, String[] filtroColeta, String[] filtroDestino) throws SQLException {
        StringBuilder buf = new StringBuilder();
        Statement st = Conexao.getStatement();
        HashMap<String, ArrayList<Registro>> map = new HashMap<String, ArrayList<Registro>>();
        String codigoPaciente = this.getCodigo(filtroPaciente);
        String codigoConvenio = this.getCodigo(filtroConvenio);
        String codigoExame = this.getExaCodigo(filtroExame);
        String codigoCidade = this.getCodigo(filtroCidade);
        String situacaoExame = this.getSituacaoExame(filtroSituacaoExame);
        String codigoColeta = this.getExaCodigo(filtroColeta);
        String codigoDestino = this.getExaCodigo(filtroDestino);
        buf.append(" SELECT req.req_codigo,  req.req_prontuario, req.req_data,  pac.pac_codigo,  pac.pac_nome,   pac.pac_datanasc, req.req_idade, req.req_anomes, con.con_codigo, ");
        buf.append("        con.con_fantasia, cid.cid_codigo,  cid.cid_nome,  med.med_nome, med.med_crm, med.med_conselho, med.med_uf, exr.exa_codigo,");
        buf.append("        exa.exa_descricao, exr.mco_codigo,  mat.mco_abreviatura, exr.exr_situacao, exr.exr_dataassina ");
        buf.append(" FROM   examerequisicao exr ");
        buf.append("        LEFT JOIN requisicao req ");
        buf.append("               ON exr.fil_codigo = req.fil_codigo ");
        buf.append("                  AND exr.req_codigo = req.req_codigo ");
        buf.append("        LEFT JOIN medico med ");
        buf.append("               ON req.fil_codigo = med.fil_codigo ");
        buf.append("                  AND req.med_crm = med.med_crm ");
        buf.append("                  AND req.med_conselho = med.med_conselho ");
        buf.append("                  AND req.med_uf = med.med_uf ");
        buf.append("        LEFT JOIN convenios con ");
        buf.append("               ON req.fil_codigo = con.fil_codigo ");
        buf.append("                  AND req.con_codigo = con.con_codigo ");
        buf.append("        LEFT JOIN paciente pac ");
        buf.append("               ON req.fil_codigo = pac.fil_codigo ");
        buf.append("                  AND req.pac_codigo = pac.pac_codigo ");
        buf.append("        LEFT JOIN cidades cid ");
        buf.append("               ON pac.fil_codigo = cid.fil_codigo ");
        buf.append("                  AND pac.cid_codigo = cid.cid_codigo ");
        buf.append("        LEFT JOIN materialcoleta mat");
        buf.append("               ON exr.fil_codigo = mat.fil_codigo");
        buf.append("                  AND exr.mco_codigo = mat.mco_codigo");
        buf.append("        LEFT JOIN exames exa");
        buf.append("               ON exr.fil_codigo = exa.fil_codigo");
        buf.append("                  AND exr.exa_codigo = exa.exa_codigo         ");
        buf.append(" WHERE  req.fil_codigo =  ").append(filial);
        if (this.contemDados(codigoPaciente)) {
            buf.append("        AND req.pac_codigo in ( ").append(codigoPaciente).append(")");
        }
        if (this.contemDados(codigoConvenio)) {
            buf.append("        AND req.con_codigo in ( ").append(codigoConvenio).append(")");
        }
        if (this.contemDados(codigoColeta)) {
            buf.append("        AND req.col_codigo in ( ").append(codigoColeta).append(")");
        }
        if (this.contemDados(codigoDestino)) {
            buf.append("        AND req.des_codigo in ( ").append(codigoDestino).append(")");
        }
        if (filtroNomePadrao.equalsIgnoreCase("Padr\u00e3o Clinic")) {
            buf.append("        AND req.req_prontuario != '' ");
        }
        if (this.contemDados(codigoExame)) {
            buf.append("        AND exa.exa_codigo in ( ").append(codigoExame).append(")");
        }
        if (this.contemDados(codigoCidade)) {
            buf.append("        AND pac.cid_codigo in ( ").append(codigoCidade).append(")");
        }
        if (this.contemDados(situacaoExame)) {
            buf.append("        AND exr.exr_situacao in ( ").append(situacaoExame).append(")");
        }
        if (this.isNotNull(filtroMedico) && this.isNotNull(filtroMedicoConselho) && this.isNotNull(filtroMedicoUF)) {
            buf.append(" AND (");
            for (int i = 0; i < filtroMedico.length && i < filtroMedicoUF.length; ++i) {
                if (i > 0) {
                    buf.append(" OR ");
                }
                buf.append(" (req.med_conselho = '").append(filtroMedicoConselho[i].trim()).append("' and upper(req.med_crm) = upper('");
                buf.append(filtroMedico[i].trim());
                buf.append("') and upper(req.med_uf) = upper('");
                buf.append(filtroMedicoUF[i].trim());
                buf.append("'))");
            }
            buf.append(" ) ");
        }
        buf.append(" AND req.req_data >= '").append(Funcoes.formataData(FORMATO_DATA, filtroDateIni)).append("'");
        buf.append(" AND req.req_data <= '").append(Funcoes.formataData(FORMATO_DATA, filtroDateFim)).append("'");
        buf.append(" AND not req.req_excluida ");
        buf.append(" AND not exr.exr_excluido ");
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        ArrayList<Registro> listReg = null;
        while (rs.next()) {
            String chave = rs.getString("req_codigo") + "," + rs.getString("pac_nome");
            listReg = map.get(chave);
            if (!this.carregouLista(listReg)) {
                listReg = new ArrayList();
            }
            Registro reg = new Registro(rs);
            listReg.add(reg);
            map.put(chave, listReg);
        }
        return map;
    }

    private String getSituacaoExame(String[] filtroSituacaoExame) {
        StringBuilder situacao = new StringBuilder();
        if (filtroSituacaoExame != null) {
            for (int i = 0; i < filtroSituacaoExame.length; ++i) {
                if (i > 0) {
                    situacao.append(", ");
                }
                situacao.append("'");
                situacao.append(SituacaoExame.getSituacaoExame(SituacaoExame.getEnum(filtroSituacaoExame[i])));
                situacao.append("'");
            }
        }
        return situacao.toString();
    }

    private boolean carregouLista(ArrayList<Registro> listReg) {
        return listReg != null;
    }

    private boolean contemDados(String dado) {
        return dado != null && !Funcoes.textoVazio(dado);
    }

    private String getCodigo(String[] filtro) {
        StringBuilder codigos = new StringBuilder();
        if (this.isNotNull(filtro)) {
            for (int i = 0; i < filtro.length; ++i) {
                if (i > 0) {
                    codigos.append(", ");
                }
                codigos.append(filtro[i]);
            }
        }
        return codigos.toString();
    }

    private String getExaCodigo(String[] filtro) {
        StringBuilder codigos = new StringBuilder();
        if (this.isNotNull(filtro)) {
            for (int i = 0; i < filtro.length; ++i) {
                if (i > 0) {
                    codigos.append(", ");
                }
                codigos.append("'").append(filtro[i]).append("'");
            }
        }
        return codigos.toString();
    }

    private boolean isNotNull(String[] filtro) {
        return filtro != null;
    }

    public RetornoExamesMateriais pegaExamesMateriaisRequisicao(String fil, String codReq) throws SQLException {
        Statement st = Conexao.getStatement();
        StringBuilder sql = new StringBuilder();
        sql.append(" select exa_codigo, mco_codigo ");
        sql.append("   from examerequisicao ");
        sql.append("  where fil_codigo = ").append(fil);
        sql.append(" and  req_codigo = ").append(codReq);
        sql.append(" and exr_excluido = false");
        ResultSet rs = Conexao.executeQuery(st, sql);
        ArrayList<String> exames = new ArrayList<String>();
        ArrayList<String> materiais = new ArrayList<String>();
        while (rs.next()) {
            exames.add(rs.getString("exa_codigo"));
            materiais.add(rs.getString("mco_codigo"));
        }
        RetornoExamesMateriais ret = new RetornoExamesMateriais();
        ret.setExames(exames.toArray(new String[exames.size()]));
        ret.setMateriais(materiais.toArray(new String[materiais.size()]));
        return ret;
    }
}

