/*
 * Decompiled with CFR 0.152.
 */
package jalis.model.dao.impressao;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.model.dao.recepcao.RequisicaoTermoConsentimentoVO;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.sql.SalvaDados;
import jalis.util.tabela.Registro;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.concurrent.Callable;

public class ImprimirTermoConsentimentoDao {
    private static final int CAMPO_MAIOR_DATA = 1;
    private static final int CAMPO_MENOR_DATA = 2;

    public static String[] pesquisarTermoConsentimentoPorCodigoLayout(String codigoFilial, String codTermo, Integer codLayout, Statement st) throws SQLException {
        String[] layout = null;
        try {
            StringBuilder select = new StringBuilder();
            select.append(" SELECT a.mtc_codigo, a.lay_codigo, a.mmt_tipo, a.mmt_formato from modelotermoconsentimento a ");
            select.append(" LEFT JOIN termoconsentimento b ON a.mtc_codigo = b.mtc_codigo AND a.fil_codigo = b.fil_codigo ");
            select.append(" WHERE b.fil_codigo = ").append(codigoFilial);
            select.append(" AND b.mtc_codigo = ").append(codTermo);
            if (codLayout > 0) {
                select.append(" AND lay_codigo = ").append(codLayout);
            } else {
                select.append(" AND mmt_padrao = true ");
            }
            ResultSet rs = st.executeQuery(select.toString());
            if (rs.next()) {
                layout = new String[]{rs.getString("mmt_formato"), rs.getString("mmt_tipo")};
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return layout;
    }

    public Integer pesquisarCodigoLayoutPadraoPorTermo(String codFilial, String codTermo, Statement st) throws SQLException {
        StringBuilder select = new StringBuilder();
        select.append(" select lay_codigo ");
        select.append(" from modelotermoconsentimento ");
        select.append(" where fil_codigo = ").append(codFilial);
        select.append(" and mtc_codigo = ").append(codTermo);
        select.append(" and mmt_padrao = true ");
        select.append(" and mmt_formato is not null ");
        select.append(" and mmt_formato != '' ");
        ResultSet rs = st.executeQuery(select.toString());
        Integer codLayout = 0;
        if (rs.next()) {
            codLayout = rs.getInt("lay_codigo");
        }
        rs.close();
        return codLayout;
    }

    public Integer getTermo(String codigoFilial, String termoConsentimento, Statement st) throws SQLException {
        int termo = 0;
        StringBuilder select = new StringBuilder();
        select.append(" SELECT mtc_codigo, mtc_descricao FROM termoconsentimento ");
        select.append(" WHERE fil_codigo = ").append(codigoFilial);
        select.append(" AND mtc_descricao = '").append(termoConsentimento).append("' ");
        ResultSet rs = st.executeQuery(select.toString());
        if (rs.next()) {
            termo = rs.getInt("mtc_codigo");
        }
        rs.close();
        return termo;
    }

    public ResultSet recuperarDados(Statement statement, String codigoFilial, String codigoRequisicao, boolean isAlimentos, int casasPrecoExame, RoundingMode arredondamentoPrecoExame, boolean precoMetodologia, boolean ocultarApenasFaturamento, boolean ordenarSetor, String ordemComprovante) throws SQLException {
        return statement.executeQuery(this.getSqlConsultaCampos(codigoFilial, codigoRequisicao, isAlimentos, casasPrecoExame, arredondamentoPrecoExame, precoMetodologia, ocultarApenasFaturamento, ordenarSetor, ordemComprovante));
    }

    private String getSqlConsultaCampos(String codigoFilial, String codigoRequisicao, boolean isAlimentos, int casasPrecoExame, RoundingMode arredondamentoPrecoExame, boolean precoMetodologia, boolean ocultarApenasFaturamento, boolean ordenarSetor, String ordemComprovante) {
        StringBuilder sqlConsulta = new StringBuilder();
        sqlConsulta.append(this.getCamposSelect(isAlimentos, casasPrecoExame, arredondamentoPrecoExame, precoMetodologia)).append(this.getCamposFrom(ocultarApenasFaturamento, isAlimentos));
        sqlConsulta.append(this.getCamposWhere(codigoFilial, codigoRequisicao)).append(this.getCamposOrderBy(ordenarSetor, ordemComprovante));
        return sqlConsulta.toString();
    }

    public ResultSet getDadosMultiguia(Statement statement, String codigoFilial, String codigoRequisicao, boolean isAlimentos, int casasPrecoExame, RoundingMode arredondamentoPrecoExame, boolean precoMetodologia, Statement st, boolean ordenarSetor, String ordemComprovante, boolean ocultarApenasFaturamento) throws SQLException {
        StringBuilder sqlConsulta = new StringBuilder();
        sqlConsulta.append(this.getCamposSelectMultiguia(isAlimentos, casasPrecoExame, arredondamentoPrecoExame, precoMetodologia)).append(this.getCamposFromMuiltiguia(ocultarApenasFaturamento, isAlimentos));
        sqlConsulta.append(this.getCamposWhereMultiguia(codigoFilial, codigoRequisicao, st)).append(this.getCamposOrderBy(ordenarSetor, ordemComprovante));
        return statement.executeQuery(sqlConsulta.toString());
    }

    private String getCamposSelect(boolean isAlimentos, int casasPrecoExame, RoundingMode arredondamentoPrecoExame, boolean precoMetodologia) {
        StringBuilder sqlSelect = new StringBuilder("select ");
        sqlSelect.append("a.req_codigo as codigoRequisicao, a.req_data as dataRequisicao, a.req_dtfatura as dataFaturaRequisicao, a.req_urgente as urgenteRequisicao, a.req_dataentregaprev as dataEntregaRequisicao,");
        sqlSelect.append("a.req_responsavel as responsavelPacienteRequisicao, a.req_cpfresponsavel as cpfResponsavelPacienteRequisicao, COALESCE(a.req_incapacitado, FALSE) as incapacitadoPacienteRequisicao,");
        sqlSelect.append("j.pac_responsavel as responsavelPaciente, j.pac_cpfresponsavel as cpfResponsavelPaciente, coalesce(j.pac_incapacitado, false) as incapacitadoPaciente,");
        sqlSelect.append("a.req_dclinicos as dadosClinicosRequisicao, a.req_obs as obsRequisicao, a.req_totpago as totalPagoRequisicao, a.req_horaentregaprev as horaEntregaRequisicao, a.req_total as totalRequisicao,");
        sqlSelect.append("a.req_horafatura as horaFaturaRequisicao, a.req_hora as horaRequisicao, a.req_gestante as gestanteRequisicao, a.req_dum as dumRequisicao, a.req_idade as idadeRequisicao, a.req_anomes as anoMesRequisicao,");
        sqlSelect.append("a.req_matricula as matriculaRequisicao, a.req_avisarpaciente as avisarPacienteRequisicao, a.req_senhaweb as senhaWebRequisicao, a.req_titular as titularRequisicao, a.req_peso as pesoRequisicao,");
        sqlSelect.append("a.req_altura as alturaRequisicao, a.req_desconto as descontoRequisicao, a.req_vlrdesconto as valorDescontoRequisicao, a.req_notacaixa as notaCaixaRequisicao, ");
        sqlSelect.append("a.req_vlrexames as valorExamesRequisicao, a.req_vlrmateriais as valorMateriaisRequisicao, a.req_guia as guiaRequisicao, ");
        sqlSelect.append("a.req_acrescimo as acrescimoRequisicao, a.req_vlracrescimo as valorAcrescimoRequisicao, a.req_tipoultpagamento as tipoUltimoPagamentoRequisicao, ");
        sqlSelect.append("a.req_imprimirseparado as imprimirSeparadoRequisicao, '' as datasEntregaParcialRequisicao, a.req_prontuario as prontuarioRequisicao, ");
        sqlSelect.append("a.req_complementodestino as complementoDestinoRequisicao, '' as multiguiasRequisicao, a.req_cartaosus as cartaoSUSRequisicao, ");
        sqlSelect.append("a.sit_codigo as codigoSituacao, g.sit_descricao as descricaoSituacao, false as existeExamesSemMaterial, ");
        sqlSelect.append("a.usr_codigo as codigoUsuario, h.usr_nome as nomeUsuario, h.usr_assinatura as assinaturaUsuario,");
        sqlSelect.append("a.usr_codabertura as codigoUsuarioAbertura, ab.usr_nome as nomeUsuarioAbertura, ab.usr_assinatura as assinaturaUsuarioAbertura,");
        sqlSelect.append("k.cid_codigo as codigoCidadeConvenio, k.cid_nome as descricaoCidadeConvenio, k.cid_uf as estadoCidadeConvenio,");
        sqlSelect.append("l.cid_codigo as codigoCidadeMedico, l.cid_nome as descricaoCidadeMedico, l.cid_uf as estadoCidadeMedico,");
        sqlSelect.append("m.cid_codigo as codigoCidadeDestino, m.cid_nome as descricaoCidadeDestino, m.cid_uf as estadoCidadeDestino,");
        sqlSelect.append("n.cid_codigo as codigoCidadeColeta, n.cid_nome as descricaoCidadeColeta, n.cid_uf as estadoCidadeColeta,");
        sqlSelect.append("o.cid_codigo as codigoCidadePaciente, o.cid_nome as descricaoCidadePaciente, o.cid_uf as estadoCidadePaciente,");
        sqlSelect.append("a.req_perguntas as perguntasRequisicao, ");
        sqlSelect.append("p.bai_codigo as codigoBairroConvenio, p.bai_descricao as descricaoBairroConvenio,");
        sqlSelect.append("q.bai_codigo as codigoBairroMedico, q.bai_descricao as descricaoBairroMedico,");
        sqlSelect.append("r.bai_codigo as codigoBairroDestino, r.bai_descricao as descricaoBairroDestino,");
        sqlSelect.append("s.bai_codigo as codigoBairroColeta, s.bai_descricao as descricaoBairroColeta,");
        sqlSelect.append("t.bai_codigo as codigoBairroPaciente, t.bai_descricao as descricaoBairroPaciente,");
        sqlSelect.append("a.des_codigo as codigoDestino, e.des_descricao as descricaoDestino, e.des_endereco as enderecoDestino, e.des_complemento as complementoDestino,e.des_cep as cepDestino, e.des_fone as foneDestino, e.des_enviarweb as enviarParaWebDestino, ");
        sqlSelect.append("a.col_codigo as codigoColeta, f.col_descricao as descricaoColeta, f.col_endereco as enderecoColeta, f.col_complemento as complementoColeta, f.col_cep as cepColeta, f.col_fone as foneColeta,");
        sqlSelect.append("a.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial,");
        sqlSelect.append("cidfilial.cid_codigo as codigoCidadeFilial, cidfilial.cid_nome as descricaoCidadeFilial, cidfilial.cid_uf as estadoCidadeFilial,");
        sqlSelect.append("baifilial.bai_codigo as codigoBairroFilial, baifilial.bai_descricao as descricaoBairroFilial,");
        sqlSelect.append("filial.fil_integrar as integracaoEntreFiliais, '' as tipoIntegracaoEntreFiliais, ");
        sqlSelect.append("d.med_conselho as conselhoMedico, d.med_crm as crmMedico, d.med_uf as estadoCrmMedico, d.med_nome as nomeMedico, to_ascii(d.med_nome) as nomeMedicoSemAcentos, d.med_abrev as tratamentoMedico, d.med_endereco as enderecoMedico, d.med_numeroendereco as numeroEnderecoMedico, d.med_tipologradouroendereco as tipoLogradouroMedico, d.med_complemento as complementoMedico, d.med_cep as cepMedico, d.med_fone as foneMedico, d.med_celular as celularMedico, d.med_fax as faxMedico, d.med_email as emailMedico, d.med_site as siteMedico,");
        sqlSelect.append("c.con_codigo as codigoConvenio, c.con_fantasia as fantasiaConvenio, c.con_razao as razaoSocialConvenio, c.con_endereco as enderecoConvenio, c.con_numeroendereco as numeroEnderecoConvenio, c.con_tipologradouroendereco as tipoLogradouroConvenio,  c.con_complemento as complementoConvenio, c.con_cep as cepConvenio, c.con_fone as foneConvenio, c.con_email1 as email1Convenio, c.con_email2 as email2Convenio, c.con_site as siteConvenio, ");
        sqlSelect.append("conrepasse.con_codigo as codigoConvenioRepasse, conrepasse.con_fantasia as fantasiaConvenioRepasse, conrepasse.con_razao as razaoSocialConvenioRepasse, conrepasse.con_numeroendereco as numeroEnderecoConvenioRepasse, conrepasse.con_tipologradouroendereco as tipoLogradouroConvenioRepasse, conrepasse.con_endereco as enderecoConvenioRepasse, conrepasse.con_complemento as complementoConvenioRepasse, conrepasse.con_cep as cepConvenioRepasse, conrepasse.con_fone as foneConvenioRepasse, conrepasse.con_email1 as email1ConvenioRepasse, conrepasse.con_email2 as email2ConvenioRepasse, conrepasse.con_site as siteConvenioRepasse,");
        sqlSelect.append("j.pac_codigo as codigoPaciente, j.pac_nome as nomePaciente, to_ascii(j.pac_nome) as nomePacienteSemAcentos, j.pac_sexo as sexoPaciente, j.pac_datanasc as dataNascimentoPaciente, j.pac_grpsangue as grupoSanguineoPaciente, j.pac_fatorrh as fatorRHPaciente, j.pac_fatordu as fatorDUPaciente, j.pac_cor as corPaciente,");
        sqlSelect.append("j.pac_profissao as profissaoPaciente, j.pac_rg as rgPaciente, j.pac_cpf as cpfPaciente, j.pac_estcivil as estadoCivilPaciente, j.pac_dum as dumPaciente, j.pac_fone as fonePaciente, j.pac_celular as celularPaciente, j.pac_fax as faxPaciente, j.pac_fonecomercial as foneComercialPaciente,");
        sqlSelect.append("j.pac_endereco as enderecoPaciente, j.pac_numeroendereco as numeroEnderecoPaciente, j.pac_tipologradouroendereco as tipoLogradouroPaciente,  j.pac_complemento as complementoPaciente, j.pac_cep as cepPaciente, j.pac_email as emailPaciente, j.pac_fonecontato as foneContatoPaciente, j.pac_nomecontato as contatoPaciente, b.exr_vlrch as valorCH,");
        sqlSelect.append("j.pac_nomepagador as nomePagadorPaciente, j.pac_cpfpagador as cpfPagadorPaciente, j.pac_whatsapp as whatsAppPaciente, ");
        sqlSelect.append("b.exa_codigo as codigoExame, b.exr_vlrchexame as ambExame, b.exr_vlrchexame as chExame, b.exr_vlrexame as valorExame, b.exr_vlrmaterial as valorMateriaisExame, b.exr_situacao as situacaoExame, '' as descricaoSituacaoExame, ");
        sqlSelect.append("w.exa_descricao as descricaoExame, to_ascii(w.exa_descricao) as descricaoExameSemAcento,");
        sqlSelect.append("w.exa_soa as soaExame, w.exa_coa as coaExame, w.exa_inmetro as certificadoInmetroExame, ");
        sqlSelect.append("b.exr_valorcusto as custoCBHPMExame, b.exr_valoruco as ucoCBHPMExame, b.exr_valorporte as valorPorteCBHPMExame, b.exr_porte as porteCHBPMExame, ");
        sqlSelect.append("v.mco_descricao as descricaoMaterial, v.mco_codigo as codigoMaterial, v.mco_abreviatura as abreviaturaMaterial, b.exr_datamaterial as dataColetaExame, b.exr_datamaterial as horaColetaExame, ");
        sqlSelect.append("coalesce(b.exr_urgente, false) as urgenteExame, b.exr_matexterno as materialExternoExame, ");
        sqlSelect.append("b.usr_codmaterial as usuarioColetaExame, prazo.prz_descricao as descricaoPrazo, prazo.prz_codigo as codigoPrazo, metodo.met_codigo as codigoMetodo, ");
        sqlSelect.append("metodo.met_descricao as descricaoMetodo, b.exr_descricaomaterial as materialInformadoExame, b.exr_dataentregaprev as dataEntregaExame, b.exr_dataentregaprev as horaEntregaExame, ");
        sqlSelect.append("b.exr_codautorizacao as autorizacaoExame, CASE WHEN exr_intervaloJejum is null then TO_CHAR(exr_tempoJejum,'HH24:MI:SS') else TO_CHAR(exr_intervaloJejum,'HH24:MI:SS') end  as tempoJejumExame, b.exr_motivoprazo as observacaoPrazoCarenciaExame, ");
        sqlSelect.append("j.pac_senhaweb as senhaWebPaciente, b.exr_vlrexame as valorExameConvenio, ");
        sqlSelect.append("exmsetor.set_codigo as codigoSetorExame, setores.set_descricao as descricaoSetorExame, setores.set_sigla as abreviaturaSetorExame, ");
        sqlSelect.append("a.req_quarto as quartoRequisicao, a.req_leito as leitoRequisicao, a.ala_codigo as codigoAla, ala.ala_descricao as descricaoAla, ");
        sqlSelect.append("tpe.tpe_codigo as codigoTabelaPreco, tpe.tpe_descricao as descricaoTabelaPreco, tpe.tpe_moeda as moedaTabelaPreco, ");
        sqlSelect.append("a.req_descricaoproduto as descricaoProdutoRequisicao, ");
        sqlSelect.append("a.req_datafabricacao as dataFabricacaoProdutoRequisicao, ");
        sqlSelect.append("a.req_numeroregistroproduto as numeroRegistroProdutoRequisicao, ");
        sqlSelect.append("a.req_temperaturacoletaproduto as temperaturaColetaProdutoRequisicao, ");
        sqlSelect.append("a.req_numeroloteproduto as numeroLoteProdutoRequisicao, ");
        sqlSelect.append("a.req_datavalidade as dataValidadeProdutoRequisicao, ");
        sqlSelect.append("a.req_marcaproduto as marcaProdutoRequisicao, ");
        sqlSelect.append("a.req_datacoletaproduto as dataColetaProdutoRequisicao, ");
        sqlSelect.append("a.req_horacoletaproduto as horaColetaProdutoRequisicao, ");
        sqlSelect.append("a.req_lacreproduto as lacreProdutoRequisicao, ");
        sqlSelect.append("a.req_lacreprodutocontra as lacreContraProvaProdutoRequisicao, ");
        sqlSelect.append("a.req_lacreprodutocontraempresa as lacreContraProvaEmpresaProdutoRequisicao, ");
        sqlSelect.append("a.req_doctoreferenciaproduto as documentoReferenciaProdutoRequisicao, ");
        sqlSelect.append("a.req_temperaturarecebimento as temperaturaRecebimentoProdutoRequisicao, ");
        sqlSelect.append("a.req_sanitariasproduto as caracteristicasSanitariasProdutoRequisicao, ");
        sqlSelect.append("a.req_condicoesambproduto as condicoesAmbientaisProdutoRequisicao, ");
        sqlSelect.append("a.req_procedimentocoletaproduto as procedimentoColetaProdutoRequisicao, ");
        sqlSelect.append("a.req_tiporecebimentoproduto as tipoRecebimentoProdutoRequisicao, ");
        sqlSelect.append("a.req_partidaproduto as partidaProdutoRequisicao, ");
        sqlSelect.append("a.req_qtdeamostraproduto as qtdeAmostrasProdutoRequisicao, ");
        sqlSelect.append("a.req_qtdeunidadeproduto as qtdeUnidadeProdutoRequisicao, ");
        sqlSelect.append("a.unm_codigo as codigoUnidadeProdutoRequisicao, ");
        sqlSelect.append("unidademedida.unm_descricao as descricaoUnidadeProdutoRequisicao, ");
        sqlSelect.append("a.emb_codigo as codigoEmbalagemProdutoRequisicao, ");
        sqlSelect.append("emb.emb_descricao as descricaoEmbalagemProdutoRequisicao, ");
        sqlSelect.append("a.req_anoprpproduto as anoPRPProdutoRequisicao, a.req_cicloprpproduto as cicloPRPProdutoRequisicao, ");
        sqlSelect.append("a.req_amostraprpproduto as amostraPRPProdutoRequisicao, a.req_amostrasupprpproduto as amostraSupervisaoPRPProdutoRequisicao, ");
        sqlSelect.append("a.req_horainicioturnoprpproduto as horaInicioTurnoPRPProdutoRequisicao, a.req_linhaprpproduto as linhaPRPProdutoRequisicao, ");
        sqlSelect.append("a.req_volumeabateprpproduto as volumeAbatePRPProdutoRequisicao, a.req_turnoprpproduto as turnoPRPProdutoRequisicao, ");
        sqlSelect.append("a.req_areaproduto as areaProdutoRequisicao, ");
        sqlSelect.append(isAlimentos ? " eaec.exa_codigo as codigoGrupoPrincipal, " : "'' as codigoGrupoPrincipal, ");
        sqlSelect.append(isAlimentos ? " examesDescricao.exa_descricao as descricaoGrupoPrincipal, " : "'' as descricaoGrupoPrincipal, ");
        sqlSelect.append(isAlimentos ? " pal.pal_codigo as codigoProdutoAlimento, " : "'' as codigoProdutoAlimento, ");
        sqlSelect.append(isAlimentos ? " pal.pal_descricao as descricaoProdutoAlimento, " : "'' as descricaoProdutoAlimento, ");
        sqlSelect.append(isAlimentos ? " cpl.cpl_codigo as codigoCategoriaProdutoAlimento, " : "'' as codigoCategoriaProdutoAlimento, ");
        sqlSelect.append(isAlimentos ? " cpl.cpl_descricao as descricaoCategoriaProdutoAlimento, " : "'' as descricaoCategoriaProdutoAlimento, ");
        sqlSelect.append(isAlimentos ? " calculaprecototalexamerequisicao(a.fil_codigo, a.con_codigo, a.req_codigo, b.exa_codigo, b.mco_codigo, true, false, true, b.exr_vlrchexame, b.exr_vlrch, b.exr_valorporte, b.exr_valorcusto, b.exr_valoruco, b.exr_vlrbalcaoconvenio, b.exr_datafatura IS NOT NULL OR b.usr_codfatura IS NOT NULL, b.exr_vlrmaterial, b.exr_vlrbalcaoconvenio, c.con_precosdiferenciados, c.con_reajuste, c.con_cobrmaterial, c.con_percpgtomaterial, c.con_percpgto, c.con_tpcalcfatu, c.con_tpcalcch, c.con_perguntarpercbalcao, c.con_acrescimo, c.con_bonus, c.tpe_codigo, c.con_acrescimoporte, c.con_acrescimouco, c.con_descontoporte, c.con_descontouco, c.con_valorch, ".concat(String.valueOf(casasPrecoExame)).concat(", ").concat(String.valueOf(arredondamentoPrecoExame.ordinal())).concat(", ").concat(precoMetodologia ? "true" : "false").concat(", b.met_codigo").concat(") as valorExameProposta, ") : "0 as valorExameProposta, ");
        sqlSelect.append("paccontatos.pco_nome as nomeResponsavelRequisicao_, ");
        sqlSelect.append("paccontatos.pco_cargo as cargoResponsavelRequisicao_, ");
        sqlSelect.append("paccontatos.pco_email as emailResponsavelRequisicao_, ");
        sqlSelect.append("paccontatos.pco_fone as foneResponsavelRequisicao_, ");
        sqlSelect.append("ent.ent_fantasia as nomeResponsavelRequisicao, ");
        sqlSelect.append("ent.ent_cargo as cargoResponsavelRequisicao, ");
        sqlSelect.append("ent.ent_email as emailResponsavelRequisicao, ");
        sqlSelect.append("ent.ent_fone as foneResponsavelRequisicao, ");
        sqlSelect.append("ent.ent_razaosocial as razaoSocialResponsavelRequisicao, ");
        sqlSelect.append("ent.ent_numeroendereco as numeroEnderecoResponsavelRequisicao, ");
        sqlSelect.append("ent.ent_tipologradouroendereco as tipoLogradouroResponsavelRequisicao, ");
        sqlSelect.append("ent.ent_endereco as enderecoResponsavelRequisicao, ");
        sqlSelect.append("ent.ent_complemento as complementoResponsavelRequisicao, ");
        sqlSelect.append("ent.ent_cep as cepResponsavelRequisicao, ");
        sqlSelect.append("ent.ent_cpfcnpj as cpfCnpjResponsavelRequisicao, ");
        sqlSelect.append("cidentidade.cid_nome as descricaoCidadeResponsavelRequisicao, ");
        sqlSelect.append("cidentidade.cid_uf as estadoCidadeResponsavelRequisicao, ");
        sqlSelect.append("baientidade.bai_descricao as descricaoBairroResponsavelRequisicao, ");
        sqlSelect.append("entempresapaciente.ent_codigo as codigoEmpresaPaciente, entempresapaciente.ent_fantasia as fantasiaEmpresaPaciente, ");
        sqlSelect.append("entempresapaciente.ent_razaosocial as razaoSocialEmpresaPaciente, entempresapaciente.ent_fone as foneEmpresaPaciente, ");
        sqlSelect.append("a.req_datarecebimentoproduto as dataRecebimentoProdutoRequisicao, ");
        sqlSelect.append("a.req_horarecebimentoproduto as horaRecebimentoProdutoRequisicao, ");
        sqlSelect.append("a.req_localcoletaproduto as localColetaProdutoRequisicao, ");
        sqlSelect.append("a.req_nrsolicitacaoproduto as numeroSolicitacaoProdutoRequisicao, ");
        sqlSelect.append("a.req_fornecedorproduto as fornecedorProdutoRequisicao, ");
        sqlSelect.append("j.bai_codigocobranca as codigoBairroCobrancaPaciente, ");
        sqlSelect.append("baicobranca.bai_descricao as descricaoBairroCobrancaPaciente, ");
        sqlSelect.append("j.cid_codigocobranca as codigoCidadeCobrancaPaciente, ");
        sqlSelect.append("cidcobranca.cid_nome as descricaoCidadeCobrancaPaciente, ");
        sqlSelect.append("cidcobranca.cid_uf as estadoCidadeCobrancaPaciente, ");
        sqlSelect.append("j.pac_razaosocial as razaoSocialPaciente, ");
        sqlSelect.append("j.pac_cnpj as cnpjPaciente, ");
        sqlSelect.append("j.pac_ie as inscricaoEstadualPaciente, ");
        sqlSelect.append("j.pac_proprietario as proprietarioPaciente, ");
        sqlSelect.append("j.pac_sif as sifPaciente, ");
        sqlSelect.append("j.pac_enderecocobranca as enderecoCobrancaPaciente, ");
        sqlSelect.append("j.pac_tipologradouroendereco as tipoLogradouroCobrancaPaciente, ");
        sqlSelect.append("j.pac_numeroenderecocobranca as numeroEnderecoCobrancaPaciente, ");
        sqlSelect.append("j.pac_complementocobranca as complementoCobrancaPaciente, ");
        sqlSelect.append("j.pac_cepcobranca as cepCobrancaPaciente, ");
        sqlSelect.append("j.pac_fonecobranca as foneCobrancaPaciente, ");
        sqlSelect.append("j.pac_responsavelcobranca as responsavelCobrancaPaciente, ");
        sqlSelect.append("j.pac_pelagem as pelagemPaciente, ");
        sqlSelect.append("j.pac_cartaosus as cartaoSUSPaciente, ");
        sqlSelect.append("j.pac_fumante as fumantePaciente, ");
        sqlSelect.append("j.pac_diabetico as diabeticoPaciente, ");
        sqlSelect.append("j.pac_nomesocial as nomeSocialPaciente, ");
        sqlSelect.append("j.pac_passaporte as passaportePaciente, ");
        sqlSelect.append("especie.epc_codigo as codigoEspecie, especie.epc_descricao as descricaoEspecie, especie.epc_cientifico as cientificoEspecie, ");
        sqlSelect.append("raca.rac_codigo as codigoRaca, raca.rac_descricao as descricaoRaca, raca.rac_cientifico as cientificoRaca, ");
        sqlSelect.append("us.uns_codigo as codigoUnidadeSaude, us.uns_descricao as descricaoUnidadeSaude, us.uns_endereco as enderecoUnidadeSaude, us.uns_complemento as complementoUnidadeSaude, us.uns_cep as cepUnidadeSaude, us.uns_fone as foneUnidadeSaude,");
        sqlSelect.append("cidadeus.cid_codigo as codigoCidadeUnidadeSaude, cidadeus.cid_nome as descricaoCidadeUnidadeSaude, cidadeus.cid_uf as estadoCidadeUnidadeSaude,");
        sqlSelect.append("bairrous.bai_codigo as codigoBairroUnidadeSaude, bairrous.bai_descricao as descricaoBairroUnidadeSaude, ");
        sqlSelect.append("pai.pai_codigo as codigoPais, pai.pai_nome as nomePais, a.req_datacertificadoalimentos as dataCertificado, ");
        sqlSelect.append("a.req_numerocertificadoalimentos as numeroCertificado, a.req_tcaalimentos as termoColetaAmostra, ");
        sqlSelect.append("a.req_totaltaxa as totalTaxaRequisicao, ");
        sqlSelect.append("'' as quantidadeExameSemMaterial, ");
        sqlSelect.append(" a.req_procedencia as procedenciaRequisicao, ");
        sqlSelect.append("CASE WHEN a.req_nrsuplemento = 0 THEN '' ELSE 's' || a.req_nrsuplemento END  as suplementoRequisicao ");
        sqlSelect.append(", age(a.req_data,j.pac_datanasc) as idadeRequisicaoPaciente ");
        sqlSelect.append(", a.req_periodogestacional as periodoGestacionalRequisicao ");
        sqlSelect.append(",'' as chaveAcessoRequisicao ");
        sqlSelect.append(", cwe.cwe_baseweb ");
        return sqlSelect.toString();
    }

    private String getCamposSelectMultiguia(boolean isAlimentos, int casasPrecoExame, RoundingMode arredondamentoPrecoExame, boolean precoMetodologia) {
        StringBuilder sqlSelect = new StringBuilder("select ");
        sqlSelect.append("rr.req_kodigo as codigoRequisicao, a.req_data as dataRequisicao, a.req_dtfatura as dataFaturaRequisicao, a.req_urgente as urgenteRequisicao, a.req_dataentregaprev as dataEntregaRequisicao,");
        sqlSelect.append("a.req_responsavel as responsavelPacienteRequisicao, a.req_cpfresponsavel as cpfResponsavelPacienteRequisicao, COALESCE(a.req_incapacitado, FALSE) as incapacitadoPacienteRequisicao,");
        sqlSelect.append("j.pac_responsavel as responsavelPaciente, j.pac_cpfresponsavel as cpfResponsavelPaciente, coalesce(j.pac_incapacitado, false) as incapacitadoPaciente,");
        sqlSelect.append("a.req_dclinicos as dadosClinicosRequisicao, a.req_obs as obsRequisicao, a.req_totpago as totalPagoRequisicao, a.req_horaentregaprev as horaEntregaRequisicao, a.req_total as totalRequisicao,");
        sqlSelect.append("a.req_horafatura as horaFaturaRequisicao, a.req_hora as horaRequisicao, a.req_gestante as gestanteRequisicao, a.req_dum as dumRequisicao, a.req_idade as idadeRequisicao, a.req_anomes as anoMesRequisicao,");
        sqlSelect.append("a.req_matricula as matriculaRequisicao, a.req_avisarpaciente as avisarPacienteRequisicao, a.req_senhaweb as senhaWebRequisicao, a.req_titular as titularRequisicao, a.req_peso as pesoRequisicao,");
        sqlSelect.append("a.req_altura as alturaRequisicao, a.req_desconto as descontoRequisicao, a.req_vlrdesconto as valorDescontoRequisicao, a.req_notacaixa as notaCaixaRequisicao, ");
        sqlSelect.append("a.req_vlrexames as valorExamesRequisicao, a.req_vlrmateriais as valorMateriaisRequisicao, a.req_guia as guiaRequisicao, ");
        sqlSelect.append("a.req_acrescimo as acrescimoRequisicao, a.req_vlracrescimo as valorAcrescimoRequisicao, a.req_tipoultpagamento as tipoUltimoPagamentoRequisicao, ");
        sqlSelect.append("a.req_imprimirseparado as imprimirSeparadoRequisicao, '' as datasEntregaParcialRequisicao, a.req_prontuario as prontuarioRequisicao, ");
        sqlSelect.append("a.req_complementodestino as complementoDestinoRequisicao, '' as multiguiasRequisicao, a.req_cartaosus as cartaoSUSRequisicao, ");
        sqlSelect.append("a.sit_codigo as codigoSituacao, g.sit_descricao as descricaoSituacao, false as existeExamesSemMaterial, ");
        sqlSelect.append("a.usr_codigo as codigoUsuario, h.usr_nome as nomeUsuario, h.usr_assinatura as assinaturaUsuario,");
        sqlSelect.append("a.usr_codabertura as codigoUsuarioAbertura, ab.usr_nome as nomeUsuarioAbertura, ab.usr_assinatura as assinaturaUsuarioAbertura,");
        sqlSelect.append("k.cid_codigo as codigoCidadeConvenio, k.cid_nome as descricaoCidadeConvenio, k.cid_uf as estadoCidadeConvenio,");
        sqlSelect.append("l.cid_codigo as codigoCidadeMedico, l.cid_nome as descricaoCidadeMedico, l.cid_uf as estadoCidadeMedico,");
        sqlSelect.append("m.cid_codigo as codigoCidadeDestino, m.cid_nome as descricaoCidadeDestino, m.cid_uf as estadoCidadeDestino,");
        sqlSelect.append("n.cid_codigo as codigoCidadeColeta, n.cid_nome as descricaoCidadeColeta, n.cid_uf as estadoCidadeColeta,");
        sqlSelect.append("o.cid_codigo as codigoCidadePaciente, o.cid_nome as descricaoCidadePaciente, o.cid_uf as estadoCidadePaciente,");
        sqlSelect.append("a.req_perguntas as perguntasRequisicao, ");
        sqlSelect.append("p.bai_codigo as codigoBairroConvenio, p.bai_descricao as descricaoBairroConvenio,");
        sqlSelect.append("q.bai_codigo as codigoBairroMedico, q.bai_descricao as descricaoBairroMedico,");
        sqlSelect.append("r.bai_codigo as codigoBairroDestino, r.bai_descricao as descricaoBairroDestino,");
        sqlSelect.append("s.bai_codigo as codigoBairroColeta, s.bai_descricao as descricaoBairroColeta,");
        sqlSelect.append("t.bai_codigo as codigoBairroPaciente, t.bai_descricao as descricaoBairroPaciente,");
        sqlSelect.append("a.des_codigo as codigoDestino, e.des_descricao as descricaoDestino, e.des_endereco as enderecoDestino, e.des_complemento as complementoDestino,e.des_cep as cepDestino, e.des_fone as foneDestino, e.des_enviarweb as enviarParaWebDestino, ");
        sqlSelect.append("a.col_codigo as codigoColeta, f.col_descricao as descricaoColeta, f.col_endereco as enderecoColeta, f.col_complemento as complementoColeta, f.col_cep as cepColeta, f.col_fone as foneColeta,");
        sqlSelect.append("a.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial,");
        sqlSelect.append("cidfilial.cid_codigo as codigoCidadeFilial, cidfilial.cid_nome as descricaoCidadeFilial, cidfilial.cid_uf as estadoCidadeFilial,");
        sqlSelect.append("baifilial.bai_codigo as codigoBairroFilial, baifilial.bai_descricao as descricaoBairroFilial,");
        sqlSelect.append("filial.fil_integrar as integracaoEntreFiliais, '' as tipoIntegracaoEntreFiliais, ");
        sqlSelect.append("d.med_conselho as conselhoMedico, d.med_crm as crmMedico, d.med_uf as estadoCrmMedico, d.med_nome as nomeMedico, to_ascii(d.med_nome) as nomeMedicoSemAcentos, d.med_abrev as tratamentoMedico, d.med_endereco as enderecoMedico, d.med_numeroendereco as numeroEnderecoMedico, d.med_tipologradouroendereco as tipoLogradouroMedico, d.med_complemento as complementoMedico, d.med_cep as cepMedico, d.med_fone as foneMedico, d.med_celular as celularMedico, d.med_fax as faxMedico, d.med_email as emailMedico, d.med_site as siteMedico,");
        sqlSelect.append("c.con_codigo as codigoConvenio, c.con_fantasia as fantasiaConvenio, c.con_razao as razaoSocialConvenio, c.con_endereco as enderecoConvenio, c.con_numeroendereco as numeroEnderecoConvenio, c.con_tipologradouroendereco as tipoLogradouroConvenio,  c.con_complemento as complementoConvenio, c.con_cep as cepConvenio, c.con_fone as foneConvenio, c.con_email1 as email1Convenio, c.con_email2 as email2Convenio, c.con_site as siteConvenio, ");
        sqlSelect.append("conrepasse.con_codigo as codigoConvenioRepasse, conrepasse.con_fantasia as fantasiaConvenioRepasse, conrepasse.con_razao as razaoSocialConvenioRepasse, conrepasse.con_numeroendereco as numeroEnderecoConvenioRepasse, conrepasse.con_tipologradouroendereco as tipoLogradouroConvenioRepasse, conrepasse.con_endereco as enderecoConvenioRepasse, conrepasse.con_complemento as complementoConvenioRepasse, conrepasse.con_cep as cepConvenioRepasse, conrepasse.con_fone as foneConvenioRepasse, conrepasse.con_email1 as email1ConvenioRepasse, conrepasse.con_email2 as email2ConvenioRepasse, conrepasse.con_site as siteConvenioRepasse,");
        sqlSelect.append("j.pac_codigo as codigoPaciente, j.pac_nome as nomePaciente, to_ascii(j.pac_nome) as nomePacienteSemAcentos, j.pac_sexo as sexoPaciente, j.pac_datanasc as dataNascimentoPaciente, j.pac_grpsangue as grupoSanguineoPaciente, j.pac_fatorrh as fatorRHPaciente, j.pac_fatordu as fatorDUPaciente, j.pac_cor as corPaciente,");
        sqlSelect.append("j.pac_profissao as profissaoPaciente, j.pac_rg as rgPaciente, j.pac_cpf as cpfPaciente, j.pac_estcivil as estadoCivilPaciente, j.pac_dum as dumPaciente, j.pac_fone as fonePaciente, j.pac_celular as celularPaciente, j.pac_fax as faxPaciente, j.pac_fonecomercial as foneComercialPaciente,");
        sqlSelect.append("j.pac_endereco as enderecoPaciente, j.pac_numeroendereco as numeroEnderecoPaciente, j.pac_tipologradouroendereco as tipoLogradouroPaciente,  j.pac_complemento as complementoPaciente, j.pac_cep as cepPaciente, j.pac_email as emailPaciente, j.pac_fonecontato as foneContatoPaciente, j.pac_nomecontato as contatoPaciente, b.exr_vlrch as valorCH,");
        sqlSelect.append("j.pac_nomepagador as nomePagadorPaciente, j.pac_cpfpagador as cpfPagadorPaciente, j.pac_whatsapp as whatsAppPaciente, ");
        sqlSelect.append("b.exa_codigo as codigoExame, b.exr_vlrchexame as ambExame, b.exr_vlrchexame as chExame, b.exr_vlrexame as valorExame, b.exr_vlrmaterial as valorMateriaisExame, b.exr_situacao as situacaoExame, '' as descricaoSituacaoExame, ");
        sqlSelect.append("w.exa_descricao as descricaoExame, to_ascii(w.exa_descricao) as descricaoExameSemAcento,");
        sqlSelect.append("w.exa_soa as soaExame, w.exa_coa as coaExame, w.exa_inmetro as certificadoInmetroExame, ");
        sqlSelect.append("b.exr_valorcusto as custoCBHPMExame, b.exr_valoruco as ucoCBHPMExame, b.exr_valorporte as valorPorteCBHPMExame, b.exr_porte as porteCHBPMExame, ");
        sqlSelect.append("v.mco_descricao as descricaoMaterial, v.mco_codigo as codigoMaterial, v.mco_abreviatura as abreviaturaMaterial, b.exr_datamaterial as dataColetaExame, b.exr_datamaterial as horaColetaExame, ");
        sqlSelect.append("coalesce(b.exr_urgente, false) as urgenteExame, b.exr_matexterno as materialExternoExame, ");
        sqlSelect.append("b.usr_codmaterial as usuarioColetaExame, prazo.prz_descricao as descricaoPrazo, prazo.prz_codigo as codigoPrazo, metodo.met_codigo as codigoMetodo, ");
        sqlSelect.append("metodo.met_descricao as descricaoMetodo, b.exr_descricaomaterial as materialInformadoExame, b.exr_dataentregaprev as dataEntregaExame, b.exr_dataentregaprev as horaEntregaExame, ");
        sqlSelect.append("b.exr_codautorizacao as autorizacaoExame, CASE WHEN exr_intervaloJejum is null then TO_CHAR(exr_tempoJejum,'HH24:MI:SS') else TO_CHAR(exr_intervaloJejum,'HH24:MI:SS') end  as tempoJejumExame, b.exr_motivoprazo as observacaoPrazoCarenciaExame, ");
        sqlSelect.append("j.pac_senhaweb as senhaWebPaciente, b.exr_vlrexame as valorExameConvenio, ");
        sqlSelect.append("exmsetor.set_codigo as codigoSetorExame, setores.set_descricao as descricaoSetorExame, setores.set_sigla as abreviaturaSetorExame, ");
        sqlSelect.append("a.req_quarto as quartoRequisicao, a.req_leito as leitoRequisicao, a.ala_codigo as codigoAla, ala.ala_descricao as descricaoAla, ");
        sqlSelect.append("tpe.tpe_codigo as codigoTabelaPreco, tpe.tpe_descricao as descricaoTabelaPreco, tpe.tpe_moeda as moedaTabelaPreco, ");
        sqlSelect.append("a.req_descricaoproduto as descricaoProdutoRequisicao, ");
        sqlSelect.append("a.req_datafabricacao as dataFabricacaoProdutoRequisicao, ");
        sqlSelect.append("a.req_numeroregistroproduto as numeroRegistroProdutoRequisicao, ");
        sqlSelect.append("a.req_temperaturacoletaproduto as temperaturaColetaProdutoRequisicao, ");
        sqlSelect.append("a.req_numeroloteproduto as numeroLoteProdutoRequisicao, ");
        sqlSelect.append("a.req_datavalidade as dataValidadeProdutoRequisicao, ");
        sqlSelect.append("a.req_marcaproduto as marcaProdutoRequisicao, ");
        sqlSelect.append("a.req_datacoletaproduto as dataColetaProdutoRequisicao, ");
        sqlSelect.append("a.req_horacoletaproduto as horaColetaProdutoRequisicao, ");
        sqlSelect.append("a.req_lacreproduto as lacreProdutoRequisicao, ");
        sqlSelect.append("a.req_lacreprodutocontra as lacreContraProvaProdutoRequisicao, ");
        sqlSelect.append("a.req_lacreprodutocontraempresa as lacreContraProvaEmpresaProdutoRequisicao, ");
        sqlSelect.append("a.req_doctoreferenciaproduto as documentoReferenciaProdutoRequisicao, ");
        sqlSelect.append("a.req_temperaturarecebimento as temperaturaRecebimentoProdutoRequisicao, ");
        sqlSelect.append("a.req_sanitariasproduto as caracteristicasSanitariasProdutoRequisicao, ");
        sqlSelect.append("a.req_condicoesambproduto as condicoesAmbientaisProdutoRequisicao, ");
        sqlSelect.append("a.req_procedimentocoletaproduto as procedimentoColetaProdutoRequisicao, ");
        sqlSelect.append("a.req_tiporecebimentoproduto as tipoRecebimentoProdutoRequisicao, ");
        sqlSelect.append("a.req_partidaproduto as partidaProdutoRequisicao, ");
        sqlSelect.append("a.req_qtdeamostraproduto as qtdeAmostrasProdutoRequisicao, ");
        sqlSelect.append("a.req_qtdeunidadeproduto as qtdeUnidadeProdutoRequisicao, ");
        sqlSelect.append("a.unm_codigo as codigoUnidadeProdutoRequisicao, ");
        sqlSelect.append("unidademedida.unm_descricao as descricaoUnidadeProdutoRequisicao, ");
        sqlSelect.append("a.emb_codigo as codigoEmbalagemProdutoRequisicao, ");
        sqlSelect.append("emb.emb_descricao as descricaoEmbalagemProdutoRequisicao, ");
        sqlSelect.append("a.req_anoprpproduto as anoPRPProdutoRequisicao, a.req_cicloprpproduto as cicloPRPProdutoRequisicao, ");
        sqlSelect.append("a.req_amostraprpproduto as amostraPRPProdutoRequisicao, a.req_amostrasupprpproduto as amostraSupervisaoPRPProdutoRequisicao, ");
        sqlSelect.append("a.req_horainicioturnoprpproduto as horaInicioTurnoPRPProdutoRequisicao, a.req_linhaprpproduto as linhaPRPProdutoRequisicao, ");
        sqlSelect.append("a.req_volumeabateprpproduto as volumeAbatePRPProdutoRequisicao, a.req_turnoprpproduto as turnoPRPProdutoRequisicao, ");
        sqlSelect.append("a.req_areaproduto as areaProdutoRequisicao, ");
        sqlSelect.append(isAlimentos ? " eaec.exa_codigo as codigoGrupoPrincipal, " : "'' as codigoGrupoPrincipal, ");
        sqlSelect.append(isAlimentos ? " examesDescricao.exa_descricao as descricaoGrupoPrincipal, " : "'' as descricaoGrupoPrincipal, ");
        sqlSelect.append(isAlimentos ? " pal.pal_codigo as codigoProdutoAlimento, " : "'' as codigoProdutoAlimento, ");
        sqlSelect.append(isAlimentos ? " pal.pal_descricao as descricaoProdutoAlimento, " : "'' as descricaoProdutoAlimento, ");
        sqlSelect.append(isAlimentos ? " cpl.cpl_codigo as codigoCategoriaProdutoAlimento, " : "'' as codigoCategoriaProdutoAlimento, ");
        sqlSelect.append(isAlimentos ? " cpl.cpl_descricao as descricaoCategoriaProdutoAlimento, " : "'' as descricaoCategoriaProdutoAlimento, ");
        sqlSelect.append(isAlimentos ? " calculaprecototalexamerequisicao(a.fil_codigo, a.con_codigo, a.req_codigo, b.exa_codigo, b.mco_codigo, true, false, true, b.exr_vlrchexame, b.exr_vlrch, b.exr_valorporte, b.exr_valorcusto, b.exr_valoruco, b.exr_vlrbalcaoconvenio, b.exr_datafatura IS NOT NULL OR b.usr_codfatura IS NOT NULL, b.exr_vlrmaterial, b.exr_vlrbalcaoconvenio, c.con_precosdiferenciados, c.con_reajuste, c.con_cobrmaterial, c.con_percpgtomaterial, c.con_percpgto, c.con_tpcalcfatu, c.con_tpcalcch, c.con_perguntarpercbalcao, c.con_acrescimo, c.con_bonus, c.tpe_codigo, c.con_acrescimoporte, c.con_acrescimouco, c.con_descontoporte, c.con_descontouco, c.con_valorch, ".concat(String.valueOf(casasPrecoExame)).concat(", ").concat(String.valueOf(arredondamentoPrecoExame.ordinal())).concat(", ").concat(precoMetodologia ? "true" : "false").concat(", b.met_codigo").concat(") as valorExameProposta, ") : "0 as valorExameProposta, ");
        sqlSelect.append("paccontatos.pco_nome as nomeResponsavelRequisicao_, ");
        sqlSelect.append("paccontatos.pco_cargo as cargoResponsavelRequisicao_, ");
        sqlSelect.append("paccontatos.pco_email as emailResponsavelRequisicao_, ");
        sqlSelect.append("paccontatos.pco_fone as foneResponsavelRequisicao_, ");
        sqlSelect.append("ent.ent_fantasia as nomeResponsavelRequisicao, ");
        sqlSelect.append("ent.ent_cargo as cargoResponsavelRequisicao, ");
        sqlSelect.append("ent.ent_email as emailResponsavelRequisicao, ");
        sqlSelect.append("ent.ent_fone as foneResponsavelRequisicao, ");
        sqlSelect.append("ent.ent_razaosocial as razaoSocialResponsavelRequisicao, ");
        sqlSelect.append("ent.ent_numeroendereco as numeroEnderecoResponsavelRequisicao, ");
        sqlSelect.append("ent.ent_tipologradouroendereco as tipoLogradouroResponsavelRequisicao, ");
        sqlSelect.append("ent.ent_endereco as enderecoResponsavelRequisicao, ");
        sqlSelect.append("ent.ent_complemento as complementoResponsavelRequisicao, ");
        sqlSelect.append("ent.ent_cep as cepResponsavelRequisicao, ");
        sqlSelect.append("ent.ent_cpfcnpj as cpfCnpjResponsavelRequisicao, ");
        sqlSelect.append("cidentidade.cid_nome as descricaoCidadeResponsavelRequisicao, ");
        sqlSelect.append("cidentidade.cid_uf as estadoCidadeResponsavelRequisicao, ");
        sqlSelect.append("baientidade.bai_descricao as descricaoBairroResponsavelRequisicao, ");
        sqlSelect.append("entempresapaciente.ent_codigo as codigoEmpresaPaciente, entempresapaciente.ent_fantasia as fantasiaEmpresaPaciente, ");
        sqlSelect.append("entempresapaciente.ent_razaosocial as razaoSocialEmpresaPaciente, entempresapaciente.ent_fone as foneEmpresaPaciente, ");
        sqlSelect.append("a.req_datarecebimentoproduto as dataRecebimentoProdutoRequisicao, ");
        sqlSelect.append("a.req_horarecebimentoproduto as horaRecebimentoProdutoRequisicao, ");
        sqlSelect.append("a.req_localcoletaproduto as localColetaProdutoRequisicao, ");
        sqlSelect.append("a.req_nrsolicitacaoproduto as numeroSolicitacaoProdutoRequisicao, ");
        sqlSelect.append("a.req_fornecedorproduto as fornecedorProdutoRequisicao, ");
        sqlSelect.append("j.bai_codigocobranca as codigoBairroCobrancaPaciente, ");
        sqlSelect.append("baicobranca.bai_descricao as descricaoBairroCobrancaPaciente, ");
        sqlSelect.append("j.cid_codigocobranca as codigoCidadeCobrancaPaciente, ");
        sqlSelect.append("cidcobranca.cid_nome as descricaoCidadeCobrancaPaciente, ");
        sqlSelect.append("cidcobranca.cid_uf as estadoCidadeCobrancaPaciente, ");
        sqlSelect.append("j.pac_razaosocial as razaoSocialPaciente, ");
        sqlSelect.append("j.pac_cnpj as cnpjPaciente, ");
        sqlSelect.append("j.pac_ie as inscricaoEstadualPaciente, ");
        sqlSelect.append("j.pac_proprietario as proprietarioPaciente, ");
        sqlSelect.append("j.pac_sif as sifPaciente, ");
        sqlSelect.append("j.pac_enderecocobranca as enderecoCobrancaPaciente, ");
        sqlSelect.append("j.pac_tipologradouroendereco as tipoLogradouroCobrancaPaciente, ");
        sqlSelect.append("j.pac_numeroenderecocobranca as numeroEnderecoCobrancaPaciente, ");
        sqlSelect.append("j.pac_complementocobranca as complementoCobrancaPaciente, ");
        sqlSelect.append("j.pac_cepcobranca as cepCobrancaPaciente, ");
        sqlSelect.append("j.pac_fonecobranca as foneCobrancaPaciente, ");
        sqlSelect.append("j.pac_responsavelcobranca as responsavelCobrancaPaciente, ");
        sqlSelect.append("j.pac_pelagem as pelagemPaciente, ");
        sqlSelect.append("j.pac_cartaosus as cartaoSUSPaciente, ");
        sqlSelect.append("j.pac_fumante as fumantePaciente, ");
        sqlSelect.append("j.pac_diabetico as diabeticoPaciente, ");
        sqlSelect.append("j.pac_nomesocial as nomeSocialPaciente, ");
        sqlSelect.append("j.pac_passaporte as passaportePaciente, ");
        sqlSelect.append("especie.epc_codigo as codigoEspecie, especie.epc_descricao as descricaoEspecie, especie.epc_cientifico as cientificoEspecie, ");
        sqlSelect.append("raca.rac_codigo as codigoRaca, raca.rac_descricao as descricaoRaca, raca.rac_cientifico as cientificoRaca, ");
        sqlSelect.append("us.uns_codigo as codigoUnidadeSaude, us.uns_descricao as descricaoUnidadeSaude, us.uns_endereco as enderecoUnidadeSaude, us.uns_complemento as complementoUnidadeSaude, us.uns_cep as cepUnidadeSaude, us.uns_fone as foneUnidadeSaude,");
        sqlSelect.append("cidadeus.cid_codigo as codigoCidadeUnidadeSaude, cidadeus.cid_nome as descricaoCidadeUnidadeSaude, cidadeus.cid_uf as estadoCidadeUnidadeSaude,");
        sqlSelect.append("bairrous.bai_codigo as codigoBairroUnidadeSaude, bairrous.bai_descricao as descricaoBairroUnidadeSaude, ");
        sqlSelect.append("pai.pai_codigo as codigoPais, pai.pai_nome as nomePais, a.req_datacertificadoalimentos as dataCertificado, ");
        sqlSelect.append("a.req_numerocertificadoalimentos as numeroCertificado, a.req_tcaalimentos as termoColetaAmostra, ");
        sqlSelect.append("a.req_totaltaxa as totalTaxaRequisicao, ");
        sqlSelect.append("'' as quantidadeExameSemMaterial, ");
        sqlSelect.append(" a.req_procedencia as procedenciaRequisicao, ");
        sqlSelect.append("CASE WHEN a.req_nrsuplemento = 0 THEN '' ELSE 's' || a.req_nrsuplemento END  as suplementoRequisicao ");
        sqlSelect.append(", age(a.req_data,j.pac_datanasc) as idadeRequisicaoPaciente ");
        sqlSelect.append(", a.req_periodogestacional as periodoGestacionalRequisicao ");
        sqlSelect.append(",'' as chaveAcessoRequisicao ");
        sqlSelect.append(", cwe.cwe_baseweb ");
        return sqlSelect.toString();
    }

    private String getCamposFromMuiltiguia(boolean ocultarApenasFaturamento, boolean isAlimentos) {
        StringBuilder sqlFrom = new StringBuilder(" from ");
        sqlFrom.append("requisicao a ");
        sqlFrom.append("left join requisicaorequisicao rr on a.fil_codigo = rr.fil_codigo and rr.req_kodigo = a.req_codigo ");
        sqlFrom.append("left join examerequisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo ");
        if (ocultarApenasFaturamento) {
            sqlFrom.append(" and b.exr_situacao <> 'A'");
        }
        sqlFrom.append("left join convenios c on a.fil_codigo = c.fil_codigo and a.con_codigo = c.con_codigo ");
        sqlFrom.append("left join convenios conrepasse on a.fil_codigo = conrepasse.fil_codigo and a.con_codrepasse = conrepasse.con_codigo ");
        sqlFrom.append("left join medico d on a.fil_codigo = d.fil_codigo and a.med_conselho = d.med_conselho and upper(a.med_crm) = upper(d.med_crm) and a.med_uf = d.med_uf ");
        sqlFrom.append("left join destino e on a.fil_codigo = e.fil_codigo and upper(a.des_codigo) = upper(e.des_codigo) ");
        sqlFrom.append("left join coletas f on a.fil_codigo = f.fil_codigo and upper(a.col_codigo) = upper(f.col_codigo) ");
        sqlFrom.append("left join situacao g on a.fil_codigo = g.fil_codigo and a.sit_codigo = g.sit_codigo ");
        sqlFrom.append("left join usuario h on upper(a.usr_codigo) = upper(h.usr_codigo) ");
        sqlFrom.append("left join usuario ab on upper(a.usr_codabertura) = upper(ab.usr_codigo) ");
        sqlFrom.append("left join paciente j on a.fil_codigo = j.fil_codigo and a.pac_codigo = j.pac_codigo ");
        sqlFrom.append("left join cidades k on c.fil_codigo = k.fil_codigo and c.cid_codigo = k.cid_codigo ");
        sqlFrom.append("left join cidades l on d.fil_codigo = l.fil_codigo and d.cid_codigo = l.cid_codigo ");
        sqlFrom.append("left join cidades m on e.fil_codigo = m.fil_codigo and e.cid_codigo = m.cid_codigo ");
        sqlFrom.append("left join cidades n on f.fil_codigo = n.fil_codigo and f.cid_codigo = n.cid_codigo ");
        sqlFrom.append("left join cidades o on j.fil_codigo = o.fil_codigo and j.cid_codigo = o.cid_codigo ");
        sqlFrom.append("left join bairro p on c.fil_codigo = p.fil_codigo and c.bai_codigo = p.bai_codigo ");
        sqlFrom.append("left join bairro q on d.fil_codigo = q.fil_codigo and d.bai_codigo = q.bai_codigo ");
        sqlFrom.append("left join bairro r on e.fil_codigo = r.fil_codigo and e.bai_codigo = r.bai_codigo ");
        sqlFrom.append("left join bairro s on f.fil_codigo = s.fil_codigo and f.bai_codigo = s.bai_codigo ");
        sqlFrom.append("left join bairro t on j.fil_codigo = t.fil_codigo and j.bai_codigo = t.bai_codigo ");
        sqlFrom.append("left join examematcoleta u on b.fil_codigo = u.fil_codigo and upper(b.exa_codigo) = upper(u.exa_codigo) and b.mco_codigo = u.mco_codigo ");
        sqlFrom.append("left join materialcoleta v on u.fil_codigo = v.fil_codigo and u.mco_codigo = v.mco_codigo ");
        sqlFrom.append("left join exames w on b.fil_codigo = w.fil_codigo and upper(b.exa_codigo) = upper(w.exa_codigo) ");
        sqlFrom.append("left join prazoentrega prazo on u.fil_codigo = prazo.fil_codigo and u.prz_codigo = prazo.prz_codigo ");
        sqlFrom.append("left join metodologia metodo on b.fil_codigo = metodo.fil_codigo and b.met_codigo = metodo.met_codigo ");
        sqlFrom.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo ");
        sqlFrom.append("left join cidades cidfilial on filial.fil_codigo = cidfilial.fil_codigo and filial.cid_codigo = cidfilial.cid_codigo ");
        sqlFrom.append("left join bairro baifilial on filial.fil_codigo = baifilial.fil_codigo and filial.bai_codigo = baifilial.bai_codigo ");
        sqlFrom.append("left join examesetor exmsetor on w.fil_codigo = exmsetor.fil_codigo and w.exa_codigo = exmsetor.exa_codigo and exmsetor.ese_default = true ");
        sqlFrom.append("left join setores setores on exmsetor.fil_codigo = setores.fil_codigo and exmsetor.set_codigo = setores.set_codigo ");
        sqlFrom.append("left join alahospital ala on a.fil_codigo = ala.fil_codigo and a.ala_codigo = ala.ala_codigo ");
        sqlFrom.append("left join tabelaprecoexames tpe on c.fil_codigo = tpe.fil_codigo and c.tpe_codigo = tpe.tpe_codigo ");
        sqlFrom.append("left join unidademedida on a.fil_codigo = unidademedida.fil_codigo and a.unm_codigo = unidademedida.unm_codigo ");
        sqlFrom.append("left join pacientescontatos paccontatos on a.fil_codigo = paccontatos.fil_codigo and a.pac_codigo = paccontatos.pac_codigo and a.pco_codigo = paccontatos.pco_codigo ");
        sqlFrom.append("left join entidade ent on a.fil_codigo = ent.fil_codigo and a.ent_codigo = ent.ent_codigo ");
        sqlFrom.append("left join entidade entempresapaciente on j.fil_codigo = entempresapaciente.fil_codigo and j.ent_codempresa = entempresapaciente.ent_codigo ");
        sqlFrom.append("left join cidades cidcobranca on j.fil_codigo = cidcobranca.fil_codigo and j.cid_codigocobranca = cidcobranca.cid_codigo ");
        sqlFrom.append("left join bairro baicobranca on j.fil_codigo = baicobranca.fil_codigo and j.bai_codigocobranca = baicobranca.bai_codigo ");
        sqlFrom.append("left join embalagemproduto emb on a.fil_codigo = emb.fil_codigo and a.emb_codigo = emb.emb_codigo ");
        sqlFrom.append("left join unidadesaude us on a.fil_codigo = us.fil_codigo and a.uns_codigo = us.uns_codigo ");
        sqlFrom.append("left join cidades cidadeus on us.fil_codigo = cidadeus.fil_codigo and us.cid_codigo = cidadeus.cid_codigo ");
        sqlFrom.append("left join bairro bairrous on us.fil_codigo = bairrous.fil_codigo and us.bai_codigo = bairrous.bai_codigo ");
        sqlFrom.append("left join especie on j.fil_codigo = especie.fil_codigo and j.epc_codigo = especie.epc_codigo ");
        sqlFrom.append("left join raca on especie.fil_codigo = raca.fil_codigo and especie.epc_codigo = raca.epc_codigo and j.rac_codigo = raca.rac_codigo ");
        sqlFrom.append("left join cidades cidentidade on ent.fil_codigo = cidentidade.fil_codigo and ent.cid_codigo = cidentidade.cid_codigo ");
        sqlFrom.append("left join bairro baientidade on ent.fil_codigo = baientidade.fil_codigo and ent.bai_codigo = baientidade.bai_codigo ");
        sqlFrom.append("left join pais pai on a.pai_codigo = pai.pai_codigo and a.fil_codigo = pai.fil_codigo ");
        sqlFrom.append("left join configuracaoweb cwe on a.fil_codigo = cwe.cwe_filialpadrao ");
        sqlFrom.append(isAlimentos ? "left join categoriaprodutoalimentos cpl on a.fil_codigo = cpl.fil_codigo and a.cpl_codigo = cpl.cpl_codigo " : "");
        sqlFrom.append(isAlimentos ? "left join produtoalimentos pal on a.fil_codigo = pal.fil_codigo and pal.pal_codigo = a.pal_codigo and cpl.cpl_codigo = pal.cpl_codigo " : "");
        sqlFrom.append(isAlimentos ? "left join exameagrupaexameconvenio eaec on a.fil_codigo = eaec.fil_codigo and b.exa_codigo = eaec.exa_kodigo and b.exa_codigopai = eaec.exa_codigo and b.mco_codigo = eaec.mco_kodigo and a.con_codigo = eaec.con_codigo and eaec.aec_tipo = 'R' " : "");
        sqlFrom.append(isAlimentos ? "left join agrupaexameconvenio aec on a.fil_codigo = aec.fil_codigo and aec.exa_codigo = eaec.exa_codigo and aec.aec_tipo = eaec.aec_tipo and (aec.con_codigo = eaec.con_codigo OR aec.aec_ignorarconvenio is true) " : "");
        return sqlFrom.toString();
    }

    private String getCamposFrom(boolean ocultarApenasFaturamento, boolean isAlimentos) {
        StringBuilder sqlFrom = new StringBuilder(" from ");
        sqlFrom.append("requisicao a ");
        sqlFrom.append("left join examerequisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo ");
        if (ocultarApenasFaturamento) {
            sqlFrom.append(" and b.exr_situacao <> 'A'");
        }
        sqlFrom.append("left join convenios c on a.fil_codigo = c.fil_codigo and a.con_codigo = c.con_codigo ");
        sqlFrom.append("left join convenios conrepasse on a.fil_codigo = conrepasse.fil_codigo and a.con_codrepasse = conrepasse.con_codigo ");
        sqlFrom.append("left join medico d on a.fil_codigo = d.fil_codigo and a.med_conselho = d.med_conselho and upper(a.med_crm) = upper(d.med_crm) and a.med_uf = d.med_uf ");
        sqlFrom.append("left join destino e on a.fil_codigo = e.fil_codigo and upper(a.des_codigo) = upper(e.des_codigo) ");
        sqlFrom.append("left join coletas f on a.fil_codigo = f.fil_codigo and upper(a.col_codigo) = upper(f.col_codigo) ");
        sqlFrom.append("left join situacao g on a.fil_codigo = g.fil_codigo and a.sit_codigo = g.sit_codigo ");
        sqlFrom.append("left join usuario h on upper(a.usr_codigo) = upper(h.usr_codigo) ");
        sqlFrom.append("left join usuario ab on upper(a.usr_codabertura) = upper(ab.usr_codigo) ");
        sqlFrom.append("left join paciente j on a.fil_codigo = j.fil_codigo and a.pac_codigo = j.pac_codigo ");
        sqlFrom.append("left join cidades k on c.fil_codigo = k.fil_codigo and c.cid_codigo = k.cid_codigo ");
        sqlFrom.append("left join cidades l on d.fil_codigo = l.fil_codigo and d.cid_codigo = l.cid_codigo ");
        sqlFrom.append("left join cidades m on e.fil_codigo = m.fil_codigo and e.cid_codigo = m.cid_codigo ");
        sqlFrom.append("left join cidades n on f.fil_codigo = n.fil_codigo and f.cid_codigo = n.cid_codigo ");
        sqlFrom.append("left join cidades o on j.fil_codigo = o.fil_codigo and j.cid_codigo = o.cid_codigo ");
        sqlFrom.append("left join bairro p on c.fil_codigo = p.fil_codigo and c.bai_codigo = p.bai_codigo ");
        sqlFrom.append("left join bairro q on d.fil_codigo = q.fil_codigo and d.bai_codigo = q.bai_codigo ");
        sqlFrom.append("left join bairro r on e.fil_codigo = r.fil_codigo and e.bai_codigo = r.bai_codigo ");
        sqlFrom.append("left join bairro s on f.fil_codigo = s.fil_codigo and f.bai_codigo = s.bai_codigo ");
        sqlFrom.append("left join bairro t on j.fil_codigo = t.fil_codigo and j.bai_codigo = t.bai_codigo ");
        sqlFrom.append("left join examematcoleta u on b.fil_codigo = u.fil_codigo and upper(b.exa_codigo) = upper(u.exa_codigo) and b.mco_codigo = u.mco_codigo ");
        sqlFrom.append("left join materialcoleta v on u.fil_codigo = v.fil_codigo and u.mco_codigo = v.mco_codigo ");
        sqlFrom.append("left join exames w on b.fil_codigo = w.fil_codigo and upper(b.exa_codigo) = upper(w.exa_codigo) ");
        sqlFrom.append("left join prazoentrega prazo on u.fil_codigo = prazo.fil_codigo and u.prz_codigo = prazo.prz_codigo ");
        sqlFrom.append("left join metodologia metodo on b.fil_codigo = metodo.fil_codigo and b.met_codigo = metodo.met_codigo ");
        sqlFrom.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo ");
        sqlFrom.append("left join cidades cidfilial on filial.fil_codigo = cidfilial.fil_codigo and filial.cid_codigo = cidfilial.cid_codigo ");
        sqlFrom.append("left join bairro baifilial on filial.fil_codigo = baifilial.fil_codigo and filial.bai_codigo = baifilial.bai_codigo ");
        sqlFrom.append("left join examesetor exmsetor on w.fil_codigo = exmsetor.fil_codigo and w.exa_codigo = exmsetor.exa_codigo and exmsetor.ese_default = true ");
        sqlFrom.append("left join setores setores on exmsetor.fil_codigo = setores.fil_codigo and exmsetor.set_codigo = setores.set_codigo ");
        sqlFrom.append("left join alahospital ala on a.fil_codigo = ala.fil_codigo and a.ala_codigo = ala.ala_codigo ");
        sqlFrom.append("left join tabelaprecoexames tpe on c.fil_codigo = tpe.fil_codigo and c.tpe_codigo = tpe.tpe_codigo ");
        sqlFrom.append("left join unidademedida on a.fil_codigo = unidademedida.fil_codigo and a.unm_codigo = unidademedida.unm_codigo ");
        sqlFrom.append("left join pacientescontatos paccontatos on a.fil_codigo = paccontatos.fil_codigo and a.pac_codigo = paccontatos.pac_codigo and a.pco_codigo = paccontatos.pco_codigo ");
        sqlFrom.append("left join entidade ent on a.fil_codigo = ent.fil_codigo and a.ent_codigo = ent.ent_codigo ");
        sqlFrom.append("left join entidade entempresapaciente on j.fil_codigo = entempresapaciente.fil_codigo and j.ent_codempresa = entempresapaciente.ent_codigo ");
        sqlFrom.append("left join cidades cidcobranca on j.fil_codigo = cidcobranca.fil_codigo and j.cid_codigocobranca = cidcobranca.cid_codigo ");
        sqlFrom.append("left join bairro baicobranca on j.fil_codigo = baicobranca.fil_codigo and j.bai_codigocobranca = baicobranca.bai_codigo ");
        sqlFrom.append("left join embalagemproduto emb on a.fil_codigo = emb.fil_codigo and a.emb_codigo = emb.emb_codigo ");
        sqlFrom.append("left join unidadesaude us on a.fil_codigo = us.fil_codigo and a.uns_codigo = us.uns_codigo ");
        sqlFrom.append("left join cidades cidadeus on us.fil_codigo = cidadeus.fil_codigo and us.cid_codigo = cidadeus.cid_codigo ");
        sqlFrom.append("left join bairro bairrous on us.fil_codigo = bairrous.fil_codigo and us.bai_codigo = bairrous.bai_codigo ");
        sqlFrom.append("left join especie on j.fil_codigo = especie.fil_codigo and j.epc_codigo = especie.epc_codigo ");
        sqlFrom.append("left join raca on especie.fil_codigo = raca.fil_codigo and especie.epc_codigo = raca.epc_codigo and j.rac_codigo = raca.rac_codigo ");
        sqlFrom.append("left join cidades cidentidade on ent.fil_codigo = cidentidade.fil_codigo and ent.cid_codigo = cidentidade.cid_codigo ");
        sqlFrom.append("left join bairro baientidade on ent.fil_codigo = baientidade.fil_codigo and ent.bai_codigo = baientidade.bai_codigo ");
        sqlFrom.append("left join pais pai on a.pai_codigo = pai.pai_codigo and a.fil_codigo = pai.fil_codigo ");
        sqlFrom.append("left join configuracaoweb cwe on a.fil_codigo = cwe.cwe_filialpadrao ");
        sqlFrom.append(isAlimentos ? "left join categoriaprodutoalimentos cpl on a.fil_codigo = cpl.fil_codigo and a.cpl_codigo = cpl.cpl_codigo " : "");
        sqlFrom.append(isAlimentos ? "left join produtoalimentos pal on a.fil_codigo = pal.fil_codigo and pal.pal_codigo = a.pal_codigo and cpl.cpl_codigo = pal.cpl_codigo " : "");
        sqlFrom.append(isAlimentos ? "left join exameagrupaexameconvenio eaec on a.fil_codigo = eaec.fil_codigo and b.exa_codigo = eaec.exa_kodigo and b.exa_codigopai = eaec.exa_codigo and b.mco_codigo = eaec.mco_kodigo and a.con_codigo = eaec.con_codigo and eaec.aec_tipo = 'R' " : "");
        sqlFrom.append(isAlimentos ? "left join agrupaexameconvenio aec on a.fil_codigo = aec.fil_codigo and aec.exa_codigo = eaec.exa_codigo and aec.aec_tipo = eaec.aec_tipo and (aec.con_codigo = eaec.con_codigo OR aec.aec_ignorarconvenio is true) " : "");
        return sqlFrom.toString();
    }

    private String getCamposWhere(String codigoFilial, String codigoRequisicao) {
        StringBuilder sqlWhere = new StringBuilder(" where ");
        sqlWhere.append(" a.fil_codigo = ").append(codigoFilial);
        sqlWhere.append(" and a.req_codigo in (").append(codigoRequisicao).append(")");
        sqlWhere.append(" and (a.req_excluida = false or (a.req_excluida = true and a.req_origemagendamento = true)) and b.exr_excluido = false ");
        return sqlWhere.toString();
    }

    private String getCamposWhereMultiguia(String codigoFilial, String codigoRequisicao, Statement st) throws SQLException {
        Integer[] multiguias = RecepcaoUtil.verificaMultiGuias(st, codigoFilial, codigoRequisicao, true, false);
        multiguias.toString();
        StringBuilder sqlWhere = new StringBuilder(" where ");
        sqlWhere.append(" a.fil_codigo = ").append(codigoFilial);
        sqlWhere.append(" and a.req_codigo in (").append(codigoRequisicao).append(") ");
        sqlWhere.append(" and (a.req_excluida = false or (a.req_excluida = true and a.req_origemagendamento = true)) and b.exr_excluido = false ");
        return sqlWhere.toString();
    }

    private String getCamposOrderBy(boolean ordenarSetor, String ordemComprovante) {
        StringBuilder sqlOrderBy = new StringBuilder(" order by  ");
        if (this.isTipoOrdemComprovante("A", ordemComprovante)) {
            sqlOrderBy.append(" b.exr_ordem ");
            return sqlOrderBy.toString();
        }
        if (this.isAlimentos()) {
            sqlOrderBy.append("A.REQ_CODIGO, EAEC.EXA_CODIGO, B.EXA_CODIGO, B.MCO_CODIGO, U.EMC_PAGINA, U.EMC_ORDEM ");
            return sqlOrderBy.toString();
        }
        sqlOrderBy.append(ordenarSetor ? " exmsetor.set_codigo, " : "");
        sqlOrderBy.append(" a.req_codigo ");
        if (this.isTipoOrdemComprovante("C", ordemComprovante)) {
            sqlOrderBy.append(", b.exa_codigo ");
        } else if (this.isTipoOrdemComprovante("P", ordemComprovante)) {
            sqlOrderBy.append(", u.emc_pagina, u.emc_ordem, b.exa_codigo, b.mco_codigo ");
        }
        return sqlOrderBy.toString();
    }

    public ResultSet recuperarCamposAgendamento(Statement statement, String codigoFilial, String codigoRequisicao) throws SQLException {
        StringBuilder sql = new StringBuilder("select ");
        sql.append("agd.agd_codigo as codigoAgendamento, ");
        sql.append("agd.agd_datahoraagenda as dataHoraAgendamento, ");
        sql.append("agd.agd_situacao as situacaoAgendamento, ");
        sql.append("agd.agd_observacao as observacaoAgendamento, ");
        sql.append("sal.sal_codigo as codigoSalaAtendimento, ");
        sql.append("sal.sal_descricao as descricaoSalaAtendimento ");
        sql.append(" from agendamento agd ");
        sql.append(" join salaatendimento sal on agd.fil_codigo = sal.fil_codigo and agd.sal_codigo = sal.sal_codigo ");
        sql.append(" where agd.fil_codigo = ").append(codigoFilial);
        sql.append(" and pegacodigomultiguiamae(agd.fil_codigo, agd.req_codigo) = pegacodigomultiguiamae(").append(codigoFilial).append(", ").append(codigoRequisicao).append(") ");
        sql.append(" and agd.agd_situacao IN ('").append("A").append("' ");
        sql.append(" ,'").append("T").append("' ");
        sql.append(" ,'").append("F").append("') ");
        sql.append(" order by agd.agd_datahoraagenda ");
        return statement.executeQuery(sql.toString());
    }

    public ResultSet recuperarCamposRodape(Statement statement, String codigoFilial, String codRequisicoes, boolean ocultarApenasFaturamento) throws SQLException {
        StringBuilder sql = new StringBuilder("select ");
        sql.append("a.exa_codigo, c.rec_capacidade, b.rec_codigo, b.rco_qtde, b.rco_volume, ");
        sql.append("d.mco_abreviatura, d.mco_codigo, d.mco_descricao, a.req_codigo, f.pac_nome, a.exr_situacao, ");
        sql.append("'' as descricaoSituacaoExame, c.rec_descricao, estacao.est_descricao, es.set_codigo, COALESCE(a.exr_codigoapoiado, '') as exr_codigoapoiado,  f.pac_nomesocial ");
        sql.append("from examerequisicao a ");
        sql.append("left join requisicao e on a.fil_codigo = e.fil_codigo and a.req_codigo = e.req_codigo ");
        sql.append("left join paciente f on e.fil_codigo = f.fil_codigo and e.pac_codigo = f.pac_codigo ");
        sql.append("left join recipcoleta b on a.fil_codigo = b.fil_codigo and upper(a.exa_codigo) = upper(b.exa_codigo) and a.mco_codigo = b.mco_codigo ");
        sql.append("left join recipientes c on a.fil_codigo = c.fil_codigo and b.rec_codigo = c.rec_codigo ");
        sql.append("left join materialcoleta d on a.fil_codigo = d.fil_codigo and a.mco_codigo = d.mco_codigo ");
        sql.append("left join examematcoleta g on a.fil_codigo = g.fil_codigo and a.exa_codigo = g.exa_codigo and a.mco_codigo = g.mco_codigo ");
        sql.append("left join examesetor es on a.fil_codigo = es.fil_codigo and upper(a.exa_codigo) = upper(es.exa_codigo) ");
        sql.append("left join estacoes estacao on e.est_codigo = estacao.est_codigo ");
        sql.append("where a.fil_codigo = ").append(codigoFilial);
        sql.append(" and a.req_codigo IN (").append(codRequisicoes).append(") ");
        sql.append(" and (a.exr_excluido = false or a.exr_excluido is null) and (e.req_excluida = false or e.req_excluida is null) ");
        if (ocultarApenasFaturamento) {
            sql.append(" and a.exr_situacao <> 'A'");
        }
        sql.append(" order by es.set_codigo, b.rec_codigo, a.mco_codigo, b.rco_qtde, a.exa_codigo ");
        return statement.executeQuery(sql.toString());
    }

    public ResultSet recuperarCurvaDeExameInterface(Statement statement, String codFilial, String codExame, String codMaterialcoletado, String tipoExportacaoInterface) throws SQLException {
        StringBuilder sql = new StringBuilder("select ");
        sql.append("emi_curva, int_codigo from examematinterface ");
        sql.append("where fil_codigo = ").append(codFilial);
        sql.append(" and exa_codigo = '").append(StringUtil.textoDB(codExame)).append("' ");
        sql.append(" and mco_codigo = ").append(codMaterialcoletado);
        sql.append(tipoExportacaoInterface.equals("P") ? " and emi_padrao = true " : "");
        return statement.executeQuery(sql.toString());
    }

    public ResultSet recuperarDadosDeExameMatIntDesmembrar(Statement statement, String codFilial, String codExame, String codMaterialColetado, Integer codInterface) throws SQLException {
        StringBuilder buf = new StringBuilder("select ");
        buf.append("exa_kodigo, mco_kodigo from examematintdesmembrar ");
        buf.append("where fil_codigo = ").append(codFilial);
        buf.append(" and exa_codigo = '").append(StringUtil.textoDB(codExame)).append("' ");
        buf.append(" and mco_codigo = ").append(codMaterialColetado);
        buf.append(" and int_codigo = ").append(codInterface);
        return statement.executeQuery(buf.toString());
    }

    public ResultSet recuperarDadosDeRecipColeta(Statement statement, String codFilial, String codExame, String codMaterialColetado, int agruparInterface) throws SQLException {
        StringBuilder sql = new StringBuilder("select ");
        sql.append("a.rec_codigo, c.rec_descricao ");
        sql.append("from ");
        sql.append("recipcoleta a ");
        sql.append("join recipientes c on c.fil_codigo = a.fil_codigo and c.rec_codigo = a.rec_codigo ");
        sql.append("where a.fil_codigo = ").append(codFilial);
        sql.append(" and a.exa_codigo = '").append(StringUtil.textoDB(codExame)).append("'");
        sql.append(" and a.mco_codigo = ").append(codMaterialColetado);
        sql.append(agruparInterface == 0 ? " and a.rco_interface = true " : "");
        sql.append(" order by a.rec_codigo ");
        return statement.executeQuery(sql.toString());
    }

    public ResultSet recuperarCamposTipoExame(String filial, String requisicao, Statement st) throws SQLException {
        if (st == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder("");
        buf.append("select a.req_codigo as codigoRequisicao, a.req_data as dataRequisicao, a.req_dtfatura as dataFaturaRequisicao, a.req_urgente as urgenteRequisicao, a.req_dataentregaprev as dataEntregaRequisicao,");
        buf.append("a.req_responsavel as responsavelPacienteRequisicao, a.req_cpfresponsavel as cpfResponsavelPacienteRequisicao, coalesce(a.req_incapacitado,false) as incapacitadoPacienteRequisicao,");
        buf.append("j.pac_responsavel as responsavelPaciente, j.pac_cpfresponsavel as cpfResponsavelPaciente, coalesce(j.pac_incapacitado,false) as incapacitadoPaciente,");
        buf.append("j.pac_whatsapp as whatsAppPaciente, ");
        buf.append("a.req_dclinicos as dadosClinicosRequisicao, a.req_obs as obsRequisicao, a.req_totpago as totalPagoRequisicao, a.req_horaentregaprev as horaEntregaRequisicao, a.req_total as totalRequisicao,");
        buf.append("a.req_horafatura as horaFaturaRequisicao, a.req_hora as horaRequisicao, a.req_gestante as gestanteRequisicao, a.req_dum as dumRequisicao, a.req_idade as idadeRequisicao, a.req_anomes as anoMesRequisicao,");
        buf.append("a.req_matricula as matriculaRequisicao, a.req_avisarpaciente as avisarPacienteRequisicao, a.req_senhaweb as senhaWebRequisicao, a.req_titular as titularRequisicao, a.req_peso as pesoRequisicao,");
        buf.append("a.req_altura as alturaRequisicao, a.req_desconto as descontoRequisicao, a.req_vlrdesconto as valorDescontoRequisicao, a.req_notacaixa as notaCaixaRequisicao, ");
        buf.append("a.req_vlrexames as valorExamesRequisicao, a.req_vlrmateriais as valorMateriaisRequisicao, a.req_guia as guiaRequisicao, ");
        buf.append("a.req_acrescimo as acrescimoRequisicao, a.req_vlracrescimo as valorAcrescimoRequisicao, a.req_tipoultpagamento as tipoUltimoPagamentoRequisicao, ");
        buf.append("a.sit_codigo as codigoSituacao, g.sit_descricao as descricaoSituacao,");
        buf.append("a.usr_codigo as codigoUsuario, h.usr_nome as nomeUsuario, ");
        buf.append("o.cid_codigo as codigoCidadePaciente, o.cid_nome as descricaoCidadePaciente, o.cid_uf as estadoCidadePaciente,");
        buf.append("t.bai_codigo as codigoBairroPaciente, t.bai_descricao as descricaoBairroPaciente,");
        buf.append("a.des_codigo as codigoDestino, e.des_descricao as descricaoDestino, e.des_endereco as enderecoDestino, e.des_complemento as complementoDestino,e.des_cep as cepDestino, e.des_fone as foneDestino,");
        buf.append("a.col_codigo as codigoColeta, f.col_descricao as descricaoColeta, f.col_endereco as enderecoColeta, f.col_complemento as complementoColeta, f.col_cep as cepColeta, f.col_fone as foneColeta,");
        buf.append("a.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial,");
        buf.append("cidfilial.cid_codigo as codigoCidadeFilial, cidfilial.cid_nome as descricaoCidadeFilial, cidfilial.cid_uf as estadoCidadeFilial,");
        buf.append("baifilial.bai_codigo as codigoBairroFilial, baifilial.bai_descricao as descricaoBairroFilial,");
        buf.append("d.med_conselho as conselhoMedico, d.med_crm as crmMedico, d.med_uf as estadoCrmMedico, d.med_nome as nomeMedico, d.med_abrev as tratamentoMedico, d.med_endereco as enderecoMedico, d.med_numeroendereco as numeroEnderecoMedico, d.med_tipologradouroendereco as tipoLogradouroMedico,  d.med_complemento as complementoMedico, d.med_cep as cepMedico, d.med_fone as foneMedico, d.med_celular as celularMedico, d.med_fax as faxMedico, d.med_email as emailMedico, d.med_site as siteMedico,");
        buf.append("c.con_codigo as codigoConvenio, c.con_fantasia as fantasiaConvenio, c.con_razao as razaoSocialConvenio, c.con_endereco as enderecoConvenio, c.con_numeroendereco as numeroEnderecoConvenio, c.con_tipologradouroendereco as tipoLogradouroConvenio,  c.con_complemento as complementoConvenio, c.con_cep as cepConvenio, c.con_fone as foneConvenio, c.con_email1 as email1Convenio, c.con_email2 as email2Convenio, c.con_site as siteConvenio,");
        buf.append("j.pac_codigo as codigoPaciente, j.pac_nome as nomePaciente, j.pac_sexo as sexoPaciente, j.pac_datanasc as dataNascimentoPaciente, j.pac_grpsangue as grupoSanguineoPaciente, j.pac_fatorrh as fatorRHPaciente, j.pac_fatordu as fatorDUPaciente, j.pac_cor as corPaciente,");
        buf.append("j.pac_profissao as profissaoPaciente, j.pac_rg as rgPaciente, j.pac_cpf as cpfPaciente, j.pac_estcivil as estadoCivilPaciente, j.pac_dum as dumPaciente, j.pac_fone as fonePaciente, j.pac_celular as celularPaciente, j.pac_fax as faxPaciente, j.pac_fonecomercial as foneComercialPaciente,");
        buf.append("j.pac_endereco as enderecoPaciente, j.pac_numeroendereco as numeroEnderecoPaciente, j.pac_tipologradouroendereco as tipoLogradouroPaciente, j.pac_complemento as complementoPaciente, j.pac_cep as cepPaciente, j.pac_email as emailPaciente, j.pac_fonecontato as foneContatoPaciente, j.pac_nomecontato as contatoPaciente, ");
        buf.append("j.pac_senhaweb as senhaWebPaciente, j.pac_nomesocial as nomeSocialPaciente, null as dataPrimeiraColetaExameRequisicao, null as dataUltimaColetaExameRequisicao, null as datasColetasExameRequisicao, ");
        buf.append("j.pac_passaporte as passaportePaciente, ");
        buf.append("a.req_procedencia as procedenciaRequisicao ");
        buf.append(", age(a.req_data, j.pac_datanasc) as idadeRequisicaoPaciente ");
        buf.append(", a.req_periodogestacional as periodoGestacionalRequisicao ");
        buf.append("from requisicao a ");
        buf.append("left join convenios c on a.fil_codigo = c.fil_codigo and a.con_codigo = c.con_codigo ");
        buf.append("left join medico d on a.fil_codigo = d.fil_codigo and a.med_conselho = d.med_conselho and upper(a.med_crm) = upper(d.med_crm) and a.med_uf = d.med_uf ");
        buf.append("left join destino e on a.fil_codigo = e.fil_codigo and upper(a.des_codigo) = upper(e.des_codigo) ");
        buf.append("left join coletas f on a.fil_codigo = f.fil_codigo and upper(a.col_codigo) = upper(f.col_codigo) ");
        buf.append("left join situacao g on a.fil_codigo = g.fil_codigo and a.sit_codigo = g.sit_codigo ");
        buf.append("left join usuario h on upper(a.usr_codigo) = upper(h.usr_codigo) ");
        buf.append("left join paciente j on a.fil_codigo = j.fil_codigo and a.pac_codigo = j.pac_codigo ");
        buf.append("left join cidades o on j.fil_codigo = o.fil_codigo and j.cid_codigo = o.cid_codigo ");
        buf.append("left join bairro t on j.fil_codigo = t.fil_codigo and j.bai_codigo = t.bai_codigo ");
        buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo ");
        buf.append("left join cidades cidfilial on filial.fil_codigo = cidfilial.fil_codigo and filial.cid_codigo = cidfilial.cid_codigo ");
        buf.append("left join bairro baifilial on filial.fil_codigo = baifilial.fil_codigo and filial.bai_codigo = baifilial.bai_codigo ");
        buf.append("where a.fil_codigo = ");
        buf.append(filial);
        buf.append(" and a.req_codigo = ");
        buf.append(requisicao);
        buf.append(" and (a.req_excluida = false or (a.req_excluida = true and a.req_origemagendamento = true))");
        return st.executeQuery(buf.toString());
    }

    public static Date getDataColetasMaxMin(String filial, String codigoRequisicao, int campoRetorno, Statement st) {
        StringBuilder buf = new StringBuilder();
        if (campoRetorno == 1) {
            buf.append(" select max(exr_datamaterial) as result ");
        } else if (campoRetorno == 2) {
            buf.append(" select min(exr_datamaterial) as result ");
        }
        buf.append("  from examerequisicao  ");
        buf.append(" where fil_codigo = ").append(filial);
        buf.append("   and req_codigo = ").append(codigoRequisicao);
        buf.append("   and not exr_excluido ");
        try {
            ResultSet rs = st.executeQuery(buf.toString());
            if (rs.next()) {
                if (Funcoes.textoVazio(rs.getString("result"))) {
                    return null;
                }
                return Funcoes.stringToDate(Funcoes.formataData("dd/MM/yyyy HH:mm", rs.getTimestamp("result")));
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
        }
        return null;
    }

    public static String getDataColetasLista(String filial, String codigoRequisicao, Statement st) {
        StringBuilder buf = new StringBuilder();
        buf.append(" select distinct exr_datamaterial as result ");
        buf.append(" from examerequisicao  ");
        buf.append(" where fil_codigo = ").append(filial);
        buf.append("   and req_codigo = ").append(codigoRequisicao);
        buf.append("   and not exr_excluido ");
        buf.append(" order by exr_datamaterial ");
        try {
            ResultSet rs = st.executeQuery(buf.toString());
            String retorno = "";
            while (rs.next()) {
                if (!Funcoes.textoVazio(retorno)) {
                    retorno = retorno + ", ";
                }
                retorno = retorno + Funcoes.formataData("dd/MM/yyyy HH:mm", rs.getTimestamp(1));
            }
            return retorno;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
            return null;
        }
    }

    public boolean salvarHistoricoImpressao(String codFilial, String codigos, String PDFImpresso, String codigoPaciente, String codigoModeloTermo, Statement st, boolean isColetaWeb, Callable<Boolean> arquivar, Callable<Boolean> anular) throws Exception {
        String[] codigosRequisicoes = codigos.split(", ");
        boolean retorno = false;
        for (String codRequisicao : codigosRequisicoes) {
            Integer codigo = this.getProximoCodigo(codFilial, String.valueOf(codRequisicao), st);
            try {
                SalvaDados salvar = new SalvaDados("requisicaotermoconsentimento", 0);
                salvar.limpar();
                salvar.adicionaCampo("fil_codigo", 2, false, true, codFilial);
                salvar.adicionaCampo("req_codigo", 2, false, true, codRequisicao);
                salvar.adicionaCampo("rtc_codigo", 2, false, true, codigo);
                salvar.adicionaCampo("pac_codigo", 2, false, true, codigoPaciente);
                salvar.adicionaCampo("mtc_codigo", 2, false, true, codigoModeloTermo);
                salvar.adicionaCampo("rtc_datahoraimpressao", 5, false, false, 0);
                salvar.adicionaCampo("usr_codigo", 0, false, false, StringUtil.textoDB(Variaveis.login));
                salvar.adicionaCampo("rtc_copiaimpressa", 0, false, false, PDFImpresso);
                if (isColetaWeb) {
                    retorno = st.executeUpdate(salvar.getComando()) > 0;
                } else {
                    Conexao.executeUpdate(codFilial, st, salvar.getComando());
                }
                arquivar.call();
            }
            catch (Exception e) {
                anular.call();
            }
        }
        return retorno;
    }

    private Integer getProximoCodigo(String codFilial, String codRequisicao, Statement st) throws SQLException {
        StringBuilder sql = new StringBuilder("select ");
        sql.append(" max(rtc_codigo) as codigo ");
        sql.append(" from requisicaotermoconsentimento ");
        sql.append(" where fil_codigo = ").append(codFilial);
        sql.append(" and req_codigo = ").append(codRequisicao);
        ResultSet consulta = st.executeQuery(sql.toString());
        Integer codigo = consulta.next() ? consulta.getInt("codigo") + 1 : 1;
        consulta.close();
        return codigo;
    }

    public Registro pesquisarLayoutPorDestinoDoConvenio(String codFilial, Integer codConvenio, String destinoRequisicao, Statement st) throws SQLException {
        StringBuilder sql = new StringBuilder(" select c.con_imprimirtermo, d.lay_codigo ");
        sql.append(" from  convenios c ");
        sql.append(" left join destinoconvlayout d on c.fil_codigo = d.fil_codigo and c.con_codigo = d.con_codigo and d.des_codigo = '").append(destinoRequisicao).append("'");
        sql.append(" where c.fil_codigo = ").append(codFilial);
        sql.append(" and c.con_codigo = ").append(codConvenio);
        Registro reg = new Registro();
        ResultSet consulta = st.executeQuery(sql.toString());
        if (consulta.next()) {
            reg.setValor("imprimeTermo", consulta.getString("con_imprimirtermo"));
            reg.setValor("codLayout", consulta.getString("lay_codigo"));
        }
        consulta.close();
        return reg;
    }

    public String pesquisarTermosImpressos(String codigoFilial, String codigoPaciente, String codigoRequisicao, Statement st) {
        StringBuilder mensagem = new StringBuilder();
        StringBuilder sql = new StringBuilder();
        sql.append("select r.req_codigo as reqcodigo, t.mtc_descricao as mtcdescricao, r.rtc_datahoraimpressao as datahoraimpressao, r.fil_codigo as filcodigo, r.mtc_codigo as mtccodigo ");
        sql.append("from requisicaotermoconsentimento r ");
        sql.append("left join termoconsentimento t on t.fil_codigo = r.fil_codigo and t.mtc_codigo = r.mtc_codigo ");
        sql.append("where r.fil_codigo in (").append(codigoFilial);
        sql.append(") and (r.pac_codigo = ").append(codigoPaciente);
        sql.append(" or r.req_codigo = ").append(codigoRequisicao);
        sql.append(") order by r.rtc_datahoraimpressao desc");
        try {
            ResultSet rs = st.executeQuery(sql.toString());
            if (!rs.next()) {
                return null;
            }
            String descricaoTermo = Funcoes.textoVazio(rs.getString("mtccodigo")) ? "O Termo de consentimento" : rs.getString("mtcdescricao");
            mensagem.append("\"").append(descricaoTermo).append("\" j\u00e1 foi impresso para o paciente em: ");
            mensagem.append(Funcoes.formataDataEHora(rs.getString("datahoraimpressao"))).append(" atrav\u00e9s da Requisi\u00e7\u00e3o ");
            mensagem.append(rs.getString("reqcodigo")).append(" da Filial ").append(rs.getString("filcodigo"));
            mensagem.append(". Deseja realizar uma nova impres\u00e3o?");
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return mensagem.toString();
    }

    private boolean isAlimentos() {
        return Variaveis.tipoFilialPadrao.equals("A");
    }

    private boolean isTipoOrdemComprovante(String tipo, String ordemComprovante) {
        return ordemComprovante.equals(tipo);
    }

    public RequisicaoTermoConsentimentoVO getDadosRequisicao(String filial, String requisicao, Statement st) throws SQLException {
        RequisicaoTermoConsentimentoVO retorno = new RequisicaoTermoConsentimentoVO();
        StringBuilder sql = new StringBuilder();
        sql.append("select fil_codigo, con_codigo, des_codigo from requisicao where fil_codigo = ").append(filial);
        sql.append(" and req_codigo = ").append(requisicao);
        ResultSet rs = st.executeQuery(sql.toString());
        if (rs.next()) {
            retorno.setCodigoFilial(rs.getInt("fil_codigo"));
            retorno.setCodigoConvenio(rs.getInt("con_codigo"));
            retorno.setCodigoDestino(rs.getString("des_codigo"));
        }
        rs.close();
        return retorno;
    }
}

