/*
 * Decompiled with CFR 0.152.
 */
package jalis.model.dao.financeiro.faturamento.enotas;

import jalis.comum.Conexao;
import jalis.laboratorio.financeiro.faturamento.integracao.DadosEspeciaisCombo;
import jalis.laboratorio.financeiro.faturamento.integracao.enotas.validador.ErroCampoEnotas;
import jalis.laboratorio.financeiro.faturamento.integracao.tecnospeed.TecnospeedUtil;
import jalis.model.AbstractThreadDao;
import jalis.model.bean.financeiro.NotaFiscalBean;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import java.sql.Statement;
import javax.swing.JComboBox;

public class DialogoErrosEnotasDao {
    public void salvar(Statement st, ErroCampoEnotas erro, String filial, String tabela, String coluna, String valor, JComboBox combo) throws Exception {
        StringBuilder buf = new StringBuilder();
        buf.append("update ");
        buf.append(tabela);
        buf.append(" set ").append(coluna).append(" = ");
        if (erro.getCampoEnotas().getTipo().getTipoJalis() == 3 || erro.getCampoEnotas().getTipo().getTipoJalis() == 9 || erro.getCampoEnotas().getTipo().getTipoJalis() == 8 || erro.getCampoEnotas().getTipo().getTipoJalis() == 7 || erro.getCampoEnotas().getTipo().getTipoJalis() == 15 || erro.getCampoEnotas().getTipo().getTipoJalis() == 101) {
            if (erro.isCombo()) {
                buf.append(DBUtil.bdText(((DadosEspeciaisCombo)combo.getSelectedItem()).getCodigo().toString()));
            } else if (erro.getCampoEnotas().getTipo().getTipoJalis() == TecnospeedUtil.TipoDado.CNPJ.getTipoJalis()) {
                buf.append(DBUtil.bdText(StringUtil.limpaString(valor, new String[]{".", "-", "/"})));
                NotaFiscalBean bean = (NotaFiscalBean)erro.getCampoEnotas().getBean();
                bean.setCpfPagador(StringUtil.limpaString(valor, new String[]{".", "-", "/"}));
            } else {
                buf.append(DBUtil.bdText(valor));
            }
        } else if (erro.getCampoEnotas().getTipo().getTipoJalis() == 4) {
            buf.append(" '").append(Funcoes.formataData("yyyy-MM-dd", valor)).append("' ");
        } else if (erro.getCampoEnotas().getTipo().getTipoJalis() == 2 || erro.getCampoEnotas().getTipo().getTipoJalis() == 1 || erro.getCampoEnotas().getTipo().getTipoJalis() == 10) {
            buf.append(erro.isCombo() ? ((DadosEspeciaisCombo)combo.getSelectedItem()).getCodigo() : Funcoes.limpaCampos(valor, new String[0]));
        }
        buf.append(AbstractThreadDao.getWhere(erro.isNullCadastro() ? erro.getCampoEnotas().getBeanPai() : erro.getCampoEnotas().getBean()));
        Conexao.executeUpdate(filial, st, buf.toString());
    }
}

