/*
 * Decompiled with CFR 0.152.
 */
package jalis.model.dao.financeiro.faturamento;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Tipos;
import jalis.laboratorio.financeiro.faturamento.ExameBasico;
import jalis.laboratorio.financeiro.faturamento.PagamentoBasico;
import jalis.laboratorio.financeiro.faturamento.RequisicaoBasica;
import jalis.util.Funcoes;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class ImprimirNotaFiscalEmpresaDao {
    public String pesquisarNomePacientePorRequisicao(String codFilial, String codRequisicao) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append(" select pac.pac_nome as nome ");
        sql.append(" from requisicao req ");
        sql.append(" join paciente pac on req.fil_codigo = pac.fil_codigo and req.pac_codigo = pac.pac_codigo ");
        sql.append(" where req.fil_codigo = ").append(codFilial);
        sql.append(" and req.req_codigo = ").append(codRequisicao);
        ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), sql.toString());
        String nomePacinete = rs.next() ? rs.getString("nome") : "";
        rs.close();
        return nomePacinete;
    }

    public List<RequisicaoBasica> pesquisarRequisicoesPorEmpresa(String codFilial, String codEmpresa) throws SQLException {
        String sql = this.getSqlRequisicoes(codFilial, codEmpresa, new Integer[0]);
        Statement st = Conexao.getStatement();
        ResultSet rs = Conexao.executeQuery(st, sql);
        ArrayList<RequisicaoBasica> requisicoes = new ArrayList<RequisicaoBasica>();
        while (rs.next()) {
            RequisicaoBasica requisicao = new RequisicaoBasica(rs.getInt("codigoRequisicao"), rs.getInt("codigoPaciente"), rs.getString("nomePaciente"), rs.getDate("dataRequisicao"), rs.getString("conselhoMedico"), rs.getString("crmMedico"), rs.getString("ufMedico"), rs.getString("nomeMedico"), rs.getString("nomePagador"), rs.getString("cpfPagador"), rs.getBigDecimal("valorTotal"), rs.getBigDecimal("valorPago"));
            if (requisicoes.contains(requisicao)) continue;
            requisicoes.add(requisicao);
        }
        Conexao.fecharStatement(st);
        rs.close();
        return requisicoes;
    }

    public List<RequisicaoBasica> pesquisarRequisicoesPorCodigo(String codFilial, Integer[] codRequisicao) throws SQLException {
        String sql = this.getSqlRequisicoes(codFilial, "", codRequisicao);
        Statement st = Conexao.getStatement();
        ResultSet rs = Conexao.executeQuery(st, sql);
        ArrayList<RequisicaoBasica> requisicoes = new ArrayList<RequisicaoBasica>();
        while (rs.next()) {
            RequisicaoBasica requisicao = new RequisicaoBasica(rs.getInt("codigoRequisicao"), rs.getInt("codigoPaciente"), rs.getString("nomePaciente"), rs.getDate("dataRequisicao"), rs.getString("conselhoMedico"), rs.getString("crmMedico"), rs.getString("ufMedico"), rs.getString("nomeMedico"), rs.getString("nomePagador"), rs.getString("cpfPagador"), rs.getBigDecimal("valorTotal"), rs.getBigDecimal("valorPago"));
            if (requisicoes.contains(requisicao)) continue;
            requisicoes.add(requisicao);
        }
        Conexao.fecharStatement(st);
        rs.close();
        return requisicoes;
    }

    public ArrayList<ExameBasico> pesquisarExamesPorRequisicao(String codFilial, Integer codRequisicao) throws SQLException {
        String sql = this.getSqlRequisicoes(codFilial, "", new Integer[]{codRequisicao});
        Statement st = Conexao.getStatement();
        ResultSet rs = Conexao.executeQuery(st, sql);
        ArrayList<ExameBasico> exames = new ArrayList<ExameBasico>();
        while (rs.next()) {
            exames.add(new ExameBasico(rs.getInt("ordemExame"), rs.getString("codigoExame"), rs.getString("descricaoExame"), rs.getString("descricaoMaterial"), rs.getBigDecimal("valorTotalExame")));
        }
        Conexao.fecharStatement(st);
        rs.close();
        return exames;
    }

    private String getSqlRequisicoes(String codFilial, String codEmpresa, Integer[] codRequisicoes) {
        StringBuilder sql = new StringBuilder();
        sql.append(" select req.req_codigo as codigoRequisicao ");
        sql.append(" ,pac.pac_codigo as codigoPaciente ");
        sql.append(" ,pac.pac_nome as nomePaciente ");
        sql.append(" ,req.req_data as dataRequisicao ");
        sql.append(" ,req.med_conselho as conselhoMedico ");
        sql.append(" ,req.med_crm as crmMedico ");
        sql.append(" ,req.med_uf as ufMedico ");
        sql.append(" ,med.med_nome as nomeMedico ");
        sql.append(" ,COALESCE(pac.pac_nomepagador, pac.pac_nome) as nomePagador ");
        sql.append(" ,COALESCE(pac.pac_cpfpagador, pac.pac_cpfpagador) as cpfPagador ");
        sql.append(" ,exr.exr_ordem as ordemExame ");
        sql.append(" ,exr.exa_codigo as codigoExame ");
        sql.append(" ,exa.exa_descricao as descricaoExame ");
        sql.append(" ,mco.mco_descricao as descricaoMaterial ");
        sql.append(" ,calculaprecototalexamerequisicao(req.fil_codigo, req.con_codigo, req.req_codigo, exr.exa_codigo, exr.mco_codigo, false, false, true, exr.exr_vlrchexame, exr.exr_vlrch, exr.exr_valorporte, exr.exr_valorcusto, exr.exr_valoruco, exr.exr_vlrbalcaoconvenio, exr.exr_datafatura IS NOT NULL OR exr.usr_codfatura IS NOT NULL, exr.exr_vlrmaterial, exr.exr_vlrbalcaoconvenio, con.con_precosdiferenciados, con.con_reajuste, con.con_cobrmaterial, con.con_percpgtomaterial, con.con_percpgto, con.con_tpcalcfatu, con.con_tpcalcch, con.con_perguntarpercbalcao, con.con_acrescimo, con.con_bonus, con.tpe_codigo, con.con_acrescimoporte, con.con_acrescimouco, con.con_descontoporte, con.con_descontouco, con.con_valorch, ").append(ParametrosGerais.getCasasPrecoExame()).append(", ").append(ParametrosGerais.getArredondamentoPrecoExame().ordinal()).append(", ").append(ParametrosGerais.getPrecoMetodologia() ? "true" : "false").append(", exr.met_codigo").append(") as valorTotalExame ");
        sql.append(" ,req.req_total as valorTotal ");
        sql.append(" ,req.req_totpago as valorPago ");
        sql.append(" from requisicao req ");
        sql.append(" join paciente pac on req.fil_codigo = pac.fil_codigo and req.pac_codigo = pac.pac_codigo ");
        sql.append(" join medico med on req.fil_codigo = med.fil_codigo and req.med_conselho = med.med_conselho and req.med_crm = med.med_crm and req.med_uf = med.med_uf ");
        sql.append(" join examerequisicao exr on req.fil_codigo = exr.fil_codigo and req.req_codigo = exr.req_codigo ");
        sql.append(" join examematcoleta  emc on exr.fil_codigo = emc.fil_codigo and exr.exa_codigo = emc.exa_codigo and exr.mco_codigo = emc.mco_codigo ");
        sql.append(" join exames exa on exr.fil_codigo = exa.fil_codigo and exr.exa_codigo = exa.exa_codigo ");
        sql.append(" join materialcoleta mco on exr.fil_codigo = mco.fil_codigo and exr.mco_codigo = mco.mco_codigo ");
        sql.append(" join convenios con on req.fil_codigo = con.fil_codigo and req.con_codigo = con.con_codigo ");
        sql.append(" where req.fil_codigo = ").append(codFilial);
        if (!Funcoes.textoVazio(codEmpresa)) {
            sql.append(" and req.pac_codigo = ").append(codEmpresa);
        }
        if (codRequisicoes.length > 0) {
            StringBuilder codigos = new StringBuilder();
            for (Integer codigo : codRequisicoes) {
                codigos.append(codigo).append(", ");
            }
            sql.append(" and req.req_codigo in (").append(codigos.substring(0, codigos.length() - 2).toString()).append(")");
        }
        sql.append(" and NOT req.req_excluida ");
        sql.append(" and NOT exr.exr_excluido ");
        sql.append(" and req.req_total > 0 ");
        sql.append(" order by req.req_codigo ");
        return sql.toString();
    }

    public ArrayList<PagamentoBasico> pesquisarPagamentosPorRequisicao(String codFilial, Integer codRequisicao) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append(" select distinct req.req_codigo ");
        sql.append(" ,lcx.lcx_datahora as dataHoraLancamento ");
        sql.append(" ,lcx.lcx_tipopagamento as tipoPagamentoLancamento ");
        sql.append(" ,cco.cco_reduzido as reduzidoContaCorrente ");
        sql.append(" ,cco.cco_conta as contaLancamento ");
        sql.append(" ,lcx.usr_codigo as codigoUsuarioLancamento ");
        sql.append(" ,lcx.lcx_valortotal as valorTotalLancamento ");
        sql.append(" ,coalesce(nfi.nfi_nomepagador, lcx.lcx_nomepagador) as nomePagador ");
        sql.append(" ,coalesce(nfi.nfi_cpfpagador, lcx.lcx_cpfpagador) as cpfPagador ");
        sql.append(" ,lcx.lcx_codigo as codigoLancamento ");
        sql.append(" ,lcx.est_codigo as codigoEstacao ");
        sql.append(" ,nfi.nfi_codigo as codigoNotaFiscal ");
        sql.append(" ,nfi.nfi_numero as numeroNotaFiscal ");
        sql.append(" ,nfi.nfi_numerorps as rpsNotaFiscal ");
        sql.append(" ,nfi.ser_codigo as serieNotaFiscal ");
        sql.append(" ,nfi.nfi_situacao as situacaoNotaFiscal");
        sql.append(" from requisicao req ");
        sql.append(" join requisicaolanctocaixa  rlc on req.fil_codigo = rlc.fil_codigo and req.req_codigo = rlc.req_codigo ");
        sql.append(" join lanctocaixa lcx on rlc.fil_codigo = lcx.fil_codigo and rlc.lcx_codigo = lcx.lcx_codigo and rlc.est_codigo = lcx.est_codigo ");
        sql.append(" join contacorrente cco on lcx.fil_codigo = cco.fil_codigo and lcx.cco_reduzido = cco.cco_reduzido ");
        sql.append(" join baixalanctocaixa blc on lcx.fil_codigo = blc.fil_codigo and lcx.lcx_codigo = blc.lcx_codigo and lcx.est_codigo = blc.est_codigo ");
        sql.append(" join baixa bxa on blc.fil_codigo = bxa.fil_codigo and blc.bxa_codigo = bxa.bxa_codigo and bxa.bxa_datacancelado IS NULL ");
        sql.append(" join baixareceberpagar brp on bxa.fil_codigo = brp.fil_codigo and bxa.bxa_codigo = brp.bxa_codigo ");
        sql.append(" join receberpagar rpg on brp.fil_codigo = rpg.fil_codigo and brp.rpg_codigo = rpg.rpg_codigo and (rpg.usr_codcancelado IS NULL and rpg.rpg_datacancelado IS NULL) ");
        sql.append(" join notafiscal nfi on rpg.fil_codigo = nfi.fil_codigo and rpg.nfi_codigo = nfi.nfi_codigo and ((nfi.nfi_numerorps IS NULL and nfi.nfi_situacao IN ('").append("A").append("', '").append("I").append("')) ");
        sql.append(" or (nfi.nfi_numerorps IS NOT NULL and nfi.nfi_situacao IN ('").append("E").append("', '").append("X").append("', '").append("A").append("', '").append("N").append("', '").append("O").append("', '").append("R").append("' ))) ");
        sql.append(" where req.fil_codigo = ").append(codFilial);
        sql.append(" and req.req_codigo = ").append(codRequisicao);
        sql.append(" and NOT req.req_excluida ");
        sql.append(" and (lcx.usr_codcancelado IS NULL and lcx.lcx_datacancelado IS NULL) ");
        sql.append(" order by req.req_codigo ");
        ArrayList<PagamentoBasico> pagamentos = new ArrayList<PagamentoBasico>();
        ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), sql.toString());
        while (rs.next()) {
            pagamentos.add(new PagamentoBasico(rs.getInt("codigoLancamento"), rs.getInt("codigoEstacao"), rs.getTimestamp("dataHoraLancamento"), Tipos.tipoPagamento(rs.getString("tipoPagamentoLancamento")), rs.getString("contaLancamento"), rs.getString("codigoUsuarioLancamento"), rs.getBigDecimal("valorTotalLancamento"), rs.getInt("codigoNotaFiscal") == 0 ? null : Integer.valueOf(rs.getInt("codigoNotaFiscal")), rs.getLong("numeroNotaFiscal") == 0L ? null : Long.valueOf(rs.getLong("numeroNotaFiscal")), rs.getLong("rpsNotaFiscal") == 0L ? null : Long.valueOf(rs.getLong("rpsNotaFiscal")), rs.getString("serieNotaFiscal"), rs.getString("nomePagador"), rs.getString("cpfPagador"), rs.getInt("reduzidoContaCorrente"), rs.getString("situacaoNotaFiscal")));
        }
        rs.close();
        return pagamentos;
    }

    public ArrayList<PagamentoBasico> pesquisarPagamentosSemNotaPorRequisicao(String codFilial, Integer codRequisicao) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append(" select distinct req.req_codigo ");
        sql.append(" ,lcx.lcx_datahora as dataHoraLancamento ");
        sql.append(" ,lcx.lcx_tipopagamento as tipoPagamentoLancamento ");
        sql.append(" ,cco.cco_reduzido as reduzidoContaCorrente ");
        sql.append(" ,cco.cco_conta as contaLancamento ");
        sql.append(" ,lcx.usr_codigo as codigoUsuarioLancamento ");
        sql.append(" ,lcx.lcx_valortotal as valorTotalLancamento ");
        sql.append(" ,lcx.lcx_nomepagador as nomePagador ");
        sql.append(" ,lcx.lcx_cpfpagador as cpfPagador ");
        sql.append(" ,lcx.lcx_codigo as codigoLancamento ");
        sql.append(" ,lcx.est_codigo as codigoEstacao ");
        sql.append(" ,null as codigoNotaFiscal ");
        sql.append(" ,null as numeroNotaFiscal ");
        sql.append(" ,null as rpsNotaFiscal ");
        sql.append(" ,null as serieNotaFiscal ");
        sql.append(" ,null as situacaoNotaFiscal");
        sql.append(" from requisicao req ");
        sql.append(" join requisicaolanctocaixa rlc on req.fil_codigo = rlc.fil_codigo and req.req_codigo = rlc.req_codigo ");
        sql.append(" join lanctocaixa lcx on rlc.fil_codigo = lcx.fil_codigo and rlc.lcx_codigo = lcx.lcx_codigo and rlc.est_codigo = lcx.est_codigo ");
        sql.append(" join contacorrente cco on lcx.fil_codigo = cco.fil_codigo and lcx.cco_reduzido = cco.cco_reduzido ");
        sql.append(" where req.fil_codigo = ").append(codFilial);
        sql.append(" and req.req_codigo = ").append(codRequisicao);
        sql.append(" and NOT req.req_excluida ");
        sql.append(" and (lcx.usr_codcancelado IS NULL and lcx.lcx_datacancelado IS NULL) ");
        sql.append(" order by req.req_codigo ");
        ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), sql.toString());
        ArrayList<PagamentoBasico> pagamentosSemNota = new ArrayList<PagamentoBasico>();
        while (rs.next()) {
            pagamentosSemNota.add(new PagamentoBasico(rs.getInt("codigoLancamento"), rs.getInt("codigoEstacao"), rs.getDate("dataHoraLancamento"), Tipos.tipoPagamento(rs.getString("tipoPagamentoLancamento")), rs.getString("contaLancamento"), rs.getString("codigoUsuarioLancamento"), rs.getBigDecimal("valorTotalLancamento"), rs.getInt("codigoNotaFiscal") == 0 ? null : Integer.valueOf(rs.getInt("codigoNotaFiscal")), rs.getLong("numeroNotaFiscal") == 0L ? null : Long.valueOf(rs.getLong("numeroNotaFiscal")), rs.getLong("rpsNotaFiscal") == 0L ? null : Long.valueOf(rs.getLong("rpsNotaFiscal")), rs.getString("serieNotaFiscal"), rs.getString("nomePagador"), rs.getString("cpfPagador"), rs.getInt("reduzidoContaCorrente"), rs.getString("situacaoNotaFiscal")));
        }
        rs.close();
        return pagamentosSemNota;
    }
}

