/*
 * Decompiled with CFR 0.152.
 */
package jalis.model.dao.financeiro.faturamento;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.comum.dados.faturamento.DadosExameFaturamento;
import jalis.comum.dados.faturamento.DadosExamePaiAgrupamento;
import jalis.comum.dados.faturamento.DadosFaturamento;
import jalis.laboratorio.financeiro.faturamento.ValorExamePai;
import jalis.laboratorio.util.faturamento.FuncoesGerais;
import jalis.model.bean.cadastro.convenio.DetalheTabelaPrecoBean;
import jalis.model.bean.cadastro.convenio.DetalheTabelaPrecoMetodologiaBean;
import jalis.model.bean.cadastro.convenio.TabelaPrecoExameBean;
import jalis.model.bean.financeiro.FaturaBean;
import jalis.model.vo.cadastro.ConvenioVO;
import jalis.model.vo.cadastro.TabelaPrecoExameVO;
import jalis.model.vo.cadastro.TabelaPrecoPorteVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.model.vo.cadastro.exame.ExameVO;
import jalis.model.vo.cadastro.exame.MaterialColetaVO;
import jalis.model.vo.cadastro.exame.MetodologiaVO;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;

public class ConferenciaFaturaDao {
    public FaturaBean pesquisarFaturaPorCodigo(String codFatura, Integer codFilial) throws SQLException {
        StringBuilder sql = new StringBuilder(" select * from fatura ");
        sql.append(" where fat_codigo = ").append(codFatura);
        sql.append(" and fil_codigo = ").append(codFilial);
        Statement st = Conexao.getStatement();
        ResultSet rs = Conexao.executeQuery(st, sql.toString());
        FaturaBean fatura = new FaturaBean();
        if (rs.next()) {
            fatura = this.converterResultSetParaFaturabean(rs);
        }
        Conexao.fecharStatement(st);
        rs.close();
        return fatura;
    }

    public void atualizarDeveGuiaNaRequisicao(int codigoFilial, int codigoRequisicao, boolean deveGuia) throws SQLException {
        Statement st = Conexao.getStatement();
        StringBuilder sql = new StringBuilder("update requisicao set req_deveguia = ");
        sql.append(deveGuia ? "TRUE" : "FALSE");
        sql.append(" where fil_codigo = ");
        sql.append(codigoFilial);
        sql.append(" and req_codigo = ");
        sql.append(codigoRequisicao);
        this.executarSQL(String.valueOf(codigoFilial), sql.toString());
    }

    public void atualizarExameRequisicao(int codFilial, int codRequisicao, DadosExameFaturamento exame) throws SQLException {
        String codExame = exame.getExamePai() != null ? exame.getExamePai().getCodigo() : exame.getCodigoExame();
        int codMaterial = exame.getExamePai() != null ? exame.getExamePai().getMaterial() : exame.getCodigoMaterial().intValue();
        boolean marcadoNaoFaturar = !exame.isMarcadoNaoFaturar();
        StringBuilder sql = new StringBuilder(" update examerequisicao set ");
        sql.append(" exr_naofaturar = ").append(marcadoNaoFaturar);
        String codUsuario = marcadoNaoFaturar ? "'".concat(Variaveis.login).concat("'") : "null";
        sql.append(" , usr_codnaofaturar = ").append(codUsuario);
        sql.append(" , exr_deveguia = ").append(exame.getDeveGuia());
        sql.append(" where fil_codigo = ").append(codFilial);
        sql.append(" and req_codigo = ").append(codRequisicao);
        sql.append(" and exa_codigo = '").append(codExame).append("'");
        sql.append(" and mco_codigo = ").append(codMaterial);
        this.executarSQL(String.valueOf(codFilial), sql.toString());
    }

    public void atualizarDadosGuiaRequisicao(DadosFaturamento dados) throws SQLException {
        String guiaPrincipal = dados.getGuiaPrincipal() == null ? null : StringUtil.textoDB(dados.getGuiaPrincipal()).trim();
        String guia = dados.getGuia() == null ? null : StringUtil.textoDB(dados.getGuia()).trim();
        StringBuilder sql = new StringBuilder(" update requisicao set ");
        sql.append(" req_guiaprincipal = '").append(guiaPrincipal).append("'");
        sql.append(" , req_guia = '").append(guia).append("'");
        sql.append(dados.isGuiaConferida() ? " ,req_dataguiaconferida = COALESCE(req_dataguiaconferida, localtimestamp) " : "");
        sql.append(dados.isGuiaConferida() ? " ,usr_codguiaconferida = COALESCE(usr_codguiaconferida,".concat(Variaveis.login).concat(") ") : "");
        sql.append(" where fil_codigo = ").append(dados.getCodigoFilial());
        sql.append(" and req_codigo = ").append(dados.getRequisicao());
        this.executarSQL(String.valueOf(dados.getCodigoFilial()), sql.toString());
    }

    public void atualizarDadosGuiaExameRequisicao(int codFilial, int codRequisicao, DadosExameFaturamento exame) throws SQLException {
        String dataValidadeGuia = exame.getValidadeGuia() != null ? this.getDataPadraoSql(exame.getValidadeGuia()) : "null";
        String dataGuia = exame.getDataGuia() != null ? this.getDataPadraoSql(exame.getDataGuia()) : "null";
        StringBuilder sql = new StringBuilder(" update examerequisicao set ");
        sql.append(" exr_deveguia = ").append(exame.getDeveGuia());
        sql.append(" ,exr_guia = '").append(exame.getCodigoGuia().trim()).append("'");
        sql.append(" ,exr_validadeguia = ").append(dataValidadeGuia);
        sql.append(" ,exr_dataguia = ").append(dataGuia);
        sql.append(" where fil_codigo = ").append(codFilial);
        sql.append(" and req_codigo = ").append(codRequisicao);
        sql.append(" and exa_codigo = '").append(exame.getCodigoExame()).append("'");
        sql.append(" and mco_codigo = ").append(exame.getCodigoMaterial());
        this.executarSQL(String.valueOf(codFilial), sql.toString());
    }

    public void atualizarDadosGuiaExameRequisicaoGuiaAgrupada(int codFilial, int codRequisicao, DadosExameFaturamento exame) throws SQLException {
        String dataValidadeGuia = exame.getValidadeGuia() != null ? this.getDataPadraoSql(exame.getValidadeGuia()) : "null";
        String dataGuia = exame.getDataGuia() != null ? this.getDataPadraoSql(exame.getDataGuia()) : "null";
        StringBuilder sql = new StringBuilder(" update examerequisicaoguiaagrupada set ");
        sql.append(" exg_guia = '").append(exame.getCodigoGuia().trim()).append("'");
        sql.append(" ,exg_validadeguia = ").append(dataValidadeGuia);
        sql.append(" ,exg_deveguia = ").append(exame.getDeveGuia());
        sql.append(" ,exg_dataguia = ").append(dataGuia);
        sql.append(" where fil_codigo = ").append(codFilial);
        sql.append(" and exa_codigo = '").append(exame.getExamePai().getCodigo()).append("'");
        sql.append(" and exa_codfilho = '").append(exame.getCodigoExame()).append("'");
        sql.append(" and mco_codigo = ").append(exame.getExamePai().getMaterial());
        sql.append(" and mco_codfilho = ").append(exame.getCodigoMaterial());
        sql.append(" and req_codigo = ").append(codRequisicao);
        this.executarSQL(String.valueOf(codFilial), sql.toString());
    }

    public void atualizarDataFaturaRequisicao(DadosFaturamento dados) throws SQLException {
        StringBuilder sql = new StringBuilder(" update requisicao set req_dtfatura = '");
        sql.append(Funcoes.formataData("MM/dd/yyyy", dados.getDataFaturaRequisicao()));
        sql.append("', usr_codigo = '").append(Variaveis.login);
        sql.append("' where fil_codigo = ").append(dados.getCodigoFilial());
        sql.append(" and req_codigo = ").append(dados.getRequisicao());
        this.executarSQL(String.valueOf(dados.getCodigoFilial()), sql.toString());
    }

    public void inserirRegistroRequisicaoUsuario(DadosFaturamento dados) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append("insert into requisicaousuario (fil_codigo, req_codigo, usr_codigo, reu_data) values (");
        sql.append(dados.getCodigoFilial());
        sql.append(", ");
        sql.append(dados.getRequisicao());
        sql.append(", '");
        sql.append(Variaveis.login);
        sql.append("', '").append(Funcoes.formataData("yyyy-MM-dd HH:mm:ss.SSS", new Date())).append("')");
        this.executarSQL(String.valueOf(dados.getCodigoFilial()), sql.toString());
    }

    public void atualizarDatafaturaExameRequisicao(DadosFaturamento dados, DadosExameFaturamento exame) throws SQLException {
        StringBuilder sql = new StringBuilder(" update examerequisicao set ");
        if (FuncoesGerais.convenioRepasseFaturado(Conexao.getStatement(), dados)) {
            sql.append("exr_datafaturarepasse = null, ");
            sql.append("usr_codfaturarepasse = null ");
        } else {
            sql.append("exr_datafatura = null, ");
            sql.append("usr_codfatura = null ");
        }
        sql.append("where fil_codigo = ").append(dados.getCodigoFilial());
        sql.append(" and req_codigo = ").append(dados.getRequisicao());
        sql.append(" and exa_codigo = '").append(exame.getCodigoExame());
        sql.append("' and mco_codigo = ").append(exame.getCodigoMaterial());
        this.executarSQL(String.valueOf(dados.getCodigoFilial()), sql.toString());
    }

    public void excluirRegistroFaturaExameRequisicao(DadosFaturamento dados, DadosExameFaturamento exame, String codigoFatura) throws SQLException {
        StringBuilder sql = new StringBuilder(" delete from faturaexamerequisicao ");
        sql.append("  where fil_codigo = ").append(Variaveis.filialPadrao);
        sql.append("\tand fil_kodigo = ").append(dados.getCodigoFilial());
        sql.append("\tand fat_codigo = ").append(codigoFatura);
        sql.append("\tand req_codigo = ").append(dados.getRequisicao());
        if (exame.getExamePai() == null) {
            sql.append("\tand exa_codigo = '").append(exame.getCodigoExame()).append("' ");
            sql.append("\tand mco_codigo = ").append(exame.getCodigoMaterial());
        } else {
            sql.append("\tand exa_codigo = '").append(exame.getExamePai().getCodigo()).append("' ");
            sql.append("\tand mco_codigo = ").append(exame.getExamePai().getMaterial());
        }
        sql.append("\tand exa_codfilho = '").append(exame.getCodigoExame()).append("' ");
        sql.append("\tand mco_codfilho = ").append(exame.getCodigoMaterial());
        this.executarSQL(Variaveis.filialPadrao, sql.toString());
    }

    public void excluirRegistroFaturaRequisicao(DadosFaturamento dados, String codigoFatura) throws SQLException {
        StringBuilder sql = new StringBuilder(" delete from faturarequisicao ");
        sql.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
        sql.append("\tand fil_kodigo = ").append(dados.getCodigoFilial());
        sql.append("\tand fat_codigo = ").append(codigoFatura);
        sql.append("\tand con_codigo = ").append(dados.getCodigoConvenio());
        sql.append("\tand req_codigo = ").append(dados.getRequisicao());
        this.executarSQL(Variaveis.filialPadrao, sql.toString());
    }

    public void atualizarTotaisFaturaExameRequisicao(DadosFaturamento dados, DadosExamePaiAgrupamento examePai, DadosExameFaturamento exame, String codigoFatura) throws SQLException {
        StringBuilder sql = new StringBuilder(" update faturaexamerequisicao set ");
        sql.append("  fer_total =  ").append(Funcoes.limpaDecimal(String.valueOf(exame.getValorExame())));
        sql.append(" ,fer_totalch =  ").append(Funcoes.limpaDecimal(String.valueOf(exame.getValorCHExame())));
        sql.append(" ,fer_totalmateriais = ").append(Funcoes.limpaDecimal(String.valueOf(exame.getValorMaterial())));
        sql.append(" ,fer_valorch = ").append(Funcoes.limpaDecimal(String.valueOf(exame.getValorCH())));
        sql.append(" ,fer_vlrbalcaoconvenio = ").append(Funcoes.limpaDecimal(String.valueOf(exame.getValorBalcao())));
        sql.append(" ,fer_ordem = ").append(exame.getOrdemExame());
        sql.append(" ,fer_notaipergs = ").append(exame.getNotaIPERGS() != null ? exame.getNotaIPERGS() : "null");
        sql.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
        sql.append(" \tand fil_kodigo = ").append(String.valueOf(dados.getCodigoFilial()));
        sql.append(" \tand fat_codigo = ").append(codigoFatura);
        sql.append(" \tand req_codigo = ").append(dados.getRequisicao());
        sql.append(" \tand exa_codfilho = '").append(exame.getCodigoExame()).append("' ");
        sql.append(" \tand mco_codfilho = ").append(exame.getCodigoMaterial());
        if (examePai != null) {
            sql.append(" and exa_codigo = '").append(examePai.getCodigo()).append("' ");
            sql.append(" and mco_codigo = ").append(String.valueOf(examePai.getMaterial()));
        } else {
            sql.append(" and exa_codigo = '").append(exame.getCodigoExame()).append("' ");
            sql.append(" and mco_codigo = ").append(String.valueOf(exame.getCodigoMaterial()));
        }
        this.executarSQL(Variaveis.filialPadrao, sql.toString());
    }

    public void atualizarExamesExameRequisicao(DadosFaturamento dados, DadosExameFaturamento exame, DadosExamePaiAgrupamento examePai) throws SQLException {
        StringBuilder sql = new StringBuilder(" update examerequisicao set ");
        if (FuncoesGerais.convenioRepasseFaturado(Conexao.getStatement(), dados)) {
            sql.append("  exr_datafaturarepasse = current_timestamp ");
            sql.append(" ,usr_codfaturarepasse = '").append(Variaveis.login).append("' ");
        } else {
            sql.append("  exr_datafatura = current_timestamp ");
            sql.append(" ,usr_codfatura = '").append(Variaveis.login).append("' ");
            sql.append(" ,exr_deveguia = ").append(exame.getDeveGuia());
            sql.append(" ,exr_guia = ").append(exame.getCodigoGuia() == null ? null : "'" + exame.getCodigoGuia().trim() + "'");
            String validadeGuia = exame.getValidadeGuia() != null ? this.getDataPadraoSql(exame.getValidadeGuia()) : "null";
            sql.append(" ,exr_validadeguia = ").append(validadeGuia);
        }
        sql.append(" where fil_codigo = ").append(dados.getCodigoFilial());
        sql.append(" and req_codigo = ").append(dados.getRequisicao());
        String codExame = examePai != null ? examePai.getCodigo() : exame.getCodigoExame();
        int codMaterial = examePai != null ? examePai.getMaterial() : exame.getCodigoMaterial().intValue();
        sql.append(" and exa_codigo = '").append(codExame).append("'");
        sql.append(" and mco_codigo = ").append(codMaterial);
        this.executarSQL(String.valueOf(dados.getCodigoFilial()), sql.toString());
    }

    public void atualizarGuiaExameRequisicaoGuiaAgrupada(DadosFaturamento dados, DadosExameFaturamento exame, DadosExamePaiAgrupamento examePai) throws SQLException {
        StringBuilder sql = new StringBuilder(" update examerequisicaoguiaagrupada ");
        sql.append(" set exg_guia = ").append(exame.getCodigoGuia() == null ? null : "'" + exame.getCodigoGuia() + "' ");
        sql.append(" ,exg_validadeguia = ").append(exame.getValidadeGuia() == null ? null : "'" + exame.getValidadeGuia() + "' ");
        sql.append(" ,exg_dataguia = ").append(exame.getDataGuia() == null ? null : "'" + exame.getDataGuia() + "' ");
        sql.append(" ,exg_deveguia = ").append(exame.getDeveGuia());
        sql.append(" where fil_codigo = ").append(dados.getCodigoFilial());
        sql.append(" and exa_codigo = '").append(examePai.getCodigo()).append("' ");
        sql.append(" and mco_codigo = ").append(examePai.getMaterial());
        sql.append(" and exa_codfilho = '").append(exame.getCodigoExame()).append("' ");
        sql.append(" and mco_codfilho = ").append(exame.getCodigoMaterial());
        sql.append(" and req_codigo = ").append(dados.getRequisicao());
        this.executarSQL(String.valueOf(dados.getCodigoFilial()), sql.toString());
    }

    private void executarSQL(String codFilial, String sql) throws SQLException {
        Statement st = Conexao.getStatement();
        Conexao.executeUpdate(codFilial, st, sql);
        Conexao.arquivaSQL();
        Conexao.fecharStatement(st);
    }

    private String getDataPadraoSql(Date data) {
        return "'".concat(Funcoes.formataData("yyyy-MM-dd", data)).concat("'");
    }

    private FaturaBean converterResultSetParaFaturabean(ResultSet rs) throws SQLException {
        FaturaBean fatura = new FaturaBean();
        fatura.setCodigo(rs.getInt("fat_codigo"));
        ConvenioVO convenio = new ConvenioVO();
        convenio.setCodigo(rs.getInt("con_codigo"));
        fatura.setConvenio(convenio);
        fatura.setDataArquivo(rs.getTimestamp("fat_dataarquivo"));
        fatura.setDataCancelamento(rs.getTimestamp("fat_datacancelamento"));
        fatura.setDataComissao(rs.getTimestamp("fat_datacomissao"));
        fatura.setDataConferencia(rs.getTimestamp("fat_dtconferencia"));
        fatura.setDataEmissao(rs.getTimestamp("fat_dtemis"));
        fatura.setDataFim(rs.getTimestamp("fat_dtfim"));
        fatura.setDataHora(rs.getTimestamp("fat_datahora"));
        fatura.setDataInicio(rs.getTimestamp("fat_dtinicio"));
        FilialVO filial = new FilialVO();
        filial.setCodigo(rs.getInt("fil_codigo"));
        fatura.setFilial(filial);
        fatura.setMensagem(rs.getString("fat_mensagem"));
        fatura.setNota(rs.getInt("fat_nota"));
        fatura.setPercentualAcrescimo(rs.getDouble("fat_percacrescimo"));
        fatura.setPercentualDesconto(rs.getDouble("fat_percdesconto"));
        fatura.setQuantidadeExames(rs.getInt("fat_qtdeexames"));
        fatura.setQuantidadeRequisicoes(rs.getInt("fat_qtderequisicao"));
        UsuarioVO usuario = new UsuarioVO();
        usuario.setCodigo(rs.getString("usr_codigo"));
        fatura.setUsuario(null);
        UsuarioVO usuarioCancelamento = new UsuarioVO();
        usuarioCancelamento.setCodigo(rs.getString("usr_codcancelamento"));
        fatura.setUsuarioCancelamento(usuarioCancelamento);
        UsuarioVO usuarioConferencia = new UsuarioVO();
        usuarioConferencia.setCodigo(rs.getString("usr_codconferencia"));
        fatura.setUsuarioConferencia(usuarioConferencia);
        fatura.setValorAdicional(rs.getDouble("fat_adicional"));
        fatura.setValorDespCobranca(rs.getDouble("fat_despcobranca"));
        fatura.setValorTotalExames(rs.getDouble("fat_totalexames"));
        fatura.setValorTotalExamesCH(rs.getDouble("fat_totalexamesch"));
        fatura.setValorTotalMateriais(rs.getDouble("fat_totalmateriais"));
        fatura.setVencimento(rs.getTimestamp("fat_dtvenc"));
        return fatura;
    }

    public void apagarExameDafatura(Statement st, DadosFaturamento dados, DadosExameFaturamento exame, String codigoFatura) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append(" delete from faturaexamerequisicao where fil_codigo = ").append(Variaveis.filialPadrao);
        buf.append("\tand fil_kodigo = ").append(dados.getCodigoFilial());
        buf.append("\tand fat_codigo = ").append(codigoFatura);
        buf.append("\tand req_codigo = ").append(dados.getRequisicao());
        if (exame.getExamePai() == null) {
            buf.append("\tand exa_codigo = '").append(exame.getCodigoExame()).append("' ");
            buf.append("\tand mco_codigo = ").append(exame.getCodigoMaterial());
        } else {
            buf.append("\tand exa_codigo = '").append(exame.getExamePai().getCodigo()).append("' ");
            buf.append("\tand mco_codigo = ").append(exame.getExamePai().getMaterial());
        }
        buf.append("\tand exa_codfilho = '").append(exame.getCodigoExame()).append("' ");
        buf.append("\tand mco_codfilho = ").append(exame.getCodigoMaterial());
        Conexao.executeUpdate(Variaveis.filialPadrao, st, buf.toString());
    }

    public void atualizarFaturaExameRequisicao(int ordem, Statement st, DadosExameFaturamento exame, DadosFaturamento dados, String codigoFatura) throws SQLException {
        DadosExamePaiAgrupamento examePai = exame.getExamePai();
        StringBuilder buf = new StringBuilder();
        buf.append("update faturaexamerequisicao set ");
        buf.append("  fer_total =  ").append(Funcoes.limpaDecimal(String.valueOf(exame.getValorExame())));
        buf.append(" ,fer_totalch =  ").append(Funcoes.limpaDecimal(String.valueOf(exame.getValorCHExame())));
        buf.append(" ,fer_totalmateriais = ").append(Funcoes.limpaDecimal(String.valueOf(exame.getValorMaterial())));
        buf.append(" ,fer_valorch = ").append(Funcoes.limpaDecimal(String.valueOf(exame.getValorCH())));
        buf.append(" ,fer_vlrbalcaoconvenio = ").append(Funcoes.limpaDecimal(String.valueOf(exame.getValorBalcao())));
        buf.append(" ,fer_ordem = ").append(ordem);
        if (dados.isTabelaTipoCBHPM()) {
            buf.append(" ,fer_custocbhpm = ").append(Funcoes.limpaDecimal(String.valueOf(exame.getCustoCBHPM())));
            buf.append(" ,fer_ucocbhpm = ").append(Funcoes.limpaDecimal(String.valueOf(exame.getUcoCBHPM())));
            buf.append(" ,fer_portecbhpm = '").append(exame.getPorteCBHPM()).append("'");
            buf.append(" ,fer_valorportecbhpm = ").append(Funcoes.limpaDecimal(String.valueOf(exame.getValorPorteCBHPM())));
        }
        buf.append(" ,fer_notaipergs = ").append(exame.getNotaIPERGS() != null ? exame.getNotaIPERGS() : "null");
        buf.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
        buf.append(" \tand fil_kodigo = ").append(String.valueOf(dados.getCodigoFilial()));
        buf.append(" \tand fat_codigo = ").append(codigoFatura);
        buf.append(" \tand req_codigo = ").append(dados.getRequisicao());
        buf.append(" \tand exa_codfilho = '").append(exame.getCodigoExame()).append("' ");
        buf.append(" \tand mco_codfilho = ").append(exame.getCodigoMaterial());
        if (examePai != null) {
            buf.append(" and exa_codigo = '").append(examePai.getCodigo()).append("' ");
            buf.append(" and mco_codigo = ").append(String.valueOf(examePai.getMaterial()));
        } else {
            buf.append(" and exa_codigo = '").append(exame.getCodigoExame()).append("' ");
            buf.append(" and mco_codigo = ").append(String.valueOf(exame.getCodigoMaterial()));
        }
        Conexao.executeUpdate(Variaveis.filialPadrao, st, buf.toString());
    }

    public void atualizarExameRequisicao(Statement st, DadosFaturamento dados, DadosExameFaturamento exame) throws SQLException {
        DadosExamePaiAgrupamento examePai = exame.getExamePai();
        StringBuilder buf = new StringBuilder();
        buf.append("update examerequisicao set ");
        if (FuncoesGerais.convenioRepasseFaturado(st, dados)) {
            buf.append("  exr_datafaturarepasse = current_timestamp ");
            buf.append(" ,usr_codfaturarepasse = '").append(Variaveis.login).append("' ");
        } else {
            buf.append(" exr_datafatura = current_timestamp ");
            buf.append(" ,exr_vlrch = ").append(Funcoes.limpaDecimal(String.valueOf(exame.getValorCH())));
            buf.append(" ,exr_vlrchexame = ").append(Funcoes.limpaDecimal(String.valueOf(exame.getValorCHExame())));
            buf.append(" ,usr_codfatura = '").append(Variaveis.login).append("' ");
            buf.append(" ,exr_deveguia = ").append(exame.getDeveGuia());
            buf.append(" ,exr_guia = ").append(exame.getCodigoGuia() == null ? null : "'" + exame.getCodigoGuia().trim() + "'");
            if (exame.getValidadeGuia() != null) {
                buf.append(" ,exr_validadeguia = '").append(exame.getValidadeGuia()).append("' ");
            } else {
                buf.append(" ,exr_validadeguia = null ");
            }
            if (dados.isTabelaTipoCBHPM()) {
                buf.append("   ,exr_valorcusto = ").append(Funcoes.limpaDecimal(String.valueOf(exame.getCustoCBHPM())));
                buf.append("   ,exr_valoruco = ").append(Funcoes.limpaDecimal(String.valueOf(exame.getUcoCBHPM())));
                buf.append("   ,exr_valorporte = ").append(Funcoes.limpaDecimal(String.valueOf(exame.getValorPorteCBHPM())));
                buf.append("   ,exr_porte = '").append(StringUtil.textoDB(exame.getPorteCBHPM())).append("' ");
            }
        }
        buf.append(" where fil_codigo = ");
        buf.append(dados.getCodigoFilial());
        buf.append(" and req_codigo = ");
        buf.append(dados.getRequisicao());
        if (examePai != null) {
            buf.append("and exa_codigo = '");
            buf.append(examePai.getCodigo());
            buf.append("' and mco_codigo = ");
            buf.append(String.valueOf(examePai.getMaterial()));
        } else {
            buf.append(" and exa_codigo = '");
            buf.append(exame.getCodigoExame());
            buf.append("' and mco_codigo = ");
            buf.append(String.valueOf(exame.getCodigoMaterial()));
        }
        Conexao.executeUpdate(String.valueOf(dados.getCodigoFilial()), st, buf.toString());
    }

    public void atualizarExameRequisicaoGuiaAgrupada(DadosExameFaturamento exame, DadosFaturamento dados, Statement st) throws SQLException {
        DadosExamePaiAgrupamento examePai = exame.getExamePai();
        StringBuilder buf = new StringBuilder();
        buf.append(" update examerequisicaoguiaagrupada ");
        buf.append("    set exg_guia = ").append(exame.getCodigoGuia() == null ? null : "'" + exame.getCodigoGuia() + "' ");
        buf.append("       ,exg_validadeguia = ").append(exame.getValidadeGuia() == null ? null : "'" + exame.getValidadeGuia() + "' ");
        buf.append("       ,exg_dataguia = ").append(exame.getDataGuia() == null ? null : "'" + exame.getDataGuia() + "' ");
        buf.append("       ,exg_deveguia = ").append(exame.getDeveGuia());
        buf.append("  where fil_codigo = ").append(dados.getCodigoFilial());
        buf.append("    and exa_codigo = '").append(examePai.getCodigo()).append("' ");
        buf.append("    and mco_codigo = ").append(examePai.getMaterial());
        buf.append("    and exa_codfilho = '").append(exame.getCodigoExame()).append("' ");
        buf.append("    and mco_codfilho = ").append(exame.getCodigoMaterial());
        buf.append("    and req_codigo = ").append(dados.getRequisicao());
        Conexao.executeUpdate(String.valueOf(dados.getCodigoFilial()), st, buf.toString());
    }

    public void atualizarExameRequisicaoExamePaiAgrupamento(DadosFaturamento dados, ArrayList<ValorExamePai> listaValores, Statement st) throws SQLException {
        if (!listaValores.isEmpty()) {
            for (int j = 0; j < listaValores.size(); ++j) {
                ValorExamePai exame = listaValores.get(j);
                StringBuilder buf = new StringBuilder();
                buf.delete(0, buf.length());
                buf.append(" update examerequisicao ");
                buf.append("    set ");
                if (dados.getCodigoConvenio() != dados.getCodigoConvenioPrincipal()) {
                    buf.append("  exr_valorchrepasse = ").append(Funcoes.limpaDecimal(String.valueOf(exame.getValorCH().setScale(2, RoundingMode.HALF_UP).doubleValue())));
                    buf.append(" ,exr_valorchexamerepasse = ").append(Funcoes.limpaDecimal(String.valueOf(exame.getValorCHExame().setScale(2, RoundingMode.HALF_UP).doubleValue())));
                    buf.append(" ,exr_datafaturarepasse = current_timestamp ");
                    buf.append(" ,usr_codfaturarepasse = '").append(Variaveis.login).append("' ");
                } else {
                    buf.append("  exr_vlrch = ").append(Funcoes.limpaDecimal(String.valueOf(exame.getValorCH().setScale(2, RoundingMode.HALF_UP).doubleValue())));
                    buf.append(" ,exr_vlrchexame = ").append(Funcoes.limpaDecimal(String.valueOf(exame.getValorCHExame().setScale(2, RoundingMode.HALF_UP).doubleValue())));
                    buf.append(" ,exr_datafatura = current_timestamp ");
                    buf.append(" ,usr_codfatura = '").append(Variaveis.login).append("' ");
                }
                buf.append(" where fil_codigo = ").append(dados.getCodigoFilial());
                buf.append("   and req_codigo = ").append(dados.getRequisicao());
                buf.append("   and exa_codigo = '").append(exame.getCodigoExame()).append("' ");
                buf.append("   and mco_codigo = ").append(exame.getCodigoMaterial());
                Conexao.execute(String.valueOf(dados.getCodigoFilial()), st, buf.toString());
            }
        }
    }

    public TabelaPrecoExameBean pesquisarTabelaPrecoExame(int codFilial, int codTabelaPreco) throws SQLException {
        StringBuilder sql = new StringBuilder(" select * from tabelaprecoexames ");
        sql.append(" where fil_codigo = ").append(codFilial);
        sql.append(" and tpe_codigo = ").append(codTabelaPreco);
        Statement st = Conexao.getStatement();
        ResultSet rs = Conexao.executeQuery(st, sql.toString());
        TabelaPrecoExameBean tabelaPreco = new TabelaPrecoExameBean();
        if (rs.next()) {
            tabelaPreco.setCodigo(rs.getInt("tpe_codigo"));
            tabelaPreco.setDescricao(rs.getString("tpe_descricao"));
            FilialVO filial = new FilialVO();
            filial.setCodigo(rs.getInt("fil_codigo"));
            tabelaPreco.setFilial(filial);
            tabelaPreco.setMoeda(rs.getString("tpe_moeda"));
            tabelaPreco.setTabelaAns(rs.getString("tpe_tabelaans"));
            tabelaPreco.setTipoCbhpm(rs.getBoolean("tpe_tipocbhpm"));
            tabelaPreco.setUco(rs.getDouble("tpe_uco"));
            tabelaPreco.setValorCh(rs.getDouble("tpe_valorch"));
        }
        rs.close();
        Conexao.fecharStatement(st);
        return tabelaPreco;
    }

    public DetalheTabelaPrecoBean pesquisarDetalheTabelaPreco(TabelaPrecoExameBean tabelaPreco, String codExame, int codMaterial) throws SQLException {
        StringBuilder sql = new StringBuilder(" select * from detalhetabelapreco ");
        sql.append(" where fil_codigo = ").append(tabelaPreco.getFilial().getCodigo());
        sql.append(" and tpe_codigo = ").append(tabelaPreco.getCodigo());
        sql.append(" and exa_codigo = '").append(codExame).append("'");
        sql.append(" and mco_codigo = ").append(codMaterial);
        Statement st = Conexao.getStatement();
        ResultSet rs = Conexao.executeQuery(st, sql.toString());
        DetalheTabelaPrecoBean detalheTabelaPreco = new DetalheTabelaPrecoBean();
        if (rs.next()) {
            FilialVO filial = new FilialVO();
            filial.setCodigo(rs.getInt("fil_codigo"));
            ExameVO exame = new ExameVO();
            exame.setFilial(filial);
            exame.setCodigo(rs.getString("exa_codigo"));
            MaterialColetaVO materialColeta = new MaterialColetaVO();
            materialColeta.setFilial(filial);
            materialColeta.setCodigo(rs.getInt("mco_codigo"));
            detalheTabelaPreco.setCodigoAmb(rs.getString("dtp_codamb"));
            detalheTabelaPreco.setExame(exame);
            detalheTabelaPreco.setFilial(filial);
            detalheTabelaPreco.setMatColeta(materialColeta);
            detalheTabelaPreco.setPercentual(rs.getDouble("dtp_percentual"));
            TabelaPrecoPorteVO tabelaPrecoPorte = new TabelaPrecoPorteVO();
            if (!Funcoes.textoVazio(rs.getString("tpp_porte"))) {
                tabelaPrecoPorte = this.pesquisarTabelaPrecoPorteBean(tabelaPreco.getFilial().getCodigo(), tabelaPreco.getCodigo(), rs.getString("tpp_porte"));
                detalheTabelaPreco.setPorte(tabelaPrecoPorte);
            }
            detalheTabelaPreco.setProibido(rs.getBoolean("dtp_proibido"));
            detalheTabelaPreco.setValorCh(rs.getDouble("dtp_valor"));
        }
        rs.close();
        Conexao.fecharStatement(st);
        return detalheTabelaPreco;
    }

    public DetalheTabelaPrecoMetodologiaBean pesquisarDetalheTabelaPrecoMetodologia(TabelaPrecoExameBean tabelaPreco, String codExame, Integer codMaterial, String codMetodologia) throws SQLException {
        StringBuilder sql = new StringBuilder(" select * from detalhetabelapreco ");
        sql.append(" where fil_codigo = ").append(tabelaPreco.getFilial().getCodigo());
        sql.append(" and tpe_codigo = ").append(tabelaPreco.getCodigo());
        sql.append(" and exa_codigo = '").append(codExame).append("'");
        sql.append(" and mco_codigo = ").append(codMaterial);
        sql.append(" and met_codigo = ").append(codMetodologia);
        Statement st = Conexao.getStatement();
        ResultSet rs = Conexao.executeQuery(st, sql.toString());
        DetalheTabelaPrecoMetodologiaBean detalheTabelaPrecoMetodologia = new DetalheTabelaPrecoMetodologiaBean();
        if (rs.next()) {
            FilialVO filial = new FilialVO();
            filial.setCodigo(rs.getInt("fil_codigo"));
            ExameVO exame = new ExameVO();
            exame.setFilial(filial);
            exame.setCodigo(rs.getString("exa_codigo"));
            MaterialColetaVO materialColeta = new MaterialColetaVO();
            materialColeta.setFilial(filial);
            materialColeta.setCodigo(rs.getInt("mco_codigo"));
            MetodologiaVO metodologia = new MetodologiaVO();
            metodologia.setCodigo(rs.getInt("met_codigo"));
            metodologia.setFilial(filial);
            detalheTabelaPrecoMetodologia.setCodigoAmb(rs.getString("dtp_codamb"));
            detalheTabelaPrecoMetodologia.setExame(exame);
            detalheTabelaPrecoMetodologia.setFilial(filial);
            detalheTabelaPrecoMetodologia.setMatColeta(materialColeta);
            detalheTabelaPrecoMetodologia.setMetodologia(metodologia);
            detalheTabelaPrecoMetodologia.setPercentual(rs.getDouble("dtm_percentual"));
            TabelaPrecoPorteVO tabelaPrecoPorte = new TabelaPrecoPorteVO();
            if (!Funcoes.textoVazio(rs.getString("tpp_porte"))) {
                tabelaPrecoPorte = this.pesquisarTabelaPrecoPorteBean(tabelaPreco.getFilial().getCodigo(), tabelaPreco.getCodigo(), rs.getString("tpp_porte"));
                detalheTabelaPrecoMetodologia.setPorte(tabelaPrecoPorte);
            }
            detalheTabelaPrecoMetodologia.setProibido(rs.getBoolean("dtm_proibido"));
            detalheTabelaPrecoMetodologia.setValorCh(rs.getDouble("dtm_valor"));
        }
        rs.close();
        Conexao.fecharStatement(st);
        return detalheTabelaPrecoMetodologia;
    }

    public TabelaPrecoPorteVO pesquisarTabelaPrecoPorteBean(int codFilial, int codTabelaPreco, String codPorte) throws SQLException {
        StringBuilder sql = new StringBuilder(" select * from tabelaprecoexamesporte ");
        sql.append(" where fil_codigo = ").append(codFilial);
        sql.append(" and tpe_codigo = ").append(codTabelaPreco);
        sql.append(" and tpp_porte = '").append(codPorte).append("'");
        Statement st = Conexao.getStatement();
        ResultSet rs = Conexao.executeQuery(st, sql.toString());
        TabelaPrecoPorteVO tabelaPrecoPorte = new TabelaPrecoPorteVO();
        if (rs.next()) {
            FilialVO filial = new FilialVO();
            filial.setCodigo(rs.getInt("fil_codigo"));
            TabelaPrecoExameVO tabelaPreco = new TabelaPrecoExameVO();
            tabelaPreco.setCodigo(rs.getInt("tpe_codigo"));
            tabelaPreco.setFilial(filial);
            tabelaPrecoPorte.setCodigo(rs.getString("tpp_porte"));
            tabelaPrecoPorte.setFilial(filial);
            tabelaPrecoPorte.setTabelaPreco(tabelaPreco);
            tabelaPrecoPorte.setValor(rs.getDouble("tpp_valor"));
        }
        rs.close();
        Conexao.fecharStatement(st);
        return tabelaPrecoPorte;
    }
}

