/*
 * Decompiled with CFR 0.152.
 */
package jalis.model.dao.financeiro;

import jalis.comum.Conexao;
import jalis.model.vo.financeiro.TransferenciaCaixaVO;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class TransferenciaCaixaDao {
    public ArrayList pesquisaLancamento(String filial, String tipoLancamento, String contaOrigem, boolean intervaloHora, String dataInicial, String dataFinal, String horaInicial, String horaFinal, String[] filtroUsuario) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append(" select lcx.lcx_datahora as  datahora ");
        buf.append("       ,lcx.usr_codigo as usuario ");
        buf.append("       ,lcx.lcx_valortotal as valortotal ");
        buf.append("       ,COALESCE(req.req_codigo, bxa.bxa_codigo) as codigoorigem ");
        buf.append("       ,lcx.lcx_banco as bancocheque ");
        buf.append("       ,lcx.lcx_agencia as agenciacheque ");
        buf.append("       ,lcx.lcx_conta as contacheque ");
        buf.append("       ,lcx.lcx_nrcheque as numerocheque ");
        buf.append("       ,lcx.lcx_vencimento as vencimentocheque ");
        buf.append("       ,lcx.lcx_cartaocredito as bandeiracartao ");
        buf.append("       ,lcx.lcx_nrcartao as numerocartao ");
        buf.append("       ,lcx.lcx_validadecartao as validadecartao ");
        buf.append("       ,lcx.lcx_documento as numeropromissoria ");
        buf.append("       ,lcx.lcx_codigo as codigoLancamento ");
        buf.append("       ,lcx.est_codigo as codigoEstacao ");
        buf.append("       ,lcx.lcx_tipopagamento as tipoPagamento ");
        buf.append("   from lanctocaixa lcx ");
        buf.append("   left join requisicaolanctocaixa rlc on lcx.fil_codigo = rlc.fil_codigo and lcx.lcx_codigo = rlc.lcx_codigo and lcx.est_codigo = rlc.est_codigo ");
        buf.append("   left join requisicao req on rlc.fil_codigo = req.fil_codigo and rlc.req_codigo = req.req_codigo and not req.req_excluida ");
        buf.append("   left join baixalanctocaixa blc on lcx.fil_codigo = blc.fil_codigo and lcx.lcx_codigo = blc.lcx_codigo and lcx.est_codigo = blc.est_codigo ");
        buf.append("   left join baixa bxa on blc.fil_codigo = bxa.fil_codigo and blc.bxa_codigo = bxa.bxa_codigo and bxa.bxa_datacancelado IS NULL ");
        buf.append("  where lcx.fil_codigo = ").append(filial);
        buf.append("    and lcx.lcx_tipo = '").append(tipoLancamento).append("' ");
        buf.append("    and lcx.lcx_datacancelado IS NULL ");
        buf.append("    and cco_reduzido = ").append(contaOrigem);
        if (intervaloHora) {
            if (Funcoes.verificaData(dataInicial) && Funcoes.verificaHora(horaInicial)) {
                buf.append(" and date_trunc('minute', lcx.lcx_datahora) >= '");
                buf.append(Funcoes.formataData("yyyy-MM-dd", dataInicial)).append(" ").append(horaInicial);
                buf.append("'");
            }
            if (Funcoes.verificaData(dataFinal) && Funcoes.verificaHora(horaFinal)) {
                buf.append(" and date_trunc('minute', lcx.lcx_datahora) <= '");
                buf.append(Funcoes.formataData("yyyy-MM-dd", dataFinal)).append(" ").append(horaFinal);
                buf.append("'");
            }
        } else {
            if (Funcoes.verificaData(dataInicial)) {
                buf.append(" and cast(lcx.lcx_datahora as date) >= '");
                buf.append(Funcoes.formataData("MM/dd/yyyy", dataInicial));
                buf.append("'");
            }
            if (Funcoes.verificaData(dataFinal)) {
                buf.append(" and cast(lcx.lcx_datahora as date) <= '");
                buf.append(Funcoes.formataData("MM/dd/yyyy", dataFinal));
                buf.append("'");
            }
            if (Funcoes.verificaHora(horaInicial)) {
                buf.append(" and cast(lcx.lcx_datahora as time) >= '");
                buf.append(horaInicial);
                buf.append("'");
            }
            if (Funcoes.verificaHora(horaFinal)) {
                buf.append(" and cast(lcx.lcx_datahora as time) <= '");
                buf.append(horaFinal);
                buf.append("'");
            }
        }
        if (!Funcoes.objectIsNull(filtroUsuario) && filtroUsuario.length > 0) {
            buf.append("    and lcx.usr_codigo in (");
            for (int i = 0; i < filtroUsuario.length; ++i) {
                if (i > 0) {
                    buf.append(",");
                }
                buf.append(StringUtil.textoDBEscape(filtroUsuario[i]));
            }
            buf.append(")");
        }
        buf.append("  order by lcx.lcx_codigo ");
        ArrayList<TransferenciaCaixaVO> lista = new ArrayList<TransferenciaCaixaVO>();
        Statement st = Conexao.getStatement();
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        while (rs.next()) {
            TransferenciaCaixaVO tranferenciaCaixaVO = new TransferenciaCaixaVO();
            tranferenciaCaixaVO.setDataHora(rs.getTimestamp("datahora"));
            tranferenciaCaixaVO.setUsuario(rs.getString("usuario"));
            tranferenciaCaixaVO.setValorTotal(rs.getDouble("valortotal"));
            tranferenciaCaixaVO.setCodigoOrigem(rs.getInt("codigoorigem"));
            tranferenciaCaixaVO.setBancoCheque(rs.getInt("bancocheque"));
            tranferenciaCaixaVO.setAgenciaCheque(rs.getString("agenciacheque"));
            tranferenciaCaixaVO.setContaCheque(rs.getString("contacheque"));
            tranferenciaCaixaVO.setNumeroCheque(rs.getString("numerocheque"));
            tranferenciaCaixaVO.setVencimentoCheque(rs.getDate("vencimentocheque"));
            tranferenciaCaixaVO.setBandeiraCartao(rs.getString("bandeiracartao"));
            tranferenciaCaixaVO.setNumeroCartao(rs.getString("numerocartao"));
            tranferenciaCaixaVO.setValidadeCartao(rs.getDate("validadeCartao"));
            tranferenciaCaixaVO.setNumeroPromissoria(rs.getString("numeropromissoria"));
            tranferenciaCaixaVO.setCodigoLancamento(rs.getInt("codigolancamento"));
            tranferenciaCaixaVO.setCodigoEstacao(rs.getInt("codigoestacao"));
            tranferenciaCaixaVO.setTipoPAgamento(rs.getString("tipopagamento"));
            lista.add(tranferenciaCaixaVO);
        }
        return lista;
    }
}

