/*
 * Decompiled with CFR 0.152.
 */
package jalis.model.dao.financeiro;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.model.AbstractThreadBean;
import jalis.model.AbstractThreadDao;
import jalis.model.bean.financeiro.ReceberPagarBean;
import jalis.model.bean.financeiro.ReceberPagarCentroCustoBean;
import jalis.model.bean.financeiro.ReceberPagarPlanoContaBean;
import jalis.model.dao.financeiro.NotaFiscalDao;
import jalis.model.dao.financeiro.ReceberPagarCentroCustoDao;
import jalis.model.dao.financeiro.ReceberPagarPlanoContaDao;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.financeiro.NotaFiscalVO;
import jalis.model.vo.financeiro.ReceberPagarVO;
import jalis.util.Funcoes;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Set;

public class ReceberPagarDao
extends AbstractThreadDao {
    public Set<ReceberPagarBean> getBeans(String where) throws ThreadDaoException {
        Set recpags = ReceberPagarDao.load(ReceberPagarBean.class, where);
        if (recpags == null || recpags.size() == 0) {
            return null;
        }
        for (ReceberPagarBean aux : recpags) {
            this.loadPlanosContas(aux);
            this.loadCentrosCusto(aux);
            this.loadNotaFiscal(aux);
        }
        return recpags;
    }

    public AbstractThreadBean getBean(String filial, String codigo) throws ThreadDaoException {
        String where = " where fil_codigo = " + filial + " and rpg_codigo = " + codigo;
        Set recpags = ReceberPagarDao.load(ReceberPagarBean.class, where);
        if (recpags == null || recpags.size() == 0 || recpags.size() > 1) {
            return null;
        }
        ReceberPagarBean recpag = (ReceberPagarBean)recpags.toArray()[0];
        this.loadPlanosContas(recpag);
        this.loadCentrosCusto(recpag);
        this.loadNotaFiscal(recpag);
        return recpag;
    }

    public AbstractThreadBean getBean(String filial, String codigo, String paramWhere) throws ThreadDaoException {
        String where = " where fil_codigo = " + filial + " and rpg_codigo = " + codigo + paramWhere;
        Set recpags = ReceberPagarDao.load(ReceberPagarBean.class, where);
        if (recpags == null || recpags.size() == 0 || recpags.size() > 1) {
            return null;
        }
        ReceberPagarBean recpag = (ReceberPagarBean)recpags.toArray()[0];
        this.loadPlanosContas(recpag);
        this.loadCentrosCusto(recpag);
        this.loadNotaFiscal(recpag);
        return recpag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadNotaFiscal(ReceberPagarBean recpag) throws ThreadDaoException {
        NotaFiscalDao dao = new NotaFiscalDao();
        Statement st = null;
        StringBuilder sql = new StringBuilder();
        sql.append(" select nfi_codigo ");
        sql.append("   from receberpagar ");
        sql.append(" where fil_codigo = ").append(recpag.getFilial().getCodigo());
        sql.append("   and rpg_codigo = ").append(recpag.getCodigo());
        try {
            NotaFiscalVO aux;
            st = Conexao.getStatement();
            ResultSet rs = st.executeQuery(sql.toString());
            String codigoNota = null;
            if (rs.next() && !Funcoes.textoVazio(codigoNota = rs.getString("nfi_codigo")) && (aux = (NotaFiscalVO)dao.getVOCodigo(String.valueOf(recpag.getFilial().getCodigo()), codigoNota)) != null) {
                recpag.setNotaFiscal(aux);
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    @Override
    public AbstractThreadBean getBean(String codigo) throws ThreadDaoException {
        return this.getBean(Variaveis.filialPadrao, codigo);
    }

    @Override
    public AbstractThreadVO getVO(String filial, String codigo) throws ThreadDaoException {
        String where = " where fil_codigo = " + filial + " and rpg_codigo = " + codigo;
        Set recpags = this.loadVO(ReceberPagarVO.class, where);
        if (recpags == null || recpags.size() == 0 || recpags.size() > 1) {
            return null;
        }
        return (AbstractThreadVO)recpags.toArray()[0];
    }

    @Override
    public AbstractThreadVO getVO(String codigo) throws ThreadDaoException {
        return this.getVO(Variaveis.filialPadrao, codigo);
    }

    private void loadPlanosContas(ReceberPagarBean recpag) throws ThreadDaoException {
        ReceberPagarPlanoContaDao dao = new ReceberPagarPlanoContaDao();
        StringBuilder where = new StringBuilder();
        where.append(" where fil_codigo = ").append(recpag.getFilial().getCodigo());
        where.append("   and rpg_codigo = ").append(recpag.getCodigo());
        where.append(" order by fil_codigo, rpg_codigo, plc_reduzido ");
        recpag.setPlanosContas(ReceberPagarPlanoContaDao.load(ReceberPagarPlanoContaBean.class, where.toString()));
    }

    private void loadCentrosCusto(ReceberPagarBean recpag) throws ThreadDaoException {
        ReceberPagarCentroCustoDao dao = new ReceberPagarCentroCustoDao();
        StringBuilder where = new StringBuilder();
        where.append(" where fil_codigo = ").append(recpag.getFilial().getCodigo());
        where.append("   and rpg_codigo = ").append(recpag.getCodigo());
        where.append(" order by fil_codigo, rpg_codigo, ccu_reduzido ");
        recpag.setCentrosCusto(ReceberPagarCentroCustoDao.load(ReceberPagarCentroCustoBean.class, where.toString()));
    }

    @Override
    public AbstractThreadBean voToBean(AbstractThreadVO vo, Class classeBean) throws ThreadDaoException, IllegalArgumentException, IllegalAccessException {
        AbstractThreadBean bean = super.voToBean(vo, classeBean);
        this.loadPlanosContas((ReceberPagarBean)bean);
        this.loadCentrosCusto((ReceberPagarBean)bean);
        return bean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelarReceberPagar(String codigoFilial, String codigoReceberPagar, Date dataCancelamento, String usuarioCancelamento) throws SQLException {
        boolean bl;
        StringBuilder buf = new StringBuilder();
        buf.append(" update receberpagar ");
        buf.append("    set rpg_datacancelado = '").append(Funcoes.formataData("yyyy-MM-dd HH:mm:ss.SSS", dataCancelamento)).append("' ");
        buf.append("       ,usr_codcancelado = '").append(usuarioCancelamento).append("' ");
        buf.append("       ,rpg_situacao = '").append("C").append("' ");
        buf.append("  where fil_codigo = ").append(codigoFilial);
        buf.append("    and rpg_codigo = ").append(codigoReceberPagar);
        Statement st = Conexao.getStatement();
        try {
            int qtde = Conexao.executeUpdate(Variaveis.filialPadrao, st, buf.toString(), true);
            bl = qtde > 0;
        }
        catch (Throwable throwable) {
            Conexao.fecharStatement(st);
            throw throwable;
        }
        Conexao.fecharStatement(st);
        return bl;
    }
}

