/*
 * Decompiled with CFR 0.152.
 */
package jalis.model.dao.financeiro;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.model.AbstractThreadBean;
import jalis.model.AbstractThreadDao;
import jalis.model.ThreadBeanDaoMultiplasChaves;
import jalis.model.bean.estoque.ConferenciaEntradaBean;
import jalis.model.bean.estoque.NotaFiscalMaterialBean;
import jalis.model.bean.financeiro.FaturaNotaFiscalBean;
import jalis.model.bean.financeiro.NotaFiscalBean;
import jalis.model.bean.financeiro.NotaFiscalServicoBean;
import jalis.model.bean.financeiro.ReceberPagarBean;
import jalis.model.dao.estoque.NotaFiscalMaterialDao;
import jalis.model.dao.financeiro.FaturaNotaFiscalDao;
import jalis.model.dao.financeiro.NotaFiscalServicoDao;
import jalis.model.dao.financeiro.ReceberPagarDao;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.financeiro.NotaFiscalVO;
import jalis.service.estoque.ConferenciaEntradaService;
import jalis.service.financeiro.ReceberPagarService;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class NotaFiscalDao
extends AbstractThreadDao
implements ThreadBeanDaoMultiplasChaves {
    public AbstractThreadBean getBean(String filial, String codigo) throws Exception {
        String where = " where fil_codigo = " + Integer.parseInt(filial) + " and nfi_codigo = " + Integer.parseInt(codigo);
        Set notas = NotaFiscalDao.load(NotaFiscalBean.class, where);
        if (notas == null || notas.size() == 0 || notas.size() > 1) {
            return null;
        }
        NotaFiscalBean nota = (NotaFiscalBean)notas.toArray()[0];
        this.loadServicos(nota);
        this.loadParcelas(nota);
        this.loadFaturas(nota);
        this.loadMateriais(nota);
        return nota;
    }

    public Set getSetBeans(String filial, String serie, String numero) throws Exception {
        String where = " where fil_codigo = " + Integer.parseInt(filial) + " and ser_codigo = upper('" + StringUtil.textoDB(serie) + "') and nfi_numero = " + Integer.parseInt(numero);
        Set notas = NotaFiscalDao.load(NotaFiscalBean.class, where);
        if (notas == null || notas.size() == 0) {
            return null;
        }
        for (NotaFiscalBean nota : (HashSet)notas) {
            this.loadServicos(nota);
            this.loadParcelas(nota);
            this.loadFaturas(nota);
        }
        return notas;
    }

    @Override
    @Deprecated
    public AbstractThreadBean getBean(String codigo) throws ThreadDaoException {
        return null;
    }

    public AbstractThreadVO getVO(String filial, String serie, String numero) throws ThreadDaoException {
        String where = " where fil_codigo = " + Integer.parseInt(filial) + " and ser_codigo = upper('" + StringUtil.textoDB(serie) + "') and nfi_numero = " + Integer.parseInt(numero);
        Set notas = this.loadVO(NotaFiscalVO.class, where);
        if (notas == null || notas.size() == 0 || notas.size() > 1) {
            return null;
        }
        return (AbstractThreadVO)notas.toArray()[0];
    }

    public AbstractThreadBean getNotaEntradaFornecedorBean(String filial, String serie, String numero, String codigoFornecedor) throws ThreadDaoException {
        String where = " where fil_codigo = " + Integer.parseInt(filial);
        where = where + " and ser_codigo = upper('" + StringUtil.textoDB(serie) + "') ";
        where = where + " and nfi_numero = " + Integer.parseInt(numero);
        where = where + " and ent_codigo = " + codigoFornecedor;
        Set notas = NotaFiscalDao.load(NotaFiscalBean.class, where = where + " and nfi_tipo = 'E' ");
        if (notas == null || notas.size() == 0 || notas.size() > 1) {
            return null;
        }
        NotaFiscalBean nota = (NotaFiscalBean)notas.toArray()[0];
        this.loadParcelas(nota);
        this.loadMateriais(nota);
        return nota;
    }

    public AbstractThreadVO getVOCodigo(String filial, String codigo) throws ThreadDaoException {
        String where = " where fil_codigo = " + Integer.parseInt(filial) + " and nfi_codigo = " + Integer.parseInt(codigo);
        Set notas = this.loadVO(NotaFiscalVO.class, where);
        if (notas == null || notas.size() == 0 || notas.size() > 1) {
            return null;
        }
        return (AbstractThreadVO)notas.toArray()[0];
    }

    @Override
    public AbstractThreadVO getVO(String codigo) throws ThreadDaoException {
        String where = " where fil_codigo = " + Integer.parseInt(Variaveis.filialPadrao) + " and nfi_codigo = " + Integer.parseInt(codigo);
        Set notas = this.loadVO(NotaFiscalVO.class, where);
        if (notas == null || notas.size() == 0 || notas.size() > 1) {
            return null;
        }
        return (AbstractThreadVO)notas.toArray()[0];
    }

    private void loadFaturas(NotaFiscalBean nota) throws ThreadDaoException {
        FaturaNotaFiscalDao dao = new FaturaNotaFiscalDao();
        String where = " where fil_codigo = " + nota.getFilial().getCodigo() + " and nfi_codigo = " + nota.getCodigo();
        nota.setFaturasNotaFiscal(FaturaNotaFiscalDao.load(FaturaNotaFiscalBean.class, where));
    }

    private void loadParcelas(NotaFiscalBean nota) throws ThreadDaoException {
        ReceberPagarDao dao = new ReceberPagarDao();
        StringBuilder where = new StringBuilder(" where receberpagar.fil_codigo = ").append(nota.getFilial().getCodigo()).append(" and receberpagar.nfi_codigo = ").append(nota.getCodigo());
        where.append(" and receberpagar.rpg_situacao IN ('").append("A").append("', '").append("Q").append("', '");
        where.append("T").append("', '").append("S").append("', '").append("V").append("', '");
        where.append("P").append("') ");
        where.append(" and receberpagar.rpg_origem = '").append("N").append("' ");
        nota.setParcelas(dao.getBeans(where.toString()));
    }

    private void loadServicos(NotaFiscalBean nota) throws Exception {
        NotaFiscalServicoDao dao = new NotaFiscalServicoDao();
        String where = " where fil_codigo = " + nota.getFilial().getCodigo() + " and nfi_codigo = " + nota.getCodigo();
        Set lista = NotaFiscalServicoDao.load(NotaFiscalServicoBean.class, where);
        Iterator it = lista.iterator();
        if (it.hasNext()) {
            nota.setServico((NotaFiscalServicoBean)it.next());
        }
    }

    private void loadMateriais(NotaFiscalBean nota) throws ThreadDaoException {
        NotaFiscalMaterialDao dao = new NotaFiscalMaterialDao();
        StringBuilder buf = new StringBuilder();
        buf.append(" where fil_codigo = ");
        buf.append(nota.getFilial().getCodigo());
        buf.append(" and nfi_codigo = ");
        buf.append(nota.getCodigo());
        buf.append(" order by nfm_ordem asc");
        nota.setMateriais(new ArrayList<AbstractThreadBean>(dao.loadOrdenado(NotaFiscalMaterialBean.class, buf.toString())));
    }

    @Override
    public AbstractThreadBean getBean(Map<String, Object> chaves) throws ThreadDaoException {
        ArrayList<String> wheres = new ArrayList<String>();
        for (String chave : chaves.keySet()) {
            wheres.add(chave + "=" + this.getValorParaBanco(chaves.get(chave)));
        }
        String where = " where " + StringUtil.implode(wheres, " and ");
        Set notas = NotaFiscalDao.load(NotaFiscalBean.class, where);
        if (notas == null || notas.size() == 0 || notas.size() > 1) {
            return null;
        }
        return (NotaFiscalBean)notas.toArray()[0];
    }

    @Override
    public AbstractThreadVO getVO(Map<String, Object> chaves) throws ThreadDaoException {
        ArrayList<String> wheres = new ArrayList<String>();
        for (String chave : chaves.keySet()) {
            wheres.add(chave + "=" + this.getValorParaBanco(chaves.get(chave)));
        }
        String where = " where " + StringUtil.implode(wheres, " and ");
        Set notas = NotaFiscalDao.load(NotaFiscalVO.class, where);
        if (notas == null || notas.size() == 0 || notas.size() > 1) {
            return null;
        }
        return (NotaFiscalVO)notas.toArray()[0];
    }

    public ArrayList<ReceberPagarBean> getReceberPagarNotaFiscal(String filial, String codigo) throws Exception {
        StringBuilder where = new StringBuilder();
        where.append(" WHERE receberpagar.fil_codigo = ").append(filial);
        where.append("   AND receberpagar.nfi_codigo = ").append(codigo);
        where.append("   AND receberpagar.rpg_situacao NOT IN ('");
        where.append("R").append("', '");
        where.append("C").append("', '");
        where.append("E").append("', '");
        where.append("X").append("', '");
        where.append("N").append("') ");
        return new ArrayList<ReceberPagarBean>(new ReceberPagarService().load(where.toString()));
    }

    public ArrayList<ReceberPagarBean> getPagarComissaoNotaFiscal(String filial, String codigo) throws Exception {
        StringBuilder where = new StringBuilder();
        where.append(" WHERE receberpagar.fil_codigo = ").append(filial);
        where.append("   AND receberpagar.nfi_codigo = ").append(codigo);
        where.append("   AND receberpagar.rpg_origem = '").append("C").append("' ");
        where.append("   AND receberpagar.rpg_tipo = '").append("P").append("' ");
        return new ArrayList<ReceberPagarBean>(new ReceberPagarService().load(where.toString()));
    }

    public void removerServicosNota(String filial, String codigoNota) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append(" delete from notafiscalservico ");
        buf.append("  where fil_codigo = ").append(filial);
        buf.append("    and nfi_codigo = ").append(codigoNota);
        Conexao.executeUpdate(filial, Conexao.getStatement(), buf.toString());
    }

    public boolean haNotaFiscalEletronicaGerada(String filial) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append(" select COUNT(1) as qtde ");
        buf.append("   from notafiscal ");
        buf.append("  where fil_codigo = ").append(filial);
        buf.append("    and nfi_numerorps IS NOT NULL ");
        ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
        if (rs.next()) {
            return rs.getInt("qtde") > 0;
        }
        return false;
    }

    public ArrayList<NotaFiscalBean> getNotasFiscaisFornecedor(String filial, String serie, String numero, String codigoFornecedor) throws ThreadDaoException {
        StringBuilder buf = new StringBuilder();
        buf.append(" where fil_codigo = ").append(filial);
        buf.append("   and ser_codigo = '").append(serie).append("' ");
        buf.append("   and nfi_numero = ").append(numero);
        buf.append("   and ent_codigo = ").append(codigoFornecedor);
        Set notas = NotaFiscalDao.load(NotaFiscalBean.class, buf.toString());
        if (notas == null || notas.size() == 0) {
            return null;
        }
        return new ArrayList<NotaFiscalBean>(notas);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<NotaFiscalBean> getNotasFiscaisPendentes(Integer filial, String cpfCnpj) throws ThreadDaoException {
        if (filial == null || Funcoes.textoVazio(cpfCnpj)) {
            return null;
        }
        ArrayList<NotaFiscalBean> lista = new ArrayList<NotaFiscalBean>();
        StringBuilder buf = new StringBuilder();
        buf.append(" select nota.nfi_codigo, nota.fil_codigo ");
        buf.append(" \tfrom notafiscal nota ");
        buf.append(" \tleft join entidade ent ");
        buf.append(" \t    on nota.fil_codigo = ent.fil_codigo ");
        buf.append(" \t   and nota.ent_codigo = ent.ent_codigo ");
        buf.append(" \tleft join paciente pac ");
        buf.append(" \t    on nota.fil_codigo = pac.fil_codigo ");
        buf.append(" \t   and nota.pac_codigo = pac.pac_codigo ");
        buf.append(" \tleft join convenios con ");
        buf.append(" \t    on nota.fil_codigo = con.fil_codigo ");
        buf.append(" \t   and nota.con_codigo = con.con_codigo ");
        buf.append(" \twhere nota.fil_codigo = ").append(filial);
        buf.append("    and nfi_situacao not in ('").append("A").append("','").append("C").append("') ");
        buf.append("    and (nfi_numero is null or nfi_numero < 1)");
        buf.append("    and '").append(StringUtil.limpaString(cpfCnpj, new String[]{"/", ",", ".", "-"})).append("' in (replace(replace(replace(con.con_cnpjcpf,'/', ''),'.', ''),'-', ''), ");
        buf.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\treplace(replace(replace(ent.ent_cpfcnpj,'/', ''),'.', ''),'-', ''),");
        buf.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\treplace(replace(replace(pac.pac_cpf,'/', ''),'.', ''),'-', '')) ");
        Statement st = Conexao.getStatement();
        try {
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                do {
                    NotaFiscalBean bean = (NotaFiscalBean)this.getBean(rs.getString("fil_codigo"), rs.getString("nfi_codigo"));
                    lista.add(bean);
                } while (rs.next());
                rs.close();
            }
        }
        catch (Exception e) {
            ArrayList<NotaFiscalBean> arrayList;
            try {
                arrayList = null;
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
            return arrayList;
        }
        Conexao.fecharStatement(st);
        if (lista == null || lista.isEmpty()) {
            return null;
        }
        return lista;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConferenciaEntradaBean getConferenciaEntradaNotaFiscalEntrada(String filial, String nota) throws Exception {
        Statement st;
        block3: {
            ConferenciaEntradaBean conferenciaEntradaBean;
            StringBuilder buf = new StringBuilder();
            buf.append(" select cen_codigo as codigo ");
            buf.append("   from conferenciaentrada ");
            buf.append("  where fil_codigo = ").append(filial);
            buf.append("    and nfi_codigo = ").append(nota);
            buf.append("    and usr_codcancelamento IS NULL ");
            st = Conexao.getStatement();
            try {
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                if (!rs.next()) break block3;
                conferenciaEntradaBean = (ConferenciaEntradaBean)new ConferenciaEntradaService().get(filial, rs.getString("codigo"));
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
            return conferenciaEntradaBean;
        }
        ConferenciaEntradaBean conferenciaEntradaBean = null;
        Conexao.fecharStatement(st);
        return conferenciaEntradaBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<NotaFiscalBean> getNotasFiscaisRequisicao(String filial, String requisicao) throws Exception {
        ArrayList<NotaFiscalBean> listaNotas = new ArrayList<NotaFiscalBean>();
        Statement st = Conexao.getStatement();
        try {
            StringBuilder buf = new StringBuilder();
            buf.append(" select nfi.fil_codigo as filial ");
            buf.append("       ,nfi.nfi_codigo as codigo ");
            buf.append("   from requisicaolanctocaixa rlc ");
            buf.append("   join lanctocaixa lcx on rlc.fil_codigo = lcx.fil_codigo and rlc.lcx_codigo = lcx.lcx_codigo and rlc.est_codigo = lcx.est_codigo and lcx.lcx_datacancelado IS NULL ");
            buf.append("   join baixalanctocaixa blc on lcx.fil_codigo = blc.fil_codigo and lcx.lcx_codigo = blc.lcx_codigo and lcx.est_codigo = blc.est_codigo ");
            buf.append("   join baixa bxa on blc.fil_codigo = bxa.fil_codigo and blc.bxa_codigo = bxa.bxa_codigo and bxa_situacao = '").append("Q").append("' ");
            buf.append("   join baixareceberpagar brp on bxa.fil_codigo = brp.fil_codigo and bxa.bxa_codigo = brp.bxa_codigo ");
            buf.append("   join receberpagar rpg on brp.fil_codigo = rpg.fil_codigo and brp.rpg_codigo = rpg.rpg_codigo and rpg_situacao = '").append("Q").append("' ");
            buf.append("   join notafiscal nfi on rpg.fil_codigo = nfi.fil_codigo and rpg.nfi_codigo = nfi.nfi_codigo ");
            buf.append("  where rlc.fil_codigo = ").append(filial);
            buf.append("    and rlc.req_codigo = ").append(requisicao);
            buf.append("    and upper(nfi_tipo) = upper('").append("F").append("') ");
            buf.append("    and ( (nfi_numerorps IS NULL and nfi_situacao NOT IN (upper('").append("C").append("'), upper('").append("E").append("'))) ");
            buf.append("    or (nfi.nfi_numerorps IS NOT NULL and nfi.nfi_situacao <> upper('").append("C").append("')) ) ");
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            while (rs.next()) {
                listaNotas.add((NotaFiscalBean)this.getBean(rs.getString("filial"), rs.getString("codigo")));
            }
            buf.setLength(0);
            buf.append(" select nfi.fil_codigo as filial ");
            buf.append("       ,nfi.nfi_codigo as codigo ");
            buf.append("   from faturarequisicao fre ");
            buf.append("   join fatura fat on fre.fil_codigo = fat.fil_codigo and fre.fat_codigo = fat.fat_codigo and fat.fat_datacancelamento IS NULL ");
            buf.append("   join faturanotafiscal fnf on fat.fil_codigo = fnf.fil_codigo and fat.fat_codigo = fnf.fat_codigo ");
            buf.append("   join notafiscal nfi on fnf.fil_codigo = nfi.fil_codigo and fnf.nfi_codigo = nfi.nfi_codigo ");
            buf.append("  where fre.fil_kodigo = ").append(filial);
            buf.append("    and fre.req_codigo = ").append(requisicao);
            buf.append("    and upper(nfi_tipo) = upper('").append("S").append("') ");
            buf.append("    and ( (nfi_numerorps IS NULL and nfi_situacao NOT IN (upper('").append("C").append("'), upper('").append("E").append("'))) ");
            buf.append("    or (nfi.nfi_numerorps IS NOT NULL and nfi.nfi_situacao <> upper('").append("C").append("')) ) ");
            rs = Conexao.executeQuery(st, buf.toString());
            while (rs.next()) {
                listaNotas.add((NotaFiscalBean)this.getBean(rs.getString("filial"), rs.getString("codigo")));
            }
        }
        catch (Throwable throwable) {
            Conexao.fecharStatement(st);
            throw throwable;
        }
        Conexao.fecharStatement(st);
        return listaNotas;
    }

    @Override
    public AbstractThreadVO getVO(String filial, String codigo) throws ThreadDaoException {
        String where = " where fil_codigo = " + filial + " and nfi_codigo = " + codigo;
        Set notas = this.loadVO(NotaFiscalVO.class, where);
        if (notas == null || notas.size() == 0 || notas.size() > 1) {
            return null;
        }
        return (AbstractThreadVO)notas.toArray()[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUltimaNota(Integer codigo, FilialVO filial, Integer matCodigo) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append("select max(nf.nfi_codigo) as codigo from notafiscalmaterial nfm");
        buf.append(" inner join notafiscal nf on (nfm.fil_codigo = nf.fil_codigo and nfm.nfi_codigo = nf.nfi_codigo)");
        buf.append(" where nfm.fil_codigo = ").append(filial.getCodigo());
        buf.append(" and nfm.mat_codigo = ").append(matCodigo);
        buf.append(" and nf.usr_codcancelada is null ");
        Statement st = Conexao.getStatement();
        Integer codigoNota = 0;
        try {
            ResultSet rs = st.executeQuery(buf.toString());
            if (rs.next()) {
                codigoNota = rs.getInt("codigo");
            }
        }
        catch (Throwable throwable) {
            Conexao.fecharStatement(st);
            throw throwable;
        }
        Conexao.fecharStatement(st);
        return codigoNota.equals(codigo);
    }
}

