/*
 * Decompiled with CFR 0.152.
 */
package jalis.model.dao.financeiro;

import jalis.comum.Conexao;
import jalis.model.AbstractThreadBean;
import jalis.model.AbstractThreadDao;
import jalis.model.bean.financeiro.NotaFiscalComposicaoBean;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.financeiro.NotaFiscalVO;
import jalis.service.financeiro.NotaFiscalService;
import jalis.util.Funcoes;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class NotaFiscalComposicaoDao
extends AbstractThreadDao {
    public AbstractThreadBean getBean(String filial, String codigo, boolean adicionarPropriaNota) throws Exception {
        Statement st = Conexao.getStatement();
        ArrayList<NotaFiscalVO> lista = new ArrayList<NotaFiscalVO>();
        if (filial == null || codigo == null || Funcoes.textoVazio(filial) || Funcoes.textoVazio(codigo)) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        buf.append(" select nfc.nfi_kodigo as notafiscalcomposicao ");
        buf.append("   from notafiscalcomposicao nfc ");
        buf.append("   join notafiscal nfi on nfi.fil_codigo = nfc.fil_codigo and nfi.nfi_codigo = nfc.nfi_kodigo ");
        buf.append("        and ((nfi.nfi_numerorps IS NULL and nfi.nfi_situacao IN ('").append("A").append("', '").append("I").append("')) ");
        buf.append("          or (nfi.nfi_numerorps IS NOT NULL and nfi.nfi_situacao = '").append("A").append("') ) ");
        buf.append("  where nfc.fil_codigo = ").append(filial);
        buf.append("    and nfc.nfi_codigo = ").append(codigo);
        buf.append("  order by nfi.nfi_numero ");
        ResultSet rs = st.executeQuery(buf.toString());
        FilialVO filialVO = new FilialVO();
        filialVO.setCodigo(Integer.parseInt(filial));
        NotaFiscalComposicaoBean beanNotaComp = new NotaFiscalComposicaoBean();
        NotaFiscalVO notaVO = (NotaFiscalVO)new NotaFiscalService().getVO(filial, codigo);
        beanNotaComp.setNotaFiscal(notaVO);
        if (adicionarPropriaNota) {
            lista.add(notaVO);
        }
        if (rs.next()) {
            do {
                notaVO = (NotaFiscalVO)new NotaFiscalService().getVO(filial, rs.getString("notafiscalcomposicao"));
                lista.add(notaVO);
            } while (rs.next());
        }
        beanNotaComp.setNotasFiscaisComposicao(lista);
        Conexao.fecharStatement(st);
        if (beanNotaComp.getNotasFiscaisComposicao().size() <= 0) {
            return null;
        }
        return beanNotaComp;
    }

    public void insert(NotaFiscalComposicaoBean bean, String filial) throws SQLException {
        StringBuilder buf = null;
        Statement st = Conexao.getStatement();
        if (bean == null || filial == null || Funcoes.textoVazio(filial)) {
            return;
        }
        if (bean.getFilial() == null || bean.getNotaFiscal() == null || bean.getNotasFiscaisComposicao() == null || bean.getNotasFiscaisComposicao().size() <= 0) {
            return;
        }
        for (NotaFiscalVO notaVO : bean.getNotasFiscaisComposicao()) {
            buf = new StringBuilder();
            buf.append(" insert into notafiscalcomposicao ");
            buf.append(" values(").append(bean.getFilial().getCodigo());
            buf.append("       ,").append(bean.getNotaFiscal().getCodigo());
            buf.append("       ,").append(notaVO.getCodigo());
            buf.append(")");
            st.executeUpdate(buf.toString());
        }
        Conexao.fecharStatement(st);
    }

    @Override
    @Deprecated
    public AbstractThreadBean getBean(String codigo) throws ThreadDaoException {
        return null;
    }

    @Override
    @Deprecated
    public AbstractThreadVO getVO(String codigo) throws ThreadDaoException {
        return null;
    }

    @Override
    public AbstractThreadVO getVO(String filial, String codigo) throws ThreadDaoException {
        return null;
    }
}

