/*
 * Decompiled with CFR 0.152.
 */
package jalis.model.dao.financeiro;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.model.AbstractThreadBean;
import jalis.model.AbstractThreadDao;
import jalis.model.ThreadBeanDaoMultiplasChaves;
import jalis.model.bean.financeiro.LancamentoBean;
import jalis.model.bean.financeiro.LancamentoCentroCustoBean;
import jalis.model.bean.financeiro.LancamentoPlanoContaBean;
import jalis.model.dao.financeiro.LancamentoCentroCustoDao;
import jalis.model.dao.financeiro.LancamentoPlanoContaDao;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.auxiliares.EstacaoVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.financeiro.LancamentoVO;
import jalis.model.vo.financeiro.NotaFiscalVO;
import jalis.service.financeiro.NotaFiscalService;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class LancamentoDao
extends AbstractThreadDao
implements ThreadBeanDaoMultiplasChaves {
    public Set<LancamentoVO> validaCheque(String banco, String agencia, String conta, String numeroCheque) throws SQLException {
        StringBuilder buf = new StringBuilder();
        Statement st = null;
        st = Conexao.getStatement();
        buf.append(" select fil_codigo ");
        buf.append("       ,lcx_codigo ");
        buf.append("       ,est_codigo ");
        buf.append("   from lanctocaixa ");
        buf.append("  where fil_codigo  = ").append(Variaveis.filialPadrao);
        buf.append("    and lcx_banco   = ").append(banco);
        buf.append("    and lcx_agencia = '").append(agencia).append("' ");
        buf.append("    and lcx_conta   = '").append(conta).append("' ");
        buf.append("    and lcx_nrcheque = '").append(numeroCheque).append("' ");
        ResultSet rs = st.executeQuery(buf.toString());
        HashSet<LancamentoVO> setLanctos = new HashSet<LancamentoVO>();
        FilialVO filial = new FilialVO();
        filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
        while (rs.next()) {
            EstacaoVO estacao = new EstacaoVO();
            estacao.setCodigo(rs.getInt("est_codigo"));
            LancamentoVO lancto = new LancamentoVO();
            lancto.setFilial(filial);
            lancto.setCodigo(rs.getInt("lcx_codigo"));
            lancto.setEstacao(estacao);
            setLanctos.add(lancto);
        }
        return setLanctos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getRequisicaoOrigem(LancamentoBean bean) throws SQLException {
        Statement st;
        block2: {
            Integer n;
            st = null;
            st = Conexao.getStatement();
            StringBuilder buf = new StringBuilder();
            buf.append(" select req_codigo as codigoRequisicao ");
            buf.append("   from requisicaolanctocaixa ");
            buf.append("  where fil_codigo = ").append(bean.getFilial().getCodigo());
            buf.append("    and lcx_codigo = ").append(bean.getCodigo());
            buf.append("    and est_codigo = ").append(bean.getEstacao().getCodigo());
            try {
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                if (!rs.next()) break block2;
                n = rs.getInt("codigoRequisicao");
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
            return n;
        }
        Conexao.fecharStatement(st);
        return null;
    }

    public AbstractThreadBean getLancamentoAberto(String filial, String codigoLancamento, String codigoEstacao) throws Exception {
        String where = " where fil_codigo = " + filial + " and lcx_codigo = " + codigoLancamento + " and lcx_situacao = upper('" + "A" + "') ";
        Set lancamentos = LancamentoDao.load(LancamentoBean.class, where);
        if (lancamentos == null || lancamentos.size() == 0 || lancamentos.size() > 1) {
            return null;
        }
        LancamentoBean lancamento = (LancamentoBean)lancamentos.toArray()[0];
        this.loadPlanosContas(lancamento);
        this.loadCentrosCusto(lancamento);
        this.loadNotaFiscal(lancamento);
        return lancamento;
    }

    public AbstractThreadVO getVO(String filial, String codigoLancamento, String codigoEstacao) throws ThreadDaoException {
        String where = " where fil_codigo = " + filial + " and lcx_codigo = " + codigoLancamento + " and est_codigo = " + codigoEstacao;
        Set lancamentos = this.loadVO(LancamentoVO.class, where);
        if (lancamentos == null || lancamentos.size() == 0 || lancamentos.size() > 1) {
            return null;
        }
        return (AbstractThreadVO)lancamentos.toArray()[0];
    }

    public Set<AbstractThreadVO> getVOs(String filial, String codigoLancamento) throws ThreadDaoException {
        String where = " where fil_codigo = " + filial + " and lcx_codigo = " + codigoLancamento;
        Set lancamentos = this.loadVO(LancamentoVO.class, where);
        if (lancamentos == null || lancamentos.size() == 0) {
            return null;
        }
        return lancamentos;
    }

    private void loadPlanosContas(LancamentoBean lancamento) throws ThreadDaoException {
        LancamentoPlanoContaDao dao = new LancamentoPlanoContaDao();
        String where = " where fil_codigo = " + lancamento.getFilial().getCodigo() + " and lcx_codigo = " + lancamento.getCodigo() + " and est_codigo = " + lancamento.getEstacao().getCodigo();
        lancamento.setPlanosContas(LancamentoPlanoContaDao.load(LancamentoPlanoContaBean.class, where));
    }

    private void loadCentrosCusto(LancamentoBean lancamento) throws ThreadDaoException {
        LancamentoCentroCustoDao dao = new LancamentoCentroCustoDao();
        String where = " where fil_codigo = " + lancamento.getFilial().getCodigo() + " and lcx_codigo = " + lancamento.getCodigo() + " and est_codigo = " + lancamento.getEstacao().getCodigo();
        lancamento.setCentrosCusto(LancamentoCentroCustoDao.load(LancamentoCentroCustoBean.class, where));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadNotaFiscal(LancamentoBean lancamento) throws Exception {
        StringBuilder buf = new StringBuilder();
        buf.append(" select nfi.fil_codigo as filial ");
        buf.append("       ,nfi.nfi_codigo as codigo ");
        buf.append("   from baixalanctocaixa blc ");
        buf.append("   join baixa             bxa on blc.fil_codigo = bxa.fil_codigo and blc.bxa_codigo = bxa.bxa_codigo and bxa.bxa_datacancelado IS NULL ");
        buf.append("   join baixareceberpagar brp on bxa.fil_codigo = brp.fil_codigo and bxa.bxa_codigo = brp.bxa_codigo ");
        buf.append("   join receberpagar      rpg on brp.fil_codigo = rpg.fil_codigo and brp.rpg_codigo = rpg.rpg_codigo and (rpg.usr_codcancelado IS NULL and rpg.rpg_datacancelado IS NULL) ");
        buf.append("   join notafiscal        nfi on rpg.fil_codigo = nfi.fil_codigo and rpg.nfi_codigo = nfi.nfi_codigo and (nfi.usr_codcancelada IS NULL and nfi.nfi_datahoracancelada IS NULL) ");
        buf.append("  where blc.fil_codigo = ").append(lancamento.getFilial().getCodigo().toString());
        buf.append("    and blc.lcx_codigo = ").append(lancamento.getCodigo().toString());
        buf.append("    and blc.est_codigo = ").append(lancamento.getEstacao().getCodigo().toString());
        Statement st = Conexao.getStatement();
        try {
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                lancamento.setNotaFiscal((NotaFiscalVO)new NotaFiscalService().getVO(rs.getString("filial"), rs.getString("codigo")));
            }
        }
        catch (Throwable throwable) {
            Conexao.fecharStatement(st);
            throw throwable;
        }
        Conexao.fecharStatement(st);
    }

    @Override
    public AbstractThreadBean voToBean(AbstractThreadVO vo, Class classeBean) throws ThreadDaoException, IllegalArgumentException, IllegalAccessException {
        AbstractThreadBean bean = super.voToBean(vo, classeBean);
        this.loadPlanosContas((LancamentoBean)bean);
        this.loadCentrosCusto((LancamentoBean)bean);
        try {
            this.loadNotaFiscal((LancamentoBean)bean);
        }
        catch (Exception e) {
            throw new ThreadDaoException(e.getMessage());
        }
        return bean;
    }

    public AbstractThreadBean getComplementarBean(String filialComplementar, String codigoComplementar, String codigoEstacaoComplementar) throws Exception {
        String where = " where fil_codigo = " + filialComplementar + " and lcx_kodigo = " + codigoComplementar + " and est_kodigo = " + codigoEstacaoComplementar + " and lcx_tipoorigem = '" + "E" + "' ";
        Set lancamentos = LancamentoDao.load(LancamentoBean.class, where);
        if (lancamentos == null || lancamentos.size() == 0 || lancamentos.size() > 1) {
            return null;
        }
        LancamentoBean lancamento = (LancamentoBean)lancamentos.toArray()[0];
        this.loadPlanosContas(lancamento);
        this.loadCentrosCusto(lancamento);
        this.loadNotaFiscal(lancamento);
        return lancamento;
    }

    public AbstractThreadBean getBean(String filial, String codigoLancamento, String codigoEstacao) throws Exception {
        String where = " where fil_codigo = " + filial + " and lcx_codigo = " + codigoLancamento + " and est_codigo = " + codigoEstacao;
        Set lancamentos = LancamentoDao.load(LancamentoBean.class, where);
        if (lancamentos == null || lancamentos.size() == 0 || lancamentos.size() > 1) {
            return null;
        }
        LancamentoBean lancamento = (LancamentoBean)lancamentos.toArray()[0];
        this.loadPlanosContas(lancamento);
        this.loadCentrosCusto(lancamento);
        this.loadNotaFiscal(lancamento);
        return lancamento;
    }

    public AbstractThreadBean getBeanComplementar(String filialComplementar, String codigoLancamentoComplementar, String codigoEstacaoComplementar, boolean trazerCancelados) throws Exception {
        Set lancamentos;
        String where = " where fil_codigo = " + filialComplementar + " and lcx_kodigo = " + codigoLancamentoComplementar + " and est_kodigo = " + codigoEstacaoComplementar;
        if (!trazerCancelados) {
            where = where + " and lcx_situacao <> 'C' ";
        }
        if ((lancamentos = LancamentoDao.load(LancamentoBean.class, where)) == null || lancamentos.size() == 0 || lancamentos.size() > 1) {
            return null;
        }
        LancamentoBean lancamento = (LancamentoBean)lancamentos.toArray()[0];
        this.loadPlanosContas(lancamento);
        this.loadCentrosCusto(lancamento);
        this.loadNotaFiscal(lancamento);
        return lancamento;
    }

    @Override
    @Deprecated
    public AbstractThreadBean getBean(String codigo) throws ThreadDaoException {
        return null;
    }

    @Override
    @Deprecated
    public AbstractThreadVO getVO(String codigo) throws ThreadDaoException {
        return null;
    }

    @Override
    public AbstractThreadBean getBean(Map<String, Object> chaves) throws ThreadDaoException {
        String where = " where fil_codigo = " + chaves.get("fil_codigo") + " and lcx_codigo = " + chaves.get("lcx_codigo") + " and est_codigo = " + chaves.get("est_codigo");
        Set lancamentos = LancamentoDao.load(LancamentoBean.class, where);
        if (lancamentos == null || lancamentos.size() == 0 || lancamentos.size() > 1) {
            return null;
        }
        LancamentoBean lancamento = (LancamentoBean)lancamentos.toArray()[0];
        this.loadPlanosContas(lancamento);
        this.loadCentrosCusto(lancamento);
        try {
            this.loadNotaFiscal(lancamento);
        }
        catch (Exception e) {
            throw new ThreadDaoException(e.getMessage());
        }
        return lancamento;
    }

    @Override
    public AbstractThreadVO getVO(Map<String, Object> chaves) throws ThreadDaoException {
        String where = " where fil_codigo = " + chaves.get("fil_codigo") + " and lcx_codigo = " + chaves.get("lcx_codigo") + " and est_codigo = " + chaves.get("est_codigo");
        Set lancamentos = this.loadVO(LancamentoVO.class, where);
        if (lancamentos == null || lancamentos.size() == 0 || lancamentos.size() > 1) {
            return null;
        }
        return (AbstractThreadVO)lancamentos.toArray()[0];
    }

    @Override
    public AbstractThreadVO getVO(String filial, String codigo) throws ThreadDaoException {
        return null;
    }
}

